/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.jdbc;

import com.google.common.annotations.VisibleForTesting;
import io.kareldb.KarelDbEngine;
import io.kareldb.jdbc.Driver;
import io.kareldb.transaction.client.KarelDbTransaction;
import java.sql.SQLException;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteMetaImplShim;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.omid.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaImpl
extends CalciteMetaImplShim {
    private static final Logger log = LoggerFactory.getLogger(MetaImpl.class);
    static final Driver DRIVER = new Driver();
    private KarelDbTransaction transaction;

    public MetaImpl(AvaticaConnection connection) {
        super(connection);
        this.connProps.setAutoCommit(false).setReadOnly(false).setTransactionIsolation(2);
        this.connProps.setDirty(false);
    }

    public AvaticaConnection getConnection() {
        return this.connection;
    }

    public KarelDbTransaction getTransaction() {
        return this.transaction;
    }

    public boolean isAutoCommit() {
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle h, String sql, long maxRowCount, int maxRowsInFirstFrame, Meta.PrepareCallback callback) throws NoSuchStatementException {
        this.begin();
        try {
            Meta.ExecuteResult executeResult = super.prepareAndExecute(h, sql, maxRowCount, maxRowsInFirstFrame, callback);
            return executeResult;
        }
        finally {
            if (this.isAutoCommit()) {
                this.commit(this.connection.handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meta.Frame fetch(Meta.StatementHandle h, long offset, int fetchMaxRowCount) throws NoSuchStatementException {
        this.begin();
        try {
            Meta.Frame frame = super.fetch(h, offset, fetchMaxRowCount);
            return frame;
        }
        finally {
            if (this.isAutoCommit()) {
                this.commit(this.connection.handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meta.ExecuteResult execute(Meta.StatementHandle h, List<TypedValue> parameterValues, int maxRowsInFirstFrame) throws NoSuchStatementException {
        this.begin();
        try {
            Meta.ExecuteResult executeResult = super.execute(h, parameterValues, maxRowsInFirstFrame);
            return executeResult;
        }
        finally {
            if (this.isAutoCommit()) {
                this.commit(this.connection.handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meta.ExecuteBatchResult executeBatch(Meta.StatementHandle h, List<List<TypedValue>> parameterValueLists) throws NoSuchStatementException {
        this.begin();
        try {
            Meta.ExecuteBatchResult executeBatchResult = super.executeBatch(h, parameterValueLists);
            return executeBatchResult;
        }
        finally {
            if (this.isAutoCommit()) {
                this.commit(this.connection.handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meta.ExecuteBatchResult prepareAndExecuteBatch(Meta.StatementHandle h, List<String> sqlCommands) throws NoSuchStatementException {
        this.begin();
        try {
            Meta.ExecuteBatchResult executeBatchResult = super.prepareAndExecuteBatch(h, sqlCommands);
            return executeBatchResult;
        }
        finally {
            if (this.isAutoCommit()) {
                this.commit(this.connection.handle);
            }
        }
    }

    @VisibleForTesting
    public static CalciteConnection connect(CalciteSchema schema, JavaTypeFactory typeFactory) {
        return DRIVER.connect(schema, typeFactory);
    }

    public boolean syncResults(Meta.StatementHandle h, QueryState state, long offset) throws NoSuchStatementException {
        throw new UnsupportedOperationException();
    }

    public void begin() {
        try {
            if (this.transaction == null || this.transaction.getStatus() != Transaction.Status.RUNNING) {
                this.transaction = (KarelDbTransaction)KarelDbEngine.getInstance().beginTx();
            }
            KarelDbTransaction.setCurrentTransaction(this.transaction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void commit(Meta.ConnectionHandle ch) {
        try {
            if (this.transaction != null && this.transaction.getStatus() == Transaction.Status.RUNNING) {
                KarelDbEngine.getInstance().commitTx((Transaction)this.transaction);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void rollback(Meta.ConnectionHandle ch) {
        try {
            if (this.transaction != null && this.transaction.getStatus() == Transaction.Status.RUNNING) {
                KarelDbEngine.getInstance().rollbackTx((Transaction)this.transaction);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

