/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.avro;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;

public class AvroUtils {
    private static final SchemaValidator BACKWARD_TRANSITIVE_VALIDATOR = new SchemaValidatorBuilder().canReadStrategy().validateAll();

    public static void checkCompatibility(Schema newSchema, List<Schema> previousSchemas) throws SchemaValidationException {
        ArrayList<Schema> previousSchemasCopy = new ArrayList<Schema>(previousSchemas);
        BACKWARD_TRANSITIVE_VALIDATOR.validate(newSchema, previousSchemasCopy);
    }

    public static Schema parseSchema(File file) throws IOException {
        try {
            Schema.Parser parser = new Schema.Parser();
            return parser.parse(file);
        }
        catch (SchemaParseException e) {
            return null;
        }
    }

    public static Schema parseSchema(String schemaString) {
        try {
            Schema.Parser parser = new Schema.Parser();
            return parser.parse(schemaString);
        }
        catch (SchemaParseException e) {
            return null;
        }
    }
}

