/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.avro;

import io.kareldb.KarelDbEngine;
import io.kareldb.avro.AvroSchema;
import io.kareldb.schema.FilterableTable;
import io.kareldb.schema.RelDef;
import io.kareldb.version.VersionedCache;
import java.io.BufferedReader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;
import org.apache.omid.transaction.Transaction;

public class AvroTable
extends FilterableTable {
    private final VersionedCache rows;
    private final DecoderFactory decoderFactory = DecoderFactory.get();

    public AvroTable(io.kareldb.schema.Schema schema, String name, RelDef rowType) {
        super(schema, name, rowType);
        this.rows = new VersionedCache(name);
    }

    @Override
    public VersionedCache getRows() {
        return this.rows;
    }

    @Override
    public void init() {
        try {
            Source avro;
            Transaction tx = KarelDbEngine.getInstance().beginTx();
            Schema schema = (Schema)this.getConfigs().get("avroSchema");
            if (schema == null) {
                schema = AvroSchema.toAvroSchema(this.getName(), this.getRelDef());
            }
            Collection modifiableCollection = this.getModifiableCollection();
            GenericDatumReader datumReader = new GenericDatumReader(schema);
            Source json = this.getSource(this.getConfigs(), schema.getName() + ".json");
            if (json != null) {
                String line;
                BufferedReader reader = Files.newBufferedReader(Paths.get(json.path(), new String[0]));
                while ((line = reader.readLine()) != null) {
                    Object row = this.toRow((GenericRecord)datumReader.read(null, (Decoder)this.decoderFactory.jsonDecoder(schema, line)));
                    modifiableCollection.add(row);
                }
            }
            if ((avro = this.getSource(this.getConfigs(), schema.getName() + ".avro")) != null) {
                DataFileReader dataFileReader = new DataFileReader(avro.file(), (DatumReader)datumReader);
                for (GenericRecord record : dataFileReader) {
                    Object row = this.toRow(record);
                    modifiableCollection.add(row);
                }
            }
            KarelDbEngine.getInstance().commitTx(tx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sync() {
    }

    private Source getSource(Map<String, ?> operand, String fileName) {
        File file;
        File base;
        if (fileName == null) {
            return null;
        }
        Path path = Paths.get(fileName, new String[0]);
        String directory = (String)operand.get("directory");
        if (directory != null) {
            path = Paths.get(directory, path.toString());
        }
        if ((base = (File)operand.get(ModelHandler.ExtraOperand.BASE_DIRECTORY.camelName)) != null) {
            path = Paths.get(base.getPath(), path.toString());
        }
        return (file = path.toFile()).exists() ? Sources.of((File)path.toFile()) : null;
    }

    private Object toRow(GenericRecord record) {
        List fields = record.getSchema().getFields();
        int size = fields.size();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            Schema schema = ((Schema.Field)fields.get(i)).schema();
            Comparable value = (Comparable)record.get(i);
            result[i] = AvroSchema.fromAvroValue(schema, value);
        }
        return size == 1 ? result[0] : result;
    }

    @Override
    public void close() {
    }
}

