/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.avro;

import io.kareldb.avro.AvroTable;
import io.kareldb.avro.AvroUtils;
import io.kareldb.schema.ColumnDef;
import io.kareldb.schema.ColumnStrategy;
import io.kareldb.schema.ColumnType;
import io.kareldb.schema.RelDef;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.util.Utf8;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.ddl.SqlAlterTableExtension;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;

public class AvroSchema
extends io.kareldb.schema.Schema {
    public static final String AVRO_LOGICAL_TYPE_PROP = "logicalType";
    public static final String AVRO_LOGICAL_TIMESTAMP_MILLIS = "timestamp-millis";
    public static final String AVRO_LOGICAL_TIME_MILLIS = "time-millis";
    public static final String AVRO_LOGICAL_DATE = "date";
    public static final String AVRO_LOGICAL_DECIMAL = "decimal";
    public static final String AVRO_LOGICAL_DECIMAL_SCALE_PROP = "scale";
    public static final String AVRO_LOGICAL_DECIMAL_PRECISION_PROP = "precision";
    public static final String SQL_KEY_INDEX_PROP = "sql.key.index";
    private final Map<String, Table> tableMap = new HashMap<String, Table>();
    private File directoryFile;

    @Override
    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    @Override
    public void configure(Map<String, ?> operand) {
        super.configure(operand);
        String directory = (String)operand.get("directory");
        File base = (File)operand.get(ModelHandler.ExtraOperand.BASE_DIRECTORY.camelName);
        File directoryFile = new File(directory);
        if (base != null && !directoryFile.isAbsolute()) {
            directoryFile = new File(base, directory);
        }
        this.directoryFile = directoryFile;
    }

    @Override
    public void init() {
        try {
            File[] files = this.directoryFile.listFiles((dir, name) -> name.endsWith(".avsc"));
            if (files == null) {
                System.out.println("directory " + this.directoryFile + " not found");
                files = new File[]{};
            }
            HashMap<String, Object> configs = new HashMap<String, Object>(this.getConfigs());
            for (File file : files) {
                Source source = Sources.of((File)file);
                Schema avroSchema = AvroUtils.parseSchema(source.file());
                configs.put("avroSchema", avroSchema);
                String name2 = avroSchema.getName();
                RelDef rowType = AvroSchema.toRowType(avroSchema);
                this.createTable(name2, configs, rowType);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sync() {
    }

    @Override
    public io.kareldb.schema.Table createTable(String tableName, Map<String, Object> operand, RelDef rowType) {
        AvroTable table = new AvroTable(this, tableName, rowType);
        table.configure(operand != null ? operand : this.getConfigs());
        table.init();
        this.tableMap.put(tableName, (Table)table);
        return table;
    }

    @Override
    public void alterTable(String tableName, List<SqlAlterTableExtension.Action> actions, RelDef rowType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean dropTable(String tableName) {
        return this.tableMap.remove(tableName) != null;
    }

    @Override
    public void close() {
    }

    public static RelDef toRowType(Schema schema) {
        Pair<LinkedHashMap<String, ColumnDef>, List<String>> types = AvroSchema.toColumnDefs(schema);
        return io.kareldb.schema.Schema.toRowType((LinkedHashMap)types.left, (List)types.right);
    }

    public static Pair<LinkedHashMap<String, ColumnDef>, List<String>> toColumnDefs(Schema schema) {
        int size = schema.getFields().size();
        LinkedHashMap<String, ColumnDef> columnDefs = new LinkedHashMap<String, ColumnDef>();
        String[] keyNames = new String[size];
        for (Schema.Field field : schema.getFields()) {
            Object defaultVal;
            ColumnDef columnDef;
            Schema fieldSchema = field.schema();
            Integer keyIndex = (Integer)field.getObjectProp(SQL_KEY_INDEX_PROP);
            if (keyIndex != null) {
                keyNames[keyIndex.intValue()] = field.name();
            }
            if ((columnDef = AvroSchema.toColumnDef(fieldSchema)) == null) {
                throw new IllegalArgumentException("Unsupported type " + fieldSchema.getType());
            }
            if (field.hasDefaultValue() && (defaultVal = field.defaultVal()) != JsonProperties.NULL_VALUE) {
                columnDef = new ColumnDef(columnDef.getColumnType(), new ColumnStrategy.DefaultStrategy(defaultVal), columnDef.getPrecision(), columnDef.getScale());
            }
            columnDefs.put(field.name(), columnDef);
        }
        ArrayList<String> keyFields = new ArrayList<String>(size);
        for (String keyName : keyNames) {
            if (keyName == null) break;
            keyFields.add(keyName);
        }
        return Pair.of(columnDefs, keyFields);
    }

    private static ColumnDef toColumnDef(Schema schema) {
        String logicalType = schema.getProp(AVRO_LOGICAL_TYPE_PROP);
        switch (schema.getType()) {
            case BOOLEAN: {
                return new ColumnDef(ColumnType.BOOLEAN);
            }
            case INT: {
                if (AVRO_LOGICAL_DATE.equalsIgnoreCase(logicalType)) {
                    return new ColumnDef(ColumnType.DATE);
                }
                if (AVRO_LOGICAL_TIME_MILLIS.equalsIgnoreCase(logicalType)) {
                    return new ColumnDef(ColumnType.TIME);
                }
                return new ColumnDef(ColumnType.INT);
            }
            case LONG: {
                if (AVRO_LOGICAL_TIMESTAMP_MILLIS.equalsIgnoreCase(logicalType)) {
                    return new ColumnDef(ColumnType.TIMESTAMP);
                }
                return new ColumnDef(ColumnType.LONG);
            }
            case FLOAT: {
                return new ColumnDef(ColumnType.FLOAT);
            }
            case DOUBLE: {
                return new ColumnDef(ColumnType.DOUBLE);
            }
            case BYTES: 
            case FIXED: {
                if (AVRO_LOGICAL_DECIMAL.equalsIgnoreCase(logicalType)) {
                    Object scaleObj = schema.getObjectProp(AVRO_LOGICAL_DECIMAL_SCALE_PROP);
                    if (!(scaleObj instanceof Number)) {
                        throw new IllegalArgumentException("Scale must be specified and must be a number.");
                    }
                    int scale = ((Number)scaleObj).intValue();
                    Object precisionObj = schema.getObjectProp(AVRO_LOGICAL_DECIMAL_PRECISION_PROP);
                    int precision = 0;
                    if (precisionObj != null) {
                        if (!(precisionObj instanceof Number)) {
                            throw new IllegalArgumentException("precision property must be an Integer. https://avro.apache.org/docs/1.9.1/spec.html#Decimal");
                        }
                        precision = ((Number)precisionObj).intValue();
                    }
                    return new ColumnDef(ColumnType.DECIMAL, precision, scale);
                }
                return new ColumnDef(ColumnType.BYTES);
            }
            case STRING: {
                return new ColumnDef(ColumnType.STRING);
            }
            case UNION: {
                for (Schema subtype : schema.getTypes()) {
                    ColumnDef columnDef = AvroSchema.toColumnDef(subtype);
                    if (columnDef == null) continue;
                    return new ColumnDef(columnDef.getColumnType(), ColumnStrategy.NULL_STRATEGY, columnDef.getPrecision(), columnDef.getScale());
                }
                return null;
            }
        }
        return null;
    }

    public static Schema toAvroSchema(String tableName, RelDef relDef) {
        SchemaBuilder.FieldAssembler<Schema> schemaBuilder = SchemaBuilder.record((String)tableName).fields();
        Map<String, Integer> keyIndices = Ord.zip(relDef.getKeyFields()).stream().collect(Collectors.toMap(o -> (String)o.e, o -> o.i));
        for (Pair entry : Pair.zip((List)relDef.getRowType().getFieldList(), relDef.getStrategies())) {
            RelDataTypeField field = (RelDataTypeField)entry.left;
            ColumnStrategy strategy = (ColumnStrategy)entry.right;
            RelDataType type = field.getType();
            SchemaBuilder.FieldBuilder fieldBuilder = schemaBuilder.name(field.getName());
            Integer keyIndex = keyIndices.get(field.getName());
            if (keyIndex != null) {
                fieldBuilder = (SchemaBuilder.FieldBuilder)fieldBuilder.prop(SQL_KEY_INDEX_PROP, (Object)keyIndex);
                strategy = ColumnStrategy.NOT_NULL_STRATEGY;
            }
            schemaBuilder = AvroSchema.toAvroType((SchemaBuilder.FieldBuilder<Schema>)fieldBuilder, type, strategy);
        }
        return (Schema)schemaBuilder.endRecord();
    }

    private static SchemaBuilder.FieldAssembler<Schema> toAvroType(SchemaBuilder.FieldBuilder<Schema> fieldBuilder, RelDataType type, ColumnStrategy strategy) {
        SchemaBuilder.FieldAssembler schemaBuilder = null;
        switch (type.getSqlTypeName()) {
            case BOOLEAN: {
                switch (strategy.getType()) {
                    case NOT_NULL: {
                        schemaBuilder = fieldBuilder.type().booleanType().noDefault();
                        break;
                    }
                    case NULL: {
                        schemaBuilder = (SchemaBuilder.FieldAssembler)fieldBuilder.type().optional().booleanType();
                        break;
                    }
                    case DEFAULT: {
                        schemaBuilder = fieldBuilder.type().booleanType().booleanDefault(((Boolean)strategy.getDefaultValue()).booleanValue());
                    }
                }
                break;
            }
            case INTEGER: {
                switch (strategy.getType()) {
                    case NOT_NULL: {
                        schemaBuilder = fieldBuilder.type().intType().noDefault();
                        break;
                    }
                    case NULL: {
                        schemaBuilder = (SchemaBuilder.FieldAssembler)fieldBuilder.type().optional().intType();
                        break;
                    }
                    case DEFAULT: {
                        schemaBuilder = fieldBuilder.type().intType().intDefault(((Number)strategy.getDefaultValue()).intValue());
                    }
                }
                break;
            }
            case BIGINT: {
                switch (strategy.getType()) {
                    case NOT_NULL: {
                        schemaBuilder = fieldBuilder.type().longType().noDefault();
                        break;
                    }
                    case NULL: {
                        schemaBuilder = (SchemaBuilder.FieldAssembler)fieldBuilder.type().optional().longType();
                        break;
                    }
                    case DEFAULT: {
                        schemaBuilder = fieldBuilder.type().longType().longDefault(((Number)strategy.getDefaultValue()).longValue());
                    }
                }
                break;
            }
            case REAL: {
                switch (strategy.getType()) {
                    case NOT_NULL: {
                        schemaBuilder = fieldBuilder.type().floatType().noDefault();
                        break;
                    }
                    case NULL: {
                        schemaBuilder = (SchemaBuilder.FieldAssembler)fieldBuilder.type().optional().floatType();
                        break;
                    }
                    case DEFAULT: {
                        schemaBuilder = fieldBuilder.type().floatType().floatDefault(((Number)strategy.getDefaultValue()).floatValue());
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (strategy.getType()) {
                    case NOT_NULL: {
                        schemaBuilder = fieldBuilder.type().doubleType().noDefault();
                        break;
                    }
                    case NULL: {
                        schemaBuilder = (SchemaBuilder.FieldAssembler)fieldBuilder.type().optional().doubleType();
                        break;
                    }
                    case DEFAULT: {
                        schemaBuilder = fieldBuilder.type().doubleType().doubleDefault(((Number)strategy.getDefaultValue()).doubleValue());
                    }
                }
                break;
            }
            case VARBINARY: {
                switch (strategy.getType()) {
                    case NOT_NULL: {
                        schemaBuilder = fieldBuilder.type().bytesType().noDefault();
                        break;
                    }
                    case NULL: {
                        schemaBuilder = (SchemaBuilder.FieldAssembler)fieldBuilder.type().optional().bytesType();
                        break;
                    }
                    case DEFAULT: {
                        schemaBuilder = fieldBuilder.type().bytesType().bytesDefault(strategy.getDefaultValue().toString());
                    }
                }
                break;
            }
            case VARCHAR: {
                switch (strategy.getType()) {
                    case NOT_NULL: {
                        schemaBuilder = fieldBuilder.type().stringType().noDefault();
                        break;
                    }
                    case NULL: {
                        schemaBuilder = (SchemaBuilder.FieldAssembler)fieldBuilder.type().optional().stringType();
                        break;
                    }
                    case DEFAULT: {
                        schemaBuilder = fieldBuilder.type().stringType().stringDefault(strategy.getDefaultValue().toString());
                    }
                }
                break;
            }
            case DECIMAL: {
                int precision = type.getPrecision();
                int scale = type.getScale();
                LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)precision, (int)Math.max(scale, 0));
                Schema bytesSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
                Schema decimalSchema = decimal.addToSchema(bytesSchema);
                switch (strategy.getType()) {
                    case NOT_NULL: {
                        schemaBuilder = fieldBuilder.type(decimalSchema).noDefault();
                        break;
                    }
                    case NULL: {
                        schemaBuilder = (SchemaBuilder.FieldAssembler)fieldBuilder.type().optional().type(decimalSchema);
                        break;
                    }
                    case DEFAULT: {
                        schemaBuilder = fieldBuilder.type(decimalSchema).withDefault(strategy.getDefaultValue());
                    }
                }
                break;
            }
            case DATE: {
                LogicalTypes.Date date = LogicalTypes.date();
                Schema intSchema = Schema.create((Schema.Type)Schema.Type.INT);
                Schema dateSchema = date.addToSchema(intSchema);
                switch (strategy.getType()) {
                    case NOT_NULL: {
                        schemaBuilder = fieldBuilder.type(dateSchema).noDefault();
                        break;
                    }
                    case NULL: {
                        schemaBuilder = (SchemaBuilder.FieldAssembler)fieldBuilder.type().optional().type(dateSchema);
                        break;
                    }
                    case DEFAULT: {
                        schemaBuilder = fieldBuilder.type(dateSchema).withDefault(strategy.getDefaultValue());
                    }
                }
                break;
            }
            case TIME: {
                LogicalTypes.TimeMillis time = LogicalTypes.timeMillis();
                Schema int2Schema = Schema.create((Schema.Type)Schema.Type.INT);
                Schema timeSchema = time.addToSchema(int2Schema);
                switch (strategy.getType()) {
                    case NOT_NULL: {
                        schemaBuilder = fieldBuilder.type(timeSchema).noDefault();
                        break;
                    }
                    case NULL: {
                        schemaBuilder = (SchemaBuilder.FieldAssembler)fieldBuilder.type().optional().type(timeSchema);
                        break;
                    }
                    case DEFAULT: {
                        schemaBuilder = fieldBuilder.type(timeSchema).withDefault(strategy.getDefaultValue());
                    }
                }
                break;
            }
            case TIMESTAMP: {
                LogicalTypes.TimestampMillis timestamp = LogicalTypes.timestampMillis();
                Schema longSchema = Schema.create((Schema.Type)Schema.Type.LONG);
                Schema timestampSchema = timestamp.addToSchema(longSchema);
                switch (strategy.getType()) {
                    case NOT_NULL: {
                        schemaBuilder = fieldBuilder.type(timestampSchema).noDefault();
                        break;
                    }
                    case NULL: {
                        schemaBuilder = (SchemaBuilder.FieldAssembler)fieldBuilder.type().optional().type(timestampSchema);
                        break;
                    }
                    case DEFAULT: {
                        schemaBuilder = fieldBuilder.type(timestampSchema).withDefault(strategy.getDefaultValue());
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type " + type);
            }
        }
        return schemaBuilder;
    }

    public static Comparable toAvroValue(Schema schema, Comparable value) {
        if (value == null) {
            return null;
        }
        String logicalType = schema.getProp(AVRO_LOGICAL_TYPE_PROP);
        switch (schema.getType()) {
            case BOOLEAN: {
                return value;
            }
            case INT: {
                if (AVRO_LOGICAL_DATE.equalsIgnoreCase(logicalType)) {
                    return value;
                }
                if (AVRO_LOGICAL_TIME_MILLIS.equalsIgnoreCase(logicalType)) {
                    return value;
                }
                return Integer.valueOf(((Number)((Object)value)).intValue());
            }
            case LONG: {
                if (AVRO_LOGICAL_TIMESTAMP_MILLIS.equalsIgnoreCase(logicalType)) {
                    return value;
                }
                return Long.valueOf(((Number)((Object)value)).longValue());
            }
            case FLOAT: {
                return Float.valueOf(((Number)((Object)value)).floatValue());
            }
            case DOUBLE: {
                return Double.valueOf(((Number)((Object)value)).doubleValue());
            }
            case BYTES: 
            case FIXED: {
                if (AVRO_LOGICAL_DECIMAL.equalsIgnoreCase(logicalType)) {
                    return value;
                }
                return ByteBuffer.wrap(((ByteString)value).getBytes());
            }
            case STRING: {
                return value;
            }
            case UNION: {
                for (Schema subtype : schema.getTypes()) {
                    Comparable v = AvroSchema.toAvroValue(subtype, value);
                    if (v == null) continue;
                    return v;
                }
                return null;
            }
        }
        return null;
    }

    public static Comparable fromAvroValue(Schema schema, Comparable value) {
        if (value instanceof Utf8) {
            value = ((Utf8)value).toString();
        } else if (value instanceof ByteBuffer) {
            value = new ByteString(((ByteBuffer)value).array());
        }
        return value;
    }
}

