/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb;

import io.kcache.KafkaCacheConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class KarelDbConfig
extends KafkaCacheConfig {
    public static final String LISTENERS_CONFIG = "listeners";
    public static final String LISTENERS_DEFAULT = "http://0.0.0.0:8765";
    public static final String LISTENERS_DOC = "List of listeners. http and https are supported. Each listener must include the protocol, hostname, and port. For example: http://myhost:8080, https://0.0.0.0:8081";
    public static final String CLUSTER_GROUP_ID_CONFIG = "cluster.group.id";
    public static final String CLUSTER_GROUP_ID_DEFAULT = "kareldb";
    public static final String CLUSTER_GROUP_ID_DOC = "The group ID used for leader election.";
    public static final String LEADER_ELIGIBILITY_CONFIG = "leader.eligibility";
    public static final boolean LEADER_ELIGIBILITY_DEFAULT = true;
    public static final String LEADER_ELIGIBILITY_DOC = "If true, this node can participate in leader election. In a multi-colo setup, turn this off for clusters in the replica data center.";
    public static final String ROCKS_DB_ENABLE_CONFIG = "rocksdb.enable";
    public static final boolean ROCKS_DB_ENABLE_DEFAULT = true;
    public static final String ROCKS_DB_ENABLE_DOC = "Whether to enable RocksDB within KCache.";
    public static final String ROCKS_DB_ROOT_DIR_CONFIG = "rocksdb.root.dir";
    public static final String ROCKS_DB_ROOT_DIR_DEFAULT = "/tmp";
    public static final String ROCKS_DB_ROOT_DIR_DOC = "Root directory for RocksDB storage.";
    public static final String SSL_KEYSTORE_LOCATION_CONFIG = "ssl.keystore.location";
    public static final String SSL_KEYSTORE_LOCATION_DOC = "Location of the keystore file to use for SSL. This is required for HTTPS.";
    public static final String SSL_KEYSTORE_LOCATION_DEFAULT = "";
    public static final String SSL_KEYSTORE_PASSWORD_CONFIG = "ssl.keystore.password";
    public static final String SSL_KEYSTORE_PASSWORD_DOC = "The store password for the keystore file.";
    public static final String SSL_KEYSTORE_PASSWORD_DEFAULT = "";
    public static final String SSL_KEY_PASSWORD_CONFIG = "ssl.key.password";
    public static final String SSL_KEY_PASSWORD_DOC = "The password of the private key in the keystore file.";
    public static final String SSL_KEY_PASSWORD_DEFAULT = "";
    public static final String SSL_KEYSTORE_TYPE_CONFIG = "ssl.keystore.type";
    public static final String SSL_KEYSTORE_TYPE_DOC = "The type of keystore file.";
    public static final String SSL_KEYSTORE_TYPE_DEFAULT = "JKS";
    public static final String SSL_KEYMANAGER_ALGORITHM_CONFIG = "ssl.keymanager.algorithm";
    public static final String SSL_KEYMANAGER_ALGORITHM_DOC = "The algorithm used by the key manager factory for SSL connections. Leave blank to use Jetty's default.";
    public static final String SSL_KEYMANAGER_ALGORITHM_DEFAULT = "";
    public static final String SSL_TRUSTSTORE_LOCATION_CONFIG = "ssl.truststore.location";
    public static final String SSL_TRUSTSTORE_LOCATION_DOC = "Location of the trust store. Required only to authenticate HTTPS clients.";
    public static final String SSL_TRUSTSTORE_LOCATION_DEFAULT = "";
    public static final String SSL_TRUSTSTORE_PASSWORD_CONFIG = "ssl.truststore.password";
    public static final String SSL_TRUSTSTORE_PASSWORD_DOC = "The store password for the trust store file.";
    public static final String SSL_TRUSTSTORE_PASSWORD_DEFAULT = "";
    public static final String SSL_TRUSTSTORE_TYPE_CONFIG = "ssl.truststore.type";
    public static final String SSL_TRUSTSTORE_TYPE_DOC = "The type of trust store file.";
    public static final String SSL_TRUSTSTORE_TYPE_DEFAULT = "JKS";
    public static final String SSL_TRUSTMANAGER_ALGORITHM_CONFIG = "ssl.trustmanager.algorithm";
    public static final String SSL_TRUSTMANAGER_ALGORITHM_DOC = "The algorithm used by the trust manager factory for SSL connections. Leave blank to use Jetty's default.";
    public static final String SSL_TRUSTMANAGER_ALGORITHM_DEFAULT = "";
    public static final String SSL_PROTOCOL_CONFIG = "ssl.protocol";
    public static final String SSL_PROTOCOL_DOC = "The SSL protocol used to generate the SslContextFactory.";
    public static final String SSL_PROTOCOL_DEFAULT = "TLS";
    public static final String SSL_PROVIDER_CONFIG = "ssl.provider";
    public static final String SSL_PROVIDER_DOC = "The SSL security provider name. Leave blank to use Jetty's default.";
    public static final String SSL_PROVIDER_DEFAULT = "";
    public static final String SSL_CLIENT_AUTHENTICATION_CONFIG = "ssl.client.authentication";
    public static final String SSL_CLIENT_AUTHENTICATION_NONE = "NONE";
    public static final String SSL_CLIENT_AUTHENTICATION_REQUESTED = "REQUESTED";
    public static final String SSL_CLIENT_AUTHENTICATION_REQUIRED = "REQUIRED";
    public static final String SSL_CLIENT_AUTHENTICATION_DOC = "SSL mutual auth. Set to NONE to disable SSL client authentication, set to REQUESTED to request but not require SSL client authentication, and set to REQUIRED to require SSL client authentication.";
    public static final ConfigDef.ValidString SSL_CLIENT_AUTHENTICATION_VALIDATOR = ConfigDef.ValidString.in((String[])new String[]{"NONE", "REQUESTED", "REQUIRED"});
    public static final String SSL_ENABLED_PROTOCOLS_CONFIG = "ssl.enabled.protocols";
    public static final String SSL_ENABLED_PROTOCOLS_DOC = "The list of protocols enabled for SSL connections. Comma-separated list. Leave blank to use Jetty's defaults.";
    public static final String SSL_ENABLED_PROTOCOLS_DEFAULT = "";
    public static final String SSL_CIPHER_SUITES_CONFIG = "ssl.cipher.suites";
    public static final String SSL_CIPHER_SUITES_DOC = "A list of SSL cipher suites. Leave blank to use Jetty's defaults.";
    public static final String SSL_CIPHER_SUITES_DEFAULT = "";
    public static final String SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_CONFIG = "ssl.endpoint.identification.algorithm";
    public static final String SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_DOC = "The endpoint identification algorithm to validate the server hostname using the server certificate.";
    public static final String SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_DEFAULT = null;
    public static final String AUTHENTICATION_METHOD_CONFIG = "authentication.method";
    public static final String AUTHENTICATION_METHOD_NONE = "NONE";
    public static final String AUTHENTICATION_METHOD_BASIC = "BASIC";
    public static final String AUTHENTICATION_METHOD_DIGEST = "DIGEST";
    public static final String AUTHENTICATION_METHOD_DOC = "Method of authentication. Must be BASIC or DIGEST to enable authentication. For BASIC or DIGEST, you must supply a valid JAAS config file for the 'java.security.auth.login.config' system property for the appropriate authentication provider.";
    public static final ConfigDef.ValidString AUTHENTICATION_METHOD_VALIDATOR = ConfigDef.ValidString.in((String[])new String[]{"NONE", "BASIC", "DIGEST"});
    public static final String AUTHENTICATION_REALM_CONFIG = "authentication.realm";
    public static final String AUTHENTICATION_REALM_DOC = "Security realm to be used in authentication.";
    public static final String AUTHENTICATION_ROLES_CONFIG = "authentication.roles";
    public static final String AUTHENTICATION_ROLES_DOC = "Valid roles to authenticate against.";
    public static final List<String> AUTHENTICATION_ROLES_DEFAULT = Collections.unmodifiableList(Arrays.asList("*"));
    private static final ConfigDef config = KarelDbConfig.baseConfigDef().define("listeners", ConfigDef.Type.LIST, (Object)"http://0.0.0.0:8765", ConfigDef.Importance.HIGH, "List of listeners. http and https are supported. Each listener must include the protocol, hostname, and port. For example: http://myhost:8080, https://0.0.0.0:8081").define("cluster.group.id", ConfigDef.Type.STRING, (Object)"kareldb", ConfigDef.Importance.HIGH, "The group ID used for leader election.").define("leader.eligibility", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, "If true, this node can participate in leader election. In a multi-colo setup, turn this off for clusters in the replica data center.").define("rocksdb.enable", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, "Whether to enable RocksDB within KCache.").define("rocksdb.root.dir", ConfigDef.Type.STRING, (Object)"/tmp", ConfigDef.Importance.MEDIUM, "Root directory for RocksDB storage.").define("ssl.keystore.location", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "Location of the keystore file to use for SSL. This is required for HTTPS.").define("ssl.keystore.password", ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, "The store password for the keystore file.").define("ssl.key.password", ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, "The password of the private key in the keystore file.").define("ssl.keystore.type", ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, "The type of keystore file.").define("ssl.keymanager.algorithm", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "The algorithm used by the key manager factory for SSL connections. Leave blank to use Jetty's default.").define("ssl.truststore.location", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "Location of the trust store. Required only to authenticate HTTPS clients.").define("ssl.truststore.password", ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, "The store password for the trust store file.").define("ssl.truststore.type", ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, "The type of trust store file.").define("ssl.trustmanager.algorithm", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "The algorithm used by the trust manager factory for SSL connections. Leave blank to use Jetty's default.").define("ssl.protocol", ConfigDef.Type.STRING, (Object)"TLS", ConfigDef.Importance.MEDIUM, "The SSL protocol used to generate the SslContextFactory.").define("ssl.provider", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The SSL security provider name. Leave blank to use Jetty's default.").define("ssl.client.authentication", ConfigDef.Type.STRING, (Object)"NONE", (ConfigDef.Validator)SSL_CLIENT_AUTHENTICATION_VALIDATOR, ConfigDef.Importance.MEDIUM, "SSL mutual auth. Set to NONE to disable SSL client authentication, set to REQUESTED to request but not require SSL client authentication, and set to REQUIRED to require SSL client authentication.").define("ssl.enabled.protocols", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.MEDIUM, "The list of protocols enabled for SSL connections. Comma-separated list. Leave blank to use Jetty's defaults.").define("ssl.cipher.suites", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of SSL cipher suites. Leave blank to use Jetty's defaults.").define("ssl.endpoint.identification.algorithm", ConfigDef.Type.STRING, (Object)SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_DEFAULT, ConfigDef.Importance.LOW, "The endpoint identification algorithm to validate the server hostname using the server certificate.").define("authentication.method", ConfigDef.Type.STRING, (Object)"NONE", (ConfigDef.Validator)AUTHENTICATION_METHOD_VALIDATOR, ConfigDef.Importance.LOW, "Method of authentication. Must be BASIC or DIGEST to enable authentication. For BASIC or DIGEST, you must supply a valid JAAS config file for the 'java.security.auth.login.config' system property for the appropriate authentication provider.").define("authentication.realm", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Security realm to be used in authentication.").define("authentication.roles", ConfigDef.Type.LIST, AUTHENTICATION_ROLES_DEFAULT, ConfigDef.Importance.LOW, "Valid roles to authenticate against.");

    public KarelDbConfig(String propsFile) {
        super(config, (Map)KarelDbConfig.getPropsFromFile((String)propsFile));
    }

    public KarelDbConfig(Map<?, ?> props) {
        super(config, props);
    }
}

