/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import com.google.common.collect.Maps;
import io.kareldb.transaction.InMemoryCommitTable;
import io.kareldb.transaction.InMemoryTimestampStorage;
import io.kareldb.transaction.client.KarelDbCellId;
import io.kareldb.transaction.client.KarelDbSyncPostCommitter;
import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.transaction.client.SnapshotFilterImpl;
import io.kareldb.version.TxVersionedCache;
import io.kareldb.version.VersionedCache;
import java.util.HashMap;
import java.util.Map;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.NullMetricsProvider;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.CommitTimestampLocator;
import org.apache.omid.transaction.PostCommitActions;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.RuntimeExceptionPanicker;
import org.apache.omid.tso.TimestampOracle;
import org.apache.omid.tso.TimestampOracleImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionClientTest {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionClientTest.class);
    private static final String TEST_TABLE = "test-table";
    private Comparable[] rowId1 = new Comparable[]{"row1"};
    private Comparable[] rowId2 = new Comparable[]{"row2"};
    private Comparable[] dataValue1 = new Comparable[]{"testWrite-1"};

    @Test
    public void testIsCommitted() throws Exception {
        KarelDbTransactionManager tm = KarelDbTransactionManager.newInstance();
        VersionedCache cache = new VersionedCache(TEST_TABLE);
        TxVersionedCache txCache = new TxVersionedCache(cache);
        SnapshotFilterImpl snapshotFilter = new SnapshotFilterImpl(cache);
        KarelDbTransaction t1 = (KarelDbTransaction)tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)t1);
        txCache.put(this.rowId1, this.dataValue1);
        tm.commit((Transaction)t1);
        KarelDbTransaction t2 = (KarelDbTransaction)tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)t2);
        txCache.put(this.rowId2, this.dataValue1);
        KarelDbTransaction t3 = (KarelDbTransaction)tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)t3);
        txCache.put(this.rowId2, this.dataValue1);
        tm.commit((Transaction)t3);
        KarelDbCellId cellId1 = new KarelDbCellId(cache, this.rowId1, t1.getStartTimestamp());
        KarelDbCellId cellId2 = new KarelDbCellId(cache, this.rowId2, t2.getStartTimestamp());
        KarelDbCellId cellId3 = new KarelDbCellId(cache, this.rowId2, t3.getStartTimestamp());
        Assert.assertTrue((String)"row1 should be committed", (boolean)snapshotFilter.isCommitted(t1, cellId1));
        Assert.assertFalse((String)"row2 should not be committed for kv2", (boolean)snapshotFilter.isCommitted(t2, cellId2));
        Assert.assertTrue((String)"row2 should be committed for kv3", (boolean)snapshotFilter.isCommitted(t3, cellId3));
    }

    @Test
    public void testCellCommitTimestampIsLocatedInCache() throws Exception {
        KarelDbTransactionManager tm = KarelDbTransactionManager.newInstance();
        VersionedCache cache = new VersionedCache(TEST_TABLE);
        TxVersionedCache txCache = new TxVersionedCache(cache);
        SnapshotFilterImpl snapshotFilter = new SnapshotFilterImpl(cache);
        KarelDbTransaction t1 = (KarelDbTransaction)tm.begin();
        long CELL_ST = 1L;
        long CELL_CT = 2L;
        KarelDbCellId cellId = new KarelDbCellId(cache, this.rowId1, 1L);
        HashMap fakeCache = Maps.newHashMap();
        fakeCache.put(1L, 2L);
        KarelDbTransactionManager.CommitTimestampLocatorImpl ctLocator = new KarelDbTransactionManager.CommitTimestampLocatorImpl(cellId, (Map)fakeCache, cache);
        CommitTable.CommitTimestamp ct = snapshotFilter.locateCellCommitTimestamp(t1, 1L, (CommitTimestampLocator)ctLocator);
        Assert.assertTrue((boolean)ct.isValid());
        Assert.assertEquals((long)ct.getValue(), (long)2L);
        Assert.assertTrue((ct.getLocation().compareTo((Enum)CommitTable.CommitTimestamp.Location.CACHE) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCellCommitTimestampIsLocatedInCommitTable() throws Exception {
        InMemoryCommitTable commitTable = new InMemoryCommitTable();
        InMemoryTimestampStorage timestampStorage = new InMemoryTimestampStorage();
        TimestampOracleImpl timestampOracle = new TimestampOracleImpl((MetricsRegistry)new NullMetricsProvider(), (TimestampStorage)timestampStorage, (Panicker)new RuntimeExceptionPanicker());
        timestampOracle.initialize();
        PostCommitActions postCommitter = (PostCommitActions)Mockito.spy((Object)new KarelDbSyncPostCommitter(commitTable.getClient()));
        VersionedCache cache = new VersionedCache(TEST_TABLE);
        TxVersionedCache txCache = new TxVersionedCache(cache);
        SnapshotFilterImpl snapshotFilter = new SnapshotFilterImpl(cache);
        KarelDbTransactionManager tm = KarelDbTransactionManager.newInstance((CommitTable)commitTable, (TimestampOracle)timestampOracle, (PostCommitActions)postCommitter);
        ((PostCommitActions)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)postCommitter)).updateShadowCells((AbstractTransaction)ArgumentMatchers.any(KarelDbTransaction.class));
        KarelDbTransaction tx1 = (KarelDbTransaction)tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)tx1);
        txCache.put(this.rowId1, this.dataValue1);
        try {
            tm.commit((Transaction)tx1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        KarelDbCellId cellId = new KarelDbCellId(cache, this.rowId1, tx1.getStartTimestamp());
        KarelDbTransactionManager.CommitTimestampLocatorImpl ctLocator = new KarelDbTransactionManager.CommitTimestampLocatorImpl(cellId, (Map)Maps.newHashMap(), cache);
        CommitTable.CommitTimestamp ct = snapshotFilter.locateCellCommitTimestamp(tx1, tx1.getStartTimestamp(), (CommitTimestampLocator)ctLocator);
        Assert.assertTrue((boolean)ct.isValid());
        long expectedCommitTS = tx1.getStartTimestamp() + 50L;
        Assert.assertEquals((long)ct.getValue(), (long)expectedCommitTS);
        Assert.assertTrue((ct.getLocation().compareTo((Enum)CommitTable.CommitTimestamp.Location.COMMIT_TABLE) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCellCommitTimestampIsLocatedInShadowCells() throws Exception {
        KarelDbTransactionManager tm = KarelDbTransactionManager.newInstance();
        VersionedCache cache = new VersionedCache(TEST_TABLE);
        TxVersionedCache txCache = new TxVersionedCache(cache);
        SnapshotFilterImpl snapshotFilter = new SnapshotFilterImpl(cache);
        KarelDbTransaction tx1 = (KarelDbTransaction)tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)tx1);
        txCache.put(this.rowId1, this.dataValue1);
        tm.commit((Transaction)tx1);
        KarelDbCellId cellId = new KarelDbCellId(cache, this.rowId1, tx1.getStartTimestamp());
        KarelDbTransactionManager.CommitTimestampLocatorImpl ctLocator = new KarelDbTransactionManager.CommitTimestampLocatorImpl(cellId, (Map)Maps.newHashMap(), cache);
        CommitTable.CommitTimestamp ct = snapshotFilter.locateCellCommitTimestamp(tx1, tx1.getStartTimestamp(), (CommitTimestampLocator)ctLocator);
        Assert.assertTrue((boolean)ct.isValid());
        Assert.assertEquals((long)ct.getValue(), (long)tx1.getCommitTimestamp());
        Assert.assertTrue((ct.getLocation().compareTo((Enum)CommitTable.CommitTimestamp.Location.SHADOW_CELL) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCellFromTransactionInPreviousEpochGetsInvalidCommitTimestamp() throws Exception {
        InMemoryCommitTable commitTable = new InMemoryCommitTable();
        InMemoryTimestampStorage timestampStorage = new InMemoryTimestampStorage();
        TimestampOracleImpl timestampOracle = new TimestampOracleImpl((MetricsRegistry)new NullMetricsProvider(), (TimestampStorage)timestampStorage, (Panicker)new RuntimeExceptionPanicker());
        timestampOracle.initialize();
        PostCommitActions postCommitter = (PostCommitActions)Mockito.spy((Object)new KarelDbSyncPostCommitter(commitTable.getClient()));
        VersionedCache cache = new VersionedCache(TEST_TABLE);
        TxVersionedCache txCache = new TxVersionedCache(cache);
        SnapshotFilterImpl snapshotFilter = new SnapshotFilterImpl(cache);
        KarelDbTransactionManager tm = KarelDbTransactionManager.newInstance((CommitTable)commitTable, (TimestampOracle)timestampOracle, (PostCommitActions)postCommitter);
        long CURRENT_EPOCH_FAKE = (System.currentTimeMillis() + 10000L) * 50L;
        KarelDbTransaction tx1 = (KarelDbTransaction)Mockito.spy((Object)((KarelDbTransaction)tm.begin()));
        ((KarelDbTransaction)Mockito.doReturn((Object)CURRENT_EPOCH_FAKE).when((Object)tx1)).getEpoch();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)tx1);
        txCache.put(this.rowId1, this.dataValue1);
        KarelDbCellId cellId = new KarelDbCellId(cache, this.rowId1, tx1.getStartTimestamp());
        KarelDbTransactionManager.CommitTimestampLocatorImpl ctLocator = new KarelDbTransactionManager.CommitTimestampLocatorImpl(cellId, (Map)Maps.newHashMap(), cache);
        CommitTable.CommitTimestamp ct = snapshotFilter.locateCellCommitTimestamp(tx1, tx1.getStartTimestamp(), (CommitTimestampLocator)ctLocator);
        Assert.assertFalse((boolean)ct.isValid());
        Assert.assertEquals((long)ct.getValue(), (long)-1L);
        Assert.assertTrue((ct.getLocation().compareTo((Enum)CommitTable.CommitTimestamp.Location.COMMIT_TABLE) == 0 ? 1 : 0) != 0);
    }
}

