/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.version.TxVersionedCache;
import io.kareldb.version.VersionedCache;
import io.kareldb.version.VersionedValue;
import java.util.ArrayList;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReadPathTest {
    private static final String TEST_TABLE = "test-table";
    private Comparable[] rowId1 = new Comparable[]{"row1"};
    private Comparable[] dataValue1 = new Comparable[]{"testWrite-1"};
    private Comparable[] dataValue2 = new Comparable[]{"testWrite-2"};
    private TransactionManager tm;
    private TxVersionedCache versionedCache;

    @Before
    public void setUp() throws Exception {
        this.tm = KarelDbTransactionManager.newInstance();
        this.versionedCache = new TxVersionedCache(new VersionedCache(TEST_TABLE));
    }

    @After
    public void tearDown() throws Exception {
        this.tm.close();
    }

    @Test
    public void testReadInterleaved() throws Exception {
        Transaction t1 = this.tm.begin();
        Transaction t2 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        this.tm.commit(t1);
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t2));
        Assert.assertNull((Object)this.versionedCache.get(this.rowId1));
    }

    @Test
    public void testReadWithSeveralUncommitted() throws Exception {
        Transaction t = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        this.tm.commit(t);
        ArrayList<Transaction> running = new ArrayList<Transaction>();
        for (int i = 0; i < 10; ++i) {
            t = this.tm.begin();
            KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)t));
            this.versionedCache.replace(this.rowId1, this.dataValue1, this.dataValue2);
            running.add(t);
        }
        t = this.tm.begin();
        VersionedValue v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
        this.tm.commit(t);
        for (Transaction r : running) {
            this.tm.rollback(r);
        }
    }
}

