/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction.client;

import io.kareldb.transaction.client.KarelDbTransaction;
import io.kareldb.transaction.client.KarelDbTransactionManager;
import io.kareldb.version.TxVersionedCache;
import io.kareldb.version.VersionedCache;
import io.kareldb.version.VersionedValue;
import java.util.List;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.transaction.TransactionException;
import org.apache.omid.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointTest {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointTest.class);
    private static final String TEST_TABLE = "test-table";
    private Comparable[] rowId1 = new Comparable[]{"row1"};
    private Comparable[] dataValue0 = new Comparable[]{"testWrite-0"};
    private Comparable[] dataValue1 = new Comparable[]{"testWrite-1"};
    private Comparable[] dataValue2 = new Comparable[]{"testWrite-2"};
    private Comparable[] dataValue3 = new Comparable[]{"testWrite-3"};
    private TransactionManager tm;
    private TxVersionedCache versionedCache;

    @Before
    public void setUp() throws Exception {
        this.tm = KarelDbTransactionManager.newInstance();
        this.versionedCache = new TxVersionedCache(new VersionedCache(TEST_TABLE));
    }

    @After
    public void tearDown() throws Exception {
        this.tm.close();
    }

    @Test
    public void testFewCheckPoints() throws Exception {
        Transaction tx1 = this.tm.begin();
        KarelDbTransaction kdbTx1 = (KarelDbTransaction)tx1;
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        VersionedValue v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
        kdbTx1.checkpoint();
        this.versionedCache.replace(this.rowId1, this.dataValue1, this.dataValue2);
        v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
        kdbTx1.setVisibilityLevel(AbstractTransaction.VisibilityLevel.SNAPSHOT);
        v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue2, (Object[])v1.getValue());
        kdbTx1.checkpoint();
        this.versionedCache.replace(this.rowId1, this.dataValue2, this.dataValue3);
        v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue2, (Object[])v1.getValue());
        kdbTx1.checkpoint();
        v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue3, (Object[])v1.getValue());
        kdbTx1.setVisibilityLevel(AbstractTransaction.VisibilityLevel.SNAPSHOT_ALL);
        List values = this.versionedCache.getAll(this.rowId1);
        Assert.assertEquals((String)("Expected 3 results and found " + values.size()), (long)3L, (long)values.size());
        Assert.assertArrayEquals((Object[])this.dataValue3, (Object[])((VersionedValue)values.get(0)).getValue());
        Assert.assertArrayEquals((Object[])this.dataValue2, (Object[])((VersionedValue)values.get(1)).getValue());
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])((VersionedValue)values.get(2)).getValue());
    }

    @Test
    public void testSnapshot() throws Exception {
        Transaction tx1 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.put(this.rowId1, this.dataValue0);
        this.tm.commit(tx1);
        tx1 = this.tm.begin();
        KarelDbTransaction kdbTx1 = (KarelDbTransaction)tx1;
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        VersionedValue v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue0, (Object[])v1.getValue());
        this.versionedCache.replace(this.rowId1, this.dataValue0, this.dataValue1);
        v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
        kdbTx1.checkpoint();
        this.versionedCache.replace(this.rowId1, this.dataValue1, this.dataValue2);
        v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
        kdbTx1.setVisibilityLevel(AbstractTransaction.VisibilityLevel.SNAPSHOT);
        v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue2, (Object[])v1.getValue());
    }

    @Test
    public void testSnapshotAll() throws Exception {
        Transaction tx1 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.put(this.rowId1, this.dataValue0);
        this.tm.commit(tx1);
        tx1 = this.tm.begin();
        KarelDbTransaction kdbTx1 = (KarelDbTransaction)tx1;
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        VersionedValue v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue0, (Object[])v1.getValue());
        this.versionedCache.replace(this.rowId1, this.dataValue0, this.dataValue1);
        v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
        kdbTx1.checkpoint();
        this.versionedCache.replace(this.rowId1, this.dataValue1, this.dataValue2);
        v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
        kdbTx1.setVisibilityLevel(AbstractTransaction.VisibilityLevel.SNAPSHOT_ALL);
        List values = this.versionedCache.getAll(this.rowId1);
        Assert.assertEquals((String)("Expected 3 results and found " + values.size()), (long)3L, (long)values.size());
        Assert.assertArrayEquals((Object[])this.dataValue2, (Object[])((VersionedValue)values.get(0)).getValue());
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])((VersionedValue)values.get(1)).getValue());
        Assert.assertArrayEquals((Object[])this.dataValue0, (Object[])((VersionedValue)values.get(2)).getValue());
    }

    @Test
    public void testSnapshotExcludeCurrent() throws Exception {
        Transaction tx1 = this.tm.begin();
        KarelDbTransaction kdbTx1 = (KarelDbTransaction)tx1;
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        VersionedValue v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
        kdbTx1.checkpoint();
        this.versionedCache.replace(this.rowId1, this.dataValue1, this.dataValue2);
        v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
        kdbTx1.setVisibilityLevel(AbstractTransaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT);
        v1 = this.versionedCache.get(this.rowId1);
        Assert.assertArrayEquals((Object[])this.dataValue1, (Object[])v1.getValue());
    }

    @Test
    public void testDeleteAfterCheckpoint() throws Exception {
        Transaction tx1 = this.tm.begin();
        KarelDbTransaction.setCurrentTransaction((KarelDbTransaction)((KarelDbTransaction)tx1));
        this.versionedCache.put(this.rowId1, this.dataValue1);
        this.tm.commit(tx1);
        Transaction tx2 = this.tm.begin();
        KarelDbTransaction kdbTx2 = (KarelDbTransaction)tx2;
        kdbTx2.checkpoint();
        this.versionedCache.remove(this.rowId1);
        try {
            this.tm.commit(tx2);
        }
        catch (TransactionException e) {
            Assert.fail();
        }
    }

    @Test
    public void testOutOfCheckpoints() throws Exception {
        Transaction tx1 = this.tm.begin();
        KarelDbTransaction kdbTx1 = (KarelDbTransaction)tx1;
        for (int i = 0; i < 49; ++i) {
            kdbTx1.checkpoint();
        }
        try {
            kdbTx1.checkpoint();
            Assert.fail();
        }
        catch (TransactionException transactionException) {
            // empty catch block
        }
    }
}

