/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction;

import io.kareldb.transaction.KarelDbTimestampStorage;
import io.kcache.Cache;
import io.kcache.utils.InMemoryCache;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampStorageTest {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampStorageTest.class);

    @Test
    public void testTimestampStorage() throws Exception {
        long INITIAL_TS_VALUE = 0L;
        KarelDbTimestampStorage tsStorage = new KarelDbTimestampStorage((Cache)new InMemoryCache());
        Assert.assertEquals((String)"Initial value should be 0", (long)tsStorage.getMaxTimestamp(), (long)0L);
        long newTimestamp = 1L;
        tsStorage.updateMaxTimestamp(0L, newTimestamp);
        long wrongTimestamp = 20L;
        try {
            tsStorage.updateMaxTimestamp(wrongTimestamp, newTimestamp);
            Assert.fail((String)"Shouldn't update");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((String)("Value should be still " + newTimestamp), (long)tsStorage.getMaxTimestamp(), (long)newTimestamp);
        long veryNewTimestamp = 40L;
        tsStorage.updateMaxTimestamp(newTimestamp, veryNewTimestamp);
        Assert.assertEquals((String)("Value should be " + veryNewTimestamp), (long)tsStorage.getMaxTimestamp(), (long)veryNewTimestamp);
    }
}

