/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.transaction;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import io.kareldb.transaction.KarelDbCommitTable;
import io.kcache.Cache;
import io.kcache.utils.InMemoryCache;
import org.apache.omid.committable.CommitTable;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitTableTest {
    private static final Logger LOG = LoggerFactory.getLogger(CommitTableTest.class);

    @Test
    public void testBasicBehaviour() throws Throwable {
        InMemoryCache cache = new InMemoryCache();
        KarelDbCommitTable commitTable = new KarelDbCommitTable((Cache)cache);
        CommitTable.Writer writer = commitTable.getWriter();
        CommitTable.Client client = commitTable.getClient();
        Assert.assertEquals((String)"Rows should be 0!", (long)cache.size(), (long)0L);
        for (int i = 0; i < 1000; i += 50) {
            writer.addCommittedTransaction((long)i, (long)(i + 1));
        }
        writer.flush();
        Assert.assertEquals((String)"Rows should be 1000!", (long)cache.size(), (long)20L);
        for (long i = 0L; i < 1000L; ++i) {
            Optional commitTimestamp = (Optional)client.getCommitTimestamp(i).get();
            Assert.assertTrue((boolean)commitTimestamp.isPresent());
            Assert.assertTrue((boolean)((CommitTable.CommitTimestamp)commitTimestamp.get()).isValid());
            long ct = ((CommitTable.CommitTimestamp)commitTimestamp.get()).getValue();
            long expected = i - i % 50L + 1L;
            Assert.assertEquals((String)("Commit timestamp should be " + expected), (long)ct, (long)expected);
        }
        Assert.assertEquals((String)"Rows should be 1000!", (long)cache.size(), (long)20L);
        for (long i = 0L; i < 1000L; i += 50L) {
            ListenableFuture f = client.deleteCommitEntry(i);
            f.get();
        }
        Assert.assertEquals((String)"Rows should be 0!", (long)cache.size(), (long)0L);
        Optional commitTimestamp = (Optional)client.getCommitTimestamp(0L).get();
        Assert.assertFalse((String)"Commit timestamp should not be present", (boolean)commitTimestamp.isPresent());
        Assert.assertEquals((String)"Rows should be 0!", (long)cache.size(), (long)0L);
        ListenableFuture lowWatermarkFuture = client.readLowWatermark();
        Assert.assertEquals((String)"Low watermark should be 0", (Object)lowWatermarkFuture.get(), (Object)0L);
        for (int lowWatermark = 0; lowWatermark < 1000; ++lowWatermark) {
            writer.updateLowWatermark((long)lowWatermark);
        }
        writer.flush();
        Assert.assertEquals((String)"Should there be only row!", (long)cache.size(), (long)1L);
        lowWatermarkFuture = client.readLowWatermark();
        long lowWatermark = (Long)lowWatermarkFuture.get();
        Assert.assertEquals((String)"Low watermark should be 999", (long)lowWatermark, (long)999L);
        Assert.assertEquals((String)"Should there be only one row", (long)cache.size(), (long)1L);
    }

    @Test
    public void testCheckpoints() throws Throwable {
        InMemoryCache cache = new InMemoryCache();
        KarelDbCommitTable commitTable = new KarelDbCommitTable((Cache)cache);
        CommitTable.Writer writer = commitTable.getWriter();
        CommitTable.Client client = commitTable.getClient();
        Assert.assertEquals((String)"Rows should be 0!", (long)cache.size(), (long)0L);
        long st = 0L;
        long ct = 1L;
        writer.addCommittedTransaction(st, ct);
        writer.flush();
        for (int i = 0; i < 50; ++i) {
            Optional commitTimestamp = (Optional)client.getCommitTimestamp((long)i).get();
            Assert.assertTrue((boolean)commitTimestamp.isPresent());
            Assert.assertTrue((boolean)((CommitTable.CommitTimestamp)commitTimestamp.get()).isValid());
            Assert.assertEquals((long)ct, (long)((CommitTable.CommitTimestamp)commitTimestamp.get()).getValue());
        }
        Assert.assertFalse((boolean)((Boolean)client.tryInvalidateTransaction(st + 1L).get()));
        long st2 = 100L;
        long ct2 = 101L;
        Assert.assertTrue((boolean)((Boolean)client.tryInvalidateTransaction(st2 + 1L).get()));
        Assert.assertFalse((boolean)writer.atomicAddCommittedTransaction(st2, ct2));
        client.deleteCommitEntry(st2 + 1L).get();
        Assert.assertTrue((boolean)writer.atomicAddCommittedTransaction(st2, ct2));
    }

    @Test
    public void testTransactionInvalidation() throws Throwable {
        boolean TX1_ST = false;
        boolean TX1_CT = true;
        int TX2_ST = 50;
        int TX2_CT = 51;
        InMemoryCache cache = new InMemoryCache();
        KarelDbCommitTable commitTable = new KarelDbCommitTable((Cache)cache);
        CommitTable.Writer writer = commitTable.getWriter();
        CommitTable.Client client = commitTable.getClient();
        Assert.assertEquals((String)"Rows should be 0!", (long)cache.size(), (long)0L);
        writer.addCommittedTransaction(0L, 1L);
        writer.flush();
        Optional commitTimestamp = (Optional)client.getCommitTimestamp(0L).get();
        Assert.assertTrue((boolean)commitTimestamp.isPresent());
        Assert.assertTrue((boolean)((CommitTable.CommitTimestamp)commitTimestamp.get()).isValid());
        long ct = ((CommitTable.CommitTimestamp)commitTimestamp.get()).getValue();
        Assert.assertEquals((String)"Commit timestamp should be 1", (long)ct, (long)1L);
        boolean wasInvalidated = (Boolean)client.tryInvalidateTransaction(0L).get();
        Assert.assertFalse((String)"Transaction should not be invalidated", (boolean)wasInvalidated);
        commitTimestamp = (Optional)client.getCommitTimestamp(0L).get();
        Assert.assertTrue((boolean)commitTimestamp.isPresent());
        Assert.assertTrue((boolean)((CommitTable.CommitTimestamp)commitTimestamp.get()).isValid());
        ct = ((CommitTable.CommitTimestamp)commitTimestamp.get()).getValue();
        Assert.assertEquals((String)"Commit timestamp should be 1", (long)ct, (long)1L);
        wasInvalidated = (Boolean)client.tryInvalidateTransaction(50L).get();
        Assert.assertTrue((String)"Transaction should be invalidated", (boolean)wasInvalidated);
        commitTimestamp = (Optional)client.getCommitTimestamp(50L).get();
        Assert.assertTrue((boolean)commitTimestamp.isPresent());
        Assert.assertFalse((boolean)((CommitTable.CommitTimestamp)commitTimestamp.get()).isValid());
        ct = ((CommitTable.CommitTimestamp)commitTimestamp.get()).getValue();
        Assert.assertEquals((String)"Commit timestamp should be -1", (long)ct, (long)-1L);
        writer.addCommittedTransaction(50L, 51L);
        writer.flush();
        commitTimestamp = (Optional)client.getCommitTimestamp(50L).get();
        Assert.assertTrue((boolean)commitTimestamp.isPresent());
        Assert.assertFalse((boolean)((CommitTable.CommitTimestamp)commitTimestamp.get()).isValid());
        ct = ((CommitTable.CommitTimestamp)commitTimestamp.get()).getValue();
        Assert.assertEquals((String)"Commit timestamp should be -1", (long)ct, (long)-1L);
        Assert.assertEquals((String)"Rows should be 2!", (long)cache.size(), (long)2L);
    }
}

