/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.jdbc;

import io.kareldb.jdbc.BaseJDBCTestCase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;

public class TransactionsTest
extends BaseJDBCTestCase {
    @Test
    public void test() throws Exception {
        try (Connection con = this.createConnection();
             Connection con2 = this.createConnection();
             Statement statement = con.createStatement();
             Statement statement2 = con2.createStatement();){
            statement.execute("CREATE TABLE mytable (key varchar, name varchar, constraint pk primary key (key))");
            con.setAutoCommit(false);
            con2.setAutoCommit(true);
            Assert.assertEquals((long)1L, (long)statement.executeUpdate("INSERT INTO mytable (key,name) values('k1','name1')"));
            Assert.assertEquals((long)1L, (long)statement.executeUpdate("INSERT INTO mytable (key,name) values('k2','name2')"));
            Assert.assertEquals((long)1L, (long)statement.executeUpdate("INSERT INTO mytable (key,name) values('k3','name3')"));
            try (ResultSet rs = statement2.executeQuery("SELECT COUNT(*) FROM mytable");){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)0L, (long)rs.getLong(1));
            }
            con.commit();
            rs = statement2.executeQuery("SELECT COUNT(*) FROM mytable");
            var10_18 = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)3L, (long)rs.getLong(1));
            }
            catch (Throwable throwable) {
                var10_18 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var10_18 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var10_18.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            Assert.assertEquals((long)1L, (long)statement.executeUpdate("INSERT INTO mytable (key,name) values('k4','name4')"));
            con.commit();
            Assert.assertEquals((long)1L, (long)statement.executeUpdate("INSERT INTO mytable (key,name) values('k5','name5')"));
            rs = statement2.executeQuery("SELECT COUNT(*) FROM mytable");
            var10_18 = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)4L, (long)rs.getLong(1));
            }
            catch (Throwable throwable) {
                var10_18 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var10_18 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var10_18.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            rs = statement.executeQuery("SELECT COUNT(*) FROM mytable");
            var10_18 = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)5L, (long)rs.getLong(1));
            }
            catch (Throwable throwable) {
                var10_18 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var10_18 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var10_18.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            con.rollback();
            rs = statement2.executeQuery("SELECT COUNT(*) FROM mytable");
            var10_18 = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)4L, (long)rs.getLong(1));
            }
            catch (Throwable throwable) {
                var10_18 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var10_18 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var10_18.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            rs = statement.executeQuery("SELECT COUNT(*) FROM mytable");
            var10_18 = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)4L, (long)rs.getLong(1));
            }
            catch (Throwable throwable) {
                var10_18 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var10_18 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var10_18.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            con.commit();
            var10_18 = null;
            try (PreparedStatement ps1 = con.prepareStatement("SELECT COUNT(*) FROM mytable");
                 ResultSet rs = ps1.executeQuery();){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)4L, (long)rs.getLong(1));
            }
            catch (Throwable throwable) {
                var10_18 = throwable;
                throw throwable;
            }
            con.commit();
            ps1 = con.prepareStatement("UPDATE mytable set name='aa' WHERE 1=-1");
            var10_18 = null;
            try {
                Assert.assertEquals((long)0L, (long)ps1.executeUpdate());
            }
            catch (Throwable throwable) {
                var10_18 = throwable;
                throw throwable;
            }
            finally {
                if (ps1 != null) {
                    if (var10_18 != null) {
                        try {
                            ps1.close();
                        }
                        catch (Throwable throwable) {
                            var10_18.addSuppressed(throwable);
                        }
                    } else {
                        ps1.close();
                    }
                }
            }
            con.commit();
            ps1 = con.prepareStatement("UPDATE mytable set name='aa' WHERE 1=1");
            var10_18 = null;
            try {
                Assert.assertEquals((long)4L, (long)ps1.executeUpdate());
            }
            catch (Throwable throwable) {
                var10_18 = throwable;
                throw throwable;
            }
            finally {
                if (ps1 != null) {
                    if (var10_18 != null) {
                        try {
                            ps1.close();
                        }
                        catch (Throwable throwable) {
                            var10_18.addSuppressed(throwable);
                        }
                    } else {
                        ps1.close();
                    }
                }
            }
            con.commit();
            ps1 = con.prepareStatement("UPDATE mytable set name='aa' WHERE key='k5'");
            var10_18 = null;
            try {
                Assert.assertEquals((long)0L, (long)ps1.executeUpdate());
            }
            catch (Throwable throwable) {
                var10_18 = throwable;
                throw throwable;
            }
            finally {
                if (ps1 != null) {
                    if (var10_18 != null) {
                        try {
                            ps1.close();
                        }
                        catch (Throwable throwable) {
                            var10_18.addSuppressed(throwable);
                        }
                    } else {
                        ps1.close();
                    }
                }
            }
            con.commit();
        }
    }
}

