/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.jdbc;

import com.google.common.io.Files;
import io.kareldb.KarelDbEngine;
import io.kareldb.jdbc.JDBC;
import io.kareldb.schema.SchemaFactory;
import io.kareldb.utils.ClusterTestHarness;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJDBCTestCase
extends ClusterTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(BaseJDBCTestCase.class);
    private static final boolean ORDERED = true;
    private static final boolean UNORDERED = false;
    private File tempDir;
    private Connection conn;
    private List<Statement> statements;
    private List<Connection> connections;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.tempDir = Files.createTempDir();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            if (this.statements != null) {
                for (Statement s : this.statements) {
                    s.close();
                }
                this.statements = null;
            }
            if (this.connections != null) {
                for (Connection c : this.connections) {
                    JDBC.cleanup(c);
                }
                this.connections = null;
            }
            this.conn = null;
            KarelDbEngine.closeInstance();
            FileUtils.deleteDirectory((File)this.tempDir);
        }
        catch (Exception e) {
            LOG.warn("Exception during tearDown", (Throwable)e);
        }
        super.tearDown();
    }

    public Connection getConnection() throws SQLException {
        if (this.conn != null) {
            if (!this.conn.isClosed()) {
                return this.conn;
            }
            this.conn = null;
        }
        this.conn = this.createConnection();
        return this.conn;
    }

    protected void initializeConnection(Connection conn) throws SQLException {
    }

    public Statement createStatement() throws SQLException {
        Statement s = this.getConnection().createStatement();
        this.addStatement(s);
        return s;
    }

    private void addStatement(Statement s) {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.statements.add(s);
    }

    private void addConnection(Connection c) {
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        }
        this.connections.add(c);
    }

    public void closeStatement(Statement s) throws SQLException {
        s.close();
        if (this.statements != null) {
            this.statements.remove(s);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement s = this.getConnection().createStatement(resultSetType, resultSetConcurrency);
        this.addStatement(s);
        return s;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql);
        this.addStatement(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
        this.addStatement(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.addStatement(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql, autoGeneratedKeys);
        this.addStatement(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql, columnIndexes);
        this.addStatement(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql, columnNames);
        this.addStatement(ps);
        return ps;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement cs = this.getConnection().prepareCall(sql);
        this.addStatement(cs);
        return cs;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement cs = this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
        this.addStatement(cs);
        return cs;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement cs = this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.addStatement(cs);
        return cs;
    }

    public void setAutoCommit(boolean commit) throws SQLException {
        this.getConnection().setAutoCommit(commit);
    }

    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    protected Connection createConnection() throws SQLException {
        Properties properties = this.createProperties();
        Connection conn = DriverManager.getConnection("jdbc:kareldb:", properties);
        this.addConnection(conn);
        this.initializeConnection(conn);
        return conn;
    }

    protected Properties createProperties() {
        Properties properties = new Properties();
        properties.put(CalciteConnectionProperty.SCHEMA_FACTORY.camelName(), SchemaFactory.class.getName());
        properties.put(CalciteConnectionProperty.PARSER_FACTORY.camelName(), "org.apache.calcite.sql.ddl.ExtensionDdlExecutor#PARSER_FACTORY");
        properties.put("schema.kind", "io.kareldb.kafka.KafkaSchema");
        properties.put("schema.kafkacache.bootstrap.servers", this.bootstrapServers);
        properties.put("schema.rocksdb.enable", "true");
        properties.put("schema.rocksdb.root.dir", this.tempDir.getAbsolutePath());
        return properties;
    }

    public Connection createConnection(String user, String password) throws SQLException {
        Connection conn = null;
        this.addConnection(conn);
        this.initializeConnection(conn);
        return conn;
    }

    public static void assertBlobEquals(Blob b1, Blob b2) throws IOException, SQLException {
        if (b1 == null || b2 == null) {
            Assert.assertNull((String)"Blob b2 is null, b1 is not", (Object)b1);
            Assert.assertNull((String)"Blob b1 is null, b2 is not", (Object)b2);
            return;
        }
        Assert.assertEquals((String)"Blobs have different lengths", (long)b1.length(), (long)b2.length());
        InputStream is1 = b1.getBinaryStream();
        InputStream is2 = b2.getBinaryStream();
        if (is1 == null || is2 == null) {
            Assert.assertNull((String)"Blob b2 has null-stream, blob b1 doesn't", (Object)is1);
            Assert.assertNull((String)"Blob b1 has null-stream, blob b2 doesn't", (Object)is2);
            return;
        }
        is1 = new BufferedInputStream(is1);
        is2 = new BufferedInputStream(is2);
        long index = 1L;
        int by1 = is1.read();
        int by2 = is2.read();
        do {
            if (by1 != by2) {
                Assert.assertEquals((String)("Blobs differ at index " + index), (long)by1, (long)by2);
            }
            ++index;
            by1 = is1.read();
            by2 = is2.read();
        } while (by1 != -1 || by2 != -1);
        is1.close();
        is2.close();
    }

    public static void assertClobEquals(Clob c1, Clob c2) throws IOException, SQLException {
        if (c1 == null || c2 == null) {
            Assert.assertNull((String)"Clob c2 is null, c1 is not", (Object)c1);
            Assert.assertNull((String)"Clob c1 is null, c2 is not", (Object)c2);
            return;
        }
        Assert.assertEquals((String)"Clobs have different lengths", (long)c1.length(), (long)c2.length());
        Reader r1 = c1.getCharacterStream();
        Assert.assertNotNull((Object)r1);
        Reader r2 = c2.getCharacterStream();
        Assert.assertNotNull((Object)r2);
        r1 = new BufferedReader(r1);
        r2 = new BufferedReader(r2);
        long index = 1L;
        int ch1 = r1.read();
        int ch2 = r2.read();
        do {
            if (ch1 != ch2) {
                Assert.assertEquals((String)("Clobs differ at index " + index), (long)ch1, (long)ch2);
            }
            ++index;
            ch1 = r1.read();
            ch2 = r2.read();
        } while (ch1 != -1 || ch2 != -1);
        r1.close();
        r2.close();
    }

    public static void assertSQLState(String message, String expected, SQLException exception) {
        Assert.assertNotNull((String)"Exception cannot be null when asserting on SQLState", (Object)exception);
        try {
            String state = exception.getSQLState();
            if (state != null) {
                Assert.assertTrue((String)"The exception's SQL state must be five characters long", (state.length() == 5 ? 1 : 0) != 0);
            }
            if (expected != null) {
                Assert.assertTrue((String)"The expected SQL state must be five characters long", (expected.length() == 5 ? 1 : 0) != 0);
            }
            Assert.assertEquals((String)message, (Object)expected, (Object)state);
        }
        catch (AssertionFailedError e) {
            e.initCause((Throwable)exception);
            exception = exception.getNextException();
            if (exception != null) {
                BaseJDBCTestCase.assertSQLState(message, expected, exception);
            }
            throw e;
        }
    }

    public static void assertWarning(Connection conn, String expected) throws SQLException {
        SQLWarning firstWarning = conn.getWarnings();
        Assert.assertNotNull((Object)firstWarning);
        for (SQLWarning warning = firstWarning; warning != null; warning = warning.getNextWarning()) {
            if (!expected.equals(warning.getSQLState())) continue;
            return;
        }
        Assert.fail((String)("Expected to see a SQLWarning with the SQLState " + expected));
    }

    public static void assertSQLState(String expected, SQLException exception) {
        BaseJDBCTestCase.assertSQLState("Unexpected SQL state.", expected, exception);
    }

    public static void assertErrorCode(int expected, SQLException exception) {
        Assert.assertNotNull((String)"Exception should not be null", (Object)exception);
        int actual = exception.getErrorCode();
        if (actual != expected) {
            Assert.fail((String)("Expected error code " + expected + ", got " + actual));
        }
    }

    public void assertCompileError(String sqlState, String sql) {
        try {
            PreparedStatement pSt = this.prepareStatement(sql);
            Assert.fail((String)("expected compile error: " + sqlState));
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
        }
    }

    protected void assertTableRowCount(String table, int rowCount) throws SQLException {
        this.assertEscapedTableRowCount(JDBC.escape(table), rowCount);
    }

    private void assertEscapedTableRowCount(String escapedTableName, int rowCount) throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM " + escapedTableName);
        rs.next();
        Assert.assertEquals((String)(escapedTableName + " row count:"), (long)rowCount, (long)rs.getInt(1));
        rs.close();
        s.close();
    }

    protected final void emptyStatementCache() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CALL SYSCS_UTIL.SYSCS_EMPTY_STATEMENT_CACHE()");
        this.closeStatement(s);
    }

    public final void dropTable(String tableName) throws SQLException {
        BaseJDBCTestCase.dropTable(this.getConnection(), tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTable(Connection conn, String tableName) throws SQLException {
        String dropSQL = "DROP TABLE " + tableName;
        try (Statement statement = conn.createStatement();){
            statement.executeUpdate(dropSQL);
        }
    }

    public static void assertStatementError(String[] sqlStates, Statement st, String query) {
        BaseJDBCTestCase.assertStatementErrorMinion(sqlStates, true, st, query);
    }

    public static void assertStatementErrorUnordered(String[] sqlStates, Statement st, String query) {
        BaseJDBCTestCase.assertStatementErrorMinion(sqlStates, false, st, query);
    }

    private static void assertStatementErrorMinion(String[] sqlStates, boolean orderedStates, Statement st, String query) {
        ArrayList<String> statesBag = null;
        if (!orderedStates) {
            statesBag = new ArrayList<String>(Arrays.asList(sqlStates));
        }
        try {
            boolean haveRS = st.execute(query);
            BaseJDBCTestCase.fetchAndDiscardAllResults(st, haveRS);
            String errorMsg = "Expected error(s) '";
            for (String sqlState : sqlStates) {
                errorMsg = errorMsg + " " + sqlState;
            }
            errorMsg = errorMsg + "' but no error was thrown.";
            Assert.fail((String)errorMsg);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void assertStatementError(String sqlState, Statement st, String query) {
        BaseJDBCTestCase.assertStatementError(new String[]{sqlState}, st, query);
    }

    public static void assertCommitError(String sqlState, Connection c) {
        try {
            c.commit();
            Assert.fail();
        }
        catch (SQLException e) {
            BaseJDBCTestCase.assertSQLState(sqlState, e);
        }
    }

    public static void assertStatementError(String sqlState, int errorCode, Statement st, String query) {
        try {
            boolean haveRS = st.execute(query);
            BaseJDBCTestCase.fetchAndDiscardAllResults(st, haveRS);
            Assert.fail((String)("Expected error '" + sqlState + "' but no error was thrown."));
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
            BaseJDBCTestCase.assertErrorCode(errorCode, se);
        }
    }

    public static void assertPreparedStatementError(String sqlState, PreparedStatement ps) {
        try {
            boolean haveRS = ps.execute();
            BaseJDBCTestCase.fetchAndDiscardAllResults(ps, haveRS);
            Assert.fail((String)("Expected error '" + sqlState + "' but no error was thrown."));
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
        }
    }

    public static void assertStatementError(String sqlState, PreparedStatement pSt) {
        try {
            boolean haveRS = pSt.execute();
            BaseJDBCTestCase.fetchAndDiscardAllResults(pSt, haveRS);
            Assert.fail((String)("Expected error '" + sqlState + "' but no error was thrown."));
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
        }
    }

    public void assertCallError(String expectedSE, String callSQL) throws SQLException {
        try {
            CallableStatement cs = this.prepareCall(callSQL);
            cs.execute();
            Assert.fail((String)"FAIL - SQL expected to throw exception");
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(expectedSE, se);
        }
    }

    public static void assertNextError(String sqlState, ResultSet rs) {
        try {
            rs.next();
            Assert.fail((String)"Expected error on next()");
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
        }
    }

    public static void assertGetIntError(int position, String sqlState, ResultSet rs) {
        try {
            rs.getInt(position);
            Assert.fail((String)("Expected exception " + sqlState));
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
        }
    }

    public static void assertUpdateCount(Statement st, int expectedRC, String sql) throws SQLException {
        Assert.assertEquals((String)"Update count does not match:", (long)expectedRC, (long)st.executeUpdate(sql));
    }

    public static void assertUpdateCount(PreparedStatement pSt, int expectedRC) throws SQLException {
        Assert.assertEquals((String)"Update count does not match:", (long)expectedRC, (long)pSt.executeUpdate());
    }

    public SQLException getLastSQLException(SQLException sqle) {
        SQLException current = sqle;
        for (SQLException next = sqle.getNextException(); next != null; next = next.getNextException()) {
            current = next;
        }
        return current;
    }

    private static void fetchAndDiscardAllResults(Statement st, boolean haveRS) throws SQLException {
        Object rs = null;
        while (haveRS || st.getUpdateCount() != -1) {
            if (haveRS) {
                JDBC.assertDrainResults(st.getResultSet(), -1);
            }
            haveRS = st.getMoreResults();
        }
    }

    public static void assertSQLExceptionEquals(SQLException se1, SQLException se2) {
        Assert.assertNotNull((String)"Passed-in SQLException se1 cannot be null", (Object)se1);
        Assert.assertNotNull((String)"Passed-in SQLException se2 cannot be null", (Object)se2);
        Assert.assertEquals((String)"SQLException class types are different", (Object)se1.getClass().getName(), (Object)se2.getClass().getName());
        Assert.assertEquals((String)"Detailed messages of the SQLException's are different", (Object)se1.getMessage(), (Object)se2.getMessage());
        Throwable se1Cause = se1.getCause();
        Throwable se2Cause = se2.getCause();
        if (se1Cause == null) {
            Assert.assertNull((Object)se2Cause);
        } else {
            Assert.assertEquals((Object)se1Cause, (Object)se2Cause);
        }
        if (se1.getNextException() == null) {
            Assert.assertNull((Object)se2.getNextException());
        } else {
            BaseJDBCTestCase.assertSQLExceptionEquals(se1.getNextException(), se2.getNextException());
        }
    }

    public static void assertEquivalentDataType(int expectedType, int type) {
        if (expectedType == type) {
            return;
        }
        if (expectedType == 3 && type == 2) {
            return;
        }
        if (expectedType == 2 && type == 3) {
            return;
        }
        if (expectedType == 8 && type == 6) {
            return;
        }
        if (expectedType == 6 && type == 8) {
            return;
        }
        Assert.fail((String)("types:" + expectedType + " and " + type + " are not equivalent"));
    }

    protected void checkAllConsistency(Connection conn) throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select schemaname, tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE(schemaname, tablename) from sys.systables a,  sys.sysschemas b where a.schemaid = b.schemaid");
        int table_count = 0;
        while (rs.next()) {
            ++table_count;
            if (rs.getInt(3) == 1) continue;
            Assert.assertEquals((String)("Bad return from consistency check of " + rs.getString(1) + "." + rs.getString(2)), (long)1L, (long)rs.getInt(3));
        }
        Assert.assertTrue((String)("Something wrong with consistency check query, found only " + table_count + " tables."), (table_count >= 5 ? 1 : 0) != 0);
        rs.close();
        s.close();
        conn.commit();
    }

    protected static void dumpRs(ResultSet s, PrintStream out) throws SQLException {
        if (s == null) {
            out.println("<NULL>");
            return;
        }
        ResultSetMetaData rsmd = s.getMetaData();
        int numCols = rsmd.getColumnCount();
        if (numCols <= 0) {
            out.println("(no columns!)");
            return;
        }
        StringBuilder heading = new StringBuilder("\t ");
        StringBuilder underline = new StringBuilder("\t ");
        for (int i = 1; i <= numCols; ++i) {
            if (i > 1) {
                heading.append(",");
                underline.append(" ");
            }
            int len = heading.length();
            heading.append(rsmd.getColumnLabel(i));
            for (int j = len = heading.length() - len; j > 0; --j) {
                underline.append("-");
            }
        }
        out.println(heading.toString());
        out.println(underline.toString());
        StringBuilder row = new StringBuilder();
        while (s.next()) {
            row.append("\t{");
            for (int i = 1; i <= numCols; ++i) {
                if (i > 1) {
                    row.append(",");
                }
                row.append(s.getString(i));
            }
            row.append("}\n");
        }
        out.println(row.toString());
        s.close();
    }

    public static void dumpRs(ResultSet s) throws SQLException {
        BaseJDBCTestCase.dumpRs(s, System.out);
    }

    protected void goodStatement(Connection conn, String command) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(conn, command);
        ps.execute();
        ps.close();
    }

    protected void goodUpdate(Connection conn, String update, int expectedRowCount) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(conn, update);
        int actualRowCount = ps.executeUpdate();
        ps.close();
        System.out.println("Expecting to touch " + expectedRowCount + " rows.");
        Assert.assertEquals((long)expectedRowCount, (long)actualRowCount);
    }

    protected void assertResults(Connection conn, String query, String[][] rows, boolean trimResults) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(conn, query);
        ResultSet rs = ps.executeQuery();
        this.assertResults(rs, rows, trimResults);
        rs.close();
        ps.close();
    }

    protected void assertResults(ResultSet rs, String[][] rows, boolean trimResults) throws SQLException {
        int rowCount = rows.length;
        for (String[] row : rows) {
            int columnCount = row.length;
            Assert.assertTrue((boolean)rs.next());
            for (int j = 0; j < columnCount; ++j) {
                String expectedValue = row[j];
                String actualValue = null;
                int column = j + 1;
                actualValue = rs.getString(column);
                if (rs.wasNull()) {
                    actualValue = null;
                }
                if (actualValue != null && trimResults) {
                    actualValue = actualValue.trim();
                }
                Assert.assertEquals((Object)(expectedValue == null ? 1 : 0), (Object)rs.wasNull());
                if (expectedValue == null) {
                    Assert.assertNull((Object)actualValue);
                    continue;
                }
                Assert.assertEquals((Object)expectedValue, (Object)actualValue);
            }
        }
        Assert.assertFalse((boolean)rs.next());
    }

    protected static ResultSet executeQuery(Statement stmt, String text) throws SQLException {
        System.out.println("Executing '" + text + "'");
        return stmt.executeQuery(text);
    }

    protected PreparedStatement chattyPrepare(Connection conn, String text) throws SQLException {
        System.out.println("Preparing statement:\n\t" + text);
        return conn.prepareStatement(text);
    }

    protected CallableStatement chattyPrepareCall(Connection conn, String text) throws SQLException {
        System.out.println("Preparing callable statement:\n\t" + text);
        return conn.prepareCall(text);
    }

    protected void expectCompilationError(String sqlState, String query) {
        System.out.println("\nExpecting " + sqlState + " when preparing:\n\t" + query);
        this.assertCompileError(sqlState, query);
    }

    protected void expectCompilationError(Connection conn, String sqlState, String query) {
        System.out.println("\nExpecting " + sqlState + " when preparing:\n\t" + query);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(query);
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
            return;
        }
        Assert.fail((String)("Expected SQL state: " + sqlState));
    }

    protected void expectExecutionError(Connection conn, String sqlState, String query) throws Exception {
        System.out.println("\nExpecting " + sqlState + " when executing:\n\t");
        PreparedStatement ps = this.chattyPrepare(conn, query);
        BaseJDBCTestCase.assertStatementError(sqlState, ps);
        ps.close();
    }
}

