/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.jdbc;

import io.kareldb.jdbc.BaseJDBCTestCase;
import io.kareldb.jdbc.JDBC;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;

public final class AlterTableTest
extends BaseJDBCTestCase {
    private static final String CANNOT_ALTER_NON_IDENTITY_COLUMN = "42Z29";
    private static final String CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN = "42Z23";
    private static final String DUPLICATE_KEY = "23505";
    private static final String EXHAUSTED_IDENTITY_COLUMN = "2200H";

    private void createTestObjects(Statement st) throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        st.executeUpdate("create table t0(c1 int not null, constraint p1 primary key (c1))");
        st.executeUpdate("create table t0_1(c1 int)");
        st.executeUpdate("create table t0_2(c1 int)");
        st.executeUpdate("create table t0_3(c1 int)");
        st.executeUpdate("create table t1(c1 int)");
        st.executeUpdate("create table t1_1(c1 int)");
        st.executeUpdate("create table t2(c1 int)");
        st.executeUpdate("create table t3(c1 int)");
        st.executeUpdate("create table t4(c1 int not null)");
        st.executeUpdate("insert into t1 values 1");
        st.executeUpdate("insert into t1_1 values 1");
        st.executeUpdate("insert into t2 values 1");
        st.executeUpdate("insert into t2 values 2");
        st.executeUpdate("insert into t3 values 1");
        st.executeUpdate("insert into t3 values 2");
        st.executeUpdate("insert into t3 values 3");
        st.executeUpdate("insert into t4 values 1, 2, 3");
    }

    private void checkWarning(Statement st, String expectedWarning) throws Exception {
        SQLWarning sqlWarn = st == null ? this.getConnection().getWarnings() : st.getWarnings();
        Assert.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
        AlterTableTest.assertSQLState(expectedWarning, sqlWarn);
    }

    @Test
    public void testAddColumn() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        this.commit();
        PreparedStatement ps_c1 = this.prepareStatement("select * from t1");
        ResultSet c1 = ps_c1.executeQuery();
        c1.close();
        ps_c1.close();
        st.executeUpdate("alter table t1 add c2 int not null default 0");
        PreparedStatement pSt = this.prepareStatement("select * from t2");
        ResultSet rs = pSt.executeQuery();
        JDBC.assertColumnNames(rs, "C1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}});
        st.executeUpdate("alter table t2 add c2 int");
        pSt = this.prepareStatement("select * from t2");
        rs = pSt.executeQuery();
        JDBC.assertColumnNames(rs, "C1", "C2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", null}, {"2", null}});
        st.executeUpdate("alter table t0 add c2 int not null default 0");
        st.executeUpdate("insert into t0 values (1, default)");
        rs = st.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1", "C2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "0"}});
        st.executeUpdate("drop table t0");
        this.rollback();
    }

    private void testAlterColumnNullability(Statement st) throws SQLException {
        String setNotNull = "NOT NULL";
        String dropNotNull = "NULL";
        st.executeUpdate("create table atmcn_1 (a integer, b integer not null)");
        AlterTableTest.assertStatementError("23502", st, "insert into atmcn_1 (a) values (1)");
        st.executeUpdate("insert into atmcn_1 values (1,1)");
        ResultSet rs = st.executeQuery("select * from atmcn_1");
        String[] expColNames = new String[]{"A", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("alter table atmcn_1 alter a integer NOT NULL");
        AlterTableTest.assertStatementError("23502", st, "insert into atmcn_1 (b) values (2)");
        st.executeUpdate("insert into atmcn_1 values (2,2)");
        rs = st.executeQuery("select * from atmcn_1");
        expColNames = new String[]{"A", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("alter table atmcn_1 alter b integer NULL");
        st.executeUpdate("insert into atmcn_1 (a) values (3)");
        rs = st.executeQuery("select * from atmcn_1");
        expColNames = new String[]{"A", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}, {"2", "2"}, {"3", null}};
        JDBC.assertFullResultSet(rs, expRS, true);
        AlterTableTest.assertStatementError("X0Y80", st, "alter table atmcn_1 alter b integer NOT NULL");
        st.executeUpdate("create table atmcn_2 (a integer not null, b integer not null, constraint pk primary key (a))");
        AlterTableTest.assertStatementError("42Z20", st, " alter table atmcn_2 alter a NULL");
        st.executeUpdate(" create table atmcn_3 (a integer not null, b integer not null)");
        this.rollback();
    }

    @Test
    public void testAlterColumn() throws Exception {
        this.setAutoCommit(false);
        Statement st = this.createStatement();
        this.createTestObjects(st);
        this.testAlterColumnNullability(st);
        st.executeUpdate("create table atmod_1 (a0 integer, a integer default 0, b varchar(10))");
        st.executeUpdate("insert into atmod_1 values (1, 1, 'one')");
        st.executeUpdate("alter table atmod_1 alter a integer default -1");
        st.executeUpdate("insert into atmod_1 values (2, default, 'minus one')");
        st.executeUpdate("insert into atmod_1 (a0, b) values (3, 'b')");
        ResultSet rs = st.executeQuery("select * from atmod_1");
        JDBC.assertColumnNames(rs, "A0", "A", "B");
        Object[][] expRS = new String[][]{{"1", "1", "one"}, {"2", "-1", "minus one"}, {"3", "-1", "b"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("alter table atmod_1 alter a integer default 42");
        st.executeUpdate("insert into atmod_1 values(4, 3, 'three')");
        st.executeUpdate("insert into atmod_1 values (5, default, 'forty two')");
        rs = st.executeQuery("select * from atmod_1");
        JDBC.assertColumnNames(rs, "A0", "A", "B");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "1", "one"}, {"2", "-1", "minus one"}, {"3", "-1", "b"}, {"4", "3", "three"}, {"5", "42", "forty two"}});
    }

    @Test
    public void testDropColumn() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create table atdc_0 (a integer)");
        st.executeUpdate("create table atdc_1 (a integer, b varchar)");
        st.executeUpdate("insert into atdc_1 values (1, 'hi')");
        JDBC.assertFullResultSet(st.executeQuery(" select * from atdc_1"), new String[][]{{"1", "hi"}});
        st.executeUpdate("alter table atdc_1 drop b");
        ResultSet rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(rs, "A");
        JDBC.assertSingleValueResultSet(rs, "1");
        st.executeUpdate("alter table atdc_1 add b varchar (20)");
        st.executeUpdate("update atdc_1 set b = 'new val' where a = 1");
        st.executeUpdate("insert into atdc_1 (a, b) values (2, 'two val')");
        rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(rs, "A", "B");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "new val"}, {"2", "two val"}});
        st.executeUpdate("alter table atdc_1 add c integer");
        st.executeUpdate("insert into atdc_1 values (3, null, 3)");
        rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(rs, "A", "B", "C");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "new val", null}, {"2", "two val", null}, {"3", null, "3"}});
        st.executeUpdate("alter table atdc_1 drop b");
        rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(rs, "A", "C");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", null}, {"2", null}, {"3", "3"}});
    }
}

