/*
 * Decompiled with CFR 0.152.
 */
package io.kareldb.jdbc;

import io.kareldb.jdbc.BaseJDBCTestCase;
import io.kareldb.jdbc.JDBC;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.junit.Test;

public final class AggBuiltinTest
extends BaseJDBCTestCase {
    private Statement st;
    private ResultSet rs;
    private String[] expColNames;
    private String[][] expRS;
    private final String NULLS_ELIMINATED = "01003";
    private SQLWarning sqlWarn = null;
    private final String[][] SINGLE_NULL_ROW = new String[][]{{null}};

    @Test
    public void testBuiltinAggregates() throws Exception {
        this.st = this.createStatement();
        try {
            this.avg();
        }
        finally {
            try {
                this.st.close();
            }
            catch (SQLException sQLException) {}
            this.st = null;
            this.rs = null;
            this.expColNames = null;
            this.expRS = null;
            this.sqlWarn = null;
        }
    }

    private void avg() throws SQLException {
        this.x("create table t (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8),              lbv varbinary,             dc decimal(5,2))");
        this.x("create table empty_table (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8),              lbv varbinary,             dc decimal(5,2))");
        this.x("insert into t (i) values (0)");
        this.x("insert into t (i) values (1)");
        this.x("insert into t values (2, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', x'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (3, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (4, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (5, 200, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 222.22)");
        this.x("insert into t values (7, 100, 1000000,                   'goodbye', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (8, 100, 1000000,                   'duplicate', 'noone is here', 'jimmie noone was here',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (9, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (10, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   100.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (11, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 100.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (12, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-09-09', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (13, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:55:55', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (14, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:55:55',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (15, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'ffff', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (16, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'1111111111111111', X'1234', 111.11)");
        this.q("select avg(i) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select avg(s) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select avg(d) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select avg(l) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select avg(r) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select avg(dc) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select avg(i), avg(s), avg(r), avg(l) from empty_table");
        this.expColNames = new String[]{"EXPR$0", "EXPR$1", "EXPR$2", "EXPR$3"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{null, null, null, null}};
        this.ok();
        this.q("select avg(i+1) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select avg(i) from empty_table group by i");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select avg(s) from empty_table group by s");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select avg(d) from empty_table group by d");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select avg(l) from empty_table group by l");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select avg(r) from empty_table group by r");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select avg(dc) from empty_table group by dc");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select avg(i) from t");
        this.c1();
        this.expRS = new String[][]{{"8"}};
        this.ok();
        this.q("select avg(s) from t");
        this.c1();
        this.expRS = new String[][]{{"107"}};
        this.ok();
        this.q("select avg(d) from t");
        this.c1();
        this.expRS = new String[][]{{"192.85714285714286"}};
        this.ok();
        this.q("select avg(l) from t");
        this.c1();
        this.expRS = new String[][]{{"1000000"}};
        this.ok();
        this.q("select avg(r) from t");
        this.c1();
        this.expRS = new String[][]{{"192.85715"}};
        this.ok();
        this.q("select avg(dc) from t");
        this.c1();
        this.expRS = new String[][]{{"119.0464285714286"}};
        this.ok();
        this.q("select avg(i) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0"}, {"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"7"}, {"8"}, {"9"}, {"10"}, {"11"}, {"12"}, {"13"}, {"14"}, {"15"}, {"16"}};
        this.ok();
        this.q("select avg(s) from t group by s");
        this.c1();
        this.expRS = new String[][]{{null}, {"100"}, {"200"}};
        this.ok();
        this.q("select avg(d) from t group by d");
        this.c1();
        this.expRS = new String[][]{{null}, {"200.0"}, {"100.0"}};
        this.ok();
        this.q("select avg(l) from t group by l");
        this.c1();
        this.expRS = new String[][]{{null}, {"1000000"}};
        this.ok(new String[]{null, "01003"});
        this.q("select avg(r) from t group by r");
        this.c1();
        this.expRS = new String[][]{{null}, {"200.0"}, {"100.0"}};
        this.ok();
        this.q("select avg(dc), sum(dc), count(dc) from t group by dc");
        this.expColNames = new String[]{"EXPR$0", "EXPR$1", "EXPR$2"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{null, null, "0"}, {"111.11", "1444.43", "13"}, {"222.22", "222.22", "1"}};
        this.ok();
        this.q("select avg(1) from t");
        this.c1();
        this.expRS = new String[][]{{"1"}};
        this.ok();
        this.q("select avg(1.1) from t");
        this.c1();
        this.expRS = new String[][]{{"1.1"}};
        this.ok();
        this.q("select avg(1e1) from t");
        this.c1();
        this.expRS = new String[][]{{"10.0"}};
        this.ok();
        this.q("select avg(1) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"1"}, {"1"}, {"1"}, new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0]};
        this.ok();
        this.q("select avg(1.1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"1.1"}, {"1.1"}, {"1.1"}};
        this.ok();
        this.q("select avg(1e1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"10.0"}, {"10.0"}, {"10.0"}};
        this.ok();
        this.q("select avg(i), avg(l), avg(r) from t group by dt, b");
        this.expColNames = new String[]{"EXPR$0", "EXPR$1", "EXPR$2"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", null, null}, {"12", "1000000", "200.0"}, {"15", "1000000", "200.0"}, {"8", "1000000", "191.66667"}};
        this.ok();
        this.q("select avg(i), dt, avg(i), avg(r), avg(l), l from t group by dt, b, l");
        this.expColNames = new String[]{"EXPR$0", "DT", "EXPR$2", "EXPR$3", "EXPR$4", "L"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"8", "1992-01-01", "8", "191.66667", "1000000", "1000000"}, {"12", "1992-09-09", "12", "200.0", "1000000", "1000000"}, {"15", "1992-01-01", "15", "200.0", "1000000", "1000000"}, {"0", null, "0", null, null, null}};
        this.ok();
        this.q("select avg(expr1), avg(expr2)from (select i * s, r * 2 from t) t (expr1, expr2) group by expr2, expr1");
        this.c2();
        this.expRS = new String[][]{{null, null}, {"1400", "400.0"}, {"700", "400.0"}, {"1500", "400.0"}, {"400", "400.0"}, {"1200", "400.0"}, {"1300", "400.0"}, {"200", "400.0"}, {"1000", "400.0"}, {"300", "400.0"}, {"1100", "200.0"}, {"800", "400.0"}, {"1600", "400.0"}, {"900", "400.0"}};
        this.ok();
        this.q("select distinct avg(i) from t group by dt");
        this.c1();
        this.expRS = new String[][]{{"0"}, {"9"}, {"12"}};
        this.ok();
        this.x("create table tmp (x int, y int)");
        this.x("insert into tmp (x, y) select avg(i), avg(s) from t");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"8", "107"}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp (x int, y int)");
        this.x("insert into tmp (x, y) select avg(i), avg(s) from t group by b");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", null}, {"8", "107"}, {"15", "100"}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp (x int)");
        this.x("insert into tmp values (2147483647)");
        this.q("values(2147483647)");
        this.c1();
        this.expRS = new String[][]{{"2147483647"}};
        this.ok();
        this.q("select avg(x) from tmp");
        this.c1();
        this.expRS = new String[][]{{"2147483647"}};
        this.ok();
        this.q("select avg(-(x - 1)) from tmp");
        this.c1();
        this.expRS = new String[][]{{"-2147483646"}};
        this.ok();
        this.q("select avg(x) from tmp group by x");
        this.c1();
        this.expRS = new String[][]{{"2147483647"}};
        this.ok();
        this.q("select avg(-(x - 1)) from tmp group by x");
        this.c1();
        this.expRS = new String[][]{{"-2147483646"}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp(x double precision, y int)");
        PreparedStatement scalar = this.prepareStatement("select avg(x) from tmp");
        PreparedStatement vector = this.prepareStatement("select avg(x) from tmp group by y");
        this.x("insert into tmp values (1,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.0"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.0"}};
        this.ok();
        this.x("insert into tmp values (2,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.5"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.5"}};
        this.ok();
        this.x("insert into tmp values (3,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.0"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.0"}};
        this.ok();
        this.x("insert into tmp values (4,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.5"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.5"}};
        this.ok();
        this.x("insert into tmp values (5,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"3.0"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"3.0"}};
        this.ok();
        this.x("insert into tmp values (6,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"3.5"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"3.5"}};
        this.ok();
        this.x("insert into tmp values (7,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"4.0"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"4.0"}};
        this.ok();
        this.x("insert into tmp values (10000,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1253.5"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1253.5"}};
        this.ok();
        scalar.close();
        vector.close();
        this.x("drop table tmp");
        this.x("drop table t");
        this.x("drop table empty_table");
    }

    private void count() throws SQLException {
        this.x("create table t (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary,             dc decimal(5,2))");
        this.x("create table empty_table (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary,             dc decimal(5,2))");
        this.x("insert into t (i) values (null)");
        this.x("insert into t (i) values (null)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (1, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 200, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 222.22)");
        this.x("insert into t values (0, 100, 2000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 222.22)");
        this.x("insert into t values (0, 100, 1000000,                   'goodbye', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'noone is here', 'jimmie noone was here',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   100.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 100.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-09-09', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:55:55', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:55:55',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'ffff', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'1111111111111111', X'1234', 111.11)");
        this.q("select count(i) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(s) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(l) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(c) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(v) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(lvc) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(d) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(r) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(dt) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(t) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(ts) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(b) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(bv) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(lbv) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(dc) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(i), count(b), count(i), count(s) from empty_table");
        this.expColNames = new String[]{"1", "2", "3", "4"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", "0", "0", "0"}};
        this.ok();
        this.q("select count(i+1) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(i) from empty_table group by i");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(s) from empty_table group by s");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(l) from empty_table group by l");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(c) from empty_table group by c");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(v) from empty_table group by v");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(d) from empty_table group by d");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(r) from empty_table group by r");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(dt) from empty_table group by dt");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(t) from empty_table group by t");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(ts) from empty_table group by ts");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(b) from empty_table group by b");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(bv) from empty_table group by bv");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.e("X0X67", "select count(lbv) from empty_table group by lbv");
        this.q("select count(dc) from empty_table group by dc");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(i) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(s) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(l) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(c) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(v) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(lvc) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(d) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(r) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(dt) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(t) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(ts) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(b) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(bv) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(lbv) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(dc) from t");
        this.c1();
        this.expRS = new String[][]{{"15"}};
        this.ok("01003");
        this.q("select count(i) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(s) from t group by s");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(l) from t group by l");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(c) from t group by c");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(v) from t group by v");
        this.c1();
        this.expRS = new String[][]{{"1"}, {"14"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(d) from t group by d");
        this.c1();
        this.expRS = new String[][]{{"1"}, {"14"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(r) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"1"}, {"14"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(dt) from t group by dt");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(t) from t group by t");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(ts) from t group by ts");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(b) from t group by b");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(bv) from t group by bv");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.e("X0X67", "select count(lbv) from t group by lbv");
        this.q("select count(dc) from t group by dc");
        this.c1();
        this.expRS = new String[][]{{"13"}, {"2"}, {"0"}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select count(1) from t");
        this.c1();
        this.expRS = new String[][]{{"17"}};
        this.ok();
        this.q("select count('hello') from t");
        this.c1();
        this.expRS = new String[][]{{"17"}};
        this.ok();
        this.q("select count(1.1) from t");
        this.c1();
        this.expRS = new String[][]{{"17"}};
        this.ok();
        this.q("select count(1e1) from t");
        this.c1();
        this.expRS = new String[][]{{"17"}};
        this.ok();
        this.q("select count(X'11') from t");
        this.c1();
        this.expRS = new String[][]{{"17"}};
        this.ok();
        this.q("select count(date'1999-06-06') from t");
        this.c1();
        this.expRS = new String[][]{{"17"}};
        this.ok();
        this.q("select count(time'12:30:30') from t");
        this.c1();
        this.expRS = new String[][]{{"17"}};
        this.ok();
        this.q("select count(timestamp('1999-06-06 12:30:30')) from t");
        this.c1();
        this.expRS = new String[][]{{"17"}};
        this.ok();
        this.q("select count(1) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"2"}};
        this.ok();
        this.q("select count('hello') from t group by c");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"2"}};
        this.ok();
        this.q("select count(1.1) from t group by dc");
        this.c1();
        this.expRS = new String[][]{{"13"}, {"2"}, {"2"}};
        this.ok();
        this.q("select count(1e1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"1"}, {"14"}, {"2"}};
        this.ok();
        this.q("select count(X'11') from t group by b");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"2"}};
        this.ok();
        this.q("select count(date'1999-06-06') from t group by dt");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"2"}};
        this.ok();
        this.q("select count(time'12:30:30') from t group by t");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"2"}};
        this.ok();
        this.q("select count(timestamp('1999-06-06 12:30:30')) from t group by ts");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"2"}};
        this.ok();
        this.q("select count(i), count(dt), count(b) from t group by i, dt, b");
        this.expColNames = new String[]{"1", "2", "3"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"12", "12", "12"}, {"1", "1", "1"}, {"1", "1", "1"}, {"1", "1", "1"}, {"0", "0", "0"}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select l, dt, count(i), count(dt), count(b), i from t group by i, dt, b, l");
        this.expColNames = new String[]{"L", "DT", "3", "4", "5", "I"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1000000", "1992-01-01", "11", "11", "11", "0"}, {"2000000", "1992-01-01", "1", "1", "1", "0"}, {"1000000", "1992-01-01", "1", "1", "1", "0"}, {"1000000", "1992-09-09", "1", "1", "1", "0"}, {"1000000", "1992-01-01", "1", "1", "1", "1"}, {null, null, "0", "0", "0", null}};
        this.ok(new String[]{null, null, null, null, null, "01003"});
        this.q("select count(expr1), count(expr2)from (select i * s, c || v from t) t (expr1, expr2) group by expr2, expr1");
        this.c2();
        this.expRS = new String[][]{{"1", "1"}, {"12", "12"}, {"1", "1"}, {"1", "1"}, {"0", "0"}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select distinct count(i) from t group by i, dt");
        this.c1();
        this.expRS = new String[][]{{"0"}, {"1"}, {"13"}};
        this.ok(new String[]{"01003", "01003", "01003"});
        this.x("create table tmp (x int, y int)");
        this.x("insert into tmp (x, y) select count(i), count(c) from t");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"15", "15"}};
        this.ok();
        this.x("insert into tmp (x, y) select count(i), count(c) from t group by b");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"15", "15"}, {"14", "14"}, {"1", "1"}, {"0", "0"}};
        this.ok();
        this.x("drop table tmp");
        this.x("drop table t");
        this.x("drop table empty_table");
    }

    private void countStar() throws SQLException {
        this.x("create table t (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary)");
        this.x("create table empty_table (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary)");
        this.x("insert into t (i) values (0)");
        this.x("insert into t (i) values (1)");
        this.x("insert into t values (2, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (3, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (4, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (5, 200, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (6, 100, 2000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (7, 100, 1000000,                   'goodbye', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (8, 100, 1000000,                   'duplicate', 'noone is here', 'jimmie noone was here',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (9, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (10, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   100.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (11, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 100.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (12, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-09-09', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (13, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:55:55', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (14, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:55:55',                   X'12af', X'0000111100001111', X'ABCD')");
        this.x("insert into t values (15, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'ffff', X'0000111100001111', X'1234')");
        this.x("insert into t values (16, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'1111111111111111', X'ABCD')");
        this.q("select count(*) from empty_table");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok();
        this.q("select count(*), count(*) from empty_table");
        this.c2();
        this.expRS = new String[][]{{"0", "0"}};
        this.ok();
        this.q("select count(*) from empty_table group by i");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select count(*) from t");
        this.c1();
        this.expRS = new String[][]{{"17"}};
        this.ok();
        this.q("select count(*) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"2"}};
        this.ok();
        this.q("select count(*), count(*), count(*) from t group by i, dt, b");
        this.expColNames = new String[]{"1", "2", "3"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"12", "12", "12"}, {"1", "1", "1"}, {"1", "1", "1"}, {"1", "1", "1"}, {"2", "2", "2"}};
        this.ok();
        this.q("select count(*), count(*)from (select i * s, c || v from t) t (expr1, expr2) group by expr2, expr1");
        this.c2();
        this.expRS = new String[][]{{"1", "1"}, {"12", "12"}, {"1", "1"}, {"1", "1"}, {"2", "2"}};
        this.ok();
        this.q("select distinct count(*) from t group by i, dt");
        this.c1();
        this.expRS = new String[][]{{"1"}, {"2"}, {"13"}};
        this.ok();
        this.x("create view v1 as select * from t");
        this.q("select count(*) from v1");
        this.c1();
        this.expRS = new String[][]{{"17"}};
        this.ok();
        this.q("select count(*)+count(*) from v1");
        this.c1();
        this.expRS = new String[][]{{"34"}};
        this.ok();
        this.x("drop view v1");
        this.x("create table tmp (x int, y int)");
        this.x("insert into tmp (x, y) select count(*), count(*) from t");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"17", "17"}};
        this.ok();
        this.x("insert into tmp (x, y) select count(*), count(*) from t group by b");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"17", "17"}, {"14", "14"}, {"1", "1"}, {"2", "2"}};
        this.ok();
        this.x("drop table tmp");
        this.x("drop table t");
        this.x("drop table empty_table");
    }

    private void sum() throws SQLException {
        this.x("create table t (i int, s int, l bigint,             c varchar(10), v varchar(50),              d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8),data, dc decimal(5,2))");
        this.x("create table empty_table (i int, s int, l bigint,             c varchar(10), v varchar(50),              d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8),data, dc decimal(5,2))");
        this.x("insert into t (i) values (null)");
        this.x("insert into t (i) values (null)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (1, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 200, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 222.22)");
        this.x("insert into t values (0, 100, 2000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 222.22)");
        this.x("insert into t values (0, 100, 1000000,                   'goodbye', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'noone is here',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    100.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 100.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-09-09', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:55:55', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:55:55',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'ffff', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'1111111111111111', 111.11)");
        this.e("42Y22", "select sum(c) from t");
        this.e("42Y22", "select sum(v) from t");
        this.e("42Y22", "select sum(dt) from t");
        this.e("42Y22", "select sum(t) from t");
        this.e("42Y22", "select sum(ts) from t");
        this.e("42Y22", "select sum(b) from t");
        this.e("42Y22", "select sum(bv) from t");
        this.e("42Y22", "select sum(c) from t group by c");
        this.e("42Y22", "select sum(v) from t group by c");
        this.e("42Y22", "select sum(dt) from t group by c");
        this.e("42Y22", "select sum(t) from t group by c");
        this.e("42Y22", "select sum(ts) from t group by c");
        this.e("42Y22", "select sum(b) from t group by c");
        this.e("42Y22", "select sum(bv) from t group by c");
        this.x("create table t1 (c1 varchar)");
        this.e("42Y22", "select sum(c1) from t1");
        this.x("drop table t1");
        this.e("42Y22", "select sum('hello') from t");
        this.e("42Y22", "select sum(X'11') from t");
        this.e("42Y22", "select sum(date'1999-06-06') from t");
        this.e("42Y22", "select sum(time'12:30:30') from t");
        this.e("42Y22", "select sum(timestamp('1999-06-06 12:30:30')) from t");
        this.q("select sum(i) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select sum(s) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select sum(d) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select sum(l) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select sum(r) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select sum(dc) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select sum(i), sum(s), sum(r), sum(l) from empty_table");
        this.expColNames = new String[]{"1", "2", "3", "4"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{null, null, null, null}};
        this.ok();
        this.q("select sum(i+1) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select sum(i) from empty_table group by i");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select sum(s) from empty_table group by s");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select sum(d) from empty_table group by d");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select sum(l) from empty_table group by l");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select sum(r) from empty_table group by r");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select sum(dc) from empty_table group by dc");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select sum(i) from t");
        this.c1();
        this.expRS = new String[][]{{"1"}};
        this.ok("01003");
        this.q("select sum(s) from t");
        this.c1();
        this.expRS = new String[][]{{"1600"}};
        this.ok("01003");
        this.q("select sum(d) from t");
        this.c1();
        this.expRS = new String[][]{{"2900.0"}};
        this.ok("01003");
        this.q("select sum(l) from t");
        this.c1();
        this.expRS = new String[][]{{"16000000"}};
        this.ok("01003");
        this.q("select sum(r) from t");
        this.c1();
        this.expRS = new String[][]{{"2900.0"}};
        this.ok("01003");
        this.q("select sum(dc) from t");
        this.c1();
        this.expRS = new String[][]{{"1888.87"}};
        this.ok("01003");
        this.q("select sum(i) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0"}, {"1"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select sum(s) from t group by s");
        this.c1();
        this.expRS = new String[][]{{"1400"}, {"200"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select sum(d) from t group by d");
        this.c1();
        this.expRS = new String[][]{{"100.0"}, {"2800.0"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select sum(l) from t group by l");
        this.c1();
        this.expRS = new String[][]{{"14000000"}, {"2000000"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select sum(r) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"100.0"}, {"2800.0"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select sum(dc) from t group by dc");
        this.c1();
        this.expRS = new String[][]{{"1444.43"}, {"444.44"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select sum(1) from t");
        this.c1();
        this.expRS = new String[][]{{"17"}};
        this.ok();
        this.q("select sum(1.1) from t");
        this.c1();
        this.expRS = new String[][]{{"18.7"}};
        this.ok();
        this.q("select sum(1e1) from t");
        this.c1();
        this.expRS = new String[][]{{"170.0"}};
        this.ok();
        this.q("select sum(1) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"14"}, {"1"}, {"2"}};
        this.ok();
        this.q("select sum(1.1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"1.1"}, {"15.4"}, {"2.2"}};
        this.ok();
        this.q("select sum(1e1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"10.0"}, {"140.0"}, {"20.0"}};
        this.ok();
        this.q("select sum(i), sum(l), sum(r) from t group by i, dt, b");
        this.expColNames = new String[]{"1", "2", "3"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", "13000000", "2300.0"}, {"0", "1000000", "200.0"}, {"0", "1000000", "200.0"}, {"1", "1000000", "200.0"}, {null, null, null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select i, dt, sum(i), sum(r), sum(l), l from t group by i, dt, b, l");
        this.expColNames = new String[]{"I", "DT", "3", "4", "5", "L"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "0", "2100.0", "11000000", "1000000"}, {"0", "1992-01-01", "0", "200.0", "2000000", "2000000"}, {"0", "1992-01-01", "0", "200.0", "1000000", "1000000"}, {"0", "1992-09-09", "0", "200.0", "1000000", "1000000"}, {"1", "1992-01-01", "1", "200.0", "1000000", "1000000"}, {null, null, null, null, null, null}};
        this.ok(new String[]{null, null, null, null, null, "01003"});
        this.q("select sum(expr1), sum(expr2)from (select i * s, r * 2 from t) t (expr1, expr2) group by expr2, expr1");
        this.c2();
        this.expRS = new String[][]{{"0", "200.0"}, {"0", "5200.0"}, {"100", "400.0"}, {null, null}};
        this.ok(new String[]{null, null, null, "01003"});
        this.q("select distinct sum(i) from t group by i, dt");
        this.c1();
        this.expRS = new String[][]{{"0"}, {"1"}, {null}};
        this.ok(new String[]{"01003", "01003", "01003"});
        this.x("create table tmp (x int, y int)");
        this.x("insert into tmp (x, y) select sum(i), sum(s) from t");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1", "1600"}};
        this.ok();
        this.x("insert into tmp (x, y) select sum(i), sum(s) from t group by b");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1", "1600"}, {"1", "1500"}, {"0", "100"}, {null, null}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp (x int)");
        this.x("insert into tmp values (2147483647),                     (2147483647)");
        this.e("22003", "select sum(x) from tmp");
        this.x("drop table tmp");
        this.x("create table tmp (x double precision)");
        this.x("insert into tmp values (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647)");
        this.q("select sum(x) from tmp");
        this.c1();
        this.expRS = new String[][]{{"1.9327352823E10"}};
        this.ok();
        this.x("drop table tmp");
        this.x("drop table t");
        this.x("drop table empty_table");
    }

    private void max() throws SQLException {
        this.x("create table t (i int, s int, l bigint,             c varchar(10), v varchar(50),              d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8),data, dc decimal(5,2))");
        this.x("create table empty_table (i int, s int, l bigint,             c varchar(10), v varchar(50),              d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8),data, dc decimal(5,2))");
        this.x("insert into t (i) values (null)");
        this.x("insert into t (i) values (null)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (1, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 200, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 222.22)");
        this.x("insert into t values (0, 100, 2000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 222.22)");
        this.x("insert into t values (0, 100, 1000000,                   'goodbye', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'noone is here',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    100.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 100.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-09-09', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:55:55', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:55:55',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'ffff', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'1111111111111111', 111.11)");
        this.x("create table t1 (c1 varchar)");
        this.e("42Y22", "select max(c1) from t1");
        this.x("drop table t1");
        this.q("select max(i) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(s) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(l) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(c) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(v) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(d) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(r) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(dt) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(t) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(ts) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(b) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(bv) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(dc) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(i), max(b), max(i), max(s) from empty_table");
        this.expColNames = new String[]{"1", "2", "3", "4"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{null, null, null, null}};
        this.ok();
        this.q("select max(i+1) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select max(i) from empty_table group by i");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(s) from empty_table group by s");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(l) from empty_table group by l");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(c) from empty_table group by c");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(v) from empty_table group by v");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(d) from empty_table group by d");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(r) from empty_table group by r");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(dt) from empty_table group by dt");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(t) from empty_table group by t");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(ts) from empty_table group by ts");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(b) from empty_table group by b");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(bv) from empty_table group by bv");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(dc) from empty_table group by dc");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select max(i) from t");
        this.c1();
        this.expRS = new String[][]{{"1"}};
        this.ok("01003");
        this.q("select max(s) from t");
        this.c1();
        this.expRS = new String[][]{{"200"}};
        this.ok("01003");
        this.q("select max(l) from t");
        this.c1();
        this.expRS = new String[][]{{"2000000"}};
        this.ok("01003");
        this.q("select max(c) from t");
        this.c1();
        this.expRS = new String[][]{{"goodbye"}};
        this.ok("01003");
        this.q("select max(v) from t");
        this.c1();
        this.expRS = new String[][]{{"this is duplicated"}};
        this.ok("01003");
        this.q("select max(d) from t");
        this.c1();
        this.expRS = new String[][]{{"200.0"}};
        this.ok("01003");
        this.q("select max(r) from t");
        this.c1();
        this.expRS = new String[][]{{"200.0"}};
        this.ok("01003");
        this.q("select max(dt) from t");
        this.c1();
        this.expRS = new String[][]{{"1992-09-09"}};
        this.ok("01003");
        this.q("select max(t) from t");
        this.c1();
        this.expRS = new String[][]{{"12:55:55"}};
        this.ok("01003");
        this.q("select max(ts) from t");
        this.c1();
        this.expRS = new String[][]{{"1992-01-01 12:55:55.0"}};
        this.ok("01003");
        this.q("select max(b) from t");
        this.c1();
        this.expRS = new String[][]{{"ffff"}};
        this.ok("01003");
        this.q("select max(bv) from t");
        this.c1();
        this.expRS = new String[][]{{"1111111111111111"}};
        this.ok("01003");
        this.q("select max(dc) from t");
        this.c1();
        this.expRS = new String[][]{{"222.22"}};
        this.ok("01003");
        this.q("select max(i) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0"}, {"1"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(s) from t group by s");
        this.c1();
        this.expRS = new String[][]{{"100"}, {"200"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(l) from t group by l");
        this.c1();
        this.expRS = new String[][]{{"1000000"}, {"2000000"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(c) from t group by c");
        this.c1();
        this.expRS = new String[][]{{"duplicate"}, {"goodbye"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(v) from t group by v");
        this.c1();
        this.expRS = new String[][]{{"noone is here"}, {"this is duplicated"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(d) from t group by d");
        this.c1();
        this.expRS = new String[][]{{"100.0"}, {"200.0"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(r) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"100.0"}, {"200.0"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(dt) from t group by dt");
        this.c1();
        this.expRS = new String[][]{{"1992-01-01"}, {"1992-09-09"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(t) from t group by t");
        this.c1();
        this.expRS = new String[][]{{"12:30:30"}, {"12:55:55"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(ts) from t group by ts");
        this.c1();
        this.expRS = new String[][]{{"1992-01-01 12:30:30.0"}, {"1992-01-01 12:55:55.0"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(b) from t group by b");
        this.c1();
        this.expRS = new String[][]{{"12af"}, {"ffff"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(bv) from t group by bv");
        this.c1();
        this.expRS = new String[][]{{"0000111100001111"}, {"1111111111111111"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(dc) from t group by dc");
        this.c1();
        this.expRS = new String[][]{{"111.11"}, {"222.22"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select max(1) from t");
        this.c1();
        this.expRS = new String[][]{{"1"}};
        this.ok();
        this.q("select max('hello') from t");
        this.c1();
        this.expRS = new String[][]{{"hello"}};
        this.ok();
        this.q("select max(1.1) from t");
        this.c1();
        this.expRS = new String[][]{{"1.1"}};
        this.ok();
        this.q("select max(1e1) from t");
        this.c1();
        this.expRS = new String[][]{{"10.0"}};
        this.ok();
        this.q("select max(X'11') from t");
        this.c1();
        this.expRS = new String[][]{{"11"}};
        this.ok();
        this.q("select max(date'1999-06-06') from t");
        this.c1();
        this.expRS = new String[][]{{"1999-06-06"}};
        this.ok();
        this.q("select max(time'12:30:30') from t");
        this.c1();
        this.expRS = new String[][]{{"12:30:30"}};
        this.ok();
        this.q("select max(timestamp('1999-06-06 12:30:30')) from t");
        this.c1();
        this.expRS = new String[][]{{"1999-06-06 12:30:30.0"}};
        this.ok();
        this.q("select max(1) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"1"}, {"1"}, {"1"}};
        this.ok();
        this.q("select max('hello') from t group by c");
        this.c1();
        this.expRS = new String[][]{{"hello"}, {"hello"}, {"hello"}};
        this.ok();
        this.q("select max(1.1) from t group by dc");
        this.c1();
        this.expRS = new String[][]{{"1.1"}, {"1.1"}, {"1.1"}};
        this.ok();
        this.q("select max(1e1) from t group by d");
        this.c1();
        this.expRS = new String[][]{{"10.0"}, {"10.0"}, {"10.0"}};
        this.ok();
        this.q("select max(X'11') from t group by b");
        this.c1();
        this.expRS = new String[][]{{"11"}, {"11"}, {"11"}};
        this.ok();
        this.q("select max(date'1999-06-06') from t group by dt");
        this.c1();
        this.expRS = new String[][]{{"1999-06-06"}, {"1999-06-06"}, {"1999-06-06"}};
        this.ok();
        this.q("select max(time'12:30:30') from t group by t");
        this.c1();
        this.expRS = new String[][]{{"12:30:30"}, {"12:30:30"}, {"12:30:30"}};
        this.ok();
        this.q("select max(timestamp('1999-06-06 12:30:30')) from t group by ts");
        this.c1();
        this.expRS = new String[][]{{"1999-06-06 12:30:30.0"}, {"1999-06-06 12:30:30.0"}, {"1999-06-06 12:30:30.0"}};
        this.ok();
        this.q("select max(i), max(dt), max(b) from t group by i, dt, b");
        this.expColNames = new String[]{"1", "2", "3"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"0", "1992-01-01", "ffff"}, {"0", "1992-09-09", "12af"}, {"1", "1992-01-01", "12af"}, {null, null, null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select l, dt, max(i), max(dt), max(b), i from t group by i, dt, b, l");
        this.expColNames = new String[]{"L", "DT", "3", "4", "5", "I"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1000000", "1992-01-01", "0", "1992-01-01", "12af", "0"}, {"2000000", "1992-01-01", "0", "1992-01-01", "12af", "0"}, {"1000000", "1992-01-01", "0", "1992-01-01", "ffff", "0"}, {"1000000", "1992-09-09", "0", "1992-09-09", "12af", "0"}, {"1000000", "1992-01-01", "1", "1992-01-01", "12af", "1"}, {null, null, null, null, null, null}};
        this.ok(new String[]{null, null, null, null, null, "01003"});
        this.q("select max(expr1), max(expr2)from (select i * s, c || v from t) t (expr1, expr2) group by expr2, expr1");
        this.c2();
        this.expRS = new String[][]{{"0", "duplicate noone is here"}, {"0", "duplicate this is duplicated"}, {"100", "duplicate this is duplicated"}, {"0", "goodbye   this is duplicated"}, {null, null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select distinct max(i) from t group by i, dt");
        this.c1();
        this.expRS = new String[][]{{"0"}, {"1"}, {null}};
        this.ok(new String[]{"01003", "01003", "01003"});
        this.x("create table tmp (x int, y varchar(20))");
        this.x("insert into tmp (x, y) select max(i), max(c) from t");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1", "goodbye"}};
        this.ok();
        this.x("insert into tmp (x, y) select max(i), max(c) from t group by b");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1", "goodbye"}, {"1", "goodbye"}, {"0", "duplicate"}, {null, null}};
        this.ok();
        this.x("drop table tmp");
        this.x("drop table t");
        this.x("drop table empty_table");
    }

    private void min() throws SQLException {
        this.x("create table t (i int, s int, l bigint,             c varchar(10), v varchar(50),              d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8),data, dc decimal(5,2))");
        this.x("create table empty_table (i int, s int, l bigint,             c varchar(10), v varchar(50),              d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8),data, dc decimal(5,2))");
        this.x("insert into t (i) values (null)");
        this.x("insert into t (i) values (null)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (1, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 200, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 222.22)");
        this.x("insert into t values (0, 100, 2000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 222.22)");
        this.x("insert into t values (0, 100, 1000000,                   'goodbye', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'noone is here',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    100.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 100.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-09-09', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:55:55', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:55:55',                   X'12af', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'ffff', X'0000111100001111', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated',                    200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'1111111111111111', 111.11)");
        this.x("create table t1 (c1 varchar)");
        this.e("42Y22", "select min(c1) from t1");
        this.x("drop table t1");
        this.q("select min(i) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(s) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(l) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(c) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(v) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(d) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(r) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(dt) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(t) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(ts) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(b) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(bv) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(dc) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(i), min(b), min(i), min(s) from empty_table");
        this.expColNames = new String[]{"1", "2", "3", "4"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{null, null, null, null}};
        this.ok();
        this.q("select min(i+1) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select min(i) from empty_table group by i");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(s) from empty_table group by s");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(l) from empty_table group by l");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(c) from empty_table group by c");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(v) from empty_table group by v");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(d) from empty_table group by d");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(r) from empty_table group by r");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(dt) from empty_table group by dt");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(t) from empty_table group by t");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(ts) from empty_table group by ts");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(b) from empty_table group by b");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(bv) from empty_table group by bv");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(dc) from empty_table group by dc");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select min(i) from t");
        this.c1();
        this.expRS = new String[][]{{"0"}};
        this.ok("01003");
        this.q("select min(s) from t");
        this.c1();
        this.expRS = new String[][]{{"100"}};
        this.ok("01003");
        this.q("select min(l) from t");
        this.c1();
        this.expRS = new String[][]{{"1000000"}};
        this.ok("01003");
        this.q("select min(c) from t");
        this.c1();
        this.expRS = new String[][]{{"duplicate"}};
        this.ok("01003");
        this.q("select min(v) from t");
        this.c1();
        this.expRS = new String[][]{{"noone is here"}};
        this.ok("01003");
        this.q("select min(d) from t");
        this.c1();
        this.expRS = new String[][]{{"100.0"}};
        this.ok("01003");
        this.q("select min(r) from t");
        this.c1();
        this.expRS = new String[][]{{"100.0"}};
        this.ok("01003");
        this.q("select min(dt) from t");
        this.c1();
        this.expRS = new String[][]{{"1992-01-01"}};
        this.ok("01003");
        this.q("select min(t) from t");
        this.c1();
        this.expRS = new String[][]{{"12:30:30"}};
        this.ok("01003");
        this.q("select min(ts) from t");
        this.c1();
        this.expRS = new String[][]{{"1992-01-01 12:30:30.0"}};
        this.ok("01003");
        this.q("select min(b) from t");
        this.c1();
        this.expRS = new String[][]{{"12af"}};
        this.ok("01003");
        this.q("select min(bv) from t");
        this.c1();
        this.expRS = new String[][]{{"0000111100001111"}};
        this.ok("01003");
        this.q("select min(dc) from t");
        this.c1();
        this.expRS = new String[][]{{"111.11"}};
        this.ok("01003");
        this.q("select min(i) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0"}, {"1"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(s) from t group by s");
        this.c1();
        this.expRS = new String[][]{{"100"}, {"200"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(l) from t group by l");
        this.c1();
        this.expRS = new String[][]{{"1000000"}, {"2000000"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(c) from t group by c");
        this.c1();
        this.expRS = new String[][]{{"duplicate"}, {"goodbye"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(v) from t group by v");
        this.c1();
        this.expRS = new String[][]{{"noone is here"}, {"this is duplicated"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(d) from t group by d");
        this.c1();
        this.expRS = new String[][]{{"100.0"}, {"200.0"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(r) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"100.0"}, {"200.0"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(dt) from t group by dt");
        this.c1();
        this.expRS = new String[][]{{"1992-01-01"}, {"1992-09-09"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(t) from t group by t");
        this.c1();
        this.expRS = new String[][]{{"12:30:30"}, {"12:55:55"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(ts) from t group by ts");
        this.c1();
        this.expRS = new String[][]{{"1992-01-01 12:30:30.0"}, {"1992-01-01 12:55:55.0"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(b) from t group by b");
        this.c1();
        this.expRS = new String[][]{{"12af"}, {"ffff"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(bv) from t group by bv");
        this.c1();
        this.expRS = new String[][]{{"0000111100001111"}, {"1111111111111111"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(dc) from t group by dc");
        this.c1();
        this.expRS = new String[][]{{"111.11"}, {"222.22"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select min(1) from t");
        this.c1();
        this.expRS = new String[][]{{"1"}};
        this.ok();
        this.q("select min('hello') from t");
        this.c1();
        this.expRS = new String[][]{{"hello"}};
        this.ok();
        this.q("select min(1.1) from t");
        this.c1();
        this.expRS = new String[][]{{"1.1"}};
        this.ok();
        this.q("select min(1e1) from t");
        this.c1();
        this.expRS = new String[][]{{"10.0"}};
        this.ok();
        this.q("select min(X'11') from t");
        this.c1();
        this.expRS = new String[][]{{"11"}};
        this.ok();
        this.q("select min(date('1999-06-06')) from t");
        this.c1();
        this.expRS = new String[][]{{"1999-06-06"}};
        this.ok();
        this.q("select min(time'12:30:30') from t");
        this.c1();
        this.expRS = new String[][]{{"12:30:30"}};
        this.ok();
        this.q("select min(timestamp('1999-06-06 12:30:30')) from t");
        this.c1();
        this.expRS = new String[][]{{"1999-06-06 12:30:30.0"}};
        this.ok();
        this.q("select min(1) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"1"}, {"1"}, {"1"}};
        this.ok();
        this.q("select min('hello') from t group by c");
        this.c1();
        this.expRS = new String[][]{{"hello"}, {"hello"}, {"hello"}};
        this.ok();
        this.q("select min(1.1) from t group by dc");
        this.c1();
        this.expRS = new String[][]{{"1.1"}, {"1.1"}, {"1.1"}};
        this.ok();
        this.q("select min(1e1) from t group by d");
        this.c1();
        this.expRS = new String[][]{{"10.0"}, {"10.0"}, {"10.0"}};
        this.ok();
        this.q("select min(X'11') from t group by b");
        this.c1();
        this.expRS = new String[][]{{"11"}, {"11"}, {"11"}};
        this.ok();
        this.q("select min(date('1999-06-06')) from t group by dt");
        this.c1();
        this.expRS = new String[][]{{"1999-06-06"}, {"1999-06-06"}, {"1999-06-06"}};
        this.ok();
        this.q("select min(time'12:30:30') from t group by t");
        this.c1();
        this.expRS = new String[][]{{"12:30:30"}, {"12:30:30"}, {"12:30:30"}};
        this.ok();
        this.q("select min(timestamp('1999-06-06 12:30:30')) from t group by ts");
        this.c1();
        this.expRS = new String[][]{{"1999-06-06 12:30:30.0"}, {"1999-06-06 12:30:30.0"}, {"1999-06-06 12:30:30.0"}};
        this.ok();
        this.q("select min(i), min(dt), min(b) from t group by i, dt, b");
        this.expColNames = new String[]{"1", "2", "3"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "12af"}, {"0", "1992-01-01", "ffff"}, {"0", "1992-09-09", "12af"}, {"1", "1992-01-01", "12af"}, {null, null, null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select l, dt, min(i), min(dt), min(b), i from t group by i, dt, b, l");
        this.expColNames = new String[]{"L", "DT", "3", "4", "5", "I"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"1000000", "1992-01-01", "0", "1992-01-01", "12af", "0"}, {"2000000", "1992-01-01", "0", "1992-01-01", "12af", "0"}, {"1000000", "1992-01-01", "0", "1992-01-01", "ffff", "0"}, {"1000000", "1992-09-09", "0", "1992-09-09", "12af", "0"}, {"1000000", "1992-01-01", "1", "1992-01-01", "12af", "1"}, {null, null, null, null, null, null}};
        this.ok(new String[]{null, null, null, null, null, "01003"});
        this.q("select min(expr1), min(expr2)from (select i * s, c || v from t) t (expr1, expr2) group by expr2, expr1");
        this.c2();
        this.expRS = new String[][]{{"0", "duplicate noone is here"}, {"0", "duplicate this is duplicated"}, {"100", "duplicate this is duplicated"}, {"0", "goodbye   this is duplicated"}, {null, null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select distinct min(i) from t group by i, dt");
        this.c1();
        this.expRS = new String[][]{{"0"}, {"1"}, {null}};
        this.ok(new String[]{"01003", "01003", "01003"});
        this.x("create table tmp (x int, y varchar(20))");
        this.x("insert into tmp (x, y) select min(i), min(c) from t");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", "duplicate"}};
        this.ok();
        this.x("insert into tmp (x, y) select min(i), min(c) from t group by b");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", "duplicate"}, {"0", "duplicate"}, {"0", "duplicate"}, {null, null}};
        this.ok();
        this.x("drop table tmp");
        this.x("drop table t");
        this.x("drop table empty_table");
    }

    private void var_pop() throws SQLException {
        this.x("create table t (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary,             dc decimal(5,2))");
        this.x("create table empty_table (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary,             dc decimal(5,2))");
        this.x("insert into t (i) values (null)");
        this.x("insert into t (i) values (null)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', x'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (1, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 200, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 222.22)");
        this.e("42802", "insert into t values (0, 100, 2000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 222.22)");
        this.x("insert into t values (0, 100, 1000000,                   'goodbye', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'noone is here', 'jimmie noone was here',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 50, 500000,                   'duplicate', 'this is duplicated', 'also duplicated',                   150.0e0, 150.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 51.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 100.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-09-09', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:55:55', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:55:55',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'ffff', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 25, 250000,                   'duplicate', 'this is duplicated', 'also duplicated',                   250.0e0, 500.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'1111111111111111', X'1234', 211.11)");
        this.e("42Y22", "select var_pop(c) from t");
        this.e("42Y22", "select var_pop(v) from t");
        this.e("42Y22", "select var_pop(lvc) from t");
        this.e("42Y22", "select var_pop(dt) from t");
        this.e("42Y22", "select var_pop(t) from t");
        this.e("42Y22", "select var_pop(ts) from t");
        this.e("42Y22", "select var_pop(b) from t");
        this.e("42Y22", "select var_pop(bv) from t");
        this.e("42Y22", "select var_pop(lbv) from t");
        this.e("42Y22", "select var_pop(c) from t group by c");
        this.e("42Y22", "select var_pop(v) from t group by c");
        this.e("42Y22", "select var_pop(lvc) from t group by c");
        this.e("42Y22", "select var_pop(dt) from t group by c");
        this.e("42Y22", "select var_pop(t) from t group by c");
        this.e("42Y22", "select var_pop(ts) from t group by c");
        this.e("42Y22", "select var_pop(b) from t group by c");
        this.e("42Y22", "select var_pop(bv) from t group by c");
        this.e("42Y22", "select var_pop(lbv) from t group by c");
        this.x("create table t1 (c1 varchar)");
        this.e("42Y22", "select var_pop(c1) from t1");
        this.x("drop table t1");
        this.e("42Y22", "select var_pop('hello') from t");
        this.e("42Y22", "select var_pop(X'11') from t");
        this.e("42Y22", "select var_pop(date('1999-06-06')) from t");
        this.e("42Y22", "select var_pop(time'12:30:30') from t");
        this.e("42Y22", "select var_pop(timestamp('1999-06-06 12:30:30')) from t");
        this.q("select var_pop(i) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_pop(s) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_pop(d) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_pop(l) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_pop(r) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_pop(dc) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_pop(i), var_pop(s), var_pop(r), var_pop(l) from empty_table");
        this.expColNames = new String[]{"1", "2", "3", "4"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{null, null, null, null}};
        this.ok();
        this.q("select var_pop(i+1) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_pop(i) from empty_table group by i");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_pop(s) from empty_table group by s");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_pop(d) from empty_table group by d");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_pop(l) from empty_table group by l");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_pop(r) from empty_table group by r");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_pop(dc) from empty_table group by dc");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_pop(i) from t");
        this.c1();
        this.expRS = new String[][]{{"0.06632653061224489"}};
        this.ok("01003");
        this.q("select var_pop(s) from t");
        this.c1();
        this.expRS = new String[][]{{"1291.4540816326535"}};
        this.ok("01003");
        this.q("select var_pop(d) from t");
        this.c1();
        this.expRS = new String[][]{{"357.14285714285506"}};
        this.ok("01003");
        this.q("select var_pop(l) from t");
        this.c1();
        this.expRS = new String[][]{{"5.006377551020422E10"}};
        this.ok("01003");
        this.q("select var_pop(r) from t");
        this.c1();
        this.expRS = new String[][]{{"7206.6326530612205"}};
        this.ok("01003");
        this.q("select var_pop(dc) from t");
        this.c1();
        this.expRS = new String[][]{{"1736.7439658163385"}};
        this.ok("01003");
        this.q("select var_pop(i) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select var_pop(s) from t group by s");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select var_pop(d) from t group by d");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, null, "01003"});
        this.q("select var_pop(l) from t group by l");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, null, "01003"});
        this.q("select var_pop(r) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select var_pop(1) from t");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select var_pop(1.1) from t");
        this.c1();
        this.expRS = new String[][]{{"6.661338147750939E-16"}};
        this.ok();
        this.q("select var_pop(1e1) from t");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select var_pop(1) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}};
        this.ok();
        this.q("select var_pop(1.1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"6.661338147750939E-16"}, {"0.0"}, {"0.0"}};
        this.ok();
        this.q("select var_pop(1e1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}, {"0.0"}, {"0.0"}};
        this.ok();
        this.q("select var_pop(i), var_pop(l), var_pop(r) from t group by i, dt, b");
        this.expColNames = new String[]{"1", "2", "3"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.0", "6.09504132231405E10", "9132.231404958678"}, {"0.0", "0.0", "0.0"}, {"0.0", "0.0", "0.0"}, {"0.0", "0.0", "0.0"}, {null, null, null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select i, dt, var_pop(i), var_pop(r), var_pop(l), l from t group by i, dt, b, l");
        this.expColNames = new String[]{"I", "DT", "3", "4", "5", "L"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "0.0", "0.0", "0.0", "250000"}, {"0", "1992-01-01", "0.0", "0.0", "0.0", "500000"}, {"0", "1992-01-01", "0.0", "987.6543209876545", "0.0", "1000000"}, {"0", "1992-01-01", "0.0", "0.0", "0.0", "1000000"}, {"0", "1992-09-09", "0.0", "0.0", "0.0", "1000000"}, {"1", "1992-01-01", "0.0", "0.0", "0.0", "1000000"}, {null, null, null, null, null, null}};
        this.ok(new String[]{null, null, null, null, null, null, "01003"});
        this.q("select var_pop(expr1), var_pop(expr2)from (select i * s, r * 2 from t) t (expr1, expr2) group by expr2, expr1");
        this.c2();
        this.expRS = new String[][]{{"0.0", "0.0"}, {"0.0", "0.0"}, {"0.0", "0.0"}, {"0.0", "0.0"}, new String[0], new String[0]};
        this.ok();
        this.q("select distinct var_pop(i) from t group by i, dt");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {null}};
        this.ok(new String[]{"01003", "01003"});
        this.x("create table tmp (x double, y double)");
        this.x("insert into tmp (x, y) select var_pop(i), var_pop(s) from t");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.06632653061224489", "1291.4540816326535"}};
        this.ok();
        this.x("insert into tmp (x, y) select var_pop(i), var_pop(s) from t group by b");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.06632653061224489", "1291.4540816326535"}, {"0.07100591715976332", "1390.532544378697"}, {"0.0", "0.0"}, {null, null}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp (x int)");
        this.x("insert into tmp values (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647)");
        this.q("values(2147483647)");
        this.c1();
        this.expRS = new String[][]{{"2147483647"}};
        this.ok();
        this.q("select var_pop(x) from tmp");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select var_pop(-(x - 1)) from tmp");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select var_pop(x) from tmp group by x");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select var_pop(-(x - 1)) from tmp group by x");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp(x double precision, y int)");
        PreparedStatement scalar = this.prepareStatement("select var_pop(x) from tmp");
        PreparedStatement vector = this.prepareStatement("select var_pop(x) from tmp group by y");
        this.x("insert into tmp values (1,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.x("insert into tmp values (2,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.25"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.25"}};
        this.ok();
        this.x("insert into tmp values (3,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.666666666666667"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.666666666666667"}};
        this.ok();
        this.x("insert into tmp values (4,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.25"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.25"}};
        this.ok();
        this.x("insert into tmp values (5,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.0"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.0"}};
        this.ok();
        this.x("insert into tmp values (6,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.916666666666666"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.916666666666666"}};
        this.ok();
        this.x("insert into tmp values (7,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"4.0"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"4.0"}};
        this.ok();
        this.x("insert into tmp values (10000,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.092875525E7"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.092875525E7"}};
        this.ok();
        scalar.close();
        vector.close();
        this.x("drop table tmp");
        this.x("drop table t");
        this.x("drop table empty_table");
    }

    private void var_samp() throws SQLException {
        this.x("create table t (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary,             dc decimal(5,2))");
        this.x("create table empty_table (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary,             dc decimal(5,2))");
        this.x("insert into t (i) values (null)");
        this.x("insert into t (i) values (null)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', x'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (1, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 200, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 222.22)");
        this.e("42802", "insert into t values (0, 100, 2000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 222.22)");
        this.x("insert into t values (0, 100, 1000000,                   'goodbye', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'noone is here', 'jimmie noone was here',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 50, 500000,                   'duplicate', 'this is duplicated', 'also duplicated',                   150.0e0, 150.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 51.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 100.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-09-09', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:55:55', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:55:55',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'ffff', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 25, 250000,                   'duplicate', 'this is duplicated', 'also duplicated',                   250.0e0, 500.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'1111111111111111', X'1234', 211.11)");
        this.e("42Y22", "select var_samp(c) from t");
        this.e("42Y22", "select var_samp(v) from t");
        this.e("42Y22", "select var_samp(lvc) from t");
        this.e("42Y22", "select var_samp(dt) from t");
        this.e("42Y22", "select var_samp(t) from t");
        this.e("42Y22", "select var_samp(ts) from t");
        this.e("42Y22", "select var_samp(b) from t");
        this.e("42Y22", "select var_samp(bv) from t");
        this.e("42Y22", "select var_samp(lbv) from t");
        this.e("42Y22", "select var_samp(c) from t group by c");
        this.e("42Y22", "select var_samp(v) from t group by c");
        this.e("42Y22", "select var_samp(lvc) from t group by c");
        this.e("42Y22", "select var_samp(dt) from t group by c");
        this.e("42Y22", "select var_samp(t) from t group by c");
        this.e("42Y22", "select var_samp(ts) from t group by c");
        this.e("42Y22", "select var_samp(b) from t group by c");
        this.e("42Y22", "select var_samp(bv) from t group by c");
        this.e("42Y22", "select var_samp(lbv) from t group by c");
        this.x("create table t1 (c1 varchar)");
        this.e("42Y22", "select var_samp(c1) from t1");
        this.x("drop table t1");
        this.e("42Y22", "select var_samp('hello') from t");
        this.e("42Y22", "select var_samp(X'11') from t");
        this.e("42Y22", "select var_samp(date('1999-06-06')) from t");
        this.e("42Y22", "select var_samp(time'12:30:30') from t");
        this.e("42Y22", "select var_samp(timestamp('1999-06-06 12:30:30')) from t");
        this.q("select var_samp(i) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_samp(s) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_samp(d) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_samp(l) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_samp(r) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_samp(dc) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_samp(i), var_samp(s), var_samp(r), var_samp(l) from empty_table");
        this.expColNames = new String[]{"1", "2", "3", "4"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{null, null, null, null}};
        this.ok();
        this.q("select var_samp(i+1) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select var_samp(i) from empty_table group by i");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_samp(s) from empty_table group by s");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_samp(d) from empty_table group by d");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_samp(l) from empty_table group by l");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_samp(r) from empty_table group by r");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_samp(dc) from empty_table group by dc");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select var_samp(i) from t");
        this.c1();
        this.expRS = new String[][]{{"0.07142857142857142"}};
        this.ok("01003");
        this.q("select var_samp(s) from t");
        this.c1();
        this.expRS = new String[][]{{"1390.7967032967024"}};
        this.ok("01003");
        this.q("select var_samp(d) from t");
        this.c1();
        this.expRS = new String[][]{{"384.61538461538464"}};
        this.ok("01003");
        this.q("select var_samp(l) from t");
        this.c1();
        this.expRS = new String[][]{{"5.391483516483519E10"}};
        this.ok("01003");
        this.q("select var_samp(r) from t");
        this.c1();
        this.expRS = new String[][]{{"7760.989010989012"}};
        this.ok("01003");
        this.q("select var_samp(dc) from t");
        this.c1();
        this.expRS = new String[][]{{"1870.3396554945166"}};
        this.ok("01003");
        this.q("select var_samp(i) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {null}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select var_samp(s) from t group by s");
        this.c1();
        this.expRS = new String[][]{{null}, {null}, {"0.0"}, {null}, {null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select var_samp(d) from t group by d");
        this.c1();
        this.expRS = new String[][]{{null}, {"0.0"}, {null}, {null}};
        this.ok(new String[]{null, null, null, "01003"});
        this.q("select var_samp(l) from t group by l");
        this.c1();
        this.expRS = new String[][]{{null}, {null}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, null, "01003"});
        this.q("select var_samp(r) from t group by r");
        this.c1();
        this.expRS = new String[][]{{null}, {null}, {"0.0"}, {null}, {null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select var_samp(1) from t");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select var_samp(1.1) from t");
        this.c1();
        this.expRS = new String[][]{{"7.105427357601002E-16"}};
        this.ok();
        this.q("select var_samp(1e1) from t");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select var_samp(1) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {null}, {"0.0"}};
        this.ok();
        this.q("select var_samp(1.1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{null}, {null}, {"8.881784197001252E-16"}, {null}, {"0.0"}};
        this.ok();
        this.q("select var_samp(1e1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{null}, {null}, {"0.0"}, {null}, {"0.0"}};
        this.ok();
        this.q("select var_samp(i), var_samp(l), var_samp(r) from t group by i, dt, b");
        this.expColNames = new String[]{"1", "2", "3"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.0", "6.704545454545459E10", "10045.454545454548"}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select i, dt, var_samp(i), var_samp(r), var_samp(l), l from t group by i, dt, b, l");
        this.expColNames = new String[]{"I", "DT", "3", "4", "5", "L"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", null, null, null, "250000"}, {"0", "1992-01-01", null, null, null, "500000"}, {"0", "1992-01-01", "0.0", "1111.1111111111095", "0.0", "1000000"}, {"0", "1992-01-01", null, null, null, "1000000"}, {"0", "1992-09-09", null, null, null, "1000000"}, {"1", "1992-01-01", null, null, null, "1000000"}, {null, null, null, null, null, null}};
        this.ok(new String[]{null, null, null, null, null, null, "01003"});
        this.q("select var_samp(expr1), var_samp(expr2)from (select i * s, r * 2 from t) t (expr1, expr2) group by expr2, expr1");
        this.c2();
        this.expRS = new String[][]{{null, null}, {null, null}, {"0.0", "0.0"}, {null, null}, {null, null}, {null, null}};
        this.ok();
        this.q("select distinct var_samp(i) from t group by i, dt");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {null}};
        this.ok(new String[]{"01003", "01003"});
        this.x("create table tmp (x double, y double)");
        this.x("insert into tmp (x, y) select var_samp(i), var_samp(s) from t");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.07142857142857142", "1390.7967032967024"}};
        this.ok();
        this.x("insert into tmp (x, y) select var_samp(i), var_samp(s) from t group by b");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.07142857142857142", "1390.7967032967024"}, {"0.07692307692307693", "1506.4102564102566"}, {null, null}, {null, null}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp (x int)");
        this.x("insert into tmp values (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647)");
        this.q("values(2147483647)");
        this.c1();
        this.expRS = new String[][]{{"2147483647"}};
        this.ok();
        this.q("select var_samp(x) from tmp");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select var_samp(-(x - 1)) from tmp");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select var_samp(x) from tmp group by x");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select var_samp(-(x - 1)) from tmp group by x");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp(x double precision, y int)");
        PreparedStatement scalar = this.prepareStatement("select var_samp(x) from tmp");
        PreparedStatement vector = this.prepareStatement("select var_samp(x) from tmp group by y");
        this.x("insert into tmp values (1,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{null}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{null}};
        this.ok();
        this.x("insert into tmp values (2,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.5"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.5"}};
        this.ok();
        this.x("insert into tmp values (3,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.0"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.0"}};
        this.ok();
        this.x("insert into tmp values (4,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.6666666666666667"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.6666666666666667"}};
        this.ok();
        this.x("insert into tmp values (5,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.5"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.5"}};
        this.ok();
        this.x("insert into tmp values (6,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"3.5"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"3.5"}};
        this.ok();
        this.x("insert into tmp values (7,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"4.666666666666667"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"4.666666666666667"}};
        this.ok();
        this.x("insert into tmp values (10000,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.2490006E7"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.2490006E7"}};
        this.ok();
        scalar.close();
        vector.close();
        this.x("drop table tmp");
        this.x("drop table t");
        this.x("drop table empty_table");
    }

    private void stddev_pop() throws SQLException {
        this.x("create table t (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary,             dc decimal(5,2))");
        this.x("create table empty_table (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary,             dc decimal(5,2))");
        this.x("insert into t (i) values (null)");
        this.x("insert into t (i) values (null)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', x'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (1, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 200, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 222.22)");
        this.e("42802", "insert into t values (0, 100, 2000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 222.22)");
        this.x("insert into t values (0, 100, 1000000,                   'goodbye', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'noone is here', 'jimmie noone was here',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 50, 500000,                   'duplicate', 'this is duplicated', 'also duplicated',                   150.0e0, 150.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 51.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 100.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-09-09', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:55:55', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:55:55',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'ffff', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 25, 250000,                   'duplicate', 'this is duplicated', 'also duplicated',                   250.0e0, 500.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'1111111111111111', X'1234', 211.11)");
        this.e("42Y22", "select stddev_pop(c) from t");
        this.e("42Y22", "select stddev_pop(v) from t");
        this.e("42Y22", "select stddev_pop(lvc) from t");
        this.e("42Y22", "select stddev_pop(dt) from t");
        this.e("42Y22", "select stddev_pop(t) from t");
        this.e("42Y22", "select stddev_pop(ts) from t");
        this.e("42Y22", "select stddev_pop(b) from t");
        this.e("42Y22", "select stddev_pop(bv) from t");
        this.e("42Y22", "select stddev_pop(lbv) from t");
        this.e("42Y22", "select stddev_pop(c) from t group by c");
        this.e("42Y22", "select stddev_pop(v) from t group by c");
        this.e("42Y22", "select stddev_pop(lvc) from t group by c");
        this.e("42Y22", "select stddev_pop(dt) from t group by c");
        this.e("42Y22", "select stddev_pop(t) from t group by c");
        this.e("42Y22", "select stddev_pop(ts) from t group by c");
        this.e("42Y22", "select stddev_pop(b) from t group by c");
        this.e("42Y22", "select stddev_pop(bv) from t group by c");
        this.e("42Y22", "select stddev_pop(lbv) from t group by c");
        this.x("create table t1 (c1 varchar)");
        this.e("42Y22", "select stddev_pop(c1) from t1");
        this.x("drop table t1");
        this.e("42Y22", "select stddev_pop('hello') from t");
        this.e("42Y22", "select stddev_pop(X'11') from t");
        this.e("42Y22", "select stddev_pop(date('1999-06-06')) from t");
        this.e("42Y22", "select stddev_pop(time'12:30:30') from t");
        this.e("42Y22", "select stddev_pop(timestamp('1999-06-06 12:30:30')) from t");
        this.q("select stddev_pop(i) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_pop(s) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_pop(d) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_pop(l) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_pop(r) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_pop(dc) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_pop(i), stddev_pop(s), stddev_pop(r), stddev_pop(l) from empty_table");
        this.expColNames = new String[]{"1", "2", "3", "4"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{null, null, null, null}};
        this.ok();
        this.q("select stddev_pop(i+1) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_pop(i) from empty_table group by i");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_pop(s) from empty_table group by s");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_pop(d) from empty_table group by d");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_pop(l) from empty_table group by l");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_pop(r) from empty_table group by r");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_pop(dc) from empty_table group by dc");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_pop(i) from t");
        this.c1();
        this.expRS = new String[][]{{"0.25753937681885636"}};
        this.ok("01003");
        this.q("select stddev_pop(s) from t");
        this.c1();
        this.expRS = new String[][]{{"35.936806781246624"}};
        this.ok("01003");
        this.q("select stddev_pop(d) from t");
        this.c1();
        this.expRS = new String[][]{{"18.898223650461308"}};
        this.ok("01003");
        this.q("select stddev_pop(l) from t");
        this.c1();
        this.expRS = new String[][]{{"223749.35868110153"}};
        this.ok("01003");
        this.q("select stddev_pop(r) from t");
        this.c1();
        this.expRS = new String[][]{{"84.89188802860507"}};
        this.ok("01003");
        this.q("select stddev_pop(dc) from t");
        this.c1();
        this.expRS = new String[][]{{"41.67426023118273"}};
        this.ok("01003");
        this.q("select stddev_pop(i) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select stddev_pop(s) from t group by s");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select stddev_pop(d) from t group by d");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, null, "01003"});
        this.q("select stddev_pop(l) from t group by l");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, null, "01003"});
        this.q("select stddev_pop(r) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select stddev_pop(1) from t");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select stddev_pop(1.1) from t");
        this.c1();
        this.expRS = new String[][]{{"2.5809568279517847E-8"}};
        this.ok();
        this.q("select stddev_pop(1e1) from t");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select stddev_pop(1) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}};
        this.ok();
        this.q("select stddev_pop(1.1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"2.5809568279517847E-8"}, {"0.0"}, {"0.0"}};
        this.ok();
        this.q("select stddev_pop(1e1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {"0.0"}, {"0.0"}, {"0.0"}, {"0.0"}};
        this.ok();
        this.q("select stddev_pop(i), stddev_pop(l), stddev_pop(r) from t group by i, dt, b");
        this.expColNames = new String[]{"1", "2", "3"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.0", "246881.3748000049", "95.56270928013018"}, {"0.0", "0.0", "0.0"}, {"0.0", "0.0", "0.0"}, {"0.0", "0.0", "0.0"}, {null, null, null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select i, dt, stddev_pop(i), stddev_pop(r), stddev_pop(l), l from t group by i, dt, b, l");
        this.expColNames = new String[]{"I", "DT", "3", "4", "5", "L"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", "0.0", "0.0", "0.0", "250000"}, {"0", "1992-01-01", "0.0", "0.0", "0.0", "500000"}, {"0", "1992-01-01", "0.0", "31.426968052735447", "0.0", "1000000"}, {"0", "1992-01-01", "0.0", "0.0", "0.0", "1000000"}, {"0", "1992-09-09", "0.0", "0.0", "0.0", "1000000"}, {"1", "1992-01-01", "0.0", "0.0", "0.0", "1000000"}, {null, null, null, null, null, null}};
        this.ok(new String[]{null, null, null, null, null, null, "01003"});
        this.q("select stddev_pop(expr1), stddev_pop(expr2)from (select i * s, r * 2 from t) t (expr1, expr2) group by expr2, expr1");
        this.c2();
        this.expRS = new String[][]{{"0.0", "0.0"}, {"0.0", "0.0"}, {"0.0", "0.0"}, {"0.0", "0.0"}, new String[0], new String[0]};
        this.ok();
        this.q("select distinct stddev_pop(i) from t group by i, dt");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {null}};
        this.ok(new String[]{"01003", "01003"});
        this.x("create table tmp (x double, y double)");
        this.x("insert into tmp (x, y) select stddev_pop(i), stddev_pop(s) from t");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.25753937681885636", "35.936806781246624"}};
        this.ok();
        this.x("insert into tmp (x, y) select stddev_pop(i), stddev_pop(s) from t group by b");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.25753937681885636", "35.936806781246624"}, {"0.2664693550105965", "37.289845057048666"}, {"0.0", "0.0"}, {null, null}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp (x int)");
        this.x("insert into tmp values (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647)");
        this.q("values(2147483647)");
        this.c1();
        this.expRS = new String[][]{{"2147483647"}};
        this.ok();
        this.q("select stddev_pop(x) from tmp");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select stddev_pop(-(x - 1)) from tmp");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select stddev_pop(x) from tmp group by x");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select stddev_pop(-(x - 1)) from tmp group by x");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp(x double precision, y int)");
        PreparedStatement scalar = this.prepareStatement("select stddev_pop(x) from tmp");
        PreparedStatement vector = this.prepareStatement("select stddev_pop(x) from tmp group by y");
        this.x("insert into tmp values (1,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.x("insert into tmp values (2,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.5"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.5"}};
        this.ok();
        this.x("insert into tmp values (3,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.8164965809277263"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.8164965809277263"}};
        this.ok();
        this.x("insert into tmp values (4,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.118033988749895"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.118033988749895"}};
        this.ok();
        this.x("insert into tmp values (5,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.4142135623730951"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.4142135623730951"}};
        this.ok();
        this.x("insert into tmp values (6,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.707825127659933"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.707825127659933"}};
        this.ok();
        this.x("insert into tmp values (7,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.0"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.0"}};
        this.ok();
        this.x("insert into tmp values (10000,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"3305.8667925371706"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"3305.8667925371706"}};
        this.ok();
        scalar.close();
        vector.close();
        this.x("drop table tmp");
        this.x("drop table t");
        this.x("drop table empty_table");
    }

    private void stddev_samp() throws SQLException {
        this.x("create table t (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary,             dc decimal(5,2))");
        this.x("create table empty_table (i int, s int, l bigint,             c varchar(10), v varchar(50), lvc varchar,             d double precision, r real,              dt date, t time, ts timestamp,             b varbinary(2), bv varbinary(8), lbv varbinary,             dc decimal(5,2))");
        this.x("insert into t (i) values (null)");
        this.x("insert into t (i) values (null)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', x'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (1, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 200, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 222.22)");
        this.e("42802", "insert into t values (0, 100, 2000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 222.22)");
        this.x("insert into t values (0, 100, 1000000,                   'goodbye', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'noone is here', 'jimmie noone was here',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 50, 500000,                   'duplicate', 'this is duplicated', 'also duplicated',                   150.0e0, 150.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 51.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 100.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-09-09', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:55:55', timestamp'1992-01-01 12:30:30',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:55:55',                   X'12af', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 100, 1000000,                   'duplicate', 'this is duplicated', 'also duplicated',                   200.0e0, 200.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'ffff', X'0000111100001111', X'1234', 111.11)");
        this.x("insert into t values (0, 25, 250000,                   'duplicate', 'this is duplicated', 'also duplicated',                   250.0e0, 500.0e0,                    date'1992-01-01', time'12:30:30', timestamp'1992-01-01 12:30:30',                   X'12af', X'1111111111111111', X'1234', 211.11)");
        this.e("42Y22", "select stddev_samp(c) from t");
        this.e("42Y22", "select stddev_samp(v) from t");
        this.e("42Y22", "select stddev_samp(lvc) from t");
        this.e("42Y22", "select stddev_samp(dt) from t");
        this.e("42Y22", "select stddev_samp(t) from t");
        this.e("42Y22", "select stddev_samp(ts) from t");
        this.e("42Y22", "select stddev_samp(b) from t");
        this.e("42Y22", "select stddev_samp(bv) from t");
        this.e("42Y22", "select stddev_samp(lbv) from t");
        this.e("42Y22", "select stddev_samp(c) from t group by c");
        this.e("42Y22", "select stddev_samp(v) from t group by c");
        this.e("42Y22", "select stddev_samp(lvc) from t group by c");
        this.e("42Y22", "select stddev_samp(dt) from t group by c");
        this.e("42Y22", "select stddev_samp(t) from t group by c");
        this.e("42Y22", "select stddev_samp(ts) from t group by c");
        this.e("42Y22", "select stddev_samp(b) from t group by c");
        this.e("42Y22", "select stddev_samp(bv) from t group by c");
        this.e("42Y22", "select stddev_samp(lbv) from t group by c");
        this.x("create table t1 (c1 varchar)");
        this.e("42Y22", "select stddev_samp(c1) from t1");
        this.x("drop table t1");
        this.e("42Y22", "select stddev_samp('hello') from t");
        this.e("42Y22", "select stddev_samp(X'11') from t");
        this.e("42Y22", "select stddev_samp(date('1999-06-06')) from t");
        this.e("42Y22", "select stddev_samp(time'12:30:30') from t");
        this.e("42Y22", "select stddev_samp(timestamp('1999-06-06 12:30:30')) from t");
        this.q("select stddev_samp(i) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_samp(s) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_samp(d) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_samp(l) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_samp(r) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_samp(dc) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_samp(i), stddev_samp(s), stddev_samp(r), stddev_samp(l) from empty_table");
        this.expColNames = new String[]{"1", "2", "3", "4"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{null, null, null, null}};
        this.ok();
        this.q("select stddev_samp(i+1) from empty_table");
        this.c1();
        this.expRS = this.SINGLE_NULL_ROW;
        this.ok();
        this.q("select stddev_samp(i) from empty_table group by i");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_samp(s) from empty_table group by s");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_samp(d) from empty_table group by d");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_samp(l) from empty_table group by l");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_samp(r) from empty_table group by r");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_samp(dc) from empty_table group by dc");
        this.c1();
        JDBC.assertDrainResults(this.rs, 0);
        this.q("select stddev_samp(i) from t");
        this.c1();
        this.expRS = new String[][]{{"0.2672612419124244"}};
        this.ok("01003");
        this.q("select stddev_samp(s) from t");
        this.c1();
        this.expRS = new String[][]{{"37.29338685741351"}};
        this.ok("01003");
        this.q("select stddev_samp(d) from t");
        this.c1();
        this.expRS = new String[][]{{"19.611613513818405"}};
        this.ok("01003");
        this.q("select stddev_samp(l) from t");
        this.c1();
        this.expRS = new String[][]{{"232195.68291601632"}};
        this.ok("01003");
        this.q("select stddev_samp(r) from t");
        this.c1();
        this.expRS = new String[][]{{"88.09647558778394"}};
        this.ok("01003");
        this.q("select stddev_samp(dc) from t");
        this.c1();
        this.expRS = new String[][]{{"43.24742368620952"}};
        this.ok("01003");
        this.q("select stddev_samp(i) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {null}, {null}};
        this.ok(new String[]{null, null, "01003"});
        this.q("select stddev_samp(s) from t group by s");
        this.c1();
        this.expRS = new String[][]{{null}, {null}, {"0.0"}, {null}, {null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select stddev_samp(d) from t group by d");
        this.c1();
        this.expRS = new String[][]{{null}, {"0.0"}, {null}, {null}};
        this.ok(new String[]{null, null, null, "01003"});
        this.q("select stddev_samp(l) from t group by l");
        this.c1();
        this.expRS = new String[][]{{null}, {null}, {"0.0"}, {null}};
        this.ok(new String[]{null, null, null, "01003"});
        this.q("select stddev_samp(r) from t group by r");
        this.c1();
        this.expRS = new String[][]{{null}, {null}, {"0.0"}, {null}, {null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select stddev_samp(1) from t");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select stddev_samp(1.1) from t");
        this.c1();
        this.expRS = new String[][]{{"2.6656007498500224E-8"}};
        this.ok();
        this.q("select stddev_samp(1e1) from t");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select stddev_samp(1) from t group by i");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {null}, {"0.0"}};
        this.ok();
        this.q("select stddev_samp(1.1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{null}, {null}, {"2.9802322387695312E-8"}, {null}, {"0.0"}};
        this.ok();
        this.q("select stddev_samp(1e1) from t group by r");
        this.c1();
        this.expRS = new String[][]{{null}, {null}, {"0.0"}, {null}, {"0.0"}};
        this.ok();
        this.q("select stddev_samp(i), stddev_samp(l), stddev_samp(r) from t group by i, dt, b");
        this.expColNames = new String[]{"1", "2", "3"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.0", "258931.3703386567", "100.22701504811239"}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}};
        this.ok(new String[]{null, null, null, null, "01003"});
        this.q("select i, dt, stddev_samp(i), stddev_samp(r), stddev_samp(l), l from t group by i, dt, b, l");
        this.expColNames = new String[]{"I", "DT", "3", "4", "5", "L"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0", "1992-01-01", null, null, null, "250000"}, {"0", "1992-01-01", null, null, null, "500000"}, {"0", "1992-01-01", "0.0", "33.33333333333331", "0.0", "1000000"}, {"0", "1992-01-01", null, null, null, "1000000"}, {"0", "1992-09-09", null, null, null, "1000000"}, {"1", "1992-01-01", null, null, null, "1000000"}, {null, null, null, null, null, null}};
        this.ok(new String[]{null, null, null, null, null, null, "01003"});
        this.q("select stddev_samp(expr1), stddev_samp(expr2)from (select i * s, r * 2 from t) t (expr1, expr2) group by expr2, expr1");
        this.c2();
        this.expRS = new String[][]{{null, null}, {null, null}, {"0.0", "0.0"}, {null, null}, {null, null}, {null, null}};
        this.ok();
        this.q("select distinct stddev_samp(i) from t group by i, dt");
        this.c1();
        this.expRS = new String[][]{{"0.0"}, {null}};
        this.ok(new String[]{"01003", "01003"});
        this.x("create table tmp (x double, y double)");
        this.x("insert into tmp (x, y) select stddev_samp(i), stddev_samp(s) from t");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.2672612419124244", "37.29338685741351"}};
        this.ok();
        this.x("insert into tmp (x, y) select stddev_samp(i), stddev_samp(s) from t group by b");
        this.q("select * from tmp");
        this.expColNames = new String[]{"X", "Y"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
        this.expRS = new String[][]{{"0.2672612419124244", "37.29338685741351"}, {"0.2773500981126146", "38.81250129030924"}, {null, null}, {null, null}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp (x int)");
        this.x("insert into tmp values (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647),                     (2147483647)");
        this.q("values(2147483647)");
        this.c1();
        this.expRS = new String[][]{{"2147483647"}};
        this.ok();
        this.q("select stddev_samp(x) from tmp");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select stddev_samp(-(x - 1)) from tmp");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select stddev_samp(x) from tmp group by x");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.q("select stddev_samp(-(x - 1)) from tmp group by x");
        this.c1();
        this.expRS = new String[][]{{"0.0"}};
        this.ok();
        this.x("drop table tmp");
        this.x("create table tmp(x double precision, y int)");
        PreparedStatement scalar = this.prepareStatement("select stddev_samp(x) from tmp");
        PreparedStatement vector = this.prepareStatement("select stddev_samp(x) from tmp group by y");
        this.x("insert into tmp values (1,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{null}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{null}};
        this.ok();
        this.x("insert into tmp values (2,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.7071067811865476"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"0.7071067811865476"}};
        this.ok();
        this.x("insert into tmp values (3,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.0"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.0"}};
        this.ok();
        this.x("insert into tmp values (4,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.2909944487358056"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.2909944487358056"}};
        this.ok();
        this.x("insert into tmp values (5,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.5811388300841898"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.5811388300841898"}};
        this.ok();
        this.x("insert into tmp values (6,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.8708286933869707"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"1.8708286933869707"}};
        this.ok();
        this.x("insert into tmp values (7,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.160246899469287"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"2.160246899469287"}};
        this.ok();
        this.x("insert into tmp values (10000,1)");
        this.rs = scalar.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"3534.120258282109"}};
        this.ok();
        this.rs = vector.executeQuery();
        this.c1();
        this.expRS = new String[][]{{"3534.120258282109"}};
        this.ok();
        scalar.close();
        vector.close();
        this.x("drop table tmp");
        this.x("drop table t");
        this.x("drop table empty_table");
    }

    private void x(String stmt) throws SQLException {
        this.st.executeUpdate(stmt);
    }

    private void q(String query) throws SQLException {
        this.rs = this.st.executeQuery(query);
    }

    private void c1() throws SQLException {
        this.expColNames = new String[]{"EXPR$0"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
    }

    private void c2() throws SQLException {
        this.expColNames = new String[]{"EXPR$0", "EXPR$1"};
        JDBC.assertColumnNames(this.rs, this.expColNames);
    }

    private void e(String expectedState, String stmt) {
        AggBuiltinTest.assertStatementError(expectedState, this.st, stmt);
    }

    private void ok() throws SQLException {
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, true);
    }

    private void ok(String[] warnings) throws SQLException {
        JDBC.assertFullResultSet(this.rs, (Object[][])this.expRS, warnings);
    }

    private void ok(String warning) throws SQLException {
        this.ok(new String[]{warning});
    }
}

