/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.kareldb.schema;

import io.kareldb.KarelDbEngine;
import org.apache.calcite.schema.SchemaPlus;

import java.util.Map;

/**
 * Factory that creates a {@link Schema}.
 */
@SuppressWarnings("UnusedDeclaration")
public class SchemaFactory implements org.apache.calcite.schema.SchemaFactory {
    public SchemaFactory() {
    }

    public org.apache.calcite.schema.Schema create(SchemaPlus parentSchema, String name,
                                                   Map<String, Object> operand) {
        KarelDbEngine engine = KarelDbEngine.getInstance();
        if (!engine.isInitialized()) {
            engine.configure(operand);
            engine.init();
        }
        return engine.getSchema();
    }
}
