/*
 * Decompiled with CFR 0.152.
 */
package io.joern.kotlin2cpg.types;

import io.joern.kotlin2cpg.types.Constants$;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererImpl;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptionsImpl;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnresolvedType;

public final class TypeRenderer$ {
    public static final TypeRenderer$ MODULE$ = new TypeRenderer$();

    public DescriptorRenderer descriptorRenderer(DeclarationDescriptor desc) {
        DescriptorRendererOptionsImpl opts = new DescriptorRendererOptionsImpl();
        opts.setParameterNamesInFunctionalTypes(false);
        if (desc != null) {
            ClassDescriptor anyT = DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)desc).getAny();
            opts.setTypeNormalizer(t -> {
                KotlinType kotlinType = t;
                Object object = kotlinType instanceof UnresolvedType ? anyT.getDefaultType() : (kotlinType instanceof ErrorType ? anyT.getDefaultType() : t);
                return object;
            });
        }
        return new DescriptorRendererImpl(opts);
    }

    public String renderFqName(DeclarationDescriptor desc) {
        DescriptorRenderer renderer = this.descriptorRenderer(desc);
        FqNameUnsafe fqName = DescriptorUtils.getFqName((DeclarationDescriptor)desc);
        return this.stripped(renderer.renderFqName(fqName));
    }

    public String render(KotlinType t) {
        String string;
        DescriptorRenderer renderer = this.descriptorRenderer((DeclarationDescriptor)t.getConstructor().getDeclarationDescriptor());
        if (this.isFunctionXType(t)) {
            string = new StringBuilder(0).append(Constants$.MODULE$.kotlinFunctionXPrefix()).append(Integer.toString(t.getArguments().size() - 1)).toString();
        } else {
            String rendered = renderer.renderType(t);
            string = this.stripped(rendered);
        }
        return string;
    }

    private boolean isFunctionXType(KotlinType t) {
        DescriptorRenderer renderer = DescriptorRenderer.FQ_NAMES_IN_TYPES;
        String renderedConstructor = renderer.renderTypeConstructor(t.getConstructor());
        return renderedConstructor.startsWith(Constants$.MODULE$.kotlinFunctionXPrefix());
    }

    public String stripped(String typeName) {
        return TypeRenderer$.stripTypeParams$1(TypeRenderer$.stripOptionality$1(TypeRenderer$.stripDebugInfo$1(TypeRenderer$.stripOut$1(typeName))).trim().replaceAll(" ", ""));
    }

    private static final String stripTypeParams$1(String typeName) {
        return typeName.replaceAll("<.*>", "");
    }

    private static final String stripOut$1(String name) {
        return name.contains("<") && name.contains(">") && name.contains("out") ? name.replaceAll("(<[^o]*)[(]?out[)]?[ ]*([a-zA-Z])", "<$2") : name;
    }

    private static final String stripOptionality$1(String typeName) {
        return typeName.replaceAll("!", "").replaceAll("\\?", "");
    }

    private static final String stripDebugInfo$1(String typeName) {
        return typeName.contains("/* =") ? typeName.split("/\\* =")[0] : typeName;
    }

    private TypeRenderer$() {
    }
}

