/*
 * Decompiled with CFR 0.152.
 */
package io.joern.joerncli;

import better.files.File;
import better.files.File$;
import io.joern.console.BridgeBase;
import io.joern.console.Config;
import io.joern.console.Config$;
import io.joern.console.DefaultArgumentProvider;
import io.joern.console.InteractiveShell;
import io.joern.console.PluginHandling;
import io.joern.console.Query;
import io.joern.console.QueryDatabase;
import io.joern.console.QueryDatabase$;
import io.joern.console.ScriptExecution;
import io.joern.console.ServerHandling;
import io.joern.dataflowengineoss.queryengine.EngineContext;
import io.joern.dataflowengineoss.queryengine.EngineContext$;
import io.joern.dataflowengineoss.semanticsloader.Semantics$;
import io.joern.joerncli.CpgBasedTool$;
import io.joern.joerncli.JoernDefaultArgumentProvider;
import io.joern.joerncli.JoernScanConfig;
import io.joern.joerncli.JoernScanConfig$;
import io.joern.joerncli.Scan$;
import io.joern.joerncli.console.ReplBridge$;
import io.shiftleft.codepropertygraph.generated.Languages;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.native.Serialization$;
import requests.Response;
import requests.package$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scopt.OptionParser;
import scopt.Read$;

public final class JoernScan$
implements InteractiveShell,
ScriptExecution,
PluginHandling,
ServerHandling,
BridgeBase,
Serializable {
    private static final String applicationName;
    private static final String implementationVersion;
    private static final OptionParser<JoernScanConfig> optionParser;
    public static final JoernScan$ MODULE$;

    private JoernScan$() {
    }

    static {
        MODULE$ = new JoernScan$();
        applicationName = "joern";
        implementationVersion = MODULE$.getClass().getPackage().getImplementationVersion();
        optionParser = new OptionParser<JoernScanConfig>(){
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Creates a code property graph and scans it with queries from installed bundles.\nVersion: `" + JoernScan$.MODULE$.implementationVersion() + "`"}));
                this.help("help").text("Prints this usage text");
                this.arg("src", Read$.MODULE$.stringRead()).text("source code directory to scan").optional().action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$1);
                this.opt("overwrite", Read$.MODULE$.unitRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$2).text("Overwrite CPG if it already exists");
                this.opt("store", Read$.MODULE$.unitRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$3).text("Store graph changes made by scanner");
                this.opt("dump", Read$.MODULE$.unitRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$4).text("Dump available queries to a file at `" + JoernScanConfig$.MODULE$.defaultDumpQueryDestination() + "`");
                this.opt("dump-to", Read$.MODULE$.stringRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$5).text("Dump available queries to a specific file");
                this.opt("list-query-names", Read$.MODULE$.unitRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$6).text("Print a list of available query names");
                this.opt("updatedb", Read$.MODULE$.unitRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$7).text("Update query database");
                this.opt("dbversion", Read$.MODULE$.stringRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$8).text("Version of query database `updatedb`-operation installs");
                this.opt("names", Read$.MODULE$.stringRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$9).text("Filter queries used for scanning by name, comma-separated string");
                this.opt("tags", Read$.MODULE$.stringRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$10).text("Filter queries used for scanning by tags, comma-separated string");
                this.opt("depth", Read$.MODULE$.intRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$adapted$1).text("Set call depth for interprocedural analysis");
                this.opt("language", Read$.MODULE$.stringRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$12).text("Source language");
                this.opt("list-languages", Read$.MODULE$.unitRead()).action(JoernScan$::io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$13).text("List available language options");
                this.note("Args specified after the " + CpgBasedTool$.MODULE$.ARGS_DELIMITER() + " separator will be passed to the front-end verbatim");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$1(java.lang.String io.joern.joerncli.JoernScanConfig ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$2(scala.runtime.BoxedUnit io.joern.joerncli.JoernScanConfig ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$3(scala.runtime.BoxedUnit io.joern.joerncli.JoernScanConfig ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$4(scala.runtime.BoxedUnit io.joern.joerncli.JoernScanConfig ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$5(java.lang.String io.joern.joerncli.JoernScanConfig ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$6(scala.runtime.BoxedUnit io.joern.joerncli.JoernScanConfig ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$7(scala.runtime.BoxedUnit io.joern.joerncli.JoernScanConfig ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$8(java.lang.String io.joern.joerncli.JoernScanConfig ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$9(java.lang.String io.joern.joerncli.JoernScanConfig ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$10(java.lang.String io.joern.joerncli.JoernScanConfig ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$adapted$1(java.lang.Object java.lang.Object ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$12(java.lang.String io.joern.joerncli.JoernScanConfig ), io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$13(scala.runtime.BoxedUnit io.joern.joerncli.JoernScanConfig )}, serializedLambda);
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JoernScan$.class);
    }

    public String applicationName() {
        return applicationName;
    }

    public String implementationVersion() {
        return implementationVersion;
    }

    public void main(String[] args) {
        Tuple2<List<String>, List<String>> tuple2 = CpgBasedTool$.MODULE$.splitArgs(args);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List scanArgs = (List)tuple2._1();
        List frontendArgs = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)scanArgs, (Object)frontendArgs);
        List scanArgs2 = (List)tuple22._1();
        List frontendArgs2 = (List)tuple22._2();
        this.optionParser().parse((Seq)scanArgs2, (Object)JoernScanConfig$.MODULE$.apply(JoernScanConfig$.MODULE$.$lessinit$greater$default$1(), JoernScanConfig$.MODULE$.$lessinit$greater$default$2(), JoernScanConfig$.MODULE$.$lessinit$greater$default$3(), JoernScanConfig$.MODULE$.$lessinit$greater$default$4(), JoernScanConfig$.MODULE$.$lessinit$greater$default$5(), JoernScanConfig$.MODULE$.$lessinit$greater$default$6(), JoernScanConfig$.MODULE$.$lessinit$greater$default$7(), JoernScanConfig$.MODULE$.$lessinit$greater$default$8(), JoernScanConfig$.MODULE$.$lessinit$greater$default$9(), JoernScanConfig$.MODULE$.$lessinit$greater$default$10(), JoernScanConfig$.MODULE$.$lessinit$greater$default$11(), JoernScanConfig$.MODULE$.$lessinit$greater$default$12(), JoernScanConfig$.MODULE$.$lessinit$greater$default$13())).foreach((Function1)(JProcedure1 & Serializable)config -> MODULE$.run((JoernScanConfig)config, (List<String>)frontendArgs2));
    }

    public OptionParser<JoernScanConfig> optionParser() {
        return optionParser;
    }

    private void run(JoernScanConfig config, List<String> frontendArgs) {
        if (config.dump()) {
            this.dumpQueriesAsJson(config.dumpDestination());
            return;
        }
        if (config.listQueryNames()) {
            this.listQueryNames();
            return;
        }
        if (config.listLanguages()) {
            this.listLanguages();
            return;
        }
        if (config.updateQueryDb()) {
            this.updateQueryDatabase(config.queryDbVersion());
            return;
        }
        this.runScanPlugin(config, frontendArgs);
    }

    private void dumpQueriesAsJson(String outFileName) {
        EngineContext engineContext = EngineContext$.MODULE$.apply(Semantics$.MODULE$.empty(), EngineContext$.MODULE$.$lessinit$greater$default$2());
        Formats formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        QueryDatabase queryDb = new QueryDatabase((DefaultArgumentProvider)new JoernDefaultArgumentProvider(0, engineContext), QueryDatabase$.MODULE$.$lessinit$greater$default$2());
        File file = File$.MODULE$.apply(outFileName, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        String string = Serialization$.MODULE$.write((Object)queryDb.allQueries(), formats);
        file.write(string, file.write$default$2(string), file.write$default$3(string));
        Predef$.MODULE$.println((Object)("Queries written to: " + outFileName));
    }

    private void listQueryNames() {
        Predef$.MODULE$.println((Object)((IterableOnceOps)this.queryNames().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    private void listLanguages() {
        StringBuilder s = new StringBuilder();
        s.$plus$plus$eq("Available languages (case insensitive):\n");
        s.$plus$plus$eq(((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(Languages.ALL).asScala().map((Function1 & Serializable)lang -> "- " + lang.toLowerCase())).mkString("\n"));
        Predef$.MODULE$.println((Object)s.toString());
    }

    private void runScanPlugin(JoernScanConfig config, List<String> frontendArgs) {
        String string = config.src();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.println((Object)this.optionParser().usage());
            return;
        }
        if (this.queryNames().isEmpty()) {
            this.downloadAndInstallQueryDatabase(config.queryDbVersion());
            System.exit(2);
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])config.names().split(","));
        Scan$.MODULE$.defaultOpts().names_$eq((String[])ArrayOps$.MODULE$.filterNot$extension(object, (Function1 & Serializable)_$7 -> _$7.isEmpty()));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])config.tags().split(","));
        Scan$.MODULE$.defaultOpts().tags_$eq((String[])ArrayOps$.MODULE$.filterNot$extension(object2, (Function1 & Serializable)_$8 -> _$8.isEmpty()));
        Scan$.MODULE$.defaultOpts().maxCallDepth_$eq(config.maxCallDepth());
        Config config2 = Config$.MODULE$.apply(Config$.MODULE$.$lessinit$greater$default$1(), Config$.MODULE$.$lessinit$greater$default$2(), Config$.MODULE$.$lessinit$greater$default$3(), Config$.MODULE$.$lessinit$greater$default$4(), Config$.MODULE$.$lessinit$greater$default$5(), Config$.MODULE$.$lessinit$greater$default$6(), Config$.MODULE$.$lessinit$greater$default$7(), Config$.MODULE$.$lessinit$greater$default$8(), Config$.MODULE$.$lessinit$greater$default$9(), Config$.MODULE$.$lessinit$greater$default$10(), Config$.MODULE$.$lessinit$greater$default$11(), Config$.MODULE$.$lessinit$greater$default$12(), Config$.MODULE$.$lessinit$greater$default$13(), Config$.MODULE$.$lessinit$greater$default$14(), Config$.MODULE$.$lessinit$greater$default$15(), Config$.MODULE$.$lessinit$greater$default$16(), Config$.MODULE$.$lessinit$greater$default$17(), Config$.MODULE$.$lessinit$greater$default$18(), Config$.MODULE$.$lessinit$greater$default$19(), Config$.MODULE$.$lessinit$greater$default$20(), Config$.MODULE$.$lessinit$greater$default$21(), Config$.MODULE$.$lessinit$greater$default$22(), Config$.MODULE$.$lessinit$greater$default$23(), Config$.MODULE$.$lessinit$greater$default$24(), Config$.MODULE$.$lessinit$greater$default$25(), Config$.MODULE$.$lessinit$greater$default$26());
        Some some = Some$.MODULE$.apply((Object)"scan");
        Some some2 = Some$.MODULE$.apply((Object)config.src());
        String[] stringArray = (String[])frontendArgs.toArray(ClassTag$.MODULE$.apply(String.class));
        Option option = config2.copy$default$1();
        Option option2 = config2.copy$default$2();
        Map map = config2.copy$default$3();
        scala.collection.immutable.Seq seq = config2.copy$default$4();
        scala.collection.immutable.Seq seq2 = config2.copy$default$5();
        Option option3 = config2.copy$default$6();
        Option option4 = config2.copy$default$7();
        boolean bl = config2.copy$default$9();
        boolean bl2 = config2.copy$default$14();
        String string3 = config2.copy$default$15();
        int n = config2.copy$default$16();
        Option option5 = config2.copy$default$17();
        Option option6 = config2.copy$default$18();
        boolean bl3 = config2.copy$default$19();
        Option option7 = config2.copy$default$20();
        Option option8 = config2.copy$default$21();
        boolean bl4 = config2.copy$default$23();
        scala.collection.immutable.Seq seq3 = config2.copy$default$24();
        scala.collection.immutable.Seq seq4 = config2.copy$default$25();
        Option option9 = config2.copy$default$26();
        Config shellConfig = config2.copy(option, option2, map, seq, seq2, option3, option4, (Option)some, bl, (Option)some2, config.language(), config.overwrite(), config.store(), bl2, string3, n, option5, option6, bl3, option7, option8, stringArray, bl4, seq3, seq4, option9);
        this.run(shellConfig);
        Predef$.MODULE$.println((Object)("Run `joern --for-input-path " + config.src() + "` to explore interactively"));
    }

    private List<String> queryNames() {
        EngineContext engineContext = EngineContext$.MODULE$.apply(Semantics$.MODULE$.empty(), EngineContext$.MODULE$.$lessinit$greater$default$2());
        return this.getQueriesFromQueryDb(new JoernDefaultArgumentProvider(0, engineContext)).map((Function1 & Serializable)_$9 -> _$9.name());
    }

    public List<Query> getQueriesFromQueryDb(DefaultArgumentProvider defaultArgumentProvider) {
        return new QueryDatabase(defaultArgumentProvider, QueryDatabase$.MODULE$.$lessinit$greater$default$2()).allQueries();
    }

    private void updateQueryDatabase(String version) {
        this.removeQueryDatabase();
        this.downloadAndInstallQueryDatabase(version);
    }

    public void downloadAndInstallQueryDatabase(String version) {
        String actualVersion = (String)Option$.MODULE$.apply((Object)version).filter((Function1 & Serializable)_$10 -> {
            String string = _$10;
            String string2 = "";
            return string == null ? string2 != null : !string.equals(string2);
        }).getOrElse(JoernScan$::$anonfun$2);
        File$.MODULE$.usingTemporaryDirectory("joern-scan", File$.MODULE$.usingTemporaryDirectory$default$2(), File$.MODULE$.usingTemporaryDirectory$default$3(), (Function1)(JProcedure1 & Serializable)dir -> {
            String queryDbZipPath = MODULE$.downloadDefaultQueryDatabase(actualVersion, (File)dir);
            MODULE$.addQueryDatabase(queryDbZipPath);
        });
    }

    public String downloadAndInstallQueryDatabase$default$1() {
        return "";
    }

    private String downloadDefaultQueryDatabase(String version, File outDir) {
        String url = this.urlForVersion(version);
        Predef$.MODULE$.println((Object)("Downloading default query bundle from: " + url));
        Response r = package$.MODULE$.get().apply(url, package$.MODULE$.get().apply$default$2(), package$.MODULE$.get().apply$default$3(), package$.MODULE$.get().apply$default$4(), package$.MODULE$.get().apply$default$5(), package$.MODULE$.get().apply$default$6(), package$.MODULE$.get().apply$default$7(), package$.MODULE$.get().apply$default$8(), package$.MODULE$.get().apply$default$9(), package$.MODULE$.get().apply$default$10(), package$.MODULE$.get().apply$default$11(), package$.MODULE$.get().apply$default$12(), package$.MODULE$.get().apply$default$13(), package$.MODULE$.get().apply$default$14(), package$.MODULE$.get().apply$default$15(), package$.MODULE$.get().apply$default$16(), package$.MODULE$.get().apply$default$17(), package$.MODULE$.get().apply$default$18(), package$.MODULE$.get().apply$default$19());
        File queryDbZip = outDir.$div("querydb.zip");
        String absPath = queryDbZip.path().toAbsolutePath().toString();
        Object object = Predef$.MODULE$.byteArrayOps(r.bytes());
        Iterator iterator = ArrayOps$.MODULE$.iterator$extension(object);
        queryDbZip.writeBytes(iterator, queryDbZip.writeBytes$default$2(iterator));
        Predef$.MODULE$.println((Object)("Wrote: " + queryDbZip.size(queryDbZip.size$default$1()) + " bytes to " + absPath));
        return absPath;
    }

    private void removeQueryDatabase() {
        Predef$.MODULE$.println((Object)"Removing current version of query database");
        Config config = Config$.MODULE$.apply(Config$.MODULE$.$lessinit$greater$default$1(), Config$.MODULE$.$lessinit$greater$default$2(), Config$.MODULE$.$lessinit$greater$default$3(), Config$.MODULE$.$lessinit$greater$default$4(), Config$.MODULE$.$lessinit$greater$default$5(), Config$.MODULE$.$lessinit$greater$default$6(), Config$.MODULE$.$lessinit$greater$default$7(), Config$.MODULE$.$lessinit$greater$default$8(), Config$.MODULE$.$lessinit$greater$default$9(), Config$.MODULE$.$lessinit$greater$default$10(), Config$.MODULE$.$lessinit$greater$default$11(), Config$.MODULE$.$lessinit$greater$default$12(), Config$.MODULE$.$lessinit$greater$default$13(), Config$.MODULE$.$lessinit$greater$default$14(), Config$.MODULE$.$lessinit$greater$default$15(), Config$.MODULE$.$lessinit$greater$default$16(), Config$.MODULE$.$lessinit$greater$default$17(), Config$.MODULE$.$lessinit$greater$default$18(), Config$.MODULE$.$lessinit$greater$default$19(), Config$.MODULE$.$lessinit$greater$default$20(), Config$.MODULE$.$lessinit$greater$default$21(), Config$.MODULE$.$lessinit$greater$default$22(), Config$.MODULE$.$lessinit$greater$default$23(), Config$.MODULE$.$lessinit$greater$default$24(), Config$.MODULE$.$lessinit$greater$default$25(), Config$.MODULE$.$lessinit$greater$default$26());
        Some some = Some$.MODULE$.apply((Object)"querydb");
        Option option = config.copy$default$1();
        Option option2 = config.copy$default$2();
        Map map = config.copy$default$3();
        scala.collection.immutable.Seq seq = config.copy$default$4();
        scala.collection.immutable.Seq seq2 = config.copy$default$5();
        Option option3 = config.copy$default$6();
        Option option4 = config.copy$default$8();
        boolean bl = config.copy$default$9();
        Option option5 = config.copy$default$10();
        Option option6 = config.copy$default$11();
        boolean bl2 = config.copy$default$12();
        boolean bl3 = config.copy$default$13();
        boolean bl4 = config.copy$default$14();
        String string = config.copy$default$15();
        int n = config.copy$default$16();
        Option option7 = config.copy$default$17();
        Option option8 = config.copy$default$18();
        boolean bl5 = config.copy$default$19();
        Option option9 = config.copy$default$20();
        Option option10 = config.copy$default$21();
        String[] stringArray = config.copy$default$22();
        boolean bl6 = config.copy$default$23();
        scala.collection.immutable.Seq seq3 = config.copy$default$24();
        scala.collection.immutable.Seq seq4 = config.copy$default$25();
        Option option11 = config.copy$default$26();
        Config rmPluginConfig = config.copy(option, option2, map, seq, seq2, option3, (Option)some, option4, bl, option5, option6, bl2, bl3, bl4, string, n, option7, option8, bl5, option9, option10, stringArray, bl6, seq3, seq4, option11);
        this.run(rmPluginConfig);
    }

    private void addQueryDatabase(String absPath) {
        Predef$.MODULE$.println((Object)"Adding updated version of query database");
        Config config = Config$.MODULE$.apply(Config$.MODULE$.$lessinit$greater$default$1(), Config$.MODULE$.$lessinit$greater$default$2(), Config$.MODULE$.$lessinit$greater$default$3(), Config$.MODULE$.$lessinit$greater$default$4(), Config$.MODULE$.$lessinit$greater$default$5(), Config$.MODULE$.$lessinit$greater$default$6(), Config$.MODULE$.$lessinit$greater$default$7(), Config$.MODULE$.$lessinit$greater$default$8(), Config$.MODULE$.$lessinit$greater$default$9(), Config$.MODULE$.$lessinit$greater$default$10(), Config$.MODULE$.$lessinit$greater$default$11(), Config$.MODULE$.$lessinit$greater$default$12(), Config$.MODULE$.$lessinit$greater$default$13(), Config$.MODULE$.$lessinit$greater$default$14(), Config$.MODULE$.$lessinit$greater$default$15(), Config$.MODULE$.$lessinit$greater$default$16(), Config$.MODULE$.$lessinit$greater$default$17(), Config$.MODULE$.$lessinit$greater$default$18(), Config$.MODULE$.$lessinit$greater$default$19(), Config$.MODULE$.$lessinit$greater$default$20(), Config$.MODULE$.$lessinit$greater$default$21(), Config$.MODULE$.$lessinit$greater$default$22(), Config$.MODULE$.$lessinit$greater$default$23(), Config$.MODULE$.$lessinit$greater$default$24(), Config$.MODULE$.$lessinit$greater$default$25(), Config$.MODULE$.$lessinit$greater$default$26());
        Some some = Some$.MODULE$.apply((Object)absPath);
        Option option = config.copy$default$1();
        Option option2 = config.copy$default$2();
        Map map = config.copy$default$3();
        scala.collection.immutable.Seq seq = config.copy$default$4();
        scala.collection.immutable.Seq seq2 = config.copy$default$5();
        Option option3 = config.copy$default$7();
        Option option4 = config.copy$default$8();
        boolean bl = config.copy$default$9();
        Option option5 = config.copy$default$10();
        Option option6 = config.copy$default$11();
        boolean bl2 = config.copy$default$12();
        boolean bl3 = config.copy$default$13();
        boolean bl4 = config.copy$default$14();
        String string = config.copy$default$15();
        int n = config.copy$default$16();
        Option option7 = config.copy$default$17();
        Option option8 = config.copy$default$18();
        boolean bl5 = config.copy$default$19();
        Option option9 = config.copy$default$20();
        Option option10 = config.copy$default$21();
        String[] stringArray = config.copy$default$22();
        boolean bl6 = config.copy$default$23();
        scala.collection.immutable.Seq seq3 = config.copy$default$24();
        scala.collection.immutable.Seq seq4 = config.copy$default$25();
        Option option11 = config.copy$default$26();
        Config addPluginConfig = config.copy(option, option2, map, seq, seq2, (Option)some, option3, option4, bl, option5, option6, bl2, bl3, bl4, string, n, option7, option8, bl5, option9, option10, stringArray, bl6, seq3, seq4, option11);
        this.run(addPluginConfig);
    }

    private String urlForVersion(String version) {
        String string = version;
        String string2 = "latest";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return "https://github.com/joernio/joern/releases/latest/download/querydb.zip";
        }
        return "https://github.com/joernio/joern/releases/download/v" + version + "/querydb.zip";
    }

    public scala.collection.immutable.Seq<String> predefLines() {
        return ReplBridge$.MODULE$.predefLines();
    }

    public String promptStr() {
        return ReplBridge$.MODULE$.promptStr();
    }

    public String greeting() {
        return ReplBridge$.MODULE$.greeting();
    }

    public String onExitCode() {
        return ReplBridge$.MODULE$.onExitCode();
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$1(String x, JoernScanConfig c) {
        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13());
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$2(BoxedUnit _$1, JoernScanConfig c) {
        return c.copy(c.copy$default$1(), true, c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13());
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$3(BoxedUnit _$2, JoernScanConfig c) {
        return c.copy(c.copy$default$1(), c.copy$default$2(), true, c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13());
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$4(BoxedUnit _$3, JoernScanConfig c) {
        String string = JoernScanConfig$.MODULE$.defaultDumpQueryDestination();
        String string2 = c.copy$default$1();
        boolean bl = c.copy$default$2();
        boolean bl2 = c.copy$default$3();
        boolean bl3 = c.copy$default$6();
        boolean bl4 = c.copy$default$7();
        String string3 = c.copy$default$8();
        int n = c.copy$default$9();
        String string4 = c.copy$default$10();
        String string5 = c.copy$default$11();
        Option<String> option = c.copy$default$12();
        boolean bl5 = c.copy$default$13();
        return c.copy(string2, bl, bl2, true, string, bl3, bl4, string3, n, string4, string5, option, bl5);
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$5(String x, JoernScanConfig c) {
        return c.copy(c.copy$default$1(), c.copy$default$2(), c.copy$default$3(), true, x, c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13());
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$6(BoxedUnit _$4, JoernScanConfig c) {
        return c.copy(c.copy$default$1(), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), true, c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13());
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$7(BoxedUnit _$5, JoernScanConfig c) {
        return c.copy(c.copy$default$1(), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), true, c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13());
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$8(String x, JoernScanConfig c) {
        return c.copy(c.copy$default$1(), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), x, c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13());
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$9(String x, JoernScanConfig c) {
        return c.copy(c.copy$default$1(), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), x, c.copy$default$11(), c.copy$default$12(), c.copy$default$13());
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$10(String x, JoernScanConfig c) {
        return c.copy(c.copy$default$1(), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), x, c.copy$default$12(), c.copy$default$13());
    }

    public static /* bridge */ /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$adapted$1(Object x, Object c) {
        return ((JoernScanConfig)c).copy(((JoernScanConfig)c).copy$default$1(), ((JoernScanConfig)c).copy$default$2(), ((JoernScanConfig)c).copy$default$3(), ((JoernScanConfig)c).copy$default$4(), ((JoernScanConfig)c).copy$default$5(), ((JoernScanConfig)c).copy$default$6(), ((JoernScanConfig)c).copy$default$7(), ((JoernScanConfig)c).copy$default$8(), BoxesRunTime.unboxToInt((Object)x), ((JoernScanConfig)c).copy$default$10(), ((JoernScanConfig)c).copy$default$11(), ((JoernScanConfig)c).copy$default$12(), ((JoernScanConfig)c).copy$default$13());
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$12(String x, JoernScanConfig c) {
        Some some = Some$.MODULE$.apply((Object)x);
        String string = c.copy$default$1();
        boolean bl = c.copy$default$2();
        boolean bl2 = c.copy$default$3();
        boolean bl3 = c.copy$default$4();
        String string2 = c.copy$default$5();
        boolean bl4 = c.copy$default$6();
        boolean bl5 = c.copy$default$7();
        String string3 = c.copy$default$8();
        int n = c.copy$default$9();
        String string4 = c.copy$default$10();
        String string5 = c.copy$default$11();
        boolean bl6 = c.copy$default$13();
        return c.copy(string, bl, bl2, bl3, string2, bl4, bl5, string3, n, string4, string5, (Option<String>)some, bl6);
    }

    public static final /* synthetic */ JoernScanConfig io$joern$joerncli$JoernScan$$anon$1$$_$$lessinit$greater$$anonfun$13(BoxedUnit _$6, JoernScanConfig c) {
        return c.copy(c.copy$default$1(), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), true);
    }

    private static final String $anonfun$2() {
        return JoernScanConfig$.MODULE$.defaultDbVersion();
    }
}

