/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.convert;

import flatgraph.AccessHelpers;
import flatgraph.Accessors$;
import flatgraph.Edge;
import flatgraph.GNode;
import flatgraph.Graph;
import flatgraph.Schema;
import flatgraph.convert.Convert;
import flatgraph.convert.Convert$NodeStuff$;
import flatgraph.misc.ISeq;
import flatgraph.misc.Misc$;
import flatgraph.storage.Deserialization$;
import flatgraph.storage.Manifest;
import flatgraph.storage.WriterContext;
import flatgraph.storage.package;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;
import overflowdb.storage.OdbStorage;
import overflowdb.storage.ValueTypes;
import overflowdb.util.StringInterner;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Short$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;

public final class Convert$
implements Serializable {
    private static final String ANON_EDGE_PROPERTY;
    public static final Convert$NodeStuff$ flatgraph$convert$Convert$$$NodeStuff;
    public static final Convert$ MODULE$;

    private Convert$() {
    }

    static {
        MODULE$ = new Convert$();
        ANON_EDGE_PROPERTY = "EDGE_PROPERTY";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Convert$.class);
    }

    public String ANON_EDGE_PROPERTY() {
        return ANON_EDGE_PROPERTY;
    }

    public void main(String[] args) {
        ObjectRef dstFile = ObjectRef.create(null);
        ObjectRef srcFile = ObjectRef.create(null);
        BooleanRef reverse = BooleanRef.create((boolean)false);
        BooleanRef verbose = BooleanRef.create((boolean)false);
        BooleanRef tooMany = BooleanRef.create((boolean)false);
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)arg -> {
            String string = arg;
            String string2 = "-r";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                reverse$1.elem = true;
                return;
            }
            String string3 = arg;
            String string4 = "--verbose";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                verbose$2.elem = true;
                return;
            }
            if ((Path)srcFile$1.elem == null) {
                srcFile$1.elem = Paths.get(arg, new String[0]);
                return;
            }
            if ((Path)dstFile$1.elem == null) {
                dstFile$1.elem = Paths.get(arg, new String[0]);
                return;
            }
            tooMany$1.elem = true;
        });
        if (tooMany.elem || (Path)dstFile.elem == null || (Path)srcFile.elem == null) {
            System.err.println("Usage: convert [--verbose] [inputfileOdb] [outputfileFlatGraph]");
            System.err.println("Usage: convert -r [--verbose] [inputfileFlatGraph] [outputfileOdb]");
            System.err.println("Error: missing input and/or output file - exiting.");
            return;
        }
        if (reverse.elem) {
            Path path = (Path)srcFile.elem;
            Path path2 = (Path)dstFile.elem;
            boolean bl = verbose.elem;
            this.convertFlatgraphToOdb(path, path2, true, bl);
            return;
        }
        this.convertOdbToFlatgraph((Path)srcFile.elem, (Path)dstFile.elem, verbose.elem);
    }

    public void convertOdbToFlatgraph(Path overflowDbFile, Path outputFile, boolean verbose) {
        OdbStorage storage = OdbStorage.createWithSpecificLocation((File)overflowDbFile.toFile(), (StringInterner)new StringInterner());
        Convert.NodeStuff[] nodes = this.readOdb(storage);
        this.writeData(outputFile.toFile(), nodes, verbose);
    }

    public boolean convertOdbToFlatgraph$default$3() {
        return false;
    }

    public void convertFlatgraphToOdb(Path fgFile, Path outputFile, boolean debug, boolean verbose) {
        if (verbose) {
            Using$.MODULE$.apply(() -> Convert$.convertFlatgraphToOdb$$anonfun$1(fgFile), (Function1)(JProcedure1 & Serializable)channel -> {
                ujson.Value manifest = Deserialization$.MODULE$.readManifest(channel);
                Predef$.MODULE$.println((Object)manifest.render(2, manifest.render$default$2()));
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        Graph fg = Deserialization$.MODULE$.readGraph(fgFile, (Option)None$.MODULE$, false, Deserialization$.MODULE$.readGraph$default$4());
        File dst = outputFile.toFile();
        if (dst.exists()) {
            dst.delete();
        }
        dst.createNewFile();
        OdbStorage storage = OdbStorage.createWithSpecificLocation((File)dst, (StringInterner)new StringInterner());
        fg.allNodes().withFilter((Function1 & Serializable)node -> !AccessHelpers.isDeleted((GNode)node)).foreach((Function1)(JProcedure1 & Serializable)node -> {
            byte[] bytes = MODULE$.packNode((GNode)node, storage);
            if (debug) {
                HashMap legacyIdToNewId = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                LinkedHashMap byLabel = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                try {
                    MODULE$.readNode((HashMap<Object, Convert.NodeRefTmp>)legacyIdToNewId, node.id(), bytes, (LinkedHashMap<String, Convert.NodeStuff>)byLabel, storage);
                }
                catch (Throwable exc) {
                    Predef$.MODULE$.println((Object)new StringBuilder(35).append("Inconsistency encountered ").append(node.seq()).append(" / ").append(node.nodeKind).append(" / ").append(node.label()).append(" / ").append(node.id()).toString());
                    Predef$.MODULE$.println((Object)exc);
                    throw exc;
                }
            }
            storage.persist(node.id(), MODULE$.packNode((GNode)node, storage));
        });
        storage.close();
    }

    public boolean convertFlatgraphToOdb$default$3() {
        return false;
    }

    public boolean convertFlatgraphToOdb$default$4() {
        return false;
    }

    private void writeData(File filename, Convert.NodeStuff[] nodeStuff, boolean verbose) {
        File fileAbsolute = filename.getAbsoluteFile();
        AtomicLong filePtr = new AtomicLong(16L);
        if (!fileAbsolute.exists()) {
            fileAbsolute.getParentFile().mkdirs();
            fileAbsolute.createNewFile();
        }
        FileChannel fileChannel = new RandomAccessFile(fileAbsolute, "rw").getChannel();
        WriterContext writer = new WriterContext(fileChannel, Misc$.MODULE$.maybeOverrideExecutor((Option)None$.MODULE$));
        try {
            Object object = Predef$.MODULE$.refArrayOps((Object[])nodeStuff);
            Manifest.NodeItem[] nodes = (Manifest.NodeItem[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)ns -> new Manifest.NodeItem(ns.label(), ns.nextId(), (int[])null), ClassTag$.MODULE$.apply(Manifest.NodeItem.class));
            ArrayBuffer edges = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest.EdgeItem[0]));
            ArrayBuffer properties = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest.PropertyItem[0]));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])nodeStuff);
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)node -> node.quantities().iterator().withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    String prefix = (String)tuple2._1();
                    String key = (String)tuple2._2();
                    ArrayBuffer quantity = (ArrayBuffer)tuple22._2();
                    return true;
                }
                return false;
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                block10: {
                    block11: {
                        String string;
                        block16: {
                            Manifest.OutlineStorage values;
                            Manifest.OutlineStorage qty;
                            String key;
                            String prefix;
                            block13: {
                                String string2;
                                String string3;
                                block15: {
                                    block14: {
                                        String string4;
                                        String string5;
                                        block12: {
                                            Tuple2 tuple22;
                                            tuple2 = x$1;
                                            if (tuple2 == null || (tuple22 = (Tuple2)tuple2._1()) == null) break block10;
                                            prefix = (String)tuple22._1();
                                            key = (String)tuple22._2();
                                            ArrayBuffer quantity = (ArrayBuffer)tuple2._2();
                                            Tuple2<String, Object> tuple23 = MODULE$.homogenize((ArrayBuffer<Object>)((ArrayBuffer)node.values().apply((Object)Tuple2$.MODULE$.apply((Object)prefix, (Object)key))));
                                            if (tuple23 == null) {
                                                throw new MatchError(tuple23);
                                            }
                                            String valtyp = (String)tuple23._1();
                                            Object vals = tuple23._2();
                                            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)valtyp, vals);
                                            String valtyp2 = (String)tuple24._1();
                                            Object vals2 = tuple24._2();
                                            if (valtyp2 == null) break block11;
                                            int[] deltaEncoded = (int[])quantity.addOne((Object)BoxesRunTime.boxToInteger((int)0)).toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
                                            qty = writer.encodeAny((Object)deltaEncoded, writer.encodeAny$default$2(), writer.encodeAny$default$3());
                                            values = writer.encodeAny(vals2, writer.encodeAny$default$2(), writer.encodeAny$default$3());
                                            String string6 = values.typ();
                                            String string7 = valtyp2;
                                            if (string6 == null ? string7 != null : !string6.equals(string7)) {
                                                throw Scala3RunTime$.MODULE$.assertFailed();
                                            }
                                            string = prefix;
                                            String string8 = Convert$NodeStuff$.MODULE$.NODEPROPERTY();
                                            String string9 = string;
                                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                                properties.addOne((Object)new Manifest.PropertyItem(node.label(), key, qty, values));
                                                return;
                                            }
                                            string5 = Convert$NodeStuff$.MODULE$.NEIGHBOR_IN();
                                            string4 = string;
                                            if (string5 != null) break block12;
                                            if (string4 == null) break block13;
                                            break block14;
                                        }
                                        if (string5.equals(string4)) break block13;
                                    }
                                    string3 = Convert$NodeStuff$.MODULE$.NEIGHBOR_OUT();
                                    string2 = string;
                                    if (string3 != null) break block15;
                                    if (string2 == null) break block13;
                                    break block16;
                                }
                                if (!string3.equals(string2)) break block16;
                            }
                            String string10 = prefix;
                            String string11 = Convert$NodeStuff$.MODULE$.NEIGHBOR_IN();
                            byte inout = !(string10 != null ? !string10.equals(string11) : string11 != null) ? Edge.Direction$.Incoming.encoding() : Edge.Direction$.Outgoing.encoding();
                            Manifest.EdgeItem edgeItem = new Manifest.EdgeItem(node.label(), key, inout, qty, values, null);
                            edges.addOne((Object)edgeItem);
                            Option option = node.values().get((Object)Tuple2$.MODULE$.apply((Object)new StringBuilder(0).append(prefix).append(Convert$NodeStuff$.MODULE$.EDGEPROPERTY_SUFFIX()).toString(), (Object)key));
                            if (None$.MODULE$.equals(option)) {
                                return;
                            }
                            if (option instanceof Some) {
                                ArrayBuffer propvalues = (ArrayBuffer)((Some)option).value();
                                Tuple2<String, Object> tuple25 = MODULE$.homogenize((ArrayBuffer<Object>)propvalues);
                                if (tuple25 == null) {
                                    throw new MatchError(tuple25);
                                }
                                String ptype = (String)tuple25._1();
                                Object pval = tuple25._2();
                                Tuple2 tuple26 = Tuple2$.MODULE$.apply((Object)ptype, pval);
                                String ptype2 = (String)tuple26._1();
                                Object pval2 = tuple26._2();
                                if (ptype2 != null) {
                                    Manifest.OutlineStorage stored = writer.encodeAny(pval2, writer.encodeAny$default$2(), writer.encodeAny$default$3());
                                    edgeItem.property_$eq(stored);
                                    return;
                                }
                                return;
                            }
                            throw new MatchError((Object)option);
                        }
                        throw new MatchError((Object)string);
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            }));
            Manifest.GraphItem manifest = new Manifest.GraphItem(nodes, (Manifest.EdgeItem[])edges.toArray(ClassTag$.MODULE$.apply(Manifest.EdgeItem.class)), (Manifest.PropertyItem[])properties.toArray(ClassTag$.MODULE$.apply(Manifest.PropertyItem.class)), Manifest.GraphItem$.MODULE$.$lessinit$greater$default$4(), Manifest.GraphItem$.MODULE$.$lessinit$greater$default$5());
            writer.finish(manifest);
        }
        finally {
            fileChannel.close();
            writer.compressCtx().close();
        }
    }

    private boolean writeData$default$3() {
        return false;
    }

    private Tuple2<String, Object> homogenize(ArrayBuffer<Object> items) {
        Option option = items.find((Function1 & Serializable)_$1 -> _$1 != null);
        if (None$.MODULE$.equals(option)) {
            return Tuple2$.MODULE$.apply(null, null);
        }
        if (option instanceof Some) {
            Object object = ((Some)option).value();
            if (object instanceof Boolean) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Bool(), items.toArray(ClassTag$.MODULE$.apply(Boolean.TYPE)));
            }
            if (object instanceof Byte) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Byte(), items.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
            }
            if (object instanceof Short) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Short(), items.toArray(ClassTag$.MODULE$.apply(Short.TYPE)));
            }
            if (object instanceof Integer) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Int(), items.toArray(ClassTag$.MODULE$.apply(Integer.TYPE)));
            }
            if (object instanceof Long) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Long(), items.toArray(ClassTag$.MODULE$.apply(Long.TYPE)));
            }
            if (object instanceof Float) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Float(), items.toArray(ClassTag$.MODULE$.apply(Float.TYPE)));
            }
            if (object instanceof Double) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Double(), items.toArray(ClassTag$.MODULE$.apply(Double.TYPE)));
            }
            if (object instanceof String) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.String(), items.toArray(ClassTag$.MODULE$.apply(String.class)));
            }
            if (object instanceof Convert.NodeRefTmp) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Ref(), items.iterator().map((Function1 & Serializable)ref -> {
                    if (ref == null) {
                        return null;
                    }
                    return ref.newNode();
                }).toArray(ClassTag$.MODULE$.apply(GNode.class)));
            }
            Object other = object;
            throw new AssertionError((Object)new StringBuilder(37).append("unexpected item found: other of type ").append(other.getClass()).toString());
        }
        throw new MatchError((Object)option);
    }

    public byte[] packNode(GNode node, OdbStorage storage) {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        Graph graph = node.graph;
        Schema schema = graph.schema();
        packer.packLong(node.id());
        packer.packInt(storage.lookupOrCreateStringToIntMapping(schema.getNodeLabel(Short$.MODULE$.short2int(node.nodeKind))));
        IntRef nprops = IntRef.create((int)0);
        package$.MODULE$.Range().apply(0, schema.getNumberOfPropertyKinds()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)propertyId -> Accessors$.MODULE$.getNodeProperty(node, propertyId).nonEmpty()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)propertyId -> ++nprops$1.elem);
        packer.packMapHeader(nprops.elem);
        package$.MODULE$.Range().apply(0, schema.getNumberOfPropertyKinds()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)propertyId -> {
            ISeq values = Accessors$.MODULE$.getNodeProperty(graph, Short$.MODULE$.short2int(node$3.nodeKind), propertyId, node.seq());
            Object rawVals = graph.properties()[schema.propertyOffsetArrayIndex(Short$.MODULE$.short2int(node$3.nodeKind), propertyId) + 1];
            MODULE$.packProperty(rawVals, (ISeq<Object>)values, packer, storage.lookupOrCreateStringToIntMapping(schema.getPropertyLabel(Short$.MODULE$.short2int(node$3.nodeKind), propertyId)));
        });
        ((List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)1), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)0), (List)Nil$.MODULE$))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)inOut -> {
            IntRef edgeTypeCount = IntRef.create((int)0);
            package$.MODULE$.Range().apply(0, schema.getNumberOfEdgeKinds()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)edgeId -> {
                IndexedSeq edges;
                IndexedSeq indexedSeq = edges = inOut == 0 ? Accessors$.MODULE$.getEdgesIn(node, edgeId) : Accessors$.MODULE$.getEdgesOut(node, edgeId);
                if (edges.nonEmpty()) {
                    ++edgeTypeCount$1.elem;
                    return;
                }
            });
            packer.packInt(edgeTypeCount.elem);
            package$.MODULE$.Range().apply(0, schema.getNumberOfEdgeKinds()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)edgeId -> {
                IndexedSeq edges;
                IndexedSeq indexedSeq = edges = inOut == 0 ? Accessors$.MODULE$.getEdgesIn(node, edgeId) : Accessors$.MODULE$.getEdgesOut(node, edgeId);
                if (edges.nonEmpty()) {
                    packer.packInt(storage.lookupOrCreateStringToIntMapping(schema.getEdgeLabel(Short$.MODULE$.short2int(node$6.nodeKind), edgeId)));
                    packer.packInt(edges.size());
                    edges.foreach((Function1 & Serializable)edge -> {
                        packer.packLong(inOut == 0 ? edge.src().id() : edge.dst().id());
                        if (edge.property() != null) {
                            packer.packMapHeader(1);
                            packer.packInt(storage.lookupOrCreateStringToIntMapping(MODULE$.ANON_EDGE_PROPERTY()));
                            packer.packArrayHeader(2);
                            Object object = edge.property();
                            if (object instanceof Boolean) {
                                Boolean v = (Boolean)object;
                                packer.packByte(ValueTypes.BOOLEAN.id);
                                return packer.packBoolean(Predef$.MODULE$.Boolean2boolean(v));
                            }
                            if (object instanceof Byte) {
                                Byte v = (Byte)object;
                                packer.packByte(ValueTypes.BYTE.id);
                                return packer.packByte(Predef$.MODULE$.Byte2byte(v));
                            }
                            if (object instanceof Short) {
                                Short v = (Short)object;
                                packer.packByte(ValueTypes.SHORT.id);
                                return packer.packShort(Predef$.MODULE$.Short2short(v));
                            }
                            if (object instanceof Integer) {
                                Integer v = (Integer)object;
                                packer.packByte(ValueTypes.INTEGER.id);
                                return packer.packInt(Predef$.MODULE$.Integer2int(v));
                            }
                            if (object instanceof Long) {
                                Long v = (Long)object;
                                packer.packByte(ValueTypes.LONG.id);
                                return packer.packLong(Predef$.MODULE$.Long2long(v));
                            }
                            if (object instanceof Float) {
                                Float v = (Float)object;
                                packer.packByte(ValueTypes.FLOAT.id);
                                return packer.packFloat(Predef$.MODULE$.Float2float(v));
                            }
                            if (object instanceof Double) {
                                Double v = (Double)object;
                                packer.packByte(ValueTypes.DOUBLE.id);
                                return packer.packDouble(Predef$.MODULE$.Double2double(v));
                            }
                            if (object instanceof String) {
                                String v = (String)object;
                                packer.packByte(ValueTypes.STRING.id);
                                return packer.packString(v);
                            }
                            if (object instanceof GNode) {
                                GNode v = (GNode)object;
                                packer.packByte(ValueTypes.NODE_REF.id);
                                return packer.packLong(v.id());
                            }
                            throw new MatchError(object);
                        }
                        return packer.packMapHeader(0);
                    });
                    return;
                }
            });
        });
        return packer.toByteArray();
    }

    public void packProperty(Object rawVals, ISeq<Object> values, MessageBufferPacker packer, int storageId) {
        if (values.nonEmpty()) {
            packer.packInt(storageId);
            packer.packArrayHeader(2);
            Object object = rawVals;
            if (object == null) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
            if (object instanceof boolean[]) {
                ISeq<Object> vv = values;
                if (vv.size() == 1) {
                    packer.packByte(ValueTypes.BOOLEAN.id);
                    packer.packBoolean(BoxesRunTime.unboxToBoolean((Object)vv.head()));
                    return;
                }
                packer.packByte(ValueTypes.ARRAY_BOOL.id);
                packer.packArrayHeader(vv.size());
                vv.foreach((Function1 & Serializable)x$0 -> packer.packBoolean(BoxesRunTime.unboxToBoolean((Object)x$0)));
                return;
            }
            if (object instanceof byte[]) {
                ISeq<Object> vv = values;
                if (vv.size() == 1) {
                    packer.packByte(ValueTypes.BYTE.id);
                    packer.packByte(BoxesRunTime.unboxToByte((Object)vv.head()));
                    return;
                }
                packer.packByte(ValueTypes.ARRAY_BYTE.id);
                packer.packArrayHeader(vv.size());
                vv.foreach((Function1 & Serializable)x$0 -> packer.packByte(BoxesRunTime.unboxToByte((Object)x$0)));
                return;
            }
            if (object instanceof short[]) {
                ISeq<Object> vv = values;
                if (vv.size() == 1) {
                    packer.packByte(ValueTypes.SHORT.id);
                    packer.packShort(BoxesRunTime.unboxToShort((Object)vv.head()));
                    return;
                }
                packer.packByte(ValueTypes.ARRAY_SHORT.id);
                packer.packArrayHeader(vv.size());
                vv.foreach((Function1 & Serializable)x$0 -> packer.packShort(BoxesRunTime.unboxToShort((Object)x$0)));
                return;
            }
            if (object instanceof int[]) {
                ISeq<Object> vv = values;
                if (vv.size() == 1) {
                    packer.packByte(ValueTypes.INTEGER.id);
                    packer.packInt(BoxesRunTime.unboxToInt((Object)vv.head()));
                    return;
                }
                packer.packByte(ValueTypes.ARRAY_INT.id);
                packer.packArrayHeader(vv.size());
                vv.foreach((Function1 & Serializable)x$0 -> packer.packInt(BoxesRunTime.unboxToInt((Object)x$0)));
                return;
            }
            if (object instanceof long[]) {
                ISeq<Object> vv = values;
                if (vv.size() == 1) {
                    packer.packByte(ValueTypes.LONG.id);
                    packer.packLong(BoxesRunTime.unboxToLong((Object)vv.head()));
                    return;
                }
                packer.packByte(ValueTypes.ARRAY_LONG.id);
                packer.packArrayHeader(vv.size());
                vv.foreach((Function1 & Serializable)x$0 -> packer.packLong(BoxesRunTime.unboxToLong((Object)x$0)));
                return;
            }
            if (object instanceof float[]) {
                ISeq<Object> vv = values;
                if (vv.size() == 1) {
                    packer.packByte(ValueTypes.FLOAT.id);
                    packer.packFloat(BoxesRunTime.unboxToFloat((Object)vv.head()));
                    return;
                }
                packer.packByte(ValueTypes.ARRAY_FLOAT.id);
                packer.packArrayHeader(vv.size());
                vv.foreach((Function1 & Serializable)x$0 -> packer.packFloat(BoxesRunTime.unboxToFloat((Object)x$0)));
                return;
            }
            if (object instanceof double[]) {
                ISeq<Object> vv = values;
                if (vv.size() == 1) {
                    packer.packByte(ValueTypes.DOUBLE.id);
                    packer.packDouble(BoxesRunTime.unboxToDouble((Object)vv.head()));
                    return;
                }
                packer.packByte(ValueTypes.ARRAY_DOUBLE.id);
                packer.packArrayHeader(vv.size());
                vv.foreach((Function1 & Serializable)x$0 -> packer.packDouble(BoxesRunTime.unboxToDouble((Object)x$0)));
                return;
            }
            if (object instanceof String[] || object instanceof GNode[]) {
                if (values.size() == 1) {
                    this.packTypedRefValue(packer, values.head(), true);
                    return;
                }
                packer.packByte(ValueTypes.ARRAY_OBJECT.id);
                packer.packArrayHeader(values.size());
                values.foreach((Function1)(JProcedure1 & Serializable)_$2 -> MODULE$.packTypedRefValue(packer, _$2, false));
                return;
            }
            throw new MatchError(object);
        }
    }

    public void packTypedRefValue(MessageBufferPacker packer, Object v, boolean skipHeader) {
        Object object;
        if (!skipHeader) {
            packer.packArrayHeader(2);
        }
        if ((object = v) == null) {
            packer.packByte(ValueTypes.UNKNOWN.id);
            packer.packNil();
            return;
        }
        if (object instanceof String) {
            String str = (String)object;
            packer.packByte(ValueTypes.STRING.id);
            packer.packString(str);
            return;
        }
        if (object instanceof GNode) {
            GNode gn = (GNode)object;
            packer.packByte(ValueTypes.NODE_REF.id);
            packer.packLong(gn.id());
            return;
        }
        throw new MatchError(object);
    }

    public void readNode(HashMap<Object, Convert.NodeRefTmp> legacyIdToNewId, long legacyId, byte[] bytes, LinkedHashMap<String, Convert.NodeStuff> byLabel, OdbStorage storage) {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);
        long legacyId2 = unpacker.unpackLong();
        if (legacyId2 != legacyId) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        String label = storage.reverseLookupStringToIntMapping(unpacker.unpackInt());
        int sz = byLabel.size();
        Convert.NodeStuff nodeStuff = (Convert.NodeStuff)byLabel.getOrElseUpdate((Object)label, () -> Convert$.$anonfun$5(label, sz));
        Convert.NodeRefTmp ref = (Convert.NodeRefTmp)legacyIdToNewId.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)legacyId), () -> Convert$.$anonfun$6(legacyId));
        ref.newNode_$eq(new GNode(null, (short)nodeStuff.kind(), nodeStuff.nextId()));
        nodeStuff.nextId_$eq(nodeStuff.nextId() + 1);
        int nprops = unpacker.unpackMapHeader();
        package$.MODULE$.Range().apply(0, nprops).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            int n = x$1;
            String key = storage.reverseLookupStringToIntMapping(unpacker.unpackInt());
            this.unpackValue(legacyIdToNewId, (Value)unpacker.unpackValue().asArrayValue(), this.unpackValue$default$3(), this.unpackValue$default$4()).foreach((Function1)(JProcedure1 & Serializable)v -> nodeStuff.addX(Convert$NodeStuff$.MODULE$.NODEPROPERTY(), key, v, nodeStuff.addX$default$4(), nodeStuff.addX$default$5()));
        });
        ((List)new .colon.colon((Object)Convert$NodeStuff$.MODULE$.NEIGHBOR_OUT(), (List)new .colon.colon((Object)Convert$NodeStuff$.MODULE$.NEIGHBOR_IN(), (List)Nil$.MODULE$))).foreach((Function1)(JProcedure1 & Serializable)inout -> {
            int edgeTypeCount = unpacker.unpackInt();
            package$.MODULE$.Range().apply(0, edgeTypeCount).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> {
                int n = x$12;
                String key = storage.reverseLookupStringToIntMapping(unpacker.unpackInt());
                int edgeCount = unpacker.unpackInt();
                package$.MODULE$.Range().apply(0, edgeCount).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                    Tuple2 tuple2;
                    int n = x$1;
                    long adjacentId = unpacker.unpackLong();
                    Convert.NodeRefTmp adjacentNode = (Convert.NodeRefTmp)legacyIdToNewId.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)adjacentId), () -> Convert$.$anonfun$7(adjacentId));
                    int n2 = unpacker.unpackMapHeader();
                    if (0 == n2) {
                        tuple2 = Tuple2$.MODULE$.apply(null, null);
                    } else {
                        if (1 != n2) throw Predef$.MODULE$.$qmark$qmark$qmark();
                        String pkey = storage.reverseLookupStringToIntMapping(unpacker.unpackInt());
                        ArrayBuffer<Object> pvals = this.unpackValue(legacyIdToNewId, (Value)unpacker.unpackValue().asArrayValue(), this.unpackValue$default$3(), this.unpackValue$default$4());
                        if (pvals.length() == 0) {
                            tuple2 = Tuple2$.MODULE$.apply(null, null);
                        } else {
                            if (pvals.length() != 1) throw Predef$.MODULE$.$qmark$qmark$qmark();
                            tuple2 = Tuple2$.MODULE$.apply((Object)pkey, pvals.head());
                        }
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    String pkey = (String)tuple22._1();
                    Object pval = tuple22._2();
                    Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)pkey, pval);
                    String pkey2 = (String)tuple23._1();
                    Object pval2 = tuple23._2();
                    nodeStuff.addX((String)inout, key, adjacentNode, pkey2, pval2);
                });
            });
        });
    }

    private Convert.NodeStuff[] readOdb(OdbStorage storage) {
        HashMap legacyIdToNewId = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        LinkedHashMap byLabel = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        for (Map.Entry e : storage.allNodes()) {
            Long legacyId = (Long)e.getKey();
            byte[] bytes = (byte[])e.getValue();
            this.readNode((HashMap<Object, Convert.NodeRefTmp>)legacyIdToNewId, Predef$.MODULE$.Long2long(legacyId), bytes, (LinkedHashMap<String, Convert.NodeStuff>)byLabel, storage);
        }
        byLabel.valuesIterator().foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.pad());
        return (Convert.NodeStuff[])byLabel.valuesIterator().toArray(ClassTag$.MODULE$.apply(Convert.NodeStuff.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayBuffer<Object> unpackValue(HashMap<Object, Convert.NodeRefTmp> legacyIdToNewId, Value valueOrPair, ArrayBuffer<Object> res, Option<ValueTypes> typId) {
        ValueTypes valueTypes;
        ArrayBuffer arrayBuffer;
        Value v;
        ValueTypes typId_;
        block42: {
            ValueTypes valueTypes2;
            block53: {
                ValueTypes valueTypes3;
                ValueTypes valueTypes4;
                block52: {
                    block51: {
                        ValueTypes valueTypes5;
                        ValueTypes valueTypes6;
                        block50: {
                            block49: {
                                ValueTypes valueTypes7;
                                ValueTypes valueTypes8;
                                block48: {
                                    block47: {
                                        ValueTypes valueTypes9;
                                        ValueTypes valueTypes10;
                                        block46: {
                                            block45: {
                                                ValueTypes valueTypes11;
                                                ValueTypes valueTypes12;
                                                block44: {
                                                    block43: {
                                                        ValueTypes valueTypes13;
                                                        ValueTypes valueTypes14;
                                                        block41: {
                                                            block40: {
                                                                block37: {
                                                                    ValueTypes valueTypes15;
                                                                    ValueTypes valueTypes16;
                                                                    block39: {
                                                                        block38: {
                                                                            ValueTypes valueTypes17;
                                                                            ValueTypes valueTypes18;
                                                                            block36: {
                                                                                Tuple2 tuple2;
                                                                                Option<ValueTypes> option = typId;
                                                                                if (None$.MODULE$.equals(option)) {
                                                                                    Iterator iter = valueOrPair.asArrayValue().iterator();
                                                                                    byte first = ((Value)iter.next()).asIntegerValue().asByte();
                                                                                    Value remainder = (Value)iter.next();
                                                                                    tuple2 = Tuple2$.MODULE$.apply((Object)ValueTypes.lookup((byte)first), (Object)remainder);
                                                                                } else {
                                                                                    if (!(option instanceof Some)) throw new MatchError(option);
                                                                                    ValueTypes t = (ValueTypes)((Some)option).value();
                                                                                    tuple2 = Tuple2$.MODULE$.apply((Object)t, (Object)valueOrPair);
                                                                                }
                                                                                Tuple2 tuple22 = tuple2;
                                                                                typId_ = (ValueTypes)tuple22._1();
                                                                                v = (Value)tuple22._2();
                                                                                valueTypes2 = typId_;
                                                                                ValueTypes valueTypes19 = ValueTypes.UNKNOWN;
                                                                                ValueTypes valueTypes20 = valueTypes2;
                                                                                if (!(valueTypes19 != null ? !valueTypes19.equals(valueTypes20) : valueTypes20 != null)) {
                                                                                    arrayBuffer = res.addOne(null);
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes21 = ValueTypes.BOOLEAN;
                                                                                ValueTypes valueTypes22 = valueTypes2;
                                                                                if (!(valueTypes21 != null ? !valueTypes21.equals(valueTypes22) : valueTypes22 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToBoolean((boolean)v.asBooleanValue().getBoolean()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes23 = ValueTypes.BYTE;
                                                                                ValueTypes valueTypes24 = valueTypes2;
                                                                                if (!(valueTypes23 != null ? !valueTypes23.equals(valueTypes24) : valueTypes24 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToByte((byte)v.asIntegerValue().asByte()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes25 = ValueTypes.SHORT;
                                                                                ValueTypes valueTypes26 = valueTypes2;
                                                                                if (!(valueTypes25 != null ? !valueTypes25.equals(valueTypes26) : valueTypes26 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToShort((short)v.asIntegerValue().asShort()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes27 = ValueTypes.INTEGER;
                                                                                ValueTypes valueTypes28 = valueTypes2;
                                                                                if (!(valueTypes27 != null ? !valueTypes27.equals(valueTypes28) : valueTypes28 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToInteger((int)v.asIntegerValue().asInt()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes29 = ValueTypes.LONG;
                                                                                ValueTypes valueTypes30 = valueTypes2;
                                                                                if (!(valueTypes29 != null ? !valueTypes29.equals(valueTypes30) : valueTypes30 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToLong((long)v.asIntegerValue().asLong()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes31 = ValueTypes.FLOAT;
                                                                                ValueTypes valueTypes32 = valueTypes2;
                                                                                if (!(valueTypes31 != null ? !valueTypes31.equals(valueTypes32) : valueTypes32 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToFloat((float)v.asFloatValue().toFloat()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes33 = ValueTypes.DOUBLE;
                                                                                ValueTypes valueTypes34 = valueTypes2;
                                                                                if (!(valueTypes33 != null ? !valueTypes33.equals(valueTypes34) : valueTypes34 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToDouble((double)v.asFloatValue().toDouble()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes35 = ValueTypes.STRING;
                                                                                ValueTypes valueTypes36 = valueTypes2;
                                                                                if (!(valueTypes35 != null ? !valueTypes35.equals(valueTypes36) : valueTypes36 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)v.asStringValue().asString());
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes37 = ValueTypes.NODE_REF;
                                                                                ValueTypes valueTypes38 = valueTypes2;
                                                                                if (!(valueTypes37 != null ? !valueTypes37.equals(valueTypes38) : valueTypes38 != null)) {
                                                                                    Convert.NodeRefTmp nodeRefTmp;
                                                                                    long legacyId = v.asIntegerValue().asLong();
                                                                                    Option option2 = legacyIdToNewId.get((Object)BoxesRunTime.boxToLong((long)legacyId));
                                                                                    if (None$.MODULE$.equals(option2)) {
                                                                                        Convert.NodeRefTmp tmp = new Convert.NodeRefTmp(legacyId);
                                                                                        legacyIdToNewId.put((Object)BoxesRunTime.boxToLong((long)legacyId), (Object)tmp);
                                                                                        nodeRefTmp = tmp;
                                                                                    } else {
                                                                                        Convert.NodeRefTmp exists;
                                                                                        if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                                                                                        nodeRefTmp = exists = (Convert.NodeRefTmp)((Some)option2).value();
                                                                                    }
                                                                                    arrayBuffer = res.addOne((Object)nodeRefTmp);
                                                                                    return res;
                                                                                }
                                                                                valueTypes18 = ValueTypes.LIST;
                                                                                valueTypes17 = valueTypes2;
                                                                                if (valueTypes18 != null) break block36;
                                                                                if (valueTypes17 == null) break block37;
                                                                                break block38;
                                                                            }
                                                                            if (valueTypes18.equals(valueTypes17)) break block37;
                                                                        }
                                                                        valueTypes16 = ValueTypes.ARRAY_OBJECT;
                                                                        valueTypes15 = valueTypes2;
                                                                        if (valueTypes16 != null) break block39;
                                                                        if (valueTypes15 == null) break block37;
                                                                        break block40;
                                                                    }
                                                                    if (!valueTypes16.equals(valueTypes15)) break block40;
                                                                }
                                                                Iterator iter = v.asArrayValue().iterator();
                                                                while (iter.hasNext()) {
                                                                    this.unpackValue(legacyIdToNewId, (Value)((Value)iter.next()).asArrayValue(), res, this.unpackValue$default$4());
                                                                }
                                                                arrayBuffer = BoxedUnit.UNIT;
                                                                return res;
                                                            }
                                                            valueTypes14 = ValueTypes.ARRAY_BOOL;
                                                            valueTypes13 = valueTypes2;
                                                            if (valueTypes14 != null) break block41;
                                                            if (valueTypes13 == null) break block42;
                                                            break block43;
                                                        }
                                                        if (valueTypes14.equals(valueTypes13)) break block42;
                                                    }
                                                    valueTypes12 = ValueTypes.ARRAY_BYTE;
                                                    valueTypes11 = valueTypes2;
                                                    if (valueTypes12 != null) break block44;
                                                    if (valueTypes11 == null) break block42;
                                                    break block45;
                                                }
                                                if (valueTypes12.equals(valueTypes11)) break block42;
                                            }
                                            valueTypes10 = ValueTypes.ARRAY_SHORT;
                                            valueTypes9 = valueTypes2;
                                            if (valueTypes10 != null) break block46;
                                            if (valueTypes9 == null) break block42;
                                            break block47;
                                        }
                                        if (valueTypes10.equals(valueTypes9)) break block42;
                                    }
                                    valueTypes8 = ValueTypes.ARRAY_INT;
                                    valueTypes7 = valueTypes2;
                                    if (valueTypes8 != null) break block48;
                                    if (valueTypes7 == null) break block42;
                                    break block49;
                                }
                                if (valueTypes8.equals(valueTypes7)) break block42;
                            }
                            valueTypes6 = ValueTypes.ARRAY_LONG;
                            valueTypes5 = valueTypes2;
                            if (valueTypes6 != null) break block50;
                            if (valueTypes5 == null) break block42;
                            break block51;
                        }
                        if (valueTypes6.equals(valueTypes5)) break block42;
                    }
                    valueTypes4 = ValueTypes.ARRAY_FLOAT;
                    valueTypes3 = valueTypes2;
                    if (valueTypes4 != null) break block52;
                    if (valueTypes3 == null) break block42;
                    break block53;
                }
                if (valueTypes4.equals(valueTypes3)) break block42;
            }
            ValueTypes valueTypes39 = ValueTypes.ARRAY_DOUBLE;
            ValueTypes valueTypes40 = valueTypes2;
            if (valueTypes39 == null) {
                if (valueTypes40 != null) {
                    throw Predef$.MODULE$.$qmark$qmark$qmark();
                }
            } else if (!valueTypes39.equals(valueTypes40)) throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        ValueTypes valueTypes41 = typId_;
        ValueTypes valueTypes42 = ValueTypes.ARRAY_BOOL;
        ValueTypes valueTypes43 = valueTypes41;
        if (!(valueTypes42 != null ? !valueTypes42.equals(valueTypes43) : valueTypes43 != null)) {
            valueTypes = ValueTypes.BOOLEAN;
        } else {
            ValueTypes valueTypes44 = ValueTypes.ARRAY_BYTE;
            ValueTypes valueTypes45 = valueTypes41;
            if (!(valueTypes44 != null ? !valueTypes44.equals(valueTypes45) : valueTypes45 != null)) {
                valueTypes = ValueTypes.BYTE;
            } else {
                ValueTypes valueTypes46 = ValueTypes.ARRAY_SHORT;
                ValueTypes valueTypes47 = valueTypes41;
                if (!(valueTypes46 != null ? !valueTypes46.equals(valueTypes47) : valueTypes47 != null)) {
                    valueTypes = ValueTypes.SHORT;
                } else {
                    ValueTypes valueTypes48 = ValueTypes.ARRAY_INT;
                    ValueTypes valueTypes49 = valueTypes41;
                    if (!(valueTypes48 != null ? !valueTypes48.equals(valueTypes49) : valueTypes49 != null)) {
                        valueTypes = ValueTypes.INTEGER;
                    } else {
                        ValueTypes valueTypes50 = ValueTypes.ARRAY_LONG;
                        ValueTypes valueTypes51 = valueTypes41;
                        if (!(valueTypes50 != null ? !valueTypes50.equals(valueTypes51) : valueTypes51 != null)) {
                            valueTypes = ValueTypes.LONG;
                        } else {
                            ValueTypes valueTypes52 = ValueTypes.ARRAY_FLOAT;
                            ValueTypes valueTypes53 = valueTypes41;
                            if (!(valueTypes52 != null ? !valueTypes52.equals(valueTypes53) : valueTypes53 != null)) {
                                valueTypes = ValueTypes.FLOAT;
                            } else {
                                ValueTypes valueTypes54 = ValueTypes.ARRAY_DOUBLE;
                                ValueTypes valueTypes55 = valueTypes41;
                                if (valueTypes54 != null ? !valueTypes54.equals(valueTypes55) : valueTypes55 != null) throw Predef$.MODULE$.$qmark$qmark$qmark();
                                valueTypes = ValueTypes.DOUBLE;
                            }
                        }
                    }
                }
            }
        }
        ValueTypes elementType = valueTypes;
        Iterator iter = v.asArrayValue().iterator();
        while (iter.hasNext()) {
            this.unpackValue(legacyIdToNewId, (Value)((Value)iter.next()).asArrayValue(), res, (Option<ValueTypes>)Some$.MODULE$.apply((Object)elementType));
        }
        arrayBuffer = BoxedUnit.UNIT;
        return res;
    }

    public ArrayBuffer<Object> unpackValue$default$3() {
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public Option<ValueTypes> unpackValue$default$4() {
        return None$.MODULE$;
    }

    private static final FileChannel convertFlatgraphToOdb$$anonfun$1(Path fgFile$2) {
        return new RandomAccessFile(fgFile$2.toAbsolutePath().toFile(), "r").getChannel();
    }

    public static final ArrayBuffer flatgraph$convert$Convert$NodeStuff$$_$_$$anonfun$1() {
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[0]));
    }

    public static final ArrayBuffer flatgraph$convert$Convert$NodeStuff$$_$_$$anonfun$2() {
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public static final ArrayBuffer flatgraph$convert$Convert$NodeStuff$$_$_$$anonfun$3() {
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public static final /* synthetic */ boolean flatgraph$convert$Convert$NodeStuff$$_$pad$$anonfun$2(Tuple2 x$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x$1;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
            String prefix = (String)tuple2._1();
            String key = (String)tuple2._2();
            ArrayBuffer v = (ArrayBuffer)tuple22._2();
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean flatgraph$convert$Convert$NodeStuff$$_$pad$$anonfun$3(Tuple2 x$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x$1;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
            String prefix = (String)tuple2._1();
            String key = (String)tuple2._2();
            ArrayBuffer v = (ArrayBuffer)tuple22._2();
            return prefix.endsWith(Convert$NodeStuff$.MODULE$.EDGEPROPERTY_SUFFIX());
        }
        throw new MatchError((Object)tuple22);
    }

    private static final Convert.NodeStuff $anonfun$5(String label$1, int sz$1) {
        return new Convert.NodeStuff(label$1, sz$1);
    }

    private static final Convert.NodeRefTmp $anonfun$6(long legacyId$1) {
        return new Convert.NodeRefTmp(legacyId$1);
    }

    private static final Convert.NodeRefTmp $anonfun$7(long adjacentId$1) {
        return new Convert.NodeRefTmp(adjacentId$1);
    }
}

