/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.convert;

import flatgraph.Edge;
import flatgraph.convert.Convert;
import flatgraph.convert.Convert$NodeStuff$;
import flatgraph.storage.Manifest;
import flatgraph.storage.Serialization$;
import flatgraph.storage.package;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;
import overflowdb.storage.OdbStorage;
import overflowdb.storage.ValueTypes;
import overflowdb.util.StringInterner;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class Convert$
implements Serializable {
    public static final Convert$NodeStuff$ flatgraph$convert$Convert$$$NodeStuff;
    public static final Convert$ MODULE$;

    private Convert$() {
    }

    static {
        MODULE$ = new Convert$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Convert$.class);
    }

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: convert [inputfile] [outputfile]");
            System.err.println("Error: missing input and/or output file - exiting.");
            return;
        }
        this.apply(Paths.get(args[0], new String[0]), Paths.get(args[1], new String[0]));
    }

    public void apply(Path overflowDbFile, Path outputFile) {
        OdbStorage storage = OdbStorage.createWithSpecificLocation((File)overflowDbFile.toFile(), (StringInterner)new StringInterner());
        Tuple2<Convert.NodeStuff[], String[]> tuple2 = this.readOdb(storage);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Convert.NodeStuff[] nodes = (Convert.NodeStuff[])tuple2._1();
        String[] strings = (String[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)nodes, (Object)strings);
        Convert.NodeStuff[] nodes2 = (Convert.NodeStuff[])tuple22._1();
        String[] strings2 = (String[])tuple22._2();
        this.writeData(outputFile.toFile(), nodes2, strings2);
    }

    private void writeData(File filename, Convert.NodeStuff[] nodeStuff, String[] strings) {
        File fileAbsolute = filename.getAbsoluteFile();
        AtomicLong filePtr = new AtomicLong(16L);
        if (!fileAbsolute.exists()) {
            fileAbsolute.getParentFile().mkdirs();
            fileAbsolute.createNewFile();
        }
        try (FileChannel fileChannel = new RandomAccessFile(fileAbsolute, "rw").getChannel();){
            Object object = Predef$.MODULE$.refArrayOps((Object[])nodeStuff);
            Object[] nodes = (Manifest.NodeItem[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)ns -> new Manifest.NodeItem(ns.label(), ns.nextId(), (int[])null), ClassTag$.MODULE$.apply(Manifest.NodeItem.class));
            ArrayBuffer edges = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest.EdgeItem[0]));
            ArrayBuffer properties = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest.PropertyItem[0]));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])nodeStuff);
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)node -> node.quantities().iterator().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                block9: {
                    block10: {
                        String string;
                        block15: {
                            Manifest.OutlineStorage values;
                            Manifest.OutlineStorage qty;
                            String key;
                            String prefix;
                            block12: {
                                String string2;
                                String string3;
                                block14: {
                                    block13: {
                                        String string4;
                                        String string5;
                                        block11: {
                                            Tuple2 tuple22;
                                            tuple2 = x$1;
                                            if (tuple2 == null || (tuple22 = (Tuple2)tuple2._1()) == null) break block9;
                                            prefix = (String)tuple22._1();
                                            key = (String)tuple22._2();
                                            ArrayBuffer quantity = (ArrayBuffer)tuple2._2();
                                            int[] deltaEncoded = (int[])quantity.addOne((Object)BoxesRunTime.boxToInteger((int)0)).toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
                                            qty = Serialization$.MODULE$.encodeAny((Object)deltaEncoded, filePtr, null, fileChannel);
                                            Tuple2<String, Object> tuple23 = MODULE$.homogenize((ArrayBuffer<Object>)((ArrayBuffer)node.values().apply((Object)Tuple2$.MODULE$.apply((Object)prefix, (Object)key))));
                                            if (tuple23 == null) {
                                                throw new MatchError(tuple23);
                                            }
                                            String valtyp = (String)tuple23._1();
                                            Object vals = tuple23._2();
                                            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)valtyp, vals);
                                            String valtyp2 = (String)tuple24._1();
                                            Object vals2 = tuple24._2();
                                            if (valtyp2 == null) break block10;
                                            values = Serialization$.MODULE$.encodeAny(vals2, filePtr, null, fileChannel);
                                            values.typ_$eq(valtyp2);
                                            string = prefix;
                                            String string6 = Convert$NodeStuff$.MODULE$.NODEPROPERTY();
                                            String string7 = string;
                                            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                                properties.addOne((Object)new Manifest.PropertyItem(node.label(), key, qty, values));
                                                return;
                                            }
                                            string5 = Convert$NodeStuff$.MODULE$.NEIGHBOR_IN();
                                            string4 = string;
                                            if (string5 != null) break block11;
                                            if (string4 == null) break block12;
                                            break block13;
                                        }
                                        if (string5.equals(string4)) break block12;
                                    }
                                    string3 = Convert$NodeStuff$.MODULE$.NEIGHBOR_OUT();
                                    string2 = string;
                                    if (string3 != null) break block14;
                                    if (string2 == null) break block12;
                                    break block15;
                                }
                                if (!string3.equals(string2)) break block15;
                            }
                            String string8 = prefix;
                            String string9 = Convert$NodeStuff$.MODULE$.NEIGHBOR_IN();
                            byte inout = !(string8 != null ? !string8.equals(string9) : string9 != null) ? Edge.Direction$.Incoming.encoding() : Edge.Direction$.Outgoing.encoding();
                            Manifest.EdgeItem edgeItem = new Manifest.EdgeItem(node.label(), key, inout, qty, values, null);
                            edges.addOne((Object)edgeItem);
                            Option option = node.values().get((Object)Tuple2$.MODULE$.apply((Object)new StringBuilder(0).append(prefix).append(Convert$NodeStuff$.MODULE$.EDGEPROPERTY_SUFFIX()).toString(), (Object)key));
                            if (None$.MODULE$.equals(option)) {
                                return;
                            }
                            if (option instanceof Some) {
                                ArrayBuffer propvalues = (ArrayBuffer)((Some)option).value();
                                Tuple2<String, Object> tuple25 = MODULE$.homogenize((ArrayBuffer<Object>)propvalues);
                                if (tuple25 == null) {
                                    throw new MatchError(tuple25);
                                }
                                String ptype = (String)tuple25._1();
                                Object pval = tuple25._2();
                                Tuple2 tuple26 = Tuple2$.MODULE$.apply((Object)ptype, pval);
                                String ptype2 = (String)tuple26._1();
                                Object pval2 = tuple26._2();
                                if (ptype2 != null) {
                                    Manifest.OutlineStorage stored = Serialization$.MODULE$.encodeAny(pval2, filePtr, null, fileChannel);
                                    stored.typ_$eq(ptype2);
                                    edgeItem.property_$eq(stored);
                                    return;
                                }
                                return;
                            }
                            throw new MatchError((Object)option);
                        }
                        throw new MatchError((Object)string);
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            }));
            byte[] poolLenBytes = new byte[4 * strings.length];
            IntBuffer poolLenBuffer = ByteBuffer.wrap(poolLenBytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
            ByteArrayOutputStream poolBytes = new ByteArrayOutputStream();
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])strings);
            ArrayOps$.MODULE$.foreach$extension(object3, (Function1 & Serializable)s -> {
                byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
                poolBytes.write(bytes);
                return poolLenBuffer.put(bytes.length);
            });
            Manifest.OutlineStorage poolLensStored = new Manifest.OutlineStorage(package.StorageType$.MODULE$.Int());
            Manifest.OutlineStorage poolBytesStored = new Manifest.OutlineStorage(package.StorageType$.MODULE$.Byte());
            Serialization$.MODULE$.write(poolLenBytes, poolLensStored, filePtr, fileChannel);
            Serialization$.MODULE$.write(poolBytes.toByteArray(), poolBytesStored, filePtr, fileChannel);
            long pos = filePtr.get();
            byte[] header = new byte[16];
            ByteBuffer headerBuf = ByteBuffer.wrap(header);
            headerBuf.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().put(package.Keys$.MODULE$.Header()).put(pos);
            headerBuf.position(0);
            long headPos = 0L;
            while (headerBuf.hasRemaining()) {
                headPos += (long)fileChannel.write(headerBuf, headPos);
            }
            Object object4 = Predef$.MODULE$.refArrayOps(nodes);
            Manifest.GraphItem manifest = new Manifest.GraphItem((Manifest.NodeItem[])ArrayOps$.MODULE$.toArray$extension(object4, ClassTag$.MODULE$.apply(Manifest.NodeItem.class)), (Manifest.EdgeItem[])edges.toArray(ClassTag$.MODULE$.apply(Manifest.EdgeItem.class)), (Manifest.PropertyItem[])properties.toArray(ClassTag$.MODULE$.apply(Manifest.PropertyItem.class)), poolLensStored, poolBytesStored);
            ujson.Value manifestObj = Manifest.GraphItem$.MODULE$.write(manifest);
            ByteBuffer buf = ByteBuffer.wrap(manifestObj.render(manifestObj.render$default$1(), manifestObj.render$default$2()).getBytes(StandardCharsets.UTF_8));
            while (buf.hasRemaining()) {
                pos += (long)fileChannel.write(buf, pos);
            }
            fileChannel.truncate(pos);
        }
    }

    private Tuple2<String, Object> homogenize(ArrayBuffer<Object> items) {
        Option option = items.find((Function1 & Serializable)_$1 -> _$1 != null);
        if (None$.MODULE$.equals(option)) {
            return Tuple2$.MODULE$.apply(null, null);
        }
        if (option instanceof Some) {
            Object object = ((Some)option).value();
            if (object instanceof Boolean) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Bool(), items.toArray(ClassTag$.MODULE$.apply(Boolean.TYPE)));
            }
            if (object instanceof Byte) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Byte(), items.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
            }
            if (object instanceof Short) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Short(), items.toArray(ClassTag$.MODULE$.apply(Short.TYPE)));
            }
            if (object instanceof Integer) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Int(), items.toArray(ClassTag$.MODULE$.apply(Integer.TYPE)));
            }
            if (object instanceof Long) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Long(), items.toArray(ClassTag$.MODULE$.apply(Long.TYPE)));
            }
            if (object instanceof Float) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Float(), items.toArray(ClassTag$.MODULE$.apply(Float.TYPE)));
            }
            if (object instanceof Double) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Double(), items.toArray(ClassTag$.MODULE$.apply(Double.TYPE)));
            }
            if (object instanceof Convert.StringRef) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.String(), ((IterableOnceOps)items.map((Function1 & Serializable)ref -> {
                    if (ref == null) {
                        return -1;
                    }
                    return ref.idx();
                })).toArray(ClassTag$.MODULE$.apply(Integer.TYPE)));
            }
            if (object instanceof Convert.NodeRefTmp) {
                return Tuple2$.MODULE$.apply((Object)package.StorageType$.MODULE$.Ref(), ((IterableOnceOps)items.map((Function1 & Serializable)ref -> {
                    if (ref == null) {
                        return 0xFFFFFFFFFFFFL;
                    }
                    return ref.newId();
                })).toArray(ClassTag$.MODULE$.apply(Long.TYPE)));
            }
            Object other = object;
            throw new AssertionError((Object)new StringBuilder(32).append("unexpected item found: ").append(other).append(" of type ").append(other.getClass()).toString());
        }
        throw new MatchError((Object)option);
    }

    private Tuple2<Convert.NodeStuff[], String[]> readOdb(OdbStorage storage) {
        HashMap legacyIdToNewId = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        LinkedHashMap stringInterner = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        LinkedHashMap byLabel = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        for (Map.Entry e : storage.allNodes()) {
            Long legacyId = (Long)e.getKey();
            byte[] bytes = (byte[])e.getValue();
            MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);
            long legacyId2 = unpacker.unpackLong();
            if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)legacyId2), (Object)legacyId)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            String label = storage.reverseLookupStringToIntMapping(unpacker.unpackInt());
            int sz = byLabel.size();
            Convert.NodeStuff nodeStuff = (Convert.NodeStuff)byLabel.getOrElseUpdate((Object)label, () -> Convert$.$anonfun$5(label, sz));
            Convert.NodeRefTmp ref = (Convert.NodeRefTmp)legacyIdToNewId.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(legacyId)), () -> Convert$.$anonfun$6(legacyId));
            ref.newId_$eq((long)nodeStuff.nextId() + ((long)nodeStuff.kind() << 32));
            nodeStuff.nextId_$eq(nodeStuff.nextId() + 1);
            nodeStuff.addX(Convert$NodeStuff$.MODULE$.NODEPROPERTY(), Convert$NodeStuff$.MODULE$.legacyId(), legacyId, nodeStuff.addX$default$4(), nodeStuff.addX$default$5());
            package$.MODULE$.Range().apply(0, unpacker.unpackMapHeader()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                int n = x$1;
                String key = storage.reverseLookupStringToIntMapping(unpacker.unpackInt());
                this.unpackValue$1(stringInterner, legacyIdToNewId, (Value)unpacker.unpackValue().asArrayValue(), this.unpackValue$default$2$1(), this.unpackValue$default$3$1()).foreach((Function1)(JProcedure1 & Serializable)v -> nodeStuff.addX(Convert$NodeStuff$.MODULE$.NODEPROPERTY(), key, v, nodeStuff.addX$default$4(), nodeStuff.addX$default$5()));
            });
            ((List)new .colon.colon((Object)Convert$NodeStuff$.MODULE$.NEIGHBOR_OUT(), (List)new .colon.colon((Object)Convert$NodeStuff$.MODULE$.NEIGHBOR_IN(), (List)Nil$.MODULE$))).foreach((Function1)(JProcedure1 & Serializable)inout -> {
                int edgeTypeCount = unpacker.unpackInt();
                package$.MODULE$.Range().apply(0, edgeTypeCount).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> {
                    int n = x$12;
                    String key = storage.reverseLookupStringToIntMapping(unpacker.unpackInt());
                    int edgeCount = unpacker.unpackInt();
                    package$.MODULE$.Range().apply(0, edgeCount).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                        Tuple2 tuple2;
                        int n = x$1;
                        long adjacentId = unpacker.unpackLong();
                        Convert.NodeRefTmp adjacentNode = (Convert.NodeRefTmp)legacyIdToNewId.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)adjacentId), () -> Convert$.$anonfun$7(adjacentId));
                        int n2 = unpacker.unpackMapHeader();
                        if (0 == n2) {
                            tuple2 = Tuple2$.MODULE$.apply(null, null);
                        } else {
                            if (1 != n2) throw Predef$.MODULE$.$qmark$qmark$qmark();
                            String pkey = storage.reverseLookupStringToIntMapping(unpacker.unpackInt());
                            ArrayBuffer pvals = this.unpackValue$1(stringInterner, legacyIdToNewId, (Value)unpacker.unpackValue().asArrayValue(), this.unpackValue$default$2$1(), this.unpackValue$default$3$1());
                            if (pvals.length() == 0) {
                                tuple2 = Tuple2$.MODULE$.apply(null, null);
                            } else {
                                if (pvals.length() != 1) throw Predef$.MODULE$.$qmark$qmark$qmark();
                                tuple2 = Tuple2$.MODULE$.apply((Object)pkey, pvals.head());
                            }
                        }
                        Tuple2 tuple22 = tuple2;
                        if (tuple22 == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        String pkey = (String)tuple22._1();
                        Object pval = tuple22._2();
                        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)pkey, pval);
                        String pkey2 = (String)tuple23._1();
                        Object pval2 = tuple23._2();
                        nodeStuff.addX((String)inout, key, adjacentNode, pkey2, pval2);
                    });
                });
            });
        }
        byLabel.valuesIterator().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.pad());
        return Tuple2$.MODULE$.apply(byLabel.valuesIterator().toArray(ClassTag$.MODULE$.apply(Convert.NodeStuff.class)), stringInterner.keysIterator().toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public static final ArrayBuffer flatgraph$convert$Convert$NodeStuff$$_$_$$anonfun$1() {
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[0]));
    }

    public static final ArrayBuffer flatgraph$convert$Convert$NodeStuff$$_$_$$anonfun$2() {
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public static final ArrayBuffer flatgraph$convert$Convert$NodeStuff$$_$_$$anonfun$3() {
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public static final /* synthetic */ boolean flatgraph$convert$Convert$NodeStuff$$_$pad$$anonfun$2(Tuple2 x$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x$1;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
            String prefix = (String)tuple2._1();
            String key = (String)tuple2._2();
            ArrayBuffer v = (ArrayBuffer)tuple22._2();
            return prefix.endsWith(Convert$NodeStuff$.MODULE$.EDGEPROPERTY_SUFFIX());
        }
        throw new MatchError((Object)tuple22);
    }

    private static final Convert.NodeStuff $anonfun$5(String label$1, int sz$1) {
        return new Convert.NodeStuff(label$1, sz$1);
    }

    private static final Convert.NodeRefTmp $anonfun$6(Long legacyId$1) {
        return new Convert.NodeRefTmp(Predef$.MODULE$.Long2long(legacyId$1));
    }

    private static final Convert.NodeRefTmp $anonfun$7(long adjacentId$1) {
        return new Convert.NodeRefTmp(adjacentId$1);
    }

    private static final Convert.StringRef unpackValue$1$$anonfun$1(LinkedHashMap stringInterner$6, String s$1) {
        return new Convert.StringRef(stringInterner$6.size(), s$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ArrayBuffer unpackValue$1(LinkedHashMap stringInterner$5, HashMap legacyIdToNewId$5, Value valueOrPair, ArrayBuffer res, Option typId) {
        ValueTypes valueTypes;
        ArrayBuffer arrayBuffer;
        Value v;
        ValueTypes typId_;
        block42: {
            ValueTypes valueTypes2;
            block53: {
                ValueTypes valueTypes3;
                ValueTypes valueTypes4;
                block52: {
                    block51: {
                        ValueTypes valueTypes5;
                        ValueTypes valueTypes6;
                        block50: {
                            block49: {
                                ValueTypes valueTypes7;
                                ValueTypes valueTypes8;
                                block48: {
                                    block47: {
                                        ValueTypes valueTypes9;
                                        ValueTypes valueTypes10;
                                        block46: {
                                            block45: {
                                                ValueTypes valueTypes11;
                                                ValueTypes valueTypes12;
                                                block44: {
                                                    block43: {
                                                        ValueTypes valueTypes13;
                                                        ValueTypes valueTypes14;
                                                        block41: {
                                                            block40: {
                                                                block37: {
                                                                    ValueTypes valueTypes15;
                                                                    ValueTypes valueTypes16;
                                                                    block39: {
                                                                        block38: {
                                                                            ValueTypes valueTypes17;
                                                                            ValueTypes valueTypes18;
                                                                            block36: {
                                                                                Tuple2 tuple2;
                                                                                Option option = typId;
                                                                                if (None$.MODULE$.equals(option)) {
                                                                                    Iterator iter = valueOrPair.asArrayValue().iterator();
                                                                                    tuple2 = Tuple2$.MODULE$.apply((Object)ValueTypes.lookup((byte)((Value)iter.next()).asIntegerValue().asByte()), iter.next());
                                                                                } else {
                                                                                    if (!(option instanceof Some)) throw new MatchError((Object)option);
                                                                                    ValueTypes t = (ValueTypes)((Some)option).value();
                                                                                    tuple2 = Tuple2$.MODULE$.apply((Object)t, (Object)valueOrPair);
                                                                                }
                                                                                Tuple2 tuple22 = tuple2;
                                                                                typId_ = (ValueTypes)tuple22._1();
                                                                                v = (Value)tuple22._2();
                                                                                valueTypes2 = typId_;
                                                                                ValueTypes valueTypes19 = ValueTypes.UNKNOWN;
                                                                                ValueTypes valueTypes20 = valueTypes2;
                                                                                if (!(valueTypes19 != null ? !valueTypes19.equals(valueTypes20) : valueTypes20 != null)) {
                                                                                    arrayBuffer = res.addOne(null);
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes21 = ValueTypes.BOOLEAN;
                                                                                ValueTypes valueTypes22 = valueTypes2;
                                                                                if (!(valueTypes21 != null ? !valueTypes21.equals(valueTypes22) : valueTypes22 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToBoolean((boolean)v.asBooleanValue().getBoolean()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes23 = ValueTypes.BYTE;
                                                                                ValueTypes valueTypes24 = valueTypes2;
                                                                                if (!(valueTypes23 != null ? !valueTypes23.equals(valueTypes24) : valueTypes24 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToByte((byte)v.asIntegerValue().asByte()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes25 = ValueTypes.SHORT;
                                                                                ValueTypes valueTypes26 = valueTypes2;
                                                                                if (!(valueTypes25 != null ? !valueTypes25.equals(valueTypes26) : valueTypes26 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToShort((short)v.asIntegerValue().asShort()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes27 = ValueTypes.INTEGER;
                                                                                ValueTypes valueTypes28 = valueTypes2;
                                                                                if (!(valueTypes27 != null ? !valueTypes27.equals(valueTypes28) : valueTypes28 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToInteger((int)v.asIntegerValue().asInt()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes29 = ValueTypes.LONG;
                                                                                ValueTypes valueTypes30 = valueTypes2;
                                                                                if (!(valueTypes29 != null ? !valueTypes29.equals(valueTypes30) : valueTypes30 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToLong((long)v.asIntegerValue().asLong()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes31 = ValueTypes.FLOAT;
                                                                                ValueTypes valueTypes32 = valueTypes2;
                                                                                if (!(valueTypes31 != null ? !valueTypes31.equals(valueTypes32) : valueTypes32 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToFloat((float)v.asFloatValue().toFloat()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes33 = ValueTypes.DOUBLE;
                                                                                ValueTypes valueTypes34 = valueTypes2;
                                                                                if (!(valueTypes33 != null ? !valueTypes33.equals(valueTypes34) : valueTypes34 != null)) {
                                                                                    arrayBuffer = res.addOne((Object)BoxesRunTime.boxToDouble((double)v.asFloatValue().toDouble()));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes35 = ValueTypes.STRING;
                                                                                ValueTypes valueTypes36 = valueTypes2;
                                                                                if (!(valueTypes35 != null ? !valueTypes35.equals(valueTypes36) : valueTypes36 != null)) {
                                                                                    String s = v.asStringValue().asString();
                                                                                    arrayBuffer = res.addOne(stringInterner$5.getOrElseUpdate((Object)s, () -> Convert$.unpackValue$1$$anonfun$1(stringInterner$5, s)));
                                                                                    return res;
                                                                                }
                                                                                ValueTypes valueTypes37 = ValueTypes.NODE_REF;
                                                                                ValueTypes valueTypes38 = valueTypes2;
                                                                                if (!(valueTypes37 != null ? !valueTypes37.equals(valueTypes38) : valueTypes38 != null)) {
                                                                                    Option option2;
                                                                                    long legacyId = v.asIntegerValue().asLong();
                                                                                    Option option3 = legacyIdToNewId$5.get((Object)BoxesRunTime.boxToLong((long)legacyId));
                                                                                    if (option3 == null) {
                                                                                        Convert.NodeRefTmp tmp = new Convert.NodeRefTmp(legacyId);
                                                                                        legacyIdToNewId$5.put((Object)BoxesRunTime.boxToLong((long)legacyId), (Object)tmp);
                                                                                        option2 = res;
                                                                                    } else {
                                                                                        Option exists;
                                                                                        option2 = exists = option3;
                                                                                    }
                                                                                    arrayBuffer = res.addOne((Object)option2);
                                                                                    return res;
                                                                                }
                                                                                valueTypes18 = ValueTypes.LIST;
                                                                                valueTypes17 = valueTypes2;
                                                                                if (valueTypes18 != null) break block36;
                                                                                if (valueTypes17 == null) break block37;
                                                                                break block38;
                                                                            }
                                                                            if (valueTypes18.equals(valueTypes17)) break block37;
                                                                        }
                                                                        valueTypes16 = ValueTypes.ARRAY_OBJECT;
                                                                        valueTypes15 = valueTypes2;
                                                                        if (valueTypes16 != null) break block39;
                                                                        if (valueTypes15 == null) break block37;
                                                                        break block40;
                                                                    }
                                                                    if (!valueTypes16.equals(valueTypes15)) break block40;
                                                                }
                                                                Iterator iter = v.asArrayValue().iterator();
                                                                while (iter.hasNext()) {
                                                                    this.unpackValue$1(stringInterner$5, legacyIdToNewId$5, (Value)((Value)iter.next()).asArrayValue(), res, this.unpackValue$default$3$1());
                                                                }
                                                                arrayBuffer = BoxedUnit.UNIT;
                                                                return res;
                                                            }
                                                            valueTypes14 = ValueTypes.ARRAY_BOOL;
                                                            valueTypes13 = valueTypes2;
                                                            if (valueTypes14 != null) break block41;
                                                            if (valueTypes13 == null) break block42;
                                                            break block43;
                                                        }
                                                        if (valueTypes14.equals(valueTypes13)) break block42;
                                                    }
                                                    valueTypes12 = ValueTypes.ARRAY_BYTE;
                                                    valueTypes11 = valueTypes2;
                                                    if (valueTypes12 != null) break block44;
                                                    if (valueTypes11 == null) break block42;
                                                    break block45;
                                                }
                                                if (valueTypes12.equals(valueTypes11)) break block42;
                                            }
                                            valueTypes10 = ValueTypes.ARRAY_SHORT;
                                            valueTypes9 = valueTypes2;
                                            if (valueTypes10 != null) break block46;
                                            if (valueTypes9 == null) break block42;
                                            break block47;
                                        }
                                        if (valueTypes10.equals(valueTypes9)) break block42;
                                    }
                                    valueTypes8 = ValueTypes.ARRAY_INT;
                                    valueTypes7 = valueTypes2;
                                    if (valueTypes8 != null) break block48;
                                    if (valueTypes7 == null) break block42;
                                    break block49;
                                }
                                if (valueTypes8.equals(valueTypes7)) break block42;
                            }
                            valueTypes6 = ValueTypes.ARRAY_LONG;
                            valueTypes5 = valueTypes2;
                            if (valueTypes6 != null) break block50;
                            if (valueTypes5 == null) break block42;
                            break block51;
                        }
                        if (valueTypes6.equals(valueTypes5)) break block42;
                    }
                    valueTypes4 = ValueTypes.ARRAY_FLOAT;
                    valueTypes3 = valueTypes2;
                    if (valueTypes4 != null) break block52;
                    if (valueTypes3 == null) break block42;
                    break block53;
                }
                if (valueTypes4.equals(valueTypes3)) break block42;
            }
            ValueTypes valueTypes39 = ValueTypes.ARRAY_DOUBLE;
            ValueTypes valueTypes40 = valueTypes2;
            if (valueTypes39 == null) {
                if (valueTypes40 != null) {
                    throw Predef$.MODULE$.$qmark$qmark$qmark();
                }
            } else if (!valueTypes39.equals(valueTypes40)) throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        ValueTypes valueTypes41 = typId_;
        ValueTypes valueTypes42 = ValueTypes.ARRAY_BOOL;
        ValueTypes valueTypes43 = valueTypes41;
        if (!(valueTypes42 != null ? !valueTypes42.equals(valueTypes43) : valueTypes43 != null)) {
            valueTypes = ValueTypes.BOOLEAN;
        } else {
            ValueTypes valueTypes44 = ValueTypes.ARRAY_BYTE;
            ValueTypes valueTypes45 = valueTypes41;
            if (!(valueTypes44 != null ? !valueTypes44.equals(valueTypes45) : valueTypes45 != null)) {
                valueTypes = ValueTypes.BYTE;
            } else {
                ValueTypes valueTypes46 = ValueTypes.ARRAY_SHORT;
                ValueTypes valueTypes47 = valueTypes41;
                if (!(valueTypes46 != null ? !valueTypes46.equals(valueTypes47) : valueTypes47 != null)) {
                    valueTypes = ValueTypes.SHORT;
                } else {
                    ValueTypes valueTypes48 = ValueTypes.ARRAY_INT;
                    ValueTypes valueTypes49 = valueTypes41;
                    if (!(valueTypes48 != null ? !valueTypes48.equals(valueTypes49) : valueTypes49 != null)) {
                        valueTypes = ValueTypes.INTEGER;
                    } else {
                        ValueTypes valueTypes50 = ValueTypes.ARRAY_LONG;
                        ValueTypes valueTypes51 = valueTypes41;
                        if (!(valueTypes50 != null ? !valueTypes50.equals(valueTypes51) : valueTypes51 != null)) {
                            valueTypes = ValueTypes.LONG;
                        } else {
                            ValueTypes valueTypes52 = ValueTypes.ARRAY_FLOAT;
                            ValueTypes valueTypes53 = valueTypes41;
                            if (!(valueTypes52 != null ? !valueTypes52.equals(valueTypes53) : valueTypes53 != null)) {
                                valueTypes = ValueTypes.FLOAT;
                            } else {
                                ValueTypes valueTypes54 = ValueTypes.ARRAY_DOUBLE;
                                ValueTypes valueTypes55 = valueTypes41;
                                if (valueTypes54 != null ? !valueTypes54.equals(valueTypes55) : valueTypes55 != null) throw Predef$.MODULE$.$qmark$qmark$qmark();
                                valueTypes = ValueTypes.DOUBLE;
                            }
                        }
                    }
                }
            }
        }
        ValueTypes elementType = valueTypes;
        Iterator iter = v.asArrayValue().iterator();
        while (iter.hasNext()) {
            this.unpackValue$1(stringInterner$5, legacyIdToNewId$5, (Value)((Value)iter.next()).asArrayValue(), res, (Option)Some$.MODULE$.apply((Object)elementType));
        }
        arrayBuffer = BoxedUnit.UNIT;
        return res;
    }

    private final ArrayBuffer unpackValue$default$2$1() {
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private final Option unpackValue$default$3$1() {
        return None$.MODULE$;
    }
}

