/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.formats.graphml;

import flatgraph.DNode;
import flatgraph.DNodeOrNode;
import flatgraph.DefaultValue$;
import flatgraph.DiffGraphApplier$;
import flatgraph.DiffGraphBuilder;
import flatgraph.DiffGraphBuilder$;
import flatgraph.GNode;
import flatgraph.GenericDNode;
import flatgraph.GenericDNode$;
import flatgraph.Graph;
import flatgraph.formats.Importer;
import flatgraph.formats.graphml.package;
import flatgraph.formats.graphml.package$;
import flatgraph.formats.graphml.package$PropertyContext$;
import flatgraph.formats.graphml.package$Type$;
import flatgraph.misc.Conversions$;
import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public final class GraphMLImporter$
implements Importer,
Serializable {
    private static Logger logger;
    public static final GraphMLImporter$ MODULE$;

    private GraphMLImporter$() {
    }

    static {
        MODULE$ = new GraphMLImporter$();
        Importer.$init$(MODULE$);
        Statics.releaseFence();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void flatgraph$formats$Importer$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GraphMLImporter$.class);
    }

    @Override
    public void runImport(Graph graph, Seq<Path> inputFiles) {
        if (inputFiles.size() != 1) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(40).append("input must be exactly one file, but got ").append(inputFiles.size()).toString());
        }
        Elem doc = (Elem)XML$.MODULE$.loadFile(((Path)inputFiles.head()).toFile());
        NodeSeq graphXml = doc.$bslash("graph");
        NodeSeq graphmlNodes = graphXml.$bslash("node");
        Map<String, GNode> graphmlNodeIdToGNode = this.addNodesRaw((Seq<Node>)graphmlNodes, graph);
        NodeSeq keyEntries = doc.$bslash("key");
        DiffGraphBuilder diffGraph = new DiffGraphBuilder(graph.schema(), DiffGraphBuilder$.MODULE$.$lessinit$greater$default$2());
        Map<String, package.PropertyContext> nodePropertyContextById = this.parsePropertyEntries("node", keyEntries);
        ((IterableOnceOps)graphmlNodes.map((Function1 & Serializable)graphmlNode -> {
            String nodeId = graphmlNode.$bslash$at("id");
            return Tuple2$.MODULE$.apply(graphmlNode, (Object)nodeId);
        })).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Node graphmlNode = (Node)tuple2._1();
                String nodeId = (String)tuple2._2();
                graphmlNode.$bslash("data").foreach((Function1 & Serializable)entry -> {
                    String string = entry.$bslash$at("key");
                    String string2 = package$.MODULE$.KeyForNodeLabel();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return BoxedUnit.UNIT;
                    }
                    String key = string;
                    package.PropertyContext propertyContext = (package.PropertyContext)nodePropertyContextById.get((Object)key).getOrElse(() -> GraphMLImporter$.$anonfun$1(key));
                    String value = entry.text();
                    Object convertedValue = MODULE$.convertValue(value, propertyContext.tpe(), graphmlNode);
                    return diffGraph.setNodeProperty((GNode)graphmlNodeIdToGNode.apply((Object)nodeId), propertyContext.name(), convertedValue);
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Map<String, package.PropertyContext> edgePropertyContextById = this.parsePropertyEntries("edge", keyEntries);
        graphXml.$bslash("edge").foreach((Function1)(JProcedure1 & Serializable)edge -> MODULE$.addEdge(diffGraph, graphmlNodeIdToGNode, (Node)edge, edgePropertyContextById));
        DiffGraphApplier$.MODULE$.applyDiff(graph, diffGraph, DiffGraphApplier$.MODULE$.applyDiff$default$3(), DiffGraphApplier$.MODULE$.applyDiff$default$4());
    }

    private Map<String, GNode> addNodesRaw(Seq<Node> graphmlNodes, Graph graph) {
        DiffGraphBuilder diffGraphForRawNodes = new DiffGraphBuilder(graph.schema(), DiffGraphBuilder$.MODULE$.$lessinit$greater$default$2());
        scala.collection.mutable.Map graphmlNodeIdToGNode = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        graphmlNodes.foreach((Function1 & Serializable)graphmlNode -> {
            String id = graphmlNode.$bslash$at("id");
            String label = (String)graphmlNode.$bslash("data").find((Function1 & Serializable)_$1 -> {
                String string = _$1.$bslash$at("key");
                String string2 = package$.MODULE$.KeyForNodeLabel();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).map((Function1 & Serializable)_$2 -> _$2.text()).getOrElse(() -> GraphMLImporter$.$anonfun$4(graphmlNode));
            int nodeKind = BoxesRunTime.unboxToInt((Object)graph.schema().getNodeKindByLabelMaybe(label).getOrElse(() -> GraphMLImporter$.$anonfun$5(label, graph)));
            GenericDNode newNode = new GenericDNode(Conversions$.MODULE$.toShortSafely(graph.schema().getNodeKindByLabel(label)), GenericDNode$.MODULE$.$lessinit$greater$default$2());
            diffGraphForRawNodes.addNode((DNode)newNode);
            return graphmlNodeIdToGNode.put((Object)id, (Object)newNode);
        });
        DiffGraphApplier$.MODULE$.applyDiff(graph, diffGraphForRawNodes, DiffGraphApplier$.MODULE$.applyDiff$default$3(), DiffGraphApplier$.MODULE$.applyDiff$default$4());
        return graphmlNodeIdToGNode.view().mapValues((Function1 & Serializable)_$3 -> (GNode)_$3.storedRef().get()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, package.PropertyContext> parsePropertyEntries(String forElementType, NodeSeq keyEntries) {
        return ((IterableOnceOps)((StrictOptimizedIterableOps)keyEntries.filter((Function1 & Serializable)_$4 -> {
            String string = _$4.$bslash$at("for");
            String string2 = forElementType;
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).map((Function1 & Serializable)node -> {
            String id = node.$bslash$at("id");
            String name = node.$bslash$at("attr.name");
            String graphmlType = node.$bslash$at("attr.type");
            return Tuple2$.MODULE$.apply((Object)id, (Object)package$PropertyContext$.MODULE$.apply(name, package$Type$.MODULE$.withName(graphmlType)));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void addEdge(DiffGraphBuilder diffGraph, Map<String, GNode> graphmlNodeIdToGNode, Node edge, Map<String, package.PropertyContext> propertyContextById) {
        String sourceId = edge.$bslash$at("source");
        String targetId = edge.$bslash$at("target");
        ObjectRef label = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef edgePropertyMaybe = ObjectRef.create((Object)None$.MODULE$);
        edge.$bslash("data").foreach((Function1)(JProcedure1 & Serializable)entry -> {
            String value = entry.text();
            String string = entry.$bslash$at("key");
            String string2 = package$.MODULE$.KeyForEdgeLabel();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                label$2.elem = Option$.MODULE$.apply((Object)value);
                return;
            }
            String key = string;
            package.PropertyContext propertyContext = (package.PropertyContext)propertyContextById.get((Object)key).getOrElse(() -> GraphMLImporter$.$anonfun$6(key));
            if (propertyContext == null) {
                throw new MatchError((Object)propertyContext);
            }
            package.PropertyContext propertyContext2 = package$PropertyContext$.MODULE$.unapply(propertyContext);
            String string4 = propertyContext2._1();
            Enumeration.Value value2 = propertyContext2._2();
            String name = string4;
            Enumeration.Value tpe = value2;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)name, (Object)tpe);
            String name2 = (String)tuple2._1();
            Enumeration.Value tpe2 = (Enumeration.Value)tuple2._2();
            Object convertedValue = MODULE$.convertValue(value, tpe2, edge);
            if (((Option)edgePropertyMaybe$1.elem).isDefined()) {
                MODULE$.logger().warn(new StringBuilder(145).append("flatgraph only supports 0..1 edge properties. This graphml edge has more than one properties though - taking only the first one... graphml node: ").append(edge).toString());
            }
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)name2);
            edgePropertyMaybe$1.elem = Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, convertedValue));
        });
        graphmlNodeIdToGNode.get((Object)sourceId).foreach((Function1)(JProcedure1 & Serializable)source -> graphmlNodeIdToGNode.get((Object)targetId).foreach((Function1)(JProcedure1 & Serializable)target -> ((Option)label$4.elem).map((Function1 & Serializable)label -> {
            Object edgeProperty = ((Option)edgePropertyMaybe$4.elem).map((Function1 & Serializable)_$5 -> _$5._2()).getOrElse(GraphMLImporter$::$anonfun$8);
            return Tuple2$.MODULE$.apply(label, edgeProperty);
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                Object edgeProperty = tuple2._2();
                return diffGraph.addEdge((DNodeOrNode)source, (DNodeOrNode)target, label, edgeProperty);
            }
            throw new MatchError((Object)tuple2);
        })));
    }

    private Object convertValue(String stringValue, Enumeration.Value tpe, Node context) {
        Try<Object> try_ = this.tryConvertScalarValue(stringValue, tpe);
        if (try_ instanceof Success) {
            Object value = ((Success)try_).value();
            return value;
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            throw new AssertionError(new StringBuilder(37).append("unable to parse `").append(stringValue).append("` of tpe=").append(tpe).append(". context: ").append(context).toString(), e);
        }
        throw new MatchError(try_);
    }

    private Try<Object> tryConvertScalarValue(String stringValue, Enumeration.Value tpe) {
        return Try$.MODULE$.apply(() -> GraphMLImporter$.tryConvertScalarValue$$anonfun$1(tpe, stringValue));
    }

    private static final package.PropertyContext $anonfun$1(String key$1) {
        throw new AssertionError((Object)new StringBuilder(36).append("key ").append(key$1).append(" not found in propertyContext...").toString());
    }

    private static final String $anonfun$4(Node graphmlNode$2) {
        throw new AssertionError((Object)new StringBuilder(39).append("node label must be defined, but isn't: ").append(graphmlNode$2).toString());
    }

    private static final int $anonfun$5(String label$1, Graph graph$2) {
        throw new AssertionError((Object)new StringBuilder(75).append("node label `").append(label$1).append("` is not one of the labels defined in the schema, which are: [").append(graph$2.schema().nodeLabels().mkString(",")).append("]").toString());
    }

    private static final package.PropertyContext $anonfun$6(String key$2) {
        throw new AssertionError((Object)new StringBuilder(36).append("key ").append(key$2).append(" not found in propertyContext...").toString());
    }

    private static final Object $anonfun$8() {
        return DefaultValue$.MODULE$;
    }

    private static final Object tryConvertScalarValue$$anonfun$1(Enumeration.Value tpe$1, String stringValue$1) {
        Enumeration.Value value = tpe$1;
        Enumeration.Value value2 = package$Type$.MODULE$.Boolean();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value4 = package$Type$.MODULE$.Int();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value6 = package$Type$.MODULE$.Long();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value8 = package$Type$.MODULE$.Float();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value10 = package$Type$.MODULE$.Double();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value12 = package$Type$.MODULE$.String();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            return stringValue$1;
        }
        throw new MatchError((Object)value);
    }
}

