/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.formats;

import flatgraph.Graph;
import flatgraph.formats.ExportResult;
import flatgraph.formats.ExportResult$;
import flatgraph.formats.Exporter;
import flatgraph.formats.ExporterMain;
import flatgraph.formats.ExporterMain$Config$;
import flatgraph.formats.dot.DotExporter$;
import flatgraph.formats.graphml.GraphMLExporter$;
import flatgraph.formats.graphson.GraphSONExporter$;
import flatgraph.formats.neo4jcsv.Neo4jCsvExporter$;
import flatgraph.formats.package$Format$;
import flatgraph.storage.Deserialization$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;
import scopt.OParser;
import scopt.OParser$;
import scopt.OParserBuilder;
import scopt.Read$;

public final class ExporterMain$
implements Serializable {
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(ExporterMain$.class.getDeclaredField("parser$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(ExporterMain$.class.getDeclaredField("builder$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ExporterMain$.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private volatile Object builder$lzy1;
    private volatile Object parser$lzy1;
    private static final ExporterMain$Config$ Config;
    public static final ExporterMain$ MODULE$;

    private ExporterMain$() {
    }

    static {
        MODULE$ = new ExporterMain$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExporterMain$.class);
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger(this.getClass());
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<String[], BoxedUnit> apply() {
        return (JProcedure1 & Serializable)args -> OParser$.MODULE$.parse(MODULE$.parser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)ExporterMain$Config$.MODULE$.apply(Paths.get("/dev/null", new String[0]), null, Paths.get("/dev/null", new String[0]))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            ExporterMain.Config config = x$1;
            if (config != null) {
                Exporter exporter;
                Path path;
                ExporterMain.Config config2 = ExporterMain$Config$.MODULE$.unapply(config);
                Path path2 = config2._1();
                Enumeration.Value value = config2._2();
                Path path3 = config2._3();
                Path inputFile = path2;
                Enumeration.Value format = value;
                Path outputFile = path3;
                if (Files.notExists(inputFile, new LinkOption[0])) {
                    throw new AssertionError((Object)new StringBuilder(32).append("given input file ").append(inputFile).append(" does not exist").toString());
                }
                if (Files.exists(outputFile, new LinkOption[0])) {
                    if (Files.isRegularFile(outputFile, new LinkOption[0])) {
                        throw new AssertionError((Object)new StringBuilder(50).append("output file ").append(outputFile).append(" already exists and is not a directory").toString());
                    }
                    path = BoxedUnit.UNIT;
                } else {
                    path = Files.createDirectories(outputFile, new FileAttribute[0]);
                }
                Enumeration.Value value2 = format;
                Enumeration.Value value3 = package$Format$.MODULE$.Neo4jCsv();
                Enumeration.Value value4 = value2;
                if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                    exporter = Neo4jCsvExporter$.MODULE$;
                } else {
                    Enumeration.Value value5 = package$Format$.MODULE$.GraphML();
                    Enumeration.Value value6 = value2;
                    if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                        exporter = GraphMLExporter$.MODULE$;
                    } else {
                        Enumeration.Value value7 = package$Format$.MODULE$.GraphSON();
                        Enumeration.Value value8 = value2;
                        if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                            exporter = GraphSONExporter$.MODULE$;
                        } else {
                            Enumeration.Value value9 = package$Format$.MODULE$.Dot();
                            Enumeration.Value value10 = value2;
                            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                                exporter = DotExporter$.MODULE$;
                            } else {
                                throw new MatchError((Object)value2);
                            }
                        }
                    }
                }
                Neo4jCsvExporter$ exporter2 = exporter;
                MODULE$.logger().info(new StringBuilder(55).append("starting export of graph in ").append(inputFile).append(" to storagePath=").append(outputFile).append(" in format=").append(format).toString());
                ExportResult exportResult = (ExportResult)Using$.MODULE$.resource((Object)Deserialization$.MODULE$.readGraph(inputFile, (Option)None$.MODULE$, Deserialization$.MODULE$.readGraph$default$3()), (Function1 & Serializable)graph -> exporter2.runExport((Graph)graph, outputFile), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                if (exportResult == null) {
                    throw new MatchError((Object)exportResult);
                }
                ExportResult exportResult2 = ExportResult$.MODULE$.unapply(exportResult);
                int n = exportResult2._1();
                int n2 = exportResult2._2();
                scala.collection.immutable.Seq<Path> seq = exportResult2._3();
                Option<String> option = exportResult2._4();
                int nodeCount = n;
                int edgeCount = n2;
                scala.collection.immutable.Seq<Path> files = seq;
                Option<String> additionalInfo = option;
                Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nodeCount), (Object)BoxesRunTime.boxToInteger((int)edgeCount), files, additionalInfo);
                int nodeCount2 = BoxesRunTime.unboxToInt((Object)tuple4._1());
                int edgeCount2 = BoxesRunTime.unboxToInt((Object)tuple4._2());
                scala.collection.immutable.Seq files2 = (scala.collection.immutable.Seq)tuple4._3();
                Option additionalInfo2 = (Option)tuple4._4();
                MODULE$.logger().info(new StringBuilder(55).append("export completed successfully: ").append(nodeCount2).append(" nodes, ").append(edgeCount2).append(" edges in ").append(files2.size()).append(" files").toString());
                additionalInfo2.foreach((Function1)(JProcedure1 & Serializable)x$0 -> MODULE$.logger().info(x$0));
                return;
            }
            throw new MatchError((Object)config);
        });
    }

    private OParserBuilder<ExporterMain.Config> builder() {
        Object object = this.builder$lzy1;
        if (object instanceof OParserBuilder) {
            return (OParserBuilder)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (OParserBuilder)this.builder$lzyINIT1();
    }

    private Object builder$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.builder$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    OParserBuilder oParserBuilder = null;
                    try {
                        oParserBuilder = OParser$.MODULE$.builder();
                        object2 = oParserBuilder == null ? LazyVals.NullValue$.MODULE$ : oParserBuilder;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.builder$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return oParserBuilder;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private OParser<BoxedUnit, ExporterMain.Config> parser() {
        Object object = this.parser$lzy1;
        if (object instanceof OParser) {
            return (OParser)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (OParser)this.parser$lzyINIT1();
    }

    private Object parser$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.parser$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    OParser oParser = null;
                    try {
                        oParser = OParser$.MODULE$.sequence(this.builder().programName("odb-export"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{this.builder().help("help").text("prints this usage text"), this.builder().opt('f', "format", Read$.MODULE$.stringRead()).required().action((Function2 & Serializable)(x, c) -> {
                            Enumeration.Value value = (Enumeration.Value)package$Format$.MODULE$.byNameLowercase().apply(x);
                            Path path = c.copy$default$1();
                            Path path2 = c.copy$default$3();
                            return c.copy(path, value, path2);
                        }).text(new StringBuilder(24).append("export format, one of [").append(package$Format$.MODULE$.valuesAsStringLowercase().mkString("|")).append("]").toString()), this.builder().opt('o', "out", Read$.MODULE$.pathRead()).required().action((Function2 & Serializable)(x, c) -> c.copy(c.copy$default$1(), c.copy$default$2(), (Path)x)).text("output file or directory - must exist and be writable"), this.builder().arg("odbBinaryFile", Read$.MODULE$.pathRead()).required().action((Function2 & Serializable)(x, c) -> c.copy((Path)x, c.copy$default$2(), c.copy$default$3())).text("input flatgraph graph file - must exist and be readable")}));
                        object2 = oParser == null ? LazyVals.NullValue$.MODULE$ : oParser;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parser$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.parser$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return oParser;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }
}

