/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.formats.graphml;

import flatgraph.Accessors$;
import flatgraph.Edge;
import flatgraph.GNode;
import flatgraph.Schema;
import flatgraph.formats.ExportResult;
import flatgraph.formats.ExportResult$;
import flatgraph.formats.Exporter;
import flatgraph.formats.graphml.package;
import flatgraph.formats.graphml.package$PropertyContext$;
import flatgraph.formats.graphml.package$Type$;
import flatgraph.formats.package$;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.PrettyPrinter;
import scala.xml.Utility$;
import scala.xml.XML$;

public final class GraphMLExporter$
implements Exporter,
Serializable {
    public static final GraphMLExporter$ MODULE$ = new GraphMLExporter$();

    private GraphMLExporter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GraphMLExporter$.class);
    }

    @Override
    public String defaultFileExtension() {
        return "xml";
    }

    @Override
    public ExportResult runExport(Schema schema, IterableOnce<GNode> nodes, IterableOnce<Edge> edges, Path outputFile) {
        Path outFile = package$.MODULE$.resolveOutputFileSingle(outputFile, new StringBuilder(7).append("export.").append(this.defaultFileExtension()).toString());
        Map nodePropertyContextById = (Map)Map$.MODULE$.empty();
        Map edgePropertyContextById = (Map)Map$.MODULE$.empty();
        AtomicInteger discardedListPropertyCount = new AtomicInteger(0);
        Seq nodeEntries = nodes.iterator().map((Function1 & Serializable)node -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(91).append("<node id=\"").append(node.id()).append("\">\n         |    <data key=\"").append(flatgraph.formats.graphml.package$.MODULE$.KeyForNodeLabel()).append("\">").append(node.label()).append("</data>\n         |    ").append(MODULE$.dataEntries("node", node.label(), (IterableOnce<Tuple2<String, Object>>)Accessors$.MODULE$.getNodeProperties(node), (Map<String, package.PropertyContext>)nodePropertyContextById, discardedListPropertyCount)).append("\n         |</node>\n         |").toString()))).toSeq();
        Seq edgeEntries = edges.iterator().map((Function1 & Serializable)edge -> {
            Nil$ nil$;
            if (edge.property() == null) {
                nil$ = scala.package$.MODULE$.Nil();
            } else {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"property");
                nil$ = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, edge.property()), (List)Nil$.MODULE$);
            }
            Nil$ property = nil$;
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(105).append("<edge source=\"").append(edge.src().id()).append("\" target=\"").append(edge.dst().id()).append("\">\n         |    <data key=\"").append(flatgraph.formats.graphml.package$.MODULE$.KeyForEdgeLabel()).append("\">").append(edge.label()).append("</data>\n         |    ").append(MODULE$.dataEntries("edge", edge.label(), (IterableOnce<Tuple2<String, Object>>)property, (Map<String, package.PropertyContext>)edgePropertyContextById, discardedListPropertyCount)).append("\n         |</edge>\n         |").toString()));
        }).toSeq();
        String nodePropertyKeyEntries = this.propertyKeyXml$1("node", nodePropertyContextById);
        String edgePropertyKeyEntries = this.propertyKeyXml$1("edge", edgePropertyContextById);
        String xml = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(599).append("\n       |<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n       |<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n       |  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n       |  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n       |    <key id=\"").append(flatgraph.formats.graphml.package$.MODULE$.KeyForNodeLabel()).append("\" for=\"node\" attr.name=\"").append(flatgraph.formats.graphml.package$.MODULE$.KeyForNodeLabel()).append("\" attr.type=\"string\"></key>\n       |    <key id=\"").append(flatgraph.formats.graphml.package$.MODULE$.KeyForEdgeLabel()).append("\" for=\"edge\" attr.name=\"").append(flatgraph.formats.graphml.package$.MODULE$.KeyForEdgeLabel()).append("\" attr.type=\"string\"></key>\n       |    ").append(nodePropertyKeyEntries).append("\n       |    ").append(edgePropertyKeyEntries).append("\n       |    <graph id=\"G\" edgedefault=\"directed\">\n       |      ").append(nodeEntries.mkString(System.lineSeparator())).append("\n       |      ").append(edgeEntries.mkString(System.lineSeparator())).append("\n       |    </graph>\n       |</graphml>\n       |").toString())).trim();
        package$.MODULE$.writeFile(outFile, xml);
        this.xmlFormatInPlace(outFile);
        Option additionalInfo = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)discardedListPropertyCount.get())).filter((Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> _$1 > 0).map((Function1 & Serializable)count -> GraphMLExporter$.$anonfun$4(BoxesRunTime.unboxToInt((Object)count)));
        return ExportResult$.MODULE$.apply(nodeEntries.size(), edgeEntries.size(), (Seq<Path>)((Seq)((SeqOps)new .colon.colon((Object)outFile, (List)Nil$.MODULE$))), (Option<String>)additionalInfo);
    }

    private String dataEntries(String prefix, String elementLabel, IterableOnce<Tuple2<String, Object>> properties, Map<String, package.PropertyContext> propertyContextById, AtomicInteger discardedListPropertyCount) {
        return properties.iterator().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String propertyName = (String)tuple2._1();
                Object propertyValue = tuple2._2();
                if (package$.MODULE$.isList(propertyValue.getClass())) {
                    discardedListPropertyCount.incrementAndGet();
                    return "";
                }
                String encodedPropertyName = new StringBuilder(4).append(prefix).append("__").append(elementLabel).append("__").append(propertyName).toString();
                Enumeration.Value graphMLTpe = package$Type$.MODULE$.fromRuntimeClass(propertyValue.getClass());
                if (!propertyContextById.contains((Object)encodedPropertyName)) {
                    propertyContextById.update((Object)encodedPropertyName, (Object)package$PropertyContext$.MODULE$.apply(propertyName, graphMLTpe));
                }
                String xmlEncoded = Utility$.MODULE$.escape(propertyValue.toString());
                return new StringBuilder(20).append("<data key=\"").append(encodedPropertyName).append("\">").append(xmlEncoded).append("</data>").toString();
            }
            throw new MatchError((Object)tuple2);
        }).mkString(System.lineSeparator());
    }

    private void xmlFormatInPlace(Path xmlFile) {
        Elem xml = (Elem)XML$.MODULE$.loadFile(xmlFile.toFile());
        PrettyPrinter prettyPrinter = new PrettyPrinter(120, 2);
        String formatted = prettyPrinter.format((Node)xml, prettyPrinter.format$default$2());
        package$.MODULE$.writeFile(xmlFile, formatted);
    }

    private final String propertyKeyXml$1(String forAttr, Map propsMap) {
        return ((IterableOnceOps)propsMap.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                package.PropertyContext propertyContext = (package.PropertyContext)tuple2._2();
                String key = (String)tuple2._1();
                if (propertyContext != null) {
                    package.PropertyContext propertyContext2 = package$PropertyContext$.MODULE$.unapply(propertyContext);
                    String string = propertyContext2._1();
                    Enumeration.Value value = propertyContext2._2();
                    String name = string;
                    Enumeration.Value tpe = value;
                    return new StringBuilder(50).append("<key id=\"").append(key).append("\" for=\"").append(forAttr).append("\" attr.name=\"").append(name).append("\" attr.type=\"").append(tpe).append("\"></key>").toString();
                }
            }
            throw new MatchError((Object)tuple2);
        })).mkString(System.lineSeparator());
    }

    private static final /* synthetic */ String $anonfun$4(int count) {
        return new StringBuilder(88).append("warning: discarded ").append(count).append(" list properties (because they are not supported by the graphml spec)").toString();
    }
}

