/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.formats.graphml;

import flatgraph.Graph;
import flatgraph.formats.Importer;
import flatgraph.formats.graphml.package;
import flatgraph.formats.graphml.package$;
import flatgraph.formats.graphml.package$PropertyContext$;
import flatgraph.formats.graphml.package$Type$;
import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public final class GraphMLImporter$
implements Importer,
Serializable {
    private static Logger logger;
    public static final GraphMLImporter$ MODULE$;

    private GraphMLImporter$() {
    }

    static {
        MODULE$ = new GraphMLImporter$();
        Importer.$init$(MODULE$);
        Statics.releaseFence();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void flatgraph$formats$Importer$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GraphMLImporter$.class);
    }

    @Override
    public void runImport(Graph graph, Seq<Path> inputFiles) {
        if (inputFiles.size() != 1) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(40).append("input must be exactly one file, but got ").append(inputFiles.size()).toString());
        }
        Elem doc = (Elem)XML$.MODULE$.loadFile(((Path)inputFiles.head()).toFile());
        NodeSeq keyEntries = doc.$bslash("key");
        NodeSeq graphXml = doc.$bslash("graph");
        Map<String, package.PropertyContext> nodePropertyContextById = this.parsePropertyEntries("node", keyEntries);
        graphXml.$bslash("node").foreach((Function1)(JProcedure1 & Serializable)node -> this.addNode(graph, (Node)node, nodePropertyContextById));
        Map<String, package.PropertyContext> edgePropertyContextById = this.parsePropertyEntries("edge", keyEntries);
        graphXml.$bslash("edge").foreach((Function1)(JProcedure1 & Serializable)edge -> this.addEdge(graph, (Node)edge, edgePropertyContextById));
    }

    private Map<String, package.PropertyContext> parsePropertyEntries(String forElementType, NodeSeq keyEntries) {
        return ((IterableOnceOps)((StrictOptimizedIterableOps)keyEntries.filter((Function1 & Serializable)_$1 -> {
            String string = _$1.$bslash$at("for");
            String string2 = forElementType;
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).map((Function1 & Serializable)node -> {
            String id = node.$bslash$at("id");
            String name = node.$bslash$at("attr.name");
            String graphmlType = node.$bslash$at("attr.type");
            return Tuple2$.MODULE$.apply((Object)id, (Object)package$PropertyContext$.MODULE$.apply(name, package$Type$.MODULE$.withName(graphmlType)));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void addNode(Graph graph, Node node, Map<String, package.PropertyContext> propertyContextById) {
        String id = node.$bslash$at("id");
        ObjectRef label = ObjectRef.create((Object)None$.MODULE$);
        Builder keyValuePairs = scala.package$.MODULE$.Seq().newBuilder();
        node.$bslash("data").foreach((Function1 & Serializable)entry -> {
            String value = entry.text();
            String string = entry.$bslash$at("key");
            String string2 = package$.MODULE$.KeyForNodeLabel();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                Option option = Option$.MODULE$.apply((Object)value);
                label$1.elem = option;
                option = null;
                return BoxedUnit.UNIT;
            }
            String key = string;
            package.PropertyContext propertyContext = (package.PropertyContext)propertyContextById.get((Object)key).getOrElse(() -> this.$anonfun$1(key));
            if (propertyContext == null) {
                throw new MatchError((Object)propertyContext);
            }
            package.PropertyContext propertyContext2 = package$PropertyContext$.MODULE$.unapply(propertyContext);
            String string4 = propertyContext2._1();
            Enumeration.Value value2 = propertyContext2._2();
            String name = string4;
            Enumeration.Value tpe = value2;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)name, (Object)tpe);
            String name2 = (String)tuple2._1();
            Enumeration.Value tpe2 = (Enumeration.Value)tuple2._2();
            Object convertedValue = this.convertValue(value, tpe2, node);
            return keyValuePairs.addAll((IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name2, convertedValue})));
        });
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private void addEdge(Graph graph, Node edge, Map<String, package.PropertyContext> propertyContextById) {
        String sourceId = edge.$bslash$at("source");
        String targetId = edge.$bslash$at("target");
        ObjectRef label = ObjectRef.create((Object)None$.MODULE$);
        Builder keyValuePairs = scala.package$.MODULE$.Seq().newBuilder();
        edge.$bslash("data").foreach((Function1 & Serializable)entry -> {
            String value = entry.text();
            String string = entry.$bslash$at("key");
            String string2 = package$.MODULE$.KeyForEdgeLabel();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                Option option = Option$.MODULE$.apply((Object)value);
                label$2.elem = option;
                option = null;
                return BoxedUnit.UNIT;
            }
            String key = string;
            package.PropertyContext propertyContext = (package.PropertyContext)propertyContextById.get((Object)key).getOrElse(() -> this.$anonfun$2(key));
            if (propertyContext == null) {
                throw new MatchError((Object)propertyContext);
            }
            package.PropertyContext propertyContext2 = package$PropertyContext$.MODULE$.unapply(propertyContext);
            String string4 = propertyContext2._1();
            Enumeration.Value value2 = propertyContext2._2();
            String name = string4;
            Enumeration.Value tpe = value2;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)name, (Object)tpe);
            String name2 = (String)tuple2._1();
            Enumeration.Value tpe2 = (Enumeration.Value)tuple2._2();
            Object convertedValue = this.convertValue(value, tpe2, edge);
            return keyValuePairs.addAll((IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name2, convertedValue})));
        });
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private Object convertValue(String stringValue, Enumeration.Value tpe, Node context) {
        Try<Object> try_ = this.tryConvertScalarValue(stringValue, tpe);
        if (try_ instanceof Success) {
            Object value = ((Success)try_).value();
            return value;
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            throw new AssertionError(new StringBuilder(37).append("unable to parse `").append(stringValue).append("` of tpe=").append(tpe).append(". context: ").append(context).toString(), e);
        }
        throw new MatchError(try_);
    }

    private Try<Object> tryConvertScalarValue(String stringValue, Enumeration.Value tpe) {
        return Try$.MODULE$.apply(() -> this.tryConvertScalarValue$$anonfun$1(stringValue, tpe));
    }

    private final package.PropertyContext $anonfun$1(String key$1) {
        throw new AssertionError((Object)new StringBuilder(36).append("key ").append(key$1).append(" not found in propertyContext...").toString());
    }

    private final package.PropertyContext $anonfun$2(String key$2) {
        throw new AssertionError((Object)new StringBuilder(36).append("key ").append(key$2).append(" not found in propertyContext...").toString());
    }

    private final Object tryConvertScalarValue$$anonfun$1(String stringValue$1, Enumeration.Value tpe$1) {
        Enumeration.Value value = tpe$1;
        Enumeration.Value value2 = package$Type$.MODULE$.Boolean();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value4 = package$Type$.MODULE$.Int();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value6 = package$Type$.MODULE$.Long();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value8 = package$Type$.MODULE$.Float();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value10 = package$Type$.MODULE$.Double();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value12 = package$Type$.MODULE$.String();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            return stringValue$1;
        }
        throw new MatchError((Object)value);
    }
}

