/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.storage;

import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdDecompressCtx;
import flatgraph.storage.ZstdWrapper$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.ArrayDeque$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class ZstdWrapper {
    public static <A> A apply(Function0<A> function0) {
        return ZstdWrapper$.MODULE$.apply(function0);
    }

    public static class JniInvocationException
    extends RuntimeException {
        public JniInvocationException(String message, Option<Throwable> cause) {
            super(message, (Throwable)cause.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
    }

    public static class ZstdCtx
    implements AutoCloseable {
        private boolean closed = false;
        private final ArrayDeque compressCtxs = (ArrayDeque)ArrayDeque$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ZstdCompressCtx[0]));
        private final ArrayDeque decompressCtxs = (ArrayDeque)ArrayDeque$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ZstdDecompressCtx[0]));

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public ArrayDeque<ZstdCompressCtx> compressCtxs() {
            return this.compressCtxs;
        }

        public ArrayDeque<ZstdDecompressCtx> decompressCtxs() {
            return this.decompressCtxs;
        }

        public ByteBuffer compress(byte[] bytes) {
            return (ByteBuffer)ZstdWrapper$.MODULE$.apply(() -> this.compress$$anonfun$1(bytes));
        }

        public ByteBuffer decompress(ByteBuffer bytes, int len) {
            return (ByteBuffer)ZstdWrapper$.MODULE$.apply(() -> this.decompress$$anonfun$1(bytes, len));
        }

        @Override
        public void close() {
            ZstdCtx zstdCtx = this;
            synchronized (zstdCtx) {
                this.compressCtxs().foreach((Function1)((JProcedure1 & Serializable)ZstdWrapper$::flatgraph$storage$ZstdWrapper$ZstdCtx$$_$close$$anonfun$1));
                this.compressCtxs().clear();
                this.decompressCtxs().foreach((Function1)((JProcedure1 & Serializable)ZstdWrapper$::flatgraph$storage$ZstdWrapper$ZstdCtx$$_$close$$anonfun$2));
                this.decompressCtxs().clear();
                this.closed_$eq(true);
            }
        }

        private final ByteBuffer compress$$anonfun$1(byte[] bytes$1) {
            ByteBuffer byteBuffer;
            Option option;
            ZstdCtx zstdCtx = this;
            synchronized (zstdCtx) {
                option = this.compressCtxs().removeLastOption(this.compressCtxs().removeLastOption$default$1());
            }
            Option ctx0 = option;
            ZstdCompressCtx ctx = (ZstdCompressCtx)ctx0.getOrElse(ZstdWrapper$::flatgraph$storage$ZstdWrapper$ZstdCtx$$_$_$$anonfun$1);
            try {
                ByteBuffer buf = ByteBuffer.allocateDirect(bytes$1.length);
                buf.put(bytes$1);
                buf.flip();
                byteBuffer = ctx.compress(buf);
            }
            catch (Throwable throwable) {
                ZstdCtx zstdCtx2 = this;
                synchronized (zstdCtx2) {
                    BoxedUnit boxedUnit;
                    if (this.closed()) {
                        ctx.close();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = this.compressCtxs().append((Object)ctx);
                    }
                }
                throw throwable;
            }
            ZstdCtx zstdCtx3 = this;
            synchronized (zstdCtx3) {
                BoxedUnit boxedUnit;
                if (this.closed()) {
                    ctx.close();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = this.compressCtxs().append((Object)ctx);
                }
            }
            return byteBuffer;
        }

        private final ByteBuffer decompress$$anonfun$1(ByteBuffer bytes$2, int len$1) {
            ByteBuffer byteBuffer;
            Option option;
            ZstdCtx zstdCtx = this;
            synchronized (zstdCtx) {
                option = this.decompressCtxs().removeLastOption(this.decompressCtxs().removeLastOption$default$1());
            }
            Option ctx0 = option;
            ZstdDecompressCtx ctx = (ZstdDecompressCtx)ctx0.getOrElse(ZstdWrapper$::flatgraph$storage$ZstdWrapper$ZstdCtx$$_$_$$anonfun$2);
            try {
                byteBuffer = ctx.decompress(bytes$2, len$1).order(ByteOrder.LITTLE_ENDIAN);
            }
            catch (Throwable throwable) {
                ZstdCtx zstdCtx2 = this;
                synchronized (zstdCtx2) {
                    BoxedUnit boxedUnit;
                    if (this.closed()) {
                        ctx.close();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = this.decompressCtxs().append((Object)ctx);
                    }
                }
                throw throwable;
            }
            ZstdCtx zstdCtx3 = this;
            synchronized (zstdCtx3) {
                BoxedUnit boxedUnit;
                if (this.closed()) {
                    ctx.close();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = this.decompressCtxs().append((Object)ctx);
                }
            }
            return byteBuffer;
        }
    }
}

