/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.storage;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdDecompressCtx;
import flatgraph.storage.ZstdWrapper;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Properties$;
import scala.util.Try$;

public final class ZstdWrapper$
implements Serializable {
    private static final Logger logger;
    public static final ZstdWrapper$ MODULE$;

    private ZstdWrapper$() {
    }

    static {
        MODULE$ = new ZstdWrapper$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ZstdWrapper$.class);
    }

    public <A> A apply(Function0<A> fun) {
        Object object;
        this.probeTmpMountOptions();
        try {
            object = fun.apply();
        }
        catch (Throwable e) {
            throw new ZstdWrapper.JniInvocationException("Error while trying to invoke zstd, i.e. cannot compress or decompress, which is required for flatgraph's storage", (Option<Throwable>)Option$.MODULE$.apply((Object)e));
        }
        return (A)object;
    }

    private void probeTmpMountOptions() {
        LazyRef lazyRef = new LazyRef();
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.probeTmpMountOptions$$anonfun$1(tmpDirPath, lazyRef);
            return BoxedUnit.UNIT;
        });
    }

    public static final ZstdCompressCtx flatgraph$storage$ZstdWrapper$ZstdCtx$$_$_$$anonfun$1() {
        ZstdCompressCtx res = new ZstdCompressCtx();
        res.setLevel(Zstd.defaultCompressionLevel());
        return res;
    }

    public static final ZstdDecompressCtx flatgraph$storage$ZstdWrapper$ZstdCtx$$_$_$$anonfun$2() {
        return new ZstdDecompressCtx();
    }

    public static final /* synthetic */ void flatgraph$storage$ZstdWrapper$ZstdCtx$$_$close$$anonfun$1(ZstdCompressCtx _$1) {
        _$1.close();
    }

    public static final /* synthetic */ void flatgraph$storage$ZstdWrapper$ZstdCtx$$_$close$$anonfun$2(ZstdDecompressCtx _$2) {
        _$2.close();
    }

    private final String warnMessage$lzyINIT1$1(LazyRef warnMessage$lzy1$1, String tmpDirPath$1) {
        String string;
        LazyRef lazyRef = warnMessage$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(warnMessage$lzy1$1.initialized() ? warnMessage$lzy1$1.value() : warnMessage$lzy1$1.initialize((Object)new StringBuilder(270).append("the configured temp directory (").append(tmpDirPath$1).append(") is mounted with `noexec` flag - ").append("this will likely lead to an error when trying to invoke zstd. Please either remount it without `noexec` or ").append("configure a different tmp directory, e.g. via java system property `-Djava.io.tmpdir=/path/to/tmp`").toString()));
        }
        return string;
    }

    private final String warnMessage$1(LazyRef warnMessage$lzy1$2, String tmpDirPath$2) {
        return (String)(warnMessage$lzy1$2.initialized() ? warnMessage$lzy1$2.value() : this.warnMessage$lzyINIT1$1(warnMessage$lzy1$2, tmpDirPath$2));
    }

    private final void probeTmpMountOptions$$anonfun$1(String tmpDirPath$3, LazyRef warnMessage$lzy1$3) {
        if (Properties$.MODULE$.isLinux() || Properties$.MODULE$.isMac()) {
            List<String> mounts = Files.readAllLines(Paths.get("/proc/mounts", new String[0]));
            if (CollectionConverters$.MODULE$.ListHasAsScala(mounts).asScala().exists((Function1 & Serializable)mountInfoLine -> mountInfoLine.contains(new StringBuilder(2).append(" ").append(tmpDirPath$3).append(" ").toString()) && mountInfoLine.contains("noexec"))) {
                logger.warn(this.warnMessage$1(warnMessage$lzy1$3, tmpDirPath$3));
                return;
            }
            return;
        }
    }
}

