/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.storage;

import flatgraph.DefaultValue;
import flatgraph.GNode;
import flatgraph.storage.Manifest;
import flatgraph.storage.Manifest$GraphItem$;
import flatgraph.storage.ZstdWrapper;
import flatgraph.storage.package$Keys$;
import flatgraph.storage.package$StorageType$;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.ArrayDeque$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import ujson.Value;

public class WriterContext {
    private final FileChannel fileChannel;
    private final ExecutorService executor;
    private final ZstdWrapper.ZstdCtx compressCtx;
    private long fileOffset;
    private final ArrayDeque compressQueue;
    private final ArrayDeque writeQueue;
    private final ArrayBuffer jobQueue;
    private final ArrayDeque stringQueue;
    private final LinkedHashMap stringpool;

    public WriterContext(FileChannel fileChannel, ExecutorService executor) {
        this.fileChannel = fileChannel;
        this.executor = executor;
        this.compressCtx = new ZstdWrapper.ZstdCtx();
        this.fileOffset = 16L;
        this.compressQueue = (ArrayDeque)ArrayDeque$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[0]));
        this.writeQueue = (ArrayDeque)ArrayDeque$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[0]));
        this.jobQueue = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[0]));
        this.stringQueue = (ArrayDeque)ArrayDeque$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.stringpool = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public FileChannel fileChannel() {
        return this.fileChannel;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public ZstdWrapper.ZstdCtx compressCtx() {
        return this.compressCtx;
    }

    public long fileOffset() {
        return this.fileOffset;
    }

    public void fileOffset_$eq(long x$1) {
        this.fileOffset = x$1;
    }

    public ArrayDeque<Future<Tuple2<Manifest.OutlineStorage, ByteBuffer>>> compressQueue() {
        return this.compressQueue;
    }

    public ArrayDeque<Future<Object>> writeQueue() {
        return this.writeQueue;
    }

    public ArrayBuffer<Function0<Tuple2<Manifest.OutlineStorage, byte[]>>> jobQueue() {
        return this.jobQueue;
    }

    public ArrayDeque<Tuple2<Manifest.OutlineStorage, String[]>> stringQueue() {
        return this.stringQueue;
    }

    public LinkedHashMap<String, Object> stringpool() {
        return this.stringpool;
    }

    public void submitCompress(Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>> block) {
        this.compressQueue().addOne(this.executor().submit(() -> (Tuple2)block.apply()));
    }

    private int[] deltaEncode(int padTo, int[] offsets) {
        if (offsets == null) {
            return null;
        }
        int[] res = new int[padTo + 1];
        if (offsets.length != 0 && offsets[0] != 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        int until = package$.MODULE$.min(offsets.length - 1, padTo);
        for (int idx = 0; idx < until; ++idx) {
            res[idx] = offsets[idx + 1] - offsets[idx];
        }
        return res;
    }

    private int insertString(LinkedHashMap<String, Object> stringPool, String s) {
        if (s == null) {
            return -1;
        }
        return BoxesRunTime.unboxToInt((Object)stringPool.getOrElseUpdate((Object)s, () -> WriterContext.insertString$$anonfun$1(stringPool)));
    }

    public Manifest.OutlineStorage encodeAny(Object item, Manifest.OutlineStorage outlineStorage, int delta) {
        BoxedUnit boxedUnit;
        Object object = item;
        if (object instanceof DefaultValue) {
            boxedUnit = null;
        } else if (object == null) {
            boxedUnit = null;
        } else if (object instanceof boolean[]) {
            boolean[] bools = (boolean[])object;
            outlineStorage.typ_$eq(package$StorageType$.MODULE$.Bool());
            this.submitCompress((Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>>)((Function0 & Serializable)() -> this.encodeAny$$anonfun$1(bools, outlineStorage)));
            boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            outlineStorage.typ_$eq(package$StorageType$.MODULE$.Byte());
            this.submitCompress((Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>>)((Function0 & Serializable)() -> this.encodeAny$$anonfun$2(outlineStorage, bytes)));
            boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof short[]) {
            short[] shorts = (short[])object;
            outlineStorage.typ_$eq(package$StorageType$.MODULE$.Short());
            this.submitCompress((Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>>)((Function0 & Serializable)() -> this.encodeAny$$anonfun$3(shorts, outlineStorage)));
            boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof int[]) {
            int[] ints = (int[])object;
            outlineStorage.typ_$eq(package$StorageType$.MODULE$.Int());
            this.submitCompress((Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>>)((Function0 & Serializable)() -> this.encodeAny$$anonfun$4(delta, ints, outlineStorage)));
            boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof long[]) {
            long[] longs = (long[])object;
            outlineStorage.typ_$eq(package$StorageType$.MODULE$.Long());
            this.submitCompress((Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>>)((Function0 & Serializable)() -> this.encodeAny$$anonfun$5(longs, outlineStorage)));
            boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof float[]) {
            float[] floats = (float[])object;
            outlineStorage.typ_$eq(package$StorageType$.MODULE$.Float());
            this.submitCompress((Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>>)((Function0 & Serializable)() -> this.encodeAny$$anonfun$6(floats, outlineStorage)));
            boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof double[]) {
            double[] doubles = (double[])object;
            outlineStorage.typ_$eq(package$StorageType$.MODULE$.Double());
            this.submitCompress((Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>>)((Function0 & Serializable)() -> this.encodeAny$$anonfun$7(doubles, outlineStorage)));
            boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof GNode[]) {
            GNode[] refs = (GNode[])object;
            outlineStorage.typ_$eq(package$StorageType$.MODULE$.Ref());
            this.submitCompress((Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>>)((Function0 & Serializable)() -> this.encodeAny$$anonfun$8(refs, outlineStorage)));
            boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof String[]) {
            String[] strings = (String[])object;
            outlineStorage.typ_$eq(package$StorageType$.MODULE$.String());
            boxedUnit = this.stringQueue().addOne((Object)Tuple2$.MODULE$.apply((Object)outlineStorage, (Object)strings));
        } else {
            throw new MatchError(object);
        }
        return outlineStorage;
    }

    public Manifest.OutlineStorage encodeAny$default$2() {
        return new Manifest.OutlineStorage();
    }

    public int encodeAny$default$3() {
        return -1;
    }

    public Tuple2<Manifest.OutlineStorage, ByteBuffer> compressItem(Manifest.OutlineStorage res, byte[] bytes) {
        res.decompressedLength_$eq(bytes.length);
        ByteBuffer compressed = this.compressCtx().compress(bytes);
        return Tuple2$.MODULE$.apply((Object)res, (Object)compressed);
    }

    public void writeItem(Manifest.OutlineStorage res, ByteBuffer buf) {
        res.compressedLength_$eq(buf.limit());
        long outPos0 = this.fileOffset();
        this.fileOffset_$eq(this.fileOffset() + (long)buf.limit());
        res.startOffset_$eq(outPos0);
        this.writeQueue().addOne(this.executor().submit(() -> {
            long outPos = outPos0;
            while (buf.hasRemaining()) {
                outPos += (long)this.fileChannel().write(buf, outPos);
            }
            return null;
        }));
    }

    public void finish(Manifest.GraphItem manifest) {
        while (this.stringQueue().nonEmpty()) {
            while (this.writeQueue().nonEmpty() && ((Future)this.writeQueue().head()).isDone()) {
                this.writeQueue().removeHead(this.writeQueue().removeHead$default$1());
            }
            while (this.compressQueue().nonEmpty() && ((Future)this.compressQueue().head()).isDone()) {
                Tuple2 tuple2 = (Tuple2)((Future)this.compressQueue().removeHead(this.compressQueue().removeHead$default$1())).get();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Manifest.OutlineStorage item = (Manifest.OutlineStorage)tuple2._1();
                ByteBuffer bytes = (ByteBuffer)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)item, (Object)bytes);
                Manifest.OutlineStorage item2 = (Manifest.OutlineStorage)tuple22._1();
                ByteBuffer bytes2 = (ByteBuffer)tuple22._2();
                this.writeItem(item2, bytes2);
            }
            Tuple2 tuple2 = (Tuple2)this.stringQueue().removeHead(this.stringQueue().removeHead$default$1());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Manifest.OutlineStorage item = (Manifest.OutlineStorage)tuple2._1();
            String[] strings = (String[])tuple2._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)item, (Object)strings);
            Manifest.OutlineStorage item3 = (Manifest.OutlineStorage)tuple23._1();
            Object[] strings2 = (String[])tuple23._2();
            Object object = Predef$.MODULE$.refArrayOps(strings2);
            int[] indices = (int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)s -> this.insertString(this.stringpool(), (String)s), ClassTag$.MODULE$.apply(Integer.TYPE));
            this.submitCompress((Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>>)((Function0 & Serializable)() -> this.finish$$anonfun$1((String[])strings2, indices, item3)));
        }
        byte[] poolLenBytes = new byte[4 * this.stringpool().size()];
        IntBuffer poolLenBuffer = ByteBuffer.wrap(poolLenBytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        ByteArrayOutputStream poolBytes = new ByteArrayOutputStream();
        this.stringpool().keysIterator().foreach((Function1 & Serializable)s -> {
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            poolBytes.write(bytes);
            return poolLenBuffer.put(bytes.length);
        });
        this.submitCompress((Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>>)((Function0 & Serializable)() -> this.finish$$anonfun$3(manifest, poolLenBytes)));
        this.submitCompress((Function0<Tuple2<Manifest.OutlineStorage, ByteBuffer>>)((Function0 & Serializable)() -> this.finish$$anonfun$4(manifest, poolBytes)));
        while (this.compressQueue().nonEmpty()) {
            while (this.writeQueue().nonEmpty() && ((Future)this.writeQueue().head()).isDone()) {
                this.writeQueue().removeHead(this.writeQueue().removeHead$default$1());
            }
            Tuple2 tuple2 = (Tuple2)((Future)this.compressQueue().removeHead(this.compressQueue().removeHead$default$1())).get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Manifest.OutlineStorage item = (Manifest.OutlineStorage)tuple2._1();
            ByteBuffer bytes = (ByteBuffer)tuple2._2();
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)item, (Object)bytes);
            Manifest.OutlineStorage item4 = (Manifest.OutlineStorage)tuple24._1();
            ByteBuffer bytes3 = (ByteBuffer)tuple24._2();
            this.writeItem(item4, bytes3);
        }
        while (this.writeQueue().nonEmpty()) {
            ((Future)this.writeQueue().removeHead(this.writeQueue().removeHead$default$1())).get();
        }
        long pos = this.fileOffset();
        byte[] header = new byte[16];
        ByteBuffer headerBuf = ByteBuffer.wrap(header);
        headerBuf.order(ByteOrder.LITTLE_ENDIAN).put(package$Keys$.MODULE$.Header()).asLongBuffer().put(pos);
        headerBuf.position(0);
        long headPos = 0L;
        while (headerBuf.hasRemaining()) {
            headPos += (long)this.fileChannel().write(headerBuf, headPos);
        }
        Value manifestObj = Manifest$GraphItem$.MODULE$.write(manifest);
        String prefixForTail = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\n"), 20);
        ByteBuffer buf = ByteBuffer.wrap(new StringBuilder(0).append(prefixForTail).append(manifestObj.render(manifestObj.render$default$1(), manifestObj.render$default$2())).toString().getBytes(StandardCharsets.UTF_8));
        while (buf.hasRemaining()) {
            pos += (long)this.fileChannel().write(buf, pos);
        }
        this.fileChannel().truncate(pos);
    }

    private static final int insertString$$anonfun$1(LinkedHashMap stringPool$1) {
        return stringPool$1.size();
    }

    private static final /* synthetic */ byte $anonfun$1(boolean b) {
        if (b) {
            return (byte)1;
        }
        return (byte)0;
    }

    private final Tuple2 encodeAny$$anonfun$1(boolean[] bools$1, Manifest.OutlineStorage outlineStorage$1) {
        Object object = Predef$.MODULE$.booleanArrayOps(bools$1);
        byte[] bytes = (byte[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)b -> WriterContext.$anonfun$1(BoxesRunTime.unboxToBoolean((Object)b)), ClassTag$.MODULE$.apply(Byte.TYPE));
        return this.compressItem(outlineStorage$1, bytes);
    }

    private final Tuple2 encodeAny$$anonfun$2(Manifest.OutlineStorage outlineStorage$2, byte[] bytes$1) {
        return this.compressItem(outlineStorage$2, bytes$1);
    }

    private final Tuple2 encodeAny$$anonfun$3(short[] shorts$1, Manifest.OutlineStorage outlineStorage$3) {
        byte[] bytes = new byte[2 * shorts$1.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().put(shorts$1);
        return this.compressItem(outlineStorage$3, bytes);
    }

    private final Tuple2 encodeAny$$anonfun$4(int delta$1, int[] ints$1, Manifest.OutlineStorage outlineStorage$4) {
        int[] tmpInts = delta$1 == -1 ? ints$1 : this.deltaEncode(delta$1, ints$1);
        byte[] bytes = new byte[4 * tmpInts.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().put(tmpInts);
        return this.compressItem(outlineStorage$4, bytes);
    }

    private final Tuple2 encodeAny$$anonfun$5(long[] longs$1, Manifest.OutlineStorage outlineStorage$5) {
        byte[] bytes = new byte[8 * longs$1.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().put(longs$1);
        return this.compressItem(outlineStorage$5, bytes);
    }

    private final Tuple2 encodeAny$$anonfun$6(float[] floats$1, Manifest.OutlineStorage outlineStorage$6) {
        byte[] bytes = new byte[4 * floats$1.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().put(floats$1);
        return this.compressItem(outlineStorage$6, bytes);
    }

    private final Tuple2 encodeAny$$anonfun$7(double[] doubles$1, Manifest.OutlineStorage outlineStorage$7) {
        byte[] bytes = new byte[8 * doubles$1.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer().put(doubles$1);
        return this.compressItem(outlineStorage$7, bytes);
    }

    private final Tuple2 encodeAny$$anonfun$8(GNode[] refs$1, Manifest.OutlineStorage outlineStorage$8) {
        byte[] bytes = new byte[8 * refs$1.length];
        ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        Object object = Predef$.MODULE$.refArrayOps((Object[])refs$1);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)ref -> {
            if (ref == null) {
                return buf.putLong(0xFFFFFFFFFFFFL);
            }
            return buf.putLong((long)ref.seq() + ((long)ref.nodeKind << 32));
        });
        return this.compressItem(outlineStorage$8, bytes);
    }

    private final Tuple2 finish$$anonfun$1(String[] strings$1, int[] indices$1, Manifest.OutlineStorage item$1) {
        byte[] bytes = new byte[4 * strings$1.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().put(indices$1);
        return this.compressItem(item$1, bytes);
    }

    private final Tuple2 finish$$anonfun$3(Manifest.GraphItem manifest$1, byte[] poolLenBytes$1) {
        return this.compressItem(manifest$1.stringPoolLength(), poolLenBytes$1);
    }

    private final Tuple2 finish$$anonfun$4(Manifest.GraphItem manifest$2, ByteArrayOutputStream poolBytes$2) {
        return this.compressItem(manifest$2.stringPoolBytes(), poolBytes$2.toByteArray());
    }
}

