/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.storage;

import com.github.luben.zstd.Zstd;
import flatgraph.AccessHelpers;
import flatgraph.Edge;
import flatgraph.Edge$Direction$;
import flatgraph.GNode;
import flatgraph.Graph;
import flatgraph.misc.Misc$;
import flatgraph.storage.Manifest;
import flatgraph.storage.Manifest$EdgeItem$;
import flatgraph.storage.Manifest$GraphItem$;
import flatgraph.storage.Manifest$PropertyItem$;
import flatgraph.storage.Serialization;
import flatgraph.storage.Serialization$Counts$;
import flatgraph.storage.WriterContext;
import flatgraph.storage.ZstdWrapper$;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class Serialization$
implements Serializable {
    private static final Logger logger;
    public static final Serialization$Counts$ Counts;
    public static final Serialization$ MODULE$;

    private Serialization$() {
    }

    static {
        MODULE$ = new Serialization$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Serialization$.class);
    }

    public Logger logger() {
        return logger;
    }

    public Serialization.Counts writeGraph(Graph graph, Path storagePath, Option<ExecutorService> requestedExecutor) {
        Serialization.Counts counts;
        this.logger().info(new StringBuilder(24).append("writing to storage at `").append(storagePath).append("`").toString());
        this.ensureParentDirectoryExists(storagePath);
        FileChannel fileChannel = new RandomAccessFile(storagePath.toAbsolutePath().toFile(), "rw").getChannel();
        WriterContext writer = new WriterContext(fileChannel, Misc$.MODULE$.maybeOverrideExecutor(requestedExecutor));
        try {
            try {
                counts = this.innerWriteGraph(graph, writer);
            }
            catch (ExecutionException ex) {
                throw ex.getCause();
            }
        }
        finally {
            writer.compressCtx().close();
            fileChannel.close();
        }
        return counts;
    }

    public Option<ExecutorService> writeGraph$default$3() {
        return None$.MODULE$;
    }

    private Serialization.Counts innerWriteGraph(Graph graph, WriterContext writer) {
        ArrayBuffer nodes = ArrayBuffer$.MODULE$.empty();
        ArrayBuffer edges = ArrayBuffer$.MODULE$.empty();
        ArrayBuffer properties = ArrayBuffer$.MODULE$.empty();
        graph.schema().nodeKinds().foreach((Function1 & Serializable)nodeKind -> this.innerWriteGraph$$anonfun$1(graph, nodes, BoxesRunTime.unboxToInt((Object)nodeKind)));
        graph.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> graph.schema().edgeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)edgeKind -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])Edge$Direction$.MODULE$.values());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)direction -> {
                int pos = graph.schema().neighborOffsetArrayIndex(nodeKind, (Edge.Direction)direction, edgeKind);
                if (graph.neighbors()[pos] != null) {
                    String nodeLabel = graph.schema().getNodeLabel(nodeKind);
                    String edgeLabel = graph.schema().getEdgeLabel(nodeKind, edgeKind);
                    Manifest.EdgeItem edgeItem = new Manifest.EdgeItem(nodeLabel, edgeLabel, direction.encoding(), Manifest$EdgeItem$.MODULE$.$lessinit$greater$default$4(), Manifest$EdgeItem$.MODULE$.$lessinit$greater$default$5(), Manifest$EdgeItem$.MODULE$.$lessinit$greater$default$6());
                    edges.addOne((Object)edgeItem);
                    writer.encodeAny(graph.neighbors()[pos], edgeItem.qty(), graph.nodeCountByKind(nodeKind));
                    writer.encodeAny(graph.neighbors()[pos + 1], edgeItem.neighbors(), writer.encodeAny$default$3());
                    writer.encodeAny(graph.neighbors()[pos + 2], edgeItem.property(), writer.encodeAny$default$3());
                    return;
                }
            });
        }));
        graph.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> graph.schema().propertyKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)propertyKind -> {
            int pos = graph.schema().propertyOffsetArrayIndex(nodeKind, propertyKind);
            if (graph.properties()[pos] != null) {
                String nodeLabel = graph.schema().getNodeLabel(nodeKind);
                String propertyLabel = graph.schema().getPropertyLabel(nodeKind, propertyKind);
                Manifest.PropertyItem propertyItem = new Manifest.PropertyItem(nodeLabel, propertyLabel, Manifest$PropertyItem$.MODULE$.$lessinit$greater$default$3(), Manifest$PropertyItem$.MODULE$.$lessinit$greater$default$4());
                properties.addOne((Object)propertyItem);
                writer.encodeAny((int[])graph.properties()[pos], propertyItem.qty(), graph.nodeCountByKind(nodeKind));
                writer.encodeAny(graph.properties()[pos + 1], propertyItem.property(), writer.encodeAny$default$3());
                return;
            }
        }));
        Manifest.GraphItem manifest = new Manifest.GraphItem((Manifest.NodeItem[])nodes.toArray(ClassTag$.MODULE$.apply(Manifest.NodeItem.class)), (Manifest.EdgeItem[])edges.toArray(ClassTag$.MODULE$.apply(Manifest.EdgeItem.class)), (Manifest.PropertyItem[])properties.toArray(ClassTag$.MODULE$.apply(Manifest.PropertyItem.class)), Manifest$GraphItem$.MODULE$.$lessinit$greater$default$4(), Manifest$GraphItem$.MODULE$.$lessinit$greater$default$5());
        writer.finish(manifest);
        this.logger().debug(new StringBuilder(40).append("wrote ").append(nodes.size()).append(" nodes with ").append(edges.size()).append(" edges and ").append(properties.size()).append(" properties").toString());
        return Serialization$Counts$.MODULE$.apply(nodes.size(), edges.size(), properties.size());
    }

    public Manifest.OutlineStorage write(byte[] bytes, Manifest.OutlineStorage res, AtomicLong filePtr, FileChannel fileChannel) {
        res.decompressedLength_$eq(bytes.length);
        byte[] compressed = (byte[])ZstdWrapper$.MODULE$.apply(() -> Serialization$.$anonfun$3(bytes));
        long outPos = filePtr.getAndAdd(Int$.MODULE$.int2long(compressed.length));
        res.startOffset_$eq(outPos);
        res.compressedLength_$eq(compressed.length);
        ByteBuffer buf = ByteBuffer.wrap(compressed);
        while (buf.hasRemaining()) {
            outPos += (long)fileChannel.write(buf, outPos);
        }
        return res;
    }

    private void ensureParentDirectoryExists(Path path) {
        Option option = Option$.MODULE$.apply((Object)path.getParent());
        if (option instanceof Some) {
            Path dir = (Path)((Some)option).value();
            if (Files.notExists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private final /* synthetic */ ArrayBuffer innerWriteGraph$$anonfun$1(Graph graph$1, ArrayBuffer nodes$1, int nodeKind) {
        String nodeLabel = graph$1.schema().getNodeLabel(nodeKind);
        Object object = Predef$.MODULE$.refArrayOps(graph$1.nodesArray()[nodeKind]);
        int[] deletions = (int[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(GNode x) {
                GNode deleted;
                GNode gNode = x;
                return gNode != null && AccessHelpers.isDeleted(deleted = gNode);
            }

            public final Object applyOrElse(GNode x, Function1 function1) {
                GNode deleted;
                GNode gNode = x;
                if (gNode != null && AccessHelpers.isDeleted(deleted = gNode)) {
                    return BoxesRunTime.boxToInteger((int)deleted.seq());
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(Integer.TYPE));
        int size = graph$1.nodeCountByKind(nodeKind);
        return nodes$1.addOne((Object)new Manifest.NodeItem(nodeLabel, size, deletions));
    }

    private static final byte[] $anonfun$3(byte[] bytes$2) {
        return Zstd.compress((byte[])bytes$2);
    }
}

