/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.storage;

import flatgraph.Edge$Direction$;
import flatgraph.storage.Manifest$EdgeItem$;
import flatgraph.storage.Manifest$GraphItem$;
import flatgraph.storage.Manifest$NodeItem$;
import flatgraph.storage.Manifest$OutlineStorage$;
import flatgraph.storage.Manifest$PropertyItem$;
import ujson.Value;

public final class Manifest {

    public static class EdgeItem {
        private final String nodeLabel;
        private final String edgeLabel;
        private final byte inout;
        private OutlineStorage qty;
        private OutlineStorage neighbors;
        private OutlineStorage property;

        public static EdgeItem read(Value value) {
            return Manifest$EdgeItem$.MODULE$.read(value);
        }

        public static Value write(EdgeItem edgeItem) {
            return Manifest$EdgeItem$.MODULE$.write(edgeItem);
        }

        public static OutlineStorage $lessinit$greater$default$4() {
            return Manifest$EdgeItem$.MODULE$.$lessinit$greater$default$4();
        }

        public static OutlineStorage $lessinit$greater$default$5() {
            return Manifest$EdgeItem$.MODULE$.$lessinit$greater$default$5();
        }

        public static OutlineStorage $lessinit$greater$default$6() {
            return Manifest$EdgeItem$.MODULE$.$lessinit$greater$default$6();
        }

        public EdgeItem(String nodeLabel, String edgeLabel, byte inout, OutlineStorage qty, OutlineStorage neighbors, OutlineStorage property) {
            this.nodeLabel = nodeLabel;
            this.edgeLabel = edgeLabel;
            this.inout = inout;
            this.qty = qty;
            this.neighbors = neighbors;
            this.property = property;
            Edge$Direction$.MODULE$.verifyEncodingRange(inout);
        }

        public String nodeLabel() {
            return this.nodeLabel;
        }

        public String edgeLabel() {
            return this.edgeLabel;
        }

        public byte inout() {
            return this.inout;
        }

        public OutlineStorage qty() {
            return this.qty;
        }

        public void qty_$eq(OutlineStorage x$1) {
            this.qty = x$1;
        }

        public OutlineStorage neighbors() {
            return this.neighbors;
        }

        public void neighbors_$eq(OutlineStorage x$1) {
            this.neighbors = x$1;
        }

        public OutlineStorage property() {
            return this.property;
        }

        public void property_$eq(OutlineStorage x$1) {
            this.property = x$1;
        }
    }

    public static class GraphItem {
        private NodeItem[] nodes;
        private EdgeItem[] edges;
        private PropertyItem[] properties;
        private final OutlineStorage stringPoolLength;
        private final OutlineStorage stringPoolBytes;
        private int version;

        public static GraphItem read(Value value) {
            return Manifest$GraphItem$.MODULE$.read(value);
        }

        public static Value write(GraphItem graphItem) {
            return Manifest$GraphItem$.MODULE$.write(graphItem);
        }

        public static OutlineStorage $lessinit$greater$default$4() {
            return Manifest$GraphItem$.MODULE$.$lessinit$greater$default$4();
        }

        public static OutlineStorage $lessinit$greater$default$5() {
            return Manifest$GraphItem$.MODULE$.$lessinit$greater$default$5();
        }

        public GraphItem(NodeItem[] nodes, EdgeItem[] edges, PropertyItem[] properties, OutlineStorage stringPoolLength, OutlineStorage stringPoolBytes) {
            this.nodes = nodes;
            this.edges = edges;
            this.properties = properties;
            this.stringPoolLength = stringPoolLength;
            this.stringPoolBytes = stringPoolBytes;
            this.version = 0;
        }

        public NodeItem[] nodes() {
            return this.nodes;
        }

        public void nodes_$eq(NodeItem[] x$1) {
            this.nodes = x$1;
        }

        public EdgeItem[] edges() {
            return this.edges;
        }

        public void edges_$eq(EdgeItem[] x$1) {
            this.edges = x$1;
        }

        public PropertyItem[] properties() {
            return this.properties;
        }

        public void properties_$eq(PropertyItem[] x$1) {
            this.properties = x$1;
        }

        public OutlineStorage stringPoolLength() {
            return this.stringPoolLength;
        }

        public OutlineStorage stringPoolBytes() {
            return this.stringPoolBytes;
        }

        public int version() {
            return this.version;
        }

        public void version_$eq(int x$1) {
            this.version = x$1;
        }
    }

    public static class NodeItem {
        private final String nodeLabel;
        private final int nnodes;
        private int[] deletions;

        public static NodeItem read(Value value) {
            return Manifest$NodeItem$.MODULE$.read(value);
        }

        public static Value write(NodeItem nodeItem) {
            return Manifest$NodeItem$.MODULE$.write(nodeItem);
        }

        public NodeItem(String nodeLabel, int nnodes, int[] deletions) {
            this.nodeLabel = nodeLabel;
            this.nnodes = nnodes;
            this.deletions = deletions;
        }

        public String nodeLabel() {
            return this.nodeLabel;
        }

        public int nnodes() {
            return this.nnodes;
        }

        public int[] deletions() {
            return this.deletions;
        }

        public void deletions_$eq(int[] x$1) {
            this.deletions = x$1;
        }
    }

    public static class OutlineStorage {
        private String typ = null;
        private long startOffset = -1L;
        private int compressedLength = -1;
        private int decompressedLength = -1;

        public static OutlineStorage read(String string, Value value) {
            return Manifest$OutlineStorage$.MODULE$.read(string, value);
        }

        public static OutlineStorage read(Value value) {
            return Manifest$OutlineStorage$.MODULE$.read(value);
        }

        public static Value write(OutlineStorage outlineStorage) {
            return Manifest$OutlineStorage$.MODULE$.write(outlineStorage);
        }

        public OutlineStorage() {
        }

        public String typ() {
            return this.typ;
        }

        public void typ_$eq(String x$1) {
            this.typ = x$1;
        }

        public long startOffset() {
            return this.startOffset;
        }

        public void startOffset_$eq(long x$1) {
            this.startOffset = x$1;
        }

        public int compressedLength() {
            return this.compressedLength;
        }

        public void compressedLength_$eq(int x$1) {
            this.compressedLength = x$1;
        }

        public int decompressedLength() {
            return this.decompressedLength;
        }

        public void decompressedLength_$eq(int x$1) {
            this.decompressedLength = x$1;
        }

        public OutlineStorage(String _typ) {
            this();
            this.typ_$eq(_typ);
        }

        public String toString() {
            return new StringBuilder(0).append(super.toString()).append(new StringBuilder(8).append("(").append(this.typ()).append(", ").append(this.startOffset()).append(", ").append(this.compressedLength()).append(", ").append(this.decompressedLength()).append(")").toString()).toString();
        }
    }

    public static class PropertyItem {
        private final String nodeLabel;
        private final String propertyLabel;
        private OutlineStorage qty;
        private OutlineStorage property;

        public static PropertyItem read(Value value) {
            return Manifest$PropertyItem$.MODULE$.read(value);
        }

        public static Value write(PropertyItem propertyItem) {
            return Manifest$PropertyItem$.MODULE$.write(propertyItem);
        }

        public static OutlineStorage $lessinit$greater$default$3() {
            return Manifest$PropertyItem$.MODULE$.$lessinit$greater$default$3();
        }

        public static OutlineStorage $lessinit$greater$default$4() {
            return Manifest$PropertyItem$.MODULE$.$lessinit$greater$default$4();
        }

        public PropertyItem(String nodeLabel, String propertyLabel, OutlineStorage qty, OutlineStorage property) {
            this.nodeLabel = nodeLabel;
            this.propertyLabel = propertyLabel;
            this.qty = qty;
            this.property = property;
        }

        public String nodeLabel() {
            return this.nodeLabel;
        }

        public String propertyLabel() {
            return this.propertyLabel;
        }

        public OutlineStorage qty() {
            return this.qty;
        }

        public void qty_$eq(OutlineStorage x$1) {
            this.qty = x$1;
        }

        public OutlineStorage property() {
            return this.property;
        }

        public void property_$eq(OutlineStorage x$1) {
            this.property = x$1;
        }
    }
}

