/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.storage;

import flatgraph.AccessHelpers;
import flatgraph.Edge;
import flatgraph.Edge$Direction$;
import flatgraph.FreeSchema;
import flatgraph.FreeSchema$;
import flatgraph.GNode;
import flatgraph.Graph;
import flatgraph.Schema;
import flatgraph.misc.Conversions$;
import flatgraph.misc.Misc$;
import flatgraph.storage.Deserialization;
import flatgraph.storage.Deserialization$DeserializationException$;
import flatgraph.storage.Manifest;
import flatgraph.storage.Manifest$GraphItem$;
import flatgraph.storage.ZstdWrapper;
import flatgraph.storage.package$;
import flatgraph.storage.package$Keys$;
import flatgraph.storage.package$StorageType$;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Byte$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Short$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;

public final class Deserialization$
implements Serializable {
    private static final Logger logger;
    public static final Deserialization$DeserializationException$ DeserializationException;
    public static final Deserialization$ MODULE$;

    private Deserialization$() {
    }

    static {
        MODULE$ = new Deserialization$();
        logger = LoggerFactory.getLogger(Deserialization$.class);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Deserialization$.class);
    }

    public Graph readGraph(Path storagePath, Option<Schema> schemaMaybe, boolean persistOnClose, Option<ExecutorService> requestedExecutor) {
        Graph graph;
        ExecutorService executor = Misc$.MODULE$.maybeOverrideExecutor(requestedExecutor);
        FileChannel fileChannel = new RandomAccessFile(storagePath.toAbsolutePath().toFile(), "r").getChannel();
        ArrayBuffer queue = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[0]));
        ZstdWrapper.ZstdCtx zstdCtx = new ZstdWrapper.ZstdCtx();
        try {
            try {
                Manifest.GraphItem manifest = Manifest$GraphItem$.MODULE$.read(this.readManifest(fileChannel));
                logger.debug(new StringBuilder(46).append("loading graph with ").append(manifest.nodes().length).append(" nodes, ").append(manifest.edges().length).append(" edges, ").append(manifest.properties().length).append(" properties").toString());
                Future pool = this.submitJob$1(executor, queue, () -> Deserialization$.$anonfun$2(manifest, fileChannel, zstdCtx));
                Schema schema = (Schema)schemaMaybe.getOrElse(() -> Deserialization$.$anonfun$3(manifest));
                None$ storagePathMaybe = persistOnClose ? Option$.MODULE$.apply((Object)storagePath) : None$.MODULE$;
                Graph g = new Graph(schema, (Option<Path>)storagePathMaybe);
                HashMap nodekinds = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                g.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> nodekinds.update((Object)g.schema().getNodeLabel(nodeKind), (Object)BoxesRunTime.boxToShort((short)Conversions$.MODULE$.toShortSafely(nodeKind))));
                GNode[][] nodeRemapper = new GNode[manifest.nodes().length][];
                Object object = Predef$.MODULE$.refArrayOps((Object[])manifest.nodes());
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
                ArrayOps$.MODULE$.withFilter$extension(object2, (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Manifest.NodeItem nodeItem = (Manifest.NodeItem)tuple2._1();
                        int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        return true;
                    }
                    return false;
                }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Manifest.NodeItem nodeItem = (Manifest.NodeItem)tuple2._1();
                        int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        nodekinds.get((Object)nodeItem.nodeLabel()).foreach((Function1 & Serializable)v1 -> {
                            Deserialization$.readGraph$$anonfun$3$$anonfun$1(nodeItem, g, nodeRemapper, idx, BoxesRunTime.unboxToShort((Object)v1));
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                HashMap edgeKinds = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                g.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> g.schema().edgeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)edgeKind -> {
                    String nodeLabel = g.schema().getNodeLabel(nodeKind);
                    String edgeLabel = g.schema().getEdgeLabel(nodeKind, edgeKind);
                    if (edgeLabel != null) {
                        edgeKinds.update((Object)Tuple2$.MODULE$.apply((Object)nodeLabel, (Object)edgeLabel), (Object)BoxesRunTime.boxToShort((short)Conversions$.MODULE$.toShortSafely(edgeKind)));
                        return;
                    }
                }));
                Object object3 = Predef$.MODULE$.refArrayOps((Object[])manifest.edges());
                ArrayOps$.MODULE$.foreach$extension(object3, (Function1)(JProcedure1 & Serializable)edgeItem -> {
                    Option nodeKind = nodekinds.get((Object)edgeItem.nodeLabel());
                    Option edgeKind = edgeKinds.get((Object)Tuple2$.MODULE$.apply((Object)edgeItem.nodeLabel(), (Object)edgeItem.edgeLabel()));
                    Edge.Direction direction = Edge$Direction$.MODULE$.fromOrdinal(Byte$.MODULE$.byte2int(edgeItem.inout()));
                    if (nodeKind.isDefined() && edgeKind.isDefined()) {
                        int pos = g.schema().neighborOffsetArrayIndex(Short$.MODULE$.short2int(BoxesRunTime.unboxToShort((Object)nodeKind.get())), direction, Short$.MODULE$.short2int(BoxesRunTime.unboxToShort((Object)edgeKind.get())));
                        this.submitJob$1(executor, queue, (Function0 & Serializable)() -> {
                            Deserialization$.readGraph$$anonfun$5$$anonfun$1(g, pos, fileChannel, edgeItem, nodeRemapper, pool, zstdCtx);
                            return BoxedUnit.UNIT;
                        });
                        this.submitJob$1(executor, queue, (Function0 & Serializable)() -> {
                            Deserialization$.readGraph$$anonfun$5$$anonfun$2(g, pos, fileChannel, edgeItem, nodeRemapper, pool, zstdCtx);
                            return BoxedUnit.UNIT;
                        });
                        this.submitJob$1(executor, queue, (Function0 & Serializable)() -> {
                            Deserialization$.readGraph$$anonfun$5$$anonfun$3(fileChannel, edgeItem, nodeRemapper, pool, zstdCtx, g, pos);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                });
                HashMap propertykinds = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                g.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> g.schema().propertyKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)propertyKind -> {
                    String nodeLabel = g.schema().getNodeLabel(nodeKind);
                    String propertyLabel = g.schema().getPropertyLabel(nodeKind, propertyKind);
                    if (propertyLabel != null) {
                        propertykinds.update((Object)Tuple2$.MODULE$.apply((Object)nodeLabel, (Object)propertyLabel), (Object)BoxesRunTime.boxToInteger((int)propertyKind));
                        return;
                    }
                }));
                Object object4 = Predef$.MODULE$.refArrayOps((Object[])manifest.properties());
                ArrayOps$.MODULE$.foreach$extension(object4, (Function1)(JProcedure1 & Serializable)property -> {
                    Option nodeKind = nodekinds.get((Object)property.nodeLabel());
                    Option propertyKind = propertykinds.get((Object)Tuple2$.MODULE$.apply((Object)property.nodeLabel(), (Object)property.propertyLabel()));
                    if (nodeKind.isDefined() && propertyKind.isDefined()) {
                        int pos = g.schema().propertyOffsetArrayIndex(Short$.MODULE$.short2int(BoxesRunTime.unboxToShort((Object)nodeKind.get())), BoxesRunTime.unboxToInt((Object)propertyKind.get()));
                        this.submitJob$1(executor, queue, (Function0 & Serializable)() -> {
                            Deserialization$.readGraph$$anonfun$7$$anonfun$1(g, pos, fileChannel, property, nodeRemapper, pool, zstdCtx);
                            return BoxedUnit.UNIT;
                        });
                        this.submitJob$1(executor, queue, (Function0 & Serializable)() -> {
                            Deserialization$.readGraph$$anonfun$7$$anonfun$2(g, pos, fileChannel, property, nodeRemapper, pool, zstdCtx);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                });
                queue.foreach((Function1 & Serializable)_$1 -> _$1.get());
                graph = g;
            }
            catch (ExecutionException ex) {
                throw ex.getCause();
            }
        }
        finally {
            fileChannel.close();
            zstdCtx.close();
        }
        return graph;
    }

    public boolean readGraph$default$3() {
        return true;
    }

    public Option<ExecutorService> readGraph$default$4() {
        return None$.MODULE$;
    }

    private FreeSchema freeSchemaFromManifest(Manifest.GraphItem manifest) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])manifest.nodes());
        String[] nodeLabels = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)n -> n.nodeLabel(), ClassTag$.MODULE$.apply(String.class));
        LinkedHashMap nodePropNames = LinkedHashMap$.MODULE$.empty();
        LinkedHashMap propertyNamesByNodeLabel = LinkedHashMap$.MODULE$.empty();
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])manifest.properties());
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)prop -> {
            propertyNamesByNodeLabel.updateWith((Object)prop.nodeLabel(), (Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (None$.MODULE$.equals(option)) {
                    return Some$.MODULE$.apply(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{prop.propertyLabel()})));
                }
                if (option instanceof Some) {
                    Set oldEntries = (Set)((Some)option).value();
                    return Some$.MODULE$.apply((Object)oldEntries.$plus((Object)prop.propertyLabel()));
                }
                throw new MatchError((Object)option);
            });
            nodePropNames.update((Object)prop.propertyLabel(), MODULE$.protoFromOutline(prop.property()));
        });
        String[] propertyLabels = (String[])nodePropNames.keysIterator().toArray(ClassTag$.MODULE$.apply(String.class));
        Object[] nodePropertyPrototypes = (Object[])nodePropNames.valuesIterator().toArray(ClassTag$.MODULE$.apply(Object.class));
        LinkedHashMap edgePropNames = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])manifest.edges());
        ArrayOps$.MODULE$.foreach$extension(object3, (Function1)(JProcedure1 & Serializable)edge -> {
            Option option = edgePropNames.get((Object)edge.edgeLabel());
            if (None$.MODULE$.equals(option) || option instanceof Some && ((Some)option).value() == null) {
                edgePropNames.update((Object)edge.edgeLabel(), MODULE$.protoFromOutline(edge.property()));
                return;
            }
        });
        String[] edgeLabels = (String[])edgePropNames.keysIterator().toArray(ClassTag$.MODULE$.apply(String.class));
        Object[] edgePropertyPrototypes = (Object[])edgePropNames.valuesIterator().toArray(ClassTag$.MODULE$.apply(Object.class));
        return new FreeSchema(nodeLabels, propertyLabels, nodePropertyPrototypes, (Map<String, Set<String>>)propertyNamesByNodeLabel.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), edgeLabels, edgePropertyPrototypes, FreeSchema$.MODULE$.$lessinit$greater$default$7());
    }

    private Object protoFromOutline(Manifest.OutlineStorage outline) {
        if (outline == null) {
            return null;
        }
        String string = outline.typ();
        String string2 = package$StorageType$.MODULE$.Bool();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new boolean[0];
        }
        String string4 = package$StorageType$.MODULE$.Byte();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new byte[0];
        }
        String string6 = package$StorageType$.MODULE$.Short();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return new short[0];
        }
        String string8 = package$StorageType$.MODULE$.Int();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return new int[0];
        }
        String string10 = package$StorageType$.MODULE$.Long();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return new long[0];
        }
        String string12 = package$StorageType$.MODULE$.Float();
        String string13 = string;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            return new float[0];
        }
        String string14 = package$StorageType$.MODULE$.Double();
        String string15 = string;
        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
            return new double[0];
        }
        String string16 = package$StorageType$.MODULE$.Ref();
        String string17 = string;
        if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
            return new GNode[0];
        }
        String string18 = package$StorageType$.MODULE$.String();
        String string19 = string;
        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
            return new String[0];
        }
        throw new MatchError((Object)string);
    }

    public Value readManifest(FileChannel channel) {
        int readBytes;
        if (channel.size() < (long)package$.MODULE$.HeaderSize()) {
            throw new Deserialization.DeserializationException(new StringBuilder(55).append("corrupt file, expected at least ").append(package$.MODULE$.HeaderSize()).append(" bytes, but only found ").append(channel.size()).toString(), Deserialization$DeserializationException$.MODULE$.$lessinit$greater$default$2());
        }
        ByteBuffer header = ByteBuffer.allocate(package$.MODULE$.HeaderSize()).order(ByteOrder.LITTLE_ENDIAN);
        for (readBytes = 0; readBytes < package$.MODULE$.HeaderSize(); readBytes += channel.read(header, Int$.MODULE$.int2long(readBytes))) {
        }
        header.flip();
        byte[] headerBytes = new byte[package$Keys$.MODULE$.Header().length];
        header.get(headerBytes);
        if (!Arrays.equals(headerBytes, package$Keys$.MODULE$.Header())) {
            throw new Deserialization.DeserializationException(new StringBuilder(37).append("expected header '").append(package$.MODULE$.MagicBytesString()).append("' (`").append(Predef$.MODULE$.wrapByteArray(package$Keys$.MODULE$.Header()).mkString("")).append("`), but found '").append(Predef$.MODULE$.wrapByteArray(headerBytes).mkString("")).append("'").toString(), Deserialization$DeserializationException$.MODULE$.$lessinit$greater$default$2());
        }
        long manifestOffset = header.getLong();
        long manifestSize = channel.size() - manifestOffset;
        ByteBuffer manifestBytes = ByteBuffer.allocate((int)manifestSize);
        readBytes = 0;
        while ((long)readBytes < manifestSize) {
            readBytes += channel.read(manifestBytes, (long)readBytes + manifestOffset);
        }
        manifestBytes.flip();
        return ujson.package$.MODULE$.read((Readable)Readable$.MODULE$.fromByteBuffer(manifestBytes), ujson.package$.MODULE$.read$default$2());
    }

    private String[] readPool(Manifest.GraphItem manifest, FileChannel fileChannel, ZstdWrapper.ZstdCtx zstdCtx) {
        ByteBuffer stringPoolLength = zstdCtx.decompress(fileChannel.map(FileChannel.MapMode.READ_ONLY, manifest.stringPoolLength().startOffset(), Int$.MODULE$.int2long(manifest.stringPoolLength().compressedLength())), manifest.stringPoolLength().decompressedLength());
        ByteBuffer stringPoolBytes = zstdCtx.decompress(fileChannel.map(FileChannel.MapMode.READ_ONLY, manifest.stringPoolBytes().startOffset(), Int$.MODULE$.int2long(manifest.stringPoolBytes().compressedLength())), manifest.stringPoolBytes().decompressedLength());
        byte[] poolBytes = new byte[manifest.stringPoolBytes().decompressedLength()];
        stringPoolBytes.get(poolBytes);
        String[] pool = new String[manifest.stringPoolLength().decompressedLength() >> 2];
        int idx = 0;
        int poolPtr = 0;
        while (idx < pool.length) {
            int len = stringPoolLength.getInt();
            pool[idx] = new String(poolBytes, poolPtr, len, StandardCharsets.UTF_8);
            ++idx;
            poolPtr += len;
        }
        return pool;
    }

    private int[] deltaDecode(int[] a) {
        if (a == null) {
            return null;
        }
        int cumsum = 0;
        for (int idx = 0; idx < a.length; ++idx) {
            int tmp = a[idx];
            a[idx] = cumsum;
            cumsum += tmp;
        }
        return a;
    }

    private Object readArray(FileChannel channel, Manifest.OutlineStorage ptr, GNode[][] nodes, Future<String[]> stringPoolFuture, ZstdWrapper.ZstdCtx zstdCtx) {
        if (ptr == null) {
            return null;
        }
        String string = ptr.typ();
        String string2 = package$StorageType$.MODULE$.String();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            stringPoolFuture.get();
        }
        ByteBuffer dec = zstdCtx.decompress(channel.map(FileChannel.MapMode.READ_ONLY, ptr.startOffset(), Int$.MODULE$.int2long(ptr.compressedLength())), ptr.decompressedLength());
        String string3 = ptr.typ();
        String string4 = package$StorageType$.MODULE$.Bool();
        String string5 = string3;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            byte[] bytes = new byte[dec.limit()];
            dec.get(bytes);
            Object object = Predef$.MODULE$.byteArrayOps(bytes);
            return ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> Deserialization$.readArray$$anonfun$1(BoxesRunTime.unboxToByte((Object)x$1)), ClassTag$.MODULE$.apply(Boolean.TYPE));
        }
        String string6 = package$StorageType$.MODULE$.Byte();
        String string7 = string3;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            byte[] bytes = new byte[dec.limit()];
            dec.get(bytes);
            return bytes;
        }
        String string8 = package$StorageType$.MODULE$.Short();
        String string9 = string3;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            short[] res = new short[dec.limit() >> 1];
            dec.asShortBuffer().get(res);
            return res;
        }
        String string10 = package$StorageType$.MODULE$.Int();
        String string11 = string3;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            int[] res = new int[dec.limit() >> 2];
            dec.asIntBuffer().get(res);
            return res;
        }
        String string12 = package$StorageType$.MODULE$.Long();
        String string13 = string3;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            long[] res = new long[dec.limit() >> 3];
            dec.asLongBuffer().get(res);
            return res;
        }
        String string14 = package$StorageType$.MODULE$.Float();
        String string15 = string3;
        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
            float[] res = new float[dec.limit() >> 2];
            dec.asFloatBuffer().get(res);
            return res;
        }
        String string16 = package$StorageType$.MODULE$.Double();
        String string17 = string3;
        if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
            double[] res = new double[dec.limit() >> 3];
            dec.asDoubleBuffer().get(res);
            return res;
        }
        String string18 = package$StorageType$.MODULE$.String();
        String string19 = string3;
        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
            String[] stringPool = stringPoolFuture.get();
            String[] res = new String[dec.limit() >> 2];
            IntBuffer intbuf = dec.asIntBuffer();
            for (int idx = 0; idx < res.length; ++idx) {
                int offset = intbuf.get(idx);
                if (offset < 0) continue;
                res[idx] = stringPool[offset];
            }
            return res;
        }
        String string20 = package$StorageType$.MODULE$.Ref();
        String string21 = string3;
        if (!(string20 != null ? !string20.equals(string21) : string21 != null)) {
            GNode[] res = new GNode[dec.limit() >> 3];
            LongBuffer longbuf = dec.asLongBuffer();
            for (int idx = 0; idx < res.length; ++idx) {
                long encodedRef = longbuf.get();
                int kind = (int)(encodedRef >>> 32);
                int seqid = (int)encodedRef;
                if (kind < 0 || kind >= nodes.length) continue;
                res[idx] = nodes[kind][seqid];
            }
            return res;
        }
        throw new MatchError((Object)string3);
    }

    private final Future submitJob$1(ExecutorService executor$1, ArrayBuffer queue$1, Function0 block) {
        Future<Object> res = executor$1.submit(() -> block.apply());
        queue$1.addOne(res);
        return res;
    }

    private static final String[] $anonfun$2(Manifest.GraphItem manifest$1, FileChannel fileChannel$1, ZstdWrapper.ZstdCtx zstdCtx$1) {
        return MODULE$.readPool(manifest$1, fileChannel$1, zstdCtx$1);
    }

    private static final Schema $anonfun$3(Manifest.GraphItem manifest$2) {
        return MODULE$.freeSchemaFromManifest(manifest$2);
    }

    private static final /* synthetic */ void readGraph$$anonfun$3$$anonfun$1(Manifest.NodeItem nodeItem$1, Graph g$3, GNode[][] nodeRemapper$2, int idx$1, short nodeKind) {
        GNode[] nodes = new GNode[nodeItem$1.nnodes()];
        scala.package$.MODULE$.Range().apply(0, nodes.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)seq -> {
            nodes$1[seq] = g$3.schema().makeNode(g$3, nodeKind, seq);
        });
        g$3.nodesArray()[Short$.MODULE$.short2int((short)nodeKind)] = nodes;
        nodeRemapper$2[idx$1] = nodes;
        if (nodeItem$1.deletions() != null) {
            Object object = Predef$.MODULE$.intArrayOps(nodeItem$1.deletions());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JFunction1.mcVI.sp & Serializable)del -> {
                GNode node = nodes[del];
                if (!AccessHelpers.isDeleted(node)) {
                    AccessHelpers.markDeleted(nodes[del]);
                    return;
                }
                throw new RuntimeException();
            });
            g$3.livingNodeCountByKind()[Short$.MODULE$.short2int((short)nodeKind)] = nodes.length - nodeItem$1.deletions().length;
            return;
        }
        g$3.livingNodeCountByKind()[Short$.MODULE$.short2int((short)nodeKind)] = nodes.length;
    }

    private static final void readGraph$$anonfun$5$$anonfun$1(Graph g$8, int pos$1, FileChannel fileChannel$3, Manifest.EdgeItem edgeItem$1, GNode[][] nodeRemapper$4, Future pool$2, ZstdWrapper.ZstdCtx zstdCtx$3) {
        g$8.neighbors()[pos$1] = MODULE$.deltaDecode((int[])MODULE$.readArray(fileChannel$3, edgeItem$1.qty(), nodeRemapper$4, pool$2, zstdCtx$3));
    }

    private static final void readGraph$$anonfun$5$$anonfun$2(Graph g$9, int pos$2, FileChannel fileChannel$4, Manifest.EdgeItem edgeItem$2, GNode[][] nodeRemapper$5, Future pool$3, ZstdWrapper.ZstdCtx zstdCtx$4) {
        g$9.neighbors()[pos$2 + 1] = MODULE$.readArray(fileChannel$4, edgeItem$2.neighbors(), nodeRemapper$5, pool$3, zstdCtx$4);
    }

    private static final void readGraph$$anonfun$5$$anonfun$3(FileChannel fileChannel$5, Manifest.EdgeItem edgeItem$3, GNode[][] nodeRemapper$6, Future pool$4, ZstdWrapper.ZstdCtx zstdCtx$5, Graph g$10, int pos$3) {
        Object property = MODULE$.readArray(fileChannel$5, edgeItem$3.property(), nodeRemapper$6, pool$4, zstdCtx$5);
        if (property != null) {
            g$10.neighbors()[pos$3 + 2] = property;
            return;
        }
    }

    private static final void readGraph$$anonfun$7$$anonfun$1(Graph g$14, int pos$4, FileChannel fileChannel$7, Manifest.PropertyItem property$1, GNode[][] nodeRemapper$8, Future pool$6, ZstdWrapper.ZstdCtx zstdCtx$7) {
        g$14.properties()[pos$4] = MODULE$.deltaDecode((int[])MODULE$.readArray(fileChannel$7, property$1.qty(), nodeRemapper$8, pool$6, zstdCtx$7));
    }

    private static final void readGraph$$anonfun$7$$anonfun$2(Graph g$15, int pos$5, FileChannel fileChannel$8, Manifest.PropertyItem property$2, GNode[][] nodeRemapper$9, Future pool$7, ZstdWrapper.ZstdCtx zstdCtx$8) {
        g$15.properties()[pos$5 + 1] = MODULE$.readArray(fileChannel$8, property$2.property(), nodeRemapper$9, pool$7, zstdCtx$8);
    }

    private static final /* synthetic */ boolean readArray$$anonfun$1(byte x$1) {
        byte by = x$1;
        if (0 == by) {
            return false;
        }
        if (1 == by) {
            return true;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }
}

