/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.misc;

import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public class MultiDictIndex<A> {
    private final int size;
    private final String[] keys;
    private final Object[] values;
    private boolean finalized;

    public MultiDictIndex(int sizeHint) {
        this.size = sizeHint + (sizeHint >> 1);
        this.keys = new String[this.size];
        this.values = new Object[this.size];
        this.finalized = false;
    }

    public void insert(String key, A value) {
        if (key == null) {
            return;
        }
        if (this.finalized) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"Cannot insert into finalized index");
        }
        int position = this.hashToPos(key.hashCode());
        boolean overflowed = false;
        while (true) {
            String k;
            if (position >= this.size) {
                if (overflowed) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(105).append("We've tried all possible slots, none of which was available - please allocate a large-enough index! size=").append(this.size).toString());
                }
                position = 0;
                overflowed = true;
            }
            if ((k = this.keys[position]) == null) {
                this.keys[position] = key;
                this.values[position] = value;
                return;
            }
            String string = k;
            String string2 = key;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                ArrayBuffer arrayBuffer;
                Object object = this.values[position];
                if (object instanceof ArrayBuffer) {
                    ArrayBuffer multiple = (ArrayBuffer)object;
                    arrayBuffer = multiple.addOne(value);
                } else if (object != null) {
                    Object single = object;
                    this.values[position] = ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{single, value}));
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(object);
                }
                return;
            }
            ++position;
        }
    }

    public void shrinkFit() {
        for (int idx = 0; idx < this.size; ++idx) {
            Object object = this.values[idx];
            if (!(object instanceof ArrayBuffer)) continue;
            ArrayBuffer buf = (ArrayBuffer)object;
            this.values[idx] = buf.toArray(ClassTag$.MODULE$.apply(Object.class));
        }
        this.finalized = true;
    }

    public Iterator<A> get(String key) {
        if (key == null) {
            return null;
        }
        if (!this.finalized) {
            throw new RuntimeException("Cannot lookup in an index that's not finalized - please invoke `shrinkFit` first");
        }
        int position = this.hashToPos(key.hashCode());
        boolean overflowed = false;
        while (true) {
            if (position >= this.size) {
                if (!overflowed) {
                    position = 0;
                    overflowed = true;
                } else {
                    return package$.MODULE$.Iterator().empty();
                }
            }
            if (this.keys.length <= position || this.keys[position] == null) {
                return package$.MODULE$.Iterator().empty();
            }
            String string = this.keys[position];
            String string2 = key;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Object object = this.values[position];
                if (object instanceof Object[]) {
                    Object[] multiple = (Object[])object;
                    Object object2 = Predef$.MODULE$.refArrayOps(multiple);
                    return ArrayOps$.MODULE$.iterator$extension(object2);
                }
                if (object != null) {
                    Object single = object;
                    return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{single}));
                }
                throw new MatchError(object);
            }
            ++position;
        }
        throw new RuntimeException("unreachable");
    }

    private int hashToPos(int hash0) {
        int hash = hash0 ^ hash0 >>> 16;
        hash *= -2048144789;
        hash ^= hash >>> 13;
        hash *= -1028477387;
        hash ^= hash >>> 16;
        return (int)(((long)hash & 0xFFFFFFFFL) * (long)this.size >> 32);
    }
}

