/*
 * Decompiled with CFR 0.152.
 */
package flatgraph;

import flatgraph.DNodeOrNode;
import flatgraph.Graph;
import flatgraph.misc.DebugDump;
import java.util.Objects;

public class GNode
implements DNodeOrNode {
    public final Graph graph;
    public final short nodeKind;
    public static final long ID_SEQ_MASK = 0xFFFFFFFFL;
    public static final int ID_KIND_SHIFT = 32;
    int _seqId;
    boolean _isDeleted = false;

    public final int seq() {
        return this._seqId;
    }

    public final long id() {
        return GNode.computeId(this.nodeKind, this.seq());
    }

    public GNode(Graph graph, short nodeKind, int seqId) {
        this.nodeKind = nodeKind;
        this._seqId = seqId;
        this.graph = graph;
    }

    public String label() {
        return this.graph.schema().getNodeLabel(this.nodeKind);
    }

    public String toString() {
        return this.getClass().getName() + "[label=" + this.label() + "; seq=" + this.seq() + "; id=" + this.id() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.graph, this.nodeKind, this._seqId);
    }

    public static long computeId(int nodeKind, int seq) {
        return (long)nodeKind << 32 | (long)seq & 0xFFFFFFFFL;
    }

    public static int extractKind(long id) {
        return (int)(id >> 32);
    }

    public static int extractSeq(long id) {
        return (int)(id & 0xFFFFFFFFL);
    }

    public static KindAndSeq computeKindAndSeq(long id) {
        return new KindAndSeq(GNode.extractKind(id), GNode.extractSeq(id));
    }

    public Object[] _debugChildren() {
        return DebugDump.debugChildrenScala(this);
    }

    public static class KindAndSeq {
        public final int kind;
        public final int seq;

        public KindAndSeq(int kind, int seq) {
            this.kind = kind;
            this.seq = seq;
        }
    }
}

