/*
 * Decompiled with CFR 0.152.
 */
package flatgraph;

import flatgraph.AccessHelpers;
import flatgraph.Accessors$;
import flatgraph.AddEdgeProcessed;
import flatgraph.DNode;
import flatgraph.DNodeOrNode;
import flatgraph.DefaultValue;
import flatgraph.DefaultValue$;
import flatgraph.DiffGraphApplier$;
import flatgraph.DiffGraphApplier$NewNodeInterface$;
import flatgraph.DiffGraphBuilder;
import flatgraph.Edge;
import flatgraph.Edge$Direction$;
import flatgraph.EdgeRepr;
import flatgraph.GNode;
import flatgraph.Graph;
import flatgraph.NewNodePropertyInsertionHelper;
import flatgraph.Schema;
import flatgraph.SetPropertyDesc;
import flatgraph.UnsupportedOperationException;
import flatgraph.misc.Misc$;
import flatgraph.misc.SchemaViolationReporter;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicIntegerArray;
import scala.;
import scala.$less$colon$less$;
import scala.Byte$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Short$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.ArrayDeque$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ArraySeq$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class DiffGraphApplier {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DiffGraphApplier.class.getDeclaredField("NewNodeInterface$lzy1"));
    public final Graph flatgraph$DiffGraphApplier$$graph;
    private final DiffGraphBuilder diff;
    private final SchemaViolationReporter schemaViolationReporter;
    private final ExecutorService executor;
    private final ArrayBuffer[] newNodes;
    private final ArrayBuffer[] newEdges;
    private final ArrayBuffer[] delEdges;
    private final ArrayBuffer[] setEdgeProperties;
    private final ArrayDeque deferred;
    private final ArrayBuffer delNodes;
    private final ArrayBuffer[] setNodeProperties;
    private final int[] newNodeNewProperties;
    private final AtomicIntegerArray newNodeUsers;
    private final ArrayBuffer jobQueue;
    private volatile Object NewNodeInterface$lzy1;

    public static int applyDiff(Graph graph, DiffGraphBuilder diffGraphBuilder) {
        return DiffGraphApplier$.MODULE$.applyDiff(graph, diffGraphBuilder);
    }

    public static int applyDiff(Graph graph, DiffGraphBuilder diffGraphBuilder, SchemaViolationReporter schemaViolationReporter, Option<ExecutorService> option) {
        return DiffGraphApplier$.MODULE$.applyDiff(graph, diffGraphBuilder, schemaViolationReporter, option);
    }

    public static SchemaViolationReporter applyDiff$default$3() {
        return DiffGraphApplier$.MODULE$.applyDiff$default$3();
    }

    public static Option<ExecutorService> $lessinit$greater$default$4() {
        return DiffGraphApplier$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<ExecutorService> applyDiff$default$4() {
        return DiffGraphApplier$.MODULE$.applyDiff$default$4();
    }

    public DiffGraphApplier(Graph graph, DiffGraphBuilder diff, SchemaViolationReporter schemaViolationReporter, Option<ExecutorService> requestedExecutor) {
        this.flatgraph$DiffGraphApplier$$graph = graph;
        this.diff = diff;
        this.schemaViolationReporter = schemaViolationReporter;
        this.executor = Misc$.MODULE$.maybeOverrideExecutor(requestedExecutor);
        this.newNodes = new ArrayBuffer[graph.schema().getNumberOfNodeKinds()];
        Object object = Predef$.MODULE$.refArrayOps(graph.neighbors());
        this.newEdges = new ArrayBuffer[ArrayOps$.MODULE$.size$extension(object)];
        Object object2 = Predef$.MODULE$.refArrayOps(graph.neighbors());
        this.delEdges = new ArrayBuffer[ArrayOps$.MODULE$.size$extension(object2)];
        Object object3 = Predef$.MODULE$.refArrayOps(graph.neighbors());
        this.setEdgeProperties = new ArrayBuffer[ArrayOps$.MODULE$.size$extension(object3)];
        this.deferred = new ArrayDeque(ArrayDeque$.MODULE$.$lessinit$greater$default$1());
        this.delNodes = new ArrayBuffer();
        Object object4 = Predef$.MODULE$.refArrayOps(graph.properties());
        this.setNodeProperties = new ArrayBuffer[ArrayOps$.MODULE$.size$extension(object4)];
        Object object5 = Predef$.MODULE$.refArrayOps(graph.properties());
        this.newNodeNewProperties = new int[ArrayOps$.MODULE$.size$extension(object5)];
        this.newNodeUsers = new AtomicIntegerArray(graph.schema().getNumberOfNodeKinds());
        this.jobQueue = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[0]));
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public ArrayBuffer<DNode>[] newNodes() {
        return this.newNodes;
    }

    public ArrayBuffer<AddEdgeProcessed>[] newEdges() {
        return this.newEdges;
    }

    public ArrayBuffer<EdgeRepr>[] delEdges() {
        return this.delEdges;
    }

    public ArrayBuffer<EdgeRepr>[] setEdgeProperties() {
        return this.setEdgeProperties;
    }

    public ArrayDeque<DNode> deferred() {
        return this.deferred;
    }

    public ArrayBuffer<GNode> delNodes() {
        return this.delNodes;
    }

    public ArrayBuffer<Object>[] setNodeProperties() {
        return this.setNodeProperties;
    }

    public int[] newNodeNewProperties() {
        return this.newNodeNewProperties;
    }

    public AtomicIntegerArray newNodeUsers() {
        return this.newNodeUsers;
    }

    public ArrayBuffer<Future<BoxedUnit>> jobQueue() {
        return this.jobQueue;
    }

    public final DiffGraphApplier$NewNodeInterface$ NewNodeInterface() {
        Object object = this.NewNodeInterface$lzy1;
        if (object instanceof DiffGraphApplier$NewNodeInterface$) {
            return (DiffGraphApplier$NewNodeInterface$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DiffGraphApplier$NewNodeInterface$)this.NewNodeInterface$lzyINIT1();
    }

    private Object NewNodeInterface$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.NewNodeInterface$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DiffGraphApplier$NewNodeInterface$ diffGraphApplier$NewNodeInterface$ = null;
                    try {
                        diffGraphApplier$NewNodeInterface$ = new DiffGraphApplier$NewNodeInterface$(this);
                        object2 = diffGraphApplier$NewNodeInterface$ == null ? LazyVals.NullValue$.MODULE$ : diffGraphApplier$NewNodeInterface$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.NewNodeInterface$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return diffGraphApplier$NewNodeInterface$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public <T> void submitJob(Function0<BoxedUnit> block) {
        this.jobQueue().addOne(this.executor().submit(() -> {
            block.apply$mcV$sp();
            return BoxedUnit.UNIT;
        }));
    }

    private void insertProperty0(GNode node, int propertyKind, Iterator<Object> propertyValues) {
        int pos = this.flatgraph$DiffGraphApplier$$graph.schema().propertyOffsetArrayIndex(Short$.MODULE$.short2int(node.nodeKind), propertyKind);
        if (0 > pos || pos >= this.setNodeProperties().length) {
            this.schemaViolationReporter.illegalNodeProperty(Short$.MODULE$.short2int(node.nodeKind), BoxesRunTime.boxToInteger((int)propertyKind), this.flatgraph$DiffGraphApplier$$graph.schema());
            return;
        }
        if (this.setNodeProperties()[pos] == null) {
            this.setNodeProperties()[pos] = ArrayBuffer$.MODULE$.empty();
        }
        ArrayBuffer<Object> buf = this.setNodeProperties()[pos];
        int start = buf.size();
        propertyValues.iterator().foreach((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof DNode) {
                DNode dnode = (DNode)object;
                return buf.addOne((Object)this.flatgraph$DiffGraphApplier$$getGNode(dnode));
            }
            Object other = object;
            return buf.addOne(other);
        });
        SetPropertyDesc bound = new SetPropertyDesc(node, start, buf.size());
        this.insert(this.setNodeProperties(), bound, pos + 1);
    }

    private <T> void insert(ArrayBuffer<T>[] a, T item, int pos) {
        if (a[pos] == null) {
            a[pos] = ArrayBuffer$.MODULE$.empty();
        }
        a[pos].append(item);
    }

    private int drainDeferred() {
        int ndiff = 0;
        while (this.deferred().nonEmpty()) {
            ++ndiff;
            ((DNode)this.deferred().removeHead(this.deferred().removeHead$default$1())).countAndVisitProperties(this.NewNodeInterface());
        }
        return ndiff;
    }

    public GNode flatgraph$DiffGraphApplier$$getGNode(DNodeOrNode node) {
        DNodeOrNode dNodeOrNode = node;
        if (dNodeOrNode instanceof GNode) {
            GNode already = (GNode)dNodeOrNode;
            Graph graph = already.graph;
            Graph graph2 = this.flatgraph$DiffGraphApplier$$graph;
            if (graph == null ? graph2 != null : !graph.equals(graph2)) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"expected a different graph instance");
            }
            return already;
        }
        if (dNodeOrNode instanceof DNode) {
            GNode gNode;
            DNode detached = (DNode)dNodeOrNode;
            Option<GNode> option = detached.storedRef();
            if (option instanceof Some && (gNode = (GNode)((Some)option).value()) != null) {
                GNode already = gNode;
                Graph graph = already.graph;
                Graph graph3 = this.flatgraph$DiffGraphApplier$$graph;
                if (graph == null ? graph3 != null : !graph.equals(graph3)) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)"expected a different graph instance");
                }
                return already;
            }
            if (None$.MODULE$.equals(option)) {
                short nodeKind = detached.nodeKind();
                this.flatgraph$DiffGraphApplier$$graph.schema().verifyNodeKindIsValid(Short$.MODULE$.short2int(nodeKind));
                int seqId = this.flatgraph$DiffGraphApplier$$graph.nodeCountByKind(Short$.MODULE$.short2int(nodeKind)) + BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.newNodes()[Short$.MODULE$.short2int(nodeKind)]).map((Function1 & Serializable)_$1 -> _$1.size()).getOrElse(DiffGraphApplier::$anonfun$2));
                GNode res = this.flatgraph$DiffGraphApplier$$graph.schema().makeNode(this.flatgraph$DiffGraphApplier$$graph, nodeKind, seqId);
                detached.storedRef_$eq((Option<GNode>)Some$.MODULE$.apply((Object)res));
                this.insert(this.newNodes(), detached, Short$.MODULE$.short2int(nodeKind));
                this.deferred().append((Object)detached);
                return res;
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)dNodeOrNode);
    }

    private int splitUpdate() {
        IntRef ndiff = IntRef.create((int)0);
        this.diff.buffer().foreach((Function1 & Serializable)x$1 -> {
            DiffGraphBuilder.DelNode delNode;
            DiffGraphBuilder.RawUpdate rawUpdate = x$1;
            if (rawUpdate instanceof DiffGraphBuilder.DelNode && !AccessHelpers.isDeleted((delNode = (DiffGraphBuilder.DelNode)rawUpdate).node())) {
                ++ndiff$1.elem;
                AccessHelpers.markDeleted(delNode.node());
                return this.delNodes().append((Object)delNode.node());
            }
            return BoxedUnit.UNIT;
        });
        this.diff.buffer().foreach((Function1)(JProcedure1 & Serializable)item -> {
            DiffGraphBuilder.SetNodeProperty setNodeProperty;
            DiffGraphBuilder.RemoveEdge edgeDeletion;
            DiffGraphBuilder.SetEdgeProperty setEdgeProperty;
            GNode gNode;
            DiffGraphBuilder.RawUpdate rawUpdate = item;
            if (rawUpdate instanceof DNode) {
                DNode addNode = (DNode)rawUpdate;
                gNode = this.flatgraph$DiffGraphApplier$$getGNode(addNode);
            } else if (rawUpdate instanceof DiffGraphBuilder.AddUnsafeHalfEdge) {
                DiffGraphBuilder.AddUnsafeHalfEdge halfEdge = (DiffGraphBuilder.AddUnsafeHalfEdge)rawUpdate;
                GNode src = this.flatgraph$DiffGraphApplier$$getGNode(halfEdge.src());
                GNode dst = this.flatgraph$DiffGraphApplier$$getGNode(halfEdge.dst());
                if (!AccessHelpers.isDeleted(src) && !AccessHelpers.isDeleted(dst)) {
                    ++ndiff$2.elem;
                    Edge.Direction direction = Edge$Direction$.MODULE$.fromOrdinal(Byte$.MODULE$.byte2int(halfEdge.inout()));
                    Edge.Direction direction2 = Edge$Direction$.Incoming;
                    Edge.Direction direction3 = direction;
                    if (!(direction2 != null ? !direction2.equals(direction3) : direction3 != null)) {
                        this.insert(this.newEdges(), new AddEdgeProcessed(dst, src, Short$.MODULE$.short2int(halfEdge.edgeKind()), halfEdge.property()), this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(Short$.MODULE$.short2int(dst.nodeKind), Edge$Direction$.Incoming, Short$.MODULE$.short2int(halfEdge.edgeKind())));
                    } else {
                        Edge.Direction direction4 = Edge$Direction$.Outgoing;
                        Edge.Direction direction5 = direction;
                        if (!(direction4 != null ? !direction4.equals(direction5) : direction5 != null)) {
                            this.insert(this.newEdges(), new AddEdgeProcessed(src, dst, Short$.MODULE$.short2int(halfEdge.edgeKind()), halfEdge.property()), this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(Short$.MODULE$.short2int(src.nodeKind), Edge$Direction$.Outgoing, Short$.MODULE$.short2int(halfEdge.edgeKind())));
                        } else {
                            throw new MatchError((Object)direction);
                        }
                    }
                    gNode = BoxedUnit.UNIT;
                } else {
                    gNode = BoxedUnit.UNIT;
                }
            } else if (rawUpdate instanceof DiffGraphBuilder.AddEdgeUnprocessed) {
                DiffGraphBuilder.AddEdgeUnprocessed newEdge = (DiffGraphBuilder.AddEdgeUnprocessed)rawUpdate;
                GNode src = this.flatgraph$DiffGraphApplier$$getGNode(newEdge.src());
                GNode dst = this.flatgraph$DiffGraphApplier$$getGNode(newEdge.dst());
                if (!AccessHelpers.isDeleted(src) && !AccessHelpers.isDeleted(dst)) {
                    ++ndiff$2.elem;
                    this.insert(this.newEdges(), new AddEdgeProcessed(src, dst, Short$.MODULE$.short2int(newEdge.edgeKind()), newEdge.property()), this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(Short$.MODULE$.short2int(src.nodeKind), Edge$Direction$.Outgoing, Short$.MODULE$.short2int(newEdge.edgeKind())));
                    this.insert(this.newEdges(), new AddEdgeProcessed(dst, src, Short$.MODULE$.short2int(newEdge.edgeKind()), newEdge.property()), this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(Short$.MODULE$.short2int(dst.nodeKind), Edge$Direction$.Incoming, Short$.MODULE$.short2int(newEdge.edgeKind())));
                    gNode = BoxedUnit.UNIT;
                } else {
                    gNode = BoxedUnit.UNIT;
                }
            } else if (rawUpdate instanceof DiffGraphBuilder.SetEdgeProperty && !AccessHelpers.isDeleted((setEdgeProperty = (DiffGraphBuilder.SetEdgeProperty)rawUpdate).edge().src()) && !AccessHelpers.isDeleted(setEdgeProperty.edge().dst())) {
                ++ndiff$2.elem;
                Tuple2<EdgeRepr, EdgeRepr> tuple2 = this.normalizeRepresentation(setEdgeProperty.edge());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                EdgeRepr outR = (EdgeRepr)tuple2._1();
                EdgeRepr inR = (EdgeRepr)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)outR, (Object)inR);
                EdgeRepr outR2 = (EdgeRepr)tuple22._1();
                EdgeRepr inR2 = (EdgeRepr)tuple22._2();
                this.insert(this.setEdgeProperties(), new EdgeRepr(outR2.src(), outR2.dst(), outR2.edgeKind(), outR2.subSeq(), setEdgeProperty.property()), this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(Short$.MODULE$.short2int(outR2.src().nodeKind), Edge$Direction$.Outgoing, outR2.edgeKind()));
                this.insert(this.setEdgeProperties(), new EdgeRepr(inR2.src(), inR2.dst(), inR2.edgeKind(), inR2.subSeq(), setEdgeProperty.property()), this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(Short$.MODULE$.short2int(inR2.src().nodeKind), Edge$Direction$.Incoming, inR2.edgeKind()));
                gNode = BoxedUnit.UNIT;
            } else if (rawUpdate instanceof DiffGraphBuilder.RemoveEdge && !AccessHelpers.isDeleted((edgeDeletion = (DiffGraphBuilder.RemoveEdge)rawUpdate).edge().src()) && !AccessHelpers.isDeleted(edgeDeletion.edge().dst())) {
                ++ndiff$2.elem;
                Tuple2<EdgeRepr, EdgeRepr> tuple2 = this.normalizeRepresentation(edgeDeletion.edge());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                EdgeRepr outR = (EdgeRepr)tuple2._1();
                EdgeRepr inR = (EdgeRepr)tuple2._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)outR, (Object)inR);
                EdgeRepr outR3 = (EdgeRepr)tuple23._1();
                EdgeRepr inR3 = (EdgeRepr)tuple23._2();
                this.insert(this.delEdges(), outR3, this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(Short$.MODULE$.short2int(outR3.src().nodeKind), Edge$Direction$.Outgoing, outR3.edgeKind()));
                this.insert(this.delEdges(), inR3, this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(Short$.MODULE$.short2int(inR3.src().nodeKind), Edge$Direction$.Incoming, inR3.edgeKind()));
                gNode = BoxedUnit.UNIT;
            } else if (rawUpdate instanceof DiffGraphBuilder.SetNodeProperty && !AccessHelpers.isDeleted((setNodeProperty = (DiffGraphBuilder.SetNodeProperty)rawUpdate).node())) {
                Iterator iterator;
                ++ndiff$2.elem;
                Object object = setNodeProperty.property();
                if (object == null) {
                    iterator = Iterator$.MODULE$.empty();
                } else if (object instanceof Iterable) {
                    Iterable iterable = (Iterable)object;
                    iterator = iterable.iterator();
                } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                    Object a = object;
                    Object object2 = Predef$.MODULE$.genericArrayOps(a);
                    iterator = ArrayOps$.MODULE$.iterator$extension(object2);
                } else {
                    Object item2 = object;
                    iterator = Iterator$.MODULE$.single(item2);
                }
                Iterator iter = iterator;
                this.insertProperty0(setNodeProperty.node(), setNodeProperty.propertyKind(), (Iterator<Object>)iter);
                gNode = BoxedUnit.UNIT;
            } else if (rawUpdate instanceof DiffGraphBuilder.DelNode) {
                DiffGraphBuilder.DelNode delNode = (DiffGraphBuilder.DelNode)rawUpdate;
                if (!AccessHelpers.isDeleted(delNode.node())) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(50).append("node should have been deleted already but wasn't: ").append(delNode.node()).toString());
                }
                gNode = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)rawUpdate);
            }
            ndiff$2.elem += this.drainDeferred();
        });
        return ndiff.elem;
    }

    public int applyUpdate() {
        this.flatgraph$DiffGraphApplier$$graph.hasChangedSinceOpen_$eq(true);
        int ndiff = this.splitUpdate();
        this.diff.buffer_$eq(null);
        try {
            this.flatgraph$DiffGraphApplier$$graph.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> this.flatgraph$DiffGraphApplier$$graph.schema().edgeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)edgeKind -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])Edge$Direction$.MODULE$.values());
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)direction -> this.setEdgeProperty(nodeKind, (Edge.Direction)direction, edgeKind));
            }));
            this.jobQueue().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.get());
            this.jobQueue().clear();
            this.flatgraph$DiffGraphApplier$$graph.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> this.flatgraph$DiffGraphApplier$$graph.schema().edgeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)edgeKind -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])Edge$Direction$.MODULE$.values());
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)direction -> this.deleteEdges(nodeKind, (Edge.Direction)direction, edgeKind));
            }));
            this.jobQueue().foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.get());
            this.jobQueue().clear();
            this.flatgraph$DiffGraphApplier$$graph.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> this.addNodes(nodeKind));
            this.jobQueue().foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.get());
            this.jobQueue().clear();
            if (this.delNodes().nonEmpty()) {
                this.deleteNodes();
            }
            this.flatgraph$DiffGraphApplier$$graph.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> this.flatgraph$DiffGraphApplier$$graph.schema().edgeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)edgeKind -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])Edge$Direction$.MODULE$.values());
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)direction -> this.addEdges(nodeKind, (Edge.Direction)direction, edgeKind));
            }));
            this.flatgraph$DiffGraphApplier$$graph.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> {
                this.flatgraph$DiffGraphApplier$$graph.schema().propertyKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)propertyKind -> this.setNodeProperties(nodeKind, propertyKind));
                if (this.newNodeUsers().decrementAndGet(nodeKind) == -1) {
                    this.newNodes()[nodeKind] = null;
                    return;
                }
            });
            this.jobQueue().foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.get());
            this.jobQueue().clear();
        }
        catch (ExecutionException ex) {
            throw ex.getCause();
        }
        return ndiff;
    }

    private void deleteNodes() {
        this.delNodes().foreach((Function1)(JProcedure1 & Serializable)del -> {
            int n = Short$.MODULE$.short2int(del.nodeKind);
            this.flatgraph$DiffGraphApplier$$graph.livingNodeCountByKind()[n] = this.flatgraph$DiffGraphApplier$$graph.livingNodeCountByKind()[n] - 1;
        });
        Object[] replacements = new Object[this.flatgraph$DiffGraphApplier$$graph.neighbors().length];
        this.flatgraph$DiffGraphApplier$$graph.schema().propertyKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)propertyKind -> this.delNodes().foreach((Function1)(JProcedure1 & Serializable)deletedNode -> {
            int pos = this.flatgraph$DiffGraphApplier$$graph.schema().propertyOffsetArrayIndex(Short$.MODULE$.short2int(deletedNode.nodeKind), propertyKind);
            this.flatgraph$DiffGraphApplier$$graph.inverseIndices().set(pos, null);
            Object object = this.flatgraph$DiffGraphApplier$$graph.properties()[pos];
            if (object == null) {
                return;
            }
            if (object instanceof int[]) {
                int[] oldQty = (int[])object;
                if (this.get(oldQty, deletedNode.seq() + 1) - this.get(oldQty, deletedNode.seq()) > 0) {
                    this.insertProperty0((GNode)deletedNode, propertyKind, (Iterator<Object>)Iterator$.MODULE$.empty());
                    return;
                }
                return;
            }
        }));
        this.flatgraph$DiffGraphApplier$$graph.schema().edgeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)edgeKind -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])Edge$Direction$.MODULE$.values());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)direction -> this.delNodes().foreach((Function1)(JProcedure1 & Serializable)deletedNode -> {
                int pos = this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(Short$.MODULE$.short2int(deletedNode.nodeKind), (Edge.Direction)direction, edgeKind);
                int[] oldQty = (int[])this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos];
                GNode[] oldNeighbors = (GNode[])this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos + 1];
                if (oldQty != null) {
                    int delStartIndex = this.get(oldQty, deletedNode.seq());
                    int delEndIndex = this.get(oldQty, deletedNode.seq() + 1);
                    if (delEndIndex - delStartIndex > 0) {
                        int[] modQty = this.getReplacementLengths$1(replacements, Short$.MODULE$.short2int(deletedNode.nodeKind), (Edge.Direction)direction, edgeKind);
                        GNode[] modVal = this.getReplacementNeighbors$1(replacements, Short$.MODULE$.short2int(deletedNode.nodeKind), (Edge.Direction)direction, edgeKind);
                        modQty[deletedNode.seq()] = 0;
                        package$.MODULE$.Range().apply(delStartIndex, delEndIndex).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                            modVal$1[idx] = deletedNode;
                            GNode neighbor = oldNeighbors[idx];
                            if (!AccessHelpers.isDeleted(neighbor)) {
                                Edge.Direction newDirection = Edge$Direction$.MODULE$.fromOrdinal(1 - direction.encoding());
                                int[] nArray = this.getReplacementLengths$1(replacements, Short$.MODULE$.short2int(neighbor.nodeKind), newDirection, edgeKind);
                                int n = neighbor.seq();
                                nArray[n] = nArray[n] - 1;
                                return;
                            }
                        });
                        return;
                    }
                    return;
                }
            }));
        });
        this.flatgraph$DiffGraphApplier$$graph.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> this.flatgraph$DiffGraphApplier$$graph.schema().edgeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)edgeKind -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])Edge$Direction$.MODULE$.values());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)direction -> {
                int pos = this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(nodeKind, (Edge.Direction)direction, edgeKind);
                if (replacements[pos] != null) {
                    Object other;
                    Object other2;
                    int[] newQty = (int[])replacements[pos];
                    this.lenToRan(newQty);
                    GNode[] newNeighbors = new GNode[this.get(newQty, this.flatgraph$DiffGraphApplier$$graph.nodeCountByKind(nodeKind))];
                    GNode[] modNeighbors = (GNode[])(replacements[pos + 1] != null ? replacements[pos + 1] : this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos + 1]);
                    Object object = this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos + 2];
                    Object oldProperty = object instanceof DefaultValue ? null : (other2 = object);
                    Object newProperty = oldProperty != null ? this.flatgraph$DiffGraphApplier$$graph.schema().allocateEdgeProperty(nodeKind, (Edge.Direction)direction, edgeKind, newNeighbors.length) : null;
                    int idxOut = 0;
                    for (int idx = 0; idx < modNeighbors.length; ++idx) {
                        if (AccessHelpers.isDeleted(modNeighbors[idx])) continue;
                        newNeighbors[idxOut] = modNeighbors[idx];
                        if (oldProperty != null) {
                            System.arraycopy(oldProperty, idx, newProperty, idxOut, 1);
                        }
                        ++idxOut;
                    }
                    if (idxOut != newNeighbors.length) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(43).append("idxOut was expected to be ").append(newNeighbors.length).append(", but instead is ").append(idxOut).toString());
                    }
                    this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos] = newQty;
                    this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos + 1] = newNeighbors;
                    Object object2 = newProperty;
                    this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos + 2] = object2 == null ? this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos + 2] : (other = object2);
                    return;
                }
            });
        }));
    }

    private Tuple2<EdgeRepr, EdgeRepr> normalizeRepresentation(Edge edge) {
        Edge reversed;
        short kind;
        block11: {
            block10: {
                block7: {
                    Edge reversed2;
                    block9: {
                        block8: {
                            kind = edge.edgeKind();
                            if (edge.subSeq() == 0) {
                                throw Scala3RunTime$.MODULE$.assertFailed((Object)"edge.subSeq must not be 0");
                            }
                            if (edge.subSeq() <= 0) break block7;
                            int count = Accessors$.MODULE$.getEdgesOut(edge.src(), Short$.MODULE$.short2int(kind)).iterator().take(edge.subSeq()).count((Function1 & Serializable)_$6 -> {
                                GNode gNode = _$6.dst();
                                GNode gNode2 = edge.dst();
                                return !(gNode != null ? !gNode.equals(gNode2) : gNode2 != null);
                            });
                            reversed2 = (Edge)Accessors$.MODULE$.getEdgesIn(edge.dst(), Short$.MODULE$.short2int(kind)).iterator().filter((Function1 & Serializable)_$7 -> {
                                GNode gNode = _$7.src();
                                GNode gNode2 = edge.src();
                                return !(gNode != null ? !gNode.equals(gNode2) : gNode2 != null);
                            }).drop(count - 1).next();
                            GNode gNode = reversed2.src();
                            GNode gNode2 = edge.src();
                            if (gNode != null ? !gNode.equals(gNode2) : gNode2 != null) break block8;
                            GNode gNode3 = reversed2.dst();
                            GNode gNode4 = edge.dst();
                            if (gNode3 != null ? !gNode3.equals(gNode4) : gNode4 != null) break block8;
                            if (BoxesRunTime.equals((Object)reversed2.property(), (Object)edge.property()) && reversed2.subSeq() < 0) break block9;
                        }
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)"something went wrong when calculating reversed edge");
                    }
                    return Tuple2$.MODULE$.apply((Object)new EdgeRepr(edge.src(), edge.dst(), Short$.MODULE$.short2int(kind), edge.subSeq(), edge.property()), (Object)new EdgeRepr(edge.dst(), edge.src(), Short$.MODULE$.short2int(kind), -reversed2.subSeq(), edge.property()));
                }
                int count = Accessors$.MODULE$.getEdgesIn(edge.dst(), Short$.MODULE$.short2int(kind)).iterator().take(-edge.subSeq()).count((Function1 & Serializable)_$8 -> {
                    GNode gNode = _$8.src();
                    GNode gNode2 = edge.src();
                    return !(gNode != null ? !gNode.equals(gNode2) : gNode2 != null);
                });
                reversed = (Edge)Accessors$.MODULE$.getEdgesOut(edge.src(), Short$.MODULE$.short2int(kind)).iterator().filter((Function1 & Serializable)_$9 -> {
                    GNode gNode = _$9.dst();
                    GNode gNode2 = edge.dst();
                    return !(gNode != null ? !gNode.equals(gNode2) : gNode2 != null);
                }).drop(count - 1).next();
                GNode gNode = reversed.src();
                GNode gNode5 = edge.src();
                if (gNode != null ? !gNode.equals(gNode5) : gNode5 != null) break block10;
                GNode gNode6 = reversed.dst();
                GNode gNode7 = edge.dst();
                if (gNode6 != null ? !gNode6.equals(gNode7) : gNode7 != null) break block10;
                if (BoxesRunTime.equals((Object)reversed.property(), (Object)edge.property()) && reversed.subSeq() > 0) break block11;
            }
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"something went wrong when calculating reversed edge");
        }
        return Tuple2$.MODULE$.apply((Object)new EdgeRepr(edge.src(), edge.dst(), Short$.MODULE$.short2int(kind), reversed.subSeq(), edge.property()), (Object)new EdgeRepr(edge.dst(), edge.src(), Short$.MODULE$.short2int(kind), -edge.subSeq(), edge.property()));
    }

    private void ranToLen(int[] arr) {
        if (arr.length > 0) {
            if (arr[0] != 0) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(64).append("first element in array was expected to be `0`, but instead is `").append(arr[0]).append("`").toString());
            }
            package$.MODULE$.Range().apply(0, arr.length - 1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                arr$1[idx] = arr[idx + 1] - arr[idx];
            });
        }
        arr[arr.length - 1] = 0;
    }

    private void lenToRan(int[] arr) {
        if (arr.length > 0) {
            Object object = Predef$.MODULE$.intArrayOps(arr);
            if (BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.last$extension(object)) != 0) {
                Object object2 = Predef$.MODULE$.intArrayOps(arr);
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(63).append("last element in array was expected to be `0`, but instead is `").append(BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.last$extension(object2))).append("`").toString());
            }
            int count = 0;
            for (int idx = 0; idx < arr.length; ++idx) {
                int tmp = arr[idx];
                arr[idx] = count;
                count += tmp;
            }
            return;
        }
    }

    private void addNodes(int nodeKind) {
        if (this.newNodes()[nodeKind] == null || this.newNodes()[nodeKind].isEmpty()) {
            return;
        }
        this.submitJob((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.addNodes$$anonfun$1(nodeKind);
            return BoxedUnit.UNIT;
        });
    }

    private void setEdgeProperty(int nodeKind, Edge.Direction direction, int edgeKind) {
        int pos = this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(nodeKind, direction, edgeKind);
        if (this.setEdgeProperties()[pos] == null) {
            return;
        }
        this.submitJob((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.setEdgeProperty$$anonfun$1(pos, nodeKind, direction, edgeKind);
            return BoxedUnit.UNIT;
        });
    }

    private void deleteEdges(int nodeKind, Edge.Direction direction, int edgeKind) {
        int pos = this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(nodeKind, direction, edgeKind);
        if (this.delEdges()[pos] == null) {
            return;
        }
        this.submitJob((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.deleteEdges$$anonfun$1(pos, edgeKind, nodeKind, direction);
            return BoxedUnit.UNIT;
        });
    }

    private void addEdges(int nodeKind, Edge.Direction direction, int edgeKind) {
        int pos = this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(nodeKind, direction, edgeKind);
        if (this.newEdges()[pos] == null) {
            return;
        }
        this.submitJob((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.addEdges$$anonfun$1(pos, nodeKind, edgeKind, direction);
            return BoxedUnit.UNIT;
        });
    }

    private void setNodeProperties(int nodeKind, int propertyKind) {
        Schema schema = this.flatgraph$DiffGraphApplier$$graph.schema();
        int pos = schema.propertyOffsetArrayIndex(nodeKind, propertyKind);
        int viaNewNode = this.newNodeNewProperties()[pos];
        if (this.setNodeProperties()[pos] == null && viaNewNode == 0) {
            return;
        }
        this.newNodeUsers().incrementAndGet(nodeKind);
        this.submitJob((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.setNodeProperties$$anonfun$1(pos, nodeKind, schema, propertyKind, viaNewNode);
            return BoxedUnit.UNIT;
        });
    }

    private <T> void copyToArray(ArrayBuffer<Object> buf, Object dst) {
        try {
            buf.copyToArray(dst);
        }
        catch (ArrayStoreException store) {
            String typeMaybe = (String)buf.headOption().map((Function1 & Serializable)property -> new StringBuilder(2).append(": ").append(property.getClass()).toString()).getOrElse(DiffGraphApplier::$anonfun$18);
            throw new UnsupportedOperationException(new StringBuilder(29).append("unsupported property type").append(typeMaybe).append(" on ").append(Option$.MODULE$.apply(dst).map((Function1 & Serializable)_$15 -> _$15.getClass().toString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString(), store);
        }
    }

    private int get(int[] a, int idx) {
        if (idx < a.length) {
            return a[idx];
        }
        Object object = Predef$.MODULE$.intArrayOps(a);
        return BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.last$extension(object));
    }

    private <T, S> void dedupBy(ArrayBuffer<T> buff, Function1<T, S> by) {
        int outIdx = 0;
        int idx = 0;
        while (idx < buff.length()) {
            if (idx < buff.length() - 1 && BoxesRunTime.equals((Object)by.apply(buff.apply(idx)), (Object)by.apply(buff.apply(idx + 1)))) {
                buff.update(outIdx, buff.apply(idx));
                ++idx;
                continue;
            }
            if (outIdx != idx) {
                buff.update(outIdx, buff.apply(idx));
            }
            ++idx;
            ++outIdx;
        }
        buff.dropRightInPlace(idx - outIdx);
    }

    private long numberForEdgeComparison(EdgeRepr edge) {
        return ((long)edge.src().seq() << 32) + (long)edge.subSeq();
    }

    private static final int $anonfun$2() {
        return 0;
    }

    private final int[] getReplacementLengths$1(Object[] replacements$1, int nodeKind, Edge.Direction direction, int edgeKind) {
        int pos = this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(nodeKind, direction, edgeKind);
        if (replacements$1[pos] != null) {
            return (int[])replacements$1[pos];
        }
        int[] res = (int[])((int[])this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos]).clone();
        this.ranToLen(res);
        replacements$1[pos] = res;
        return res;
    }

    private final GNode[] getReplacementNeighbors$1(Object[] replacements$2, int nodeKind, Edge.Direction direction, int edgeKind) {
        GNode[] res;
        int pos = this.flatgraph$DiffGraphApplier$$graph.schema().neighborOffsetArrayIndex(nodeKind, direction, edgeKind);
        if (replacements$2[pos + 1] != null) {
            return (GNode[])replacements$2[pos + 1];
        }
        replacements$2[pos + 1] = res = (GNode[])((GNode[])this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos + 1]).clone();
        return res;
    }

    private final void addNodes$$anonfun$1(int nodeKind$10) {
        Object object = Predef$.MODULE$.refArrayOps(this.flatgraph$DiffGraphApplier$$graph.nodesArray()[nodeKind$10]);
        this.flatgraph$DiffGraphApplier$$graph.nodesArray()[nodeKind$10] = (GNode[])ArrayOps$.MODULE$.appendedAll$extension(object, (IterableOnce)this.newNodes()[nodeKind$10].iterator().map((Function1 & Serializable)_$10 -> (GNode)_$10.storedRef().get()), ClassTag$.MODULE$.apply(GNode.class));
        this.flatgraph$DiffGraphApplier$$graph.livingNodeCountByKind()[nodeKind$10] = this.flatgraph$DiffGraphApplier$$graph.livingNodeCountByKind()[nodeKind$10] + this.newNodes()[nodeKind$10].size();
    }

    private final void setEdgeProperty$$anonfun$1(int pos$1, int nodeKind$11, Edge.Direction direction$3, int edgeKind$8) {
        Object other;
        Object object = Predef$.MODULE$.refArrayOps((Object[])((GNode[])this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$1 + 1]));
        int size = ArrayOps$.MODULE$.size$extension(object);
        int[] oldQty = (int[])this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$1];
        Object object2 = this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$1 + 2];
        Object edgeProp = object2 instanceof DefaultValue ? this.flatgraph$DiffGraphApplier$$graph.schema().allocateEdgeProperty(nodeKind$11, direction$3, edgeKind$8, size) : (other = object2);
        ArraySeq propview = ArraySeq$.MODULE$.make(edgeProp);
        Object object3 = ScalaRunTime$.MODULE$.array_apply(this.flatgraph$DiffGraphApplier$$graph.schema().allocateEdgeProperty(nodeKind$11, direction$3, edgeKind$8, 1), 0);
        this.setEdgeProperties()[pos$1].foreach((Function1)(JProcedure1 & Serializable)edgeRepr -> {
            int index = oldQty[edgeRepr.src().seq()] + edgeRepr.subSeq() - 1;
            Object object = edgeRepr.property();
            DefaultValue$ defaultValue$ = DefaultValue$.MODULE$;
            propview.update(index, !(object != null ? !object.equals(defaultValue$) : defaultValue$ != null) ? object3 : edgeRepr.property());
        });
        this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$1 + 2] = edgeProp;
        boolean bl = this.setEdgeProperties()[pos$1] == null;
    }

    private final void deleteEdges$$anonfun$1(int pos$2, int edgeKind$9, int nodeKind$12, Edge.Direction direction$4) {
        Object other;
        Object object;
        Object other2;
        Object oldProperty;
        ArrayBuffer<EdgeRepr> deletions = this.delEdges()[pos$2];
        if (!deletions.forall((Function1 & Serializable)edge -> edge.edgeKind() == edgeKind$9 && edge.src().nodeKind == nodeKind$12 && edge.subSeq() > 0)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(85).append("something went wrong when deleting edges - values for debugging: edgeKind=").append(edgeKind$9).append("; nodeKind=").append(nodeKind$12).toString());
        }
        deletions.sortInPlaceBy((Function1 & Serializable)edge -> this.numberForEdgeComparison((EdgeRepr)edge), (Ordering)Ordering.Long$.MODULE$);
        this.dedupBy(deletions, (Function1 & Serializable)edge -> this.numberForEdgeComparison((EdgeRepr)edge));
        int nodeCount = this.flatgraph$DiffGraphApplier$$graph.nodeCountByKind(nodeKind$12);
        int[] oldQty = (int[])this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$2];
        GNode[] oldNeighbors = (GNode[])this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$2 + 1];
        int[] newQty = new int[nodeCount + 1];
        Object[] newNeighbors = new GNode[this.get(oldQty, nodeCount) - deletions.length()];
        Object object2 = this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$2 + 2];
        Object object3 = oldProperty = object2 instanceof DefaultValue ? null : (other2 = object2);
        if (oldProperty != null) {
            Object object4 = Predef$.MODULE$.refArrayOps(newNeighbors);
            object = this.flatgraph$DiffGraphApplier$$graph.schema().allocateEdgeProperty(nodeKind$12, direction$4, edgeKind$9, ArrayOps$.MODULE$.size$extension(object4));
        } else {
            object = null;
        }
        Object newProperty = object;
        IntRef deletionCounter = IntRef.create((int)0);
        int copyStartSeq = 0;
        while (copyStartSeq < nodeCount) {
            int idx2;
            int deletionSeq = deletionCounter.elem < deletions.size() ? ((EdgeRepr)deletions.apply(deletionCounter.elem)).src().seq() : nodeCount;
            int copyStartIndex = this.get(oldQty, copyStartSeq);
            int deletionSeqIndexStart = this.get(oldQty, deletionSeq);
            int deletionSeqIndexEnd = this.get(oldQty, deletionSeq + 1);
            System.arraycopy(oldNeighbors, copyStartIndex, newNeighbors, copyStartIndex - deletionCounter.elem, deletionSeqIndexStart - copyStartIndex);
            if (oldProperty != null) {
                System.arraycopy(oldProperty, copyStartIndex, newProperty, copyStartIndex - deletionCounter.elem, deletionSeqIndexStart - copyStartIndex);
            }
            package$.MODULE$.Range().apply(copyStartSeq, deletionSeq + 1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                newQty$1[idx] = this.get(oldQty, idx) - deletionCounter$1.elem;
            });
            copyStartSeq = deletionSeq + 1;
            if (deletionCounter.elem >= deletions.size()) continue;
            EdgeRepr deletion = (EdgeRepr)deletions.apply(deletionCounter.elem);
            for (idx2 = 0; idx2 < deletionSeqIndexEnd - deletionSeqIndexStart; ++idx2) {
                if (deletion != null && idx2 == deletion.subSeq() - 1) {
                    GNode gNode = deletion.dst();
                    GNode gNode2 = oldNeighbors[deletionSeqIndexStart + idx2];
                    if (gNode == null ? gNode2 != null : !gNode.equals(gNode2)) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(51).append("deletion.dst was supposed to be `").append(oldNeighbors[deletionSeqIndexStart + idx2]).append("`, but instead is ").append(deletion.dst()).toString());
                    }
                    ++deletionCounter.elem;
                    EdgeRepr edgeRepr = deletion = deletionCounter.elem < deletions.size() ? (EdgeRepr)deletions.apply(deletionCounter.elem) : null;
                    if (deletion == null || deletion.src().seq() == deletionSeq) continue;
                    deletion = null;
                    continue;
                }
                newNeighbors[deletionSeqIndexStart + idx2 - deletionCounter.elem] = oldNeighbors[deletionSeqIndexStart + idx2];
                if (oldProperty == null) continue;
                System.arraycopy(oldProperty, deletionSeqIndexStart + idx2, newProperty, deletionSeqIndexStart + idx2 - deletionCounter.elem, 1);
            }
            newQty[deletionSeq + 1] = deletionSeqIndexStart + idx2 - deletionCounter.elem;
        }
        this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$2] = newQty;
        this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$2 + 1] = newNeighbors;
        Object object5 = newProperty;
        this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$2 + 2] = object5 == null ? this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$2 + 2] : (other = object5);
        this.delEdges()[pos$2] = null;
    }

    private static final int[] $anonfun$7() {
        return new int[1];
    }

    private static final GNode[] $anonfun$8() {
        return new GNode[0];
    }

    private final void addEdges$$anonfun$1(int pos$3, int nodeKind$14, int edgeKind$11, Edge.Direction direction$5) {
        Object other;
        Object object;
        Object other2;
        Object oldProperty;
        ArrayBuffer<AddEdgeProcessed> insertions = this.newEdges()[pos$3];
        insertions.sortInPlaceBy((Function1 & Serializable)_$11 -> _$11.src().seq(), (Ordering)Ordering.Int$.MODULE$);
        if (!insertions.nonEmpty()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"insertions must be nonEmpty");
        }
        if (!insertions.forall((Function1 & Serializable)edge -> edge.src().nodeKind == nodeKind$14 && edge.edgeKind() == edgeKind$11)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(84).append("something went wrong while adding edges - values for debugging: nodeKind=").append(nodeKind$14).append("; edgeKind=").append(edgeKind$11).toString());
        }
        int nodeCount = this.flatgraph$DiffGraphApplier$$graph.nodesArray()[nodeKind$14].length;
        int[] oldQty = (int[])Option$.MODULE$.apply((Object)((int[])this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$3])).getOrElse(DiffGraphApplier::$anonfun$7);
        GNode[] oldNeighbors = (GNode[])Option$.MODULE$.apply((Object)((GNode[])this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$3 + 1])).getOrElse(DiffGraphApplier::$anonfun$8);
        int[] newQty = new int[nodeCount + 1];
        Object[] newNeighbors = new GNode[this.get(oldQty, nodeCount) + insertions.size()];
        boolean hasNewProp = insertions.exists((Function1 & Serializable)_$12 -> {
            Object object = _$12.property();
            DefaultValue$ defaultValue$ = DefaultValue$.MODULE$;
            return object == null ? defaultValue$ != null : !object.equals(defaultValue$);
        });
        Object object2 = this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$3 + 2];
        Object object3 = oldProperty = object2 instanceof DefaultValue ? null : (other2 = object2);
        if (hasNewProp || oldProperty != null) {
            Object object4 = Predef$.MODULE$.refArrayOps(newNeighbors);
            object = this.flatgraph$DiffGraphApplier$$graph.schema().allocateEdgeProperty(nodeKind$14, direction$5, edgeKind$11, ArrayOps$.MODULE$.size$extension(object4));
        } else {
            object = null;
        }
        Object newProperty = object;
        ArraySeq newPropertyView = ArraySeq$.MODULE$.make(newProperty);
        IntRef insertionCounter = IntRef.create((int)0);
        int copyStartSeq = 0;
        while (copyStartSeq < nodeCount) {
            int insertionSeq = insertionCounter.elem < insertions.size() ? ((AddEdgeProcessed)insertions.apply(insertionCounter.elem)).src().seq() : nodeCount - 1;
            int copyStartIdx = this.get(oldQty, copyStartSeq);
            int insertionIdx = this.get(oldQty, insertionSeq + 1);
            System.arraycopy(oldNeighbors, copyStartIdx, newNeighbors, copyStartIdx + insertionCounter.elem, insertionIdx - copyStartIdx);
            if (oldProperty != null) {
                System.arraycopy(oldProperty, copyStartIdx, newProperty, copyStartIdx + insertionCounter.elem, insertionIdx - copyStartIdx);
            }
            package$.MODULE$.Range().apply(copyStartSeq, insertionSeq + 2).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                newQty$2[idx] = this.get(oldQty, idx) + insertionCounter$1.elem;
            });
            int insertionBaseIndex = newQty[insertionSeq + 1] - insertionCounter.elem;
            while (insertionCounter.elem < insertions.size() && ((AddEdgeProcessed)insertions.apply(insertionCounter.elem)).src().seq() == insertionSeq) {
                AddEdgeProcessed insertion = (AddEdgeProcessed)insertions.apply(insertionCounter.elem);
                newNeighbors[insertionBaseIndex + insertionCounter.elem] = insertion.dst();
                if (newPropertyView != null) {
                    Object object5 = insertion.property();
                    DefaultValue$ defaultValue$ = DefaultValue$.MODULE$;
                    if (object5 == null ? defaultValue$ != null : !object5.equals(defaultValue$)) {
                        try {
                            newPropertyView.update(insertionBaseIndex + insertionCounter.elem, insertion.property());
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof ArrayStoreException || throwable2 instanceof ClassCastException) {
                                String edgeType = this.flatgraph$DiffGraphApplier$$graph.schema().getEdgeLabel(nodeKind$14, edgeKind$11);
                                throw new UnsupportedOperationException(new StringBuilder(45).append("unsupported property type `").append(insertion.property().getClass()).append("` for edge type `").append(edgeType).append("`").toString());
                            }
                            throw throwable;
                        }
                    }
                }
                ++insertionCounter.elem;
            }
            newQty[insertionSeq + 1] = insertionBaseIndex + insertionCounter.elem;
            copyStartSeq = insertionSeq + 1;
        }
        this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$3] = newQty;
        this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$3 + 1] = newNeighbors;
        Object object6 = newProperty;
        this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$3 + 2] = object6 == null ? this.flatgraph$DiffGraphApplier$$graph.neighbors()[pos$3 + 2] : (other = object6);
        this.newEdges()[pos$3] = null;
    }

    private static final ArrayBuffer $anonfun$10() {
        return ArrayBuffer$.MODULE$.empty();
    }

    private static final ArrayBuffer $anonfun$11() {
        return ArrayBuffer$.MODULE$.empty();
    }

    private static final int[] $anonfun$12() {
        return new int[1];
    }

    private static final Object $anonfun$14(Schema schema$2, int nodeKind$17, int propertyKind$3) {
        return schema$2.getNodePropertyFormalType(nodeKind$17, propertyKind$3).allocate(0);
    }

    private static final int $anonfun$16(int nodeCount$1) {
        return nodeCount$1;
    }

    private final void setNodeProperties$$anonfun$1(int pos$4, int nodeKind$16, Schema schema$1, int propertyKind$2, int viaNewNode$1) {
        ArrayBuffer propertyBuf = (ArrayBuffer)Option$.MODULE$.apply(this.setNodeProperties()[pos$4]).getOrElse(DiffGraphApplier::$anonfun$10);
        ArrayBuffer setPropertyPositions = (ArrayBuffer)Option$.MODULE$.apply(this.setNodeProperties()[pos$4 + 1]).getOrElse(DiffGraphApplier::$anonfun$11);
        this.flatgraph$DiffGraphApplier$$graph.inverseIndices().set(pos$4, null);
        setPropertyPositions.sortInPlaceBy((Function1 & Serializable)_$13 -> _$13.node().seq(), (Ordering)Ordering.Int$.MODULE$);
        this.dedupBy(setPropertyPositions, (Function1 & Serializable)setProp -> setProp.node().seq());
        int[] oldQty = (int[])Option$.MODULE$.apply((Object)((int[])this.flatgraph$DiffGraphApplier$$graph.properties()[pos$4])).getOrElse(DiffGraphApplier::$anonfun$12);
        int lengthDelta = BoxesRunTime.unboxToInt((Object)setPropertyPositions.iterator().map((Function1 & Serializable)setP -> setP.length() - (this.get(oldQty, setP.node().seq()) - this.get(oldQty, setP.node().seq() + 1))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int nodeCount = this.flatgraph$DiffGraphApplier$$graph.nodesArray()[nodeKind$16].length;
        Object setPropertyValues = schema$1.getNodePropertyFormalType(nodeKind$16, propertyKind$2).allocate(propertyBuf.size());
        if (setPropertyValues == null) {
            this.schemaViolationReporter.illegalNodeProperty(nodeKind$16, BoxesRunTime.boxToInteger((int)propertyKind$2), schema$1);
            return;
        }
        this.copyToArray((ArrayBuffer<Object>)propertyBuf, setPropertyValues);
        Object oldProperty = Option$.MODULE$.apply(this.flatgraph$DiffGraphApplier$$graph.properties()[pos$4 + 1]).getOrElse(() -> DiffGraphApplier.$anonfun$14(schema$1, nodeKind$16, propertyKind$2));
        if (oldProperty == null) {
            this.schemaViolationReporter.illegalNodeProperty(nodeKind$16, BoxesRunTime.boxToInteger((int)propertyKind$2), schema$1);
        }
        int[] newQty = new int[nodeCount + 1];
        Object newProperty = schema$1.getNodePropertyFormalType(nodeKind$16, propertyKind$2).allocate(this.get(oldQty, nodeCount) + lengthDelta + viaNewNode$1);
        Iterator insertionIter = setPropertyPositions.iterator();
        int copyStartSeq = 0;
        IntRef outIndex = IntRef.create((int)0);
        while (copyStartSeq < nodeCount) {
            Option insertion2 = insertionIter.nextOption();
            int insertionSeq = BoxesRunTime.unboxToInt((Object)insertion2.map((Function1 & Serializable)_$14 -> _$14.node().seq()).getOrElse(() -> DiffGraphApplier.$anonfun$16(nodeCount)));
            int copyStartIndex = this.get(oldQty, copyStartSeq);
            int copyEndIndex = this.get(oldQty, insertionSeq);
            int offset = outIndex.elem - copyStartIndex;
            System.arraycopy(oldProperty, copyStartIndex, newProperty, outIndex.elem, copyEndIndex - copyStartIndex);
            outIndex.elem += copyEndIndex - copyStartIndex;
            if (newQty[copyStartSeq] != this.get(oldQty, copyStartSeq) + offset) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(104).append("something went wrong while copying properties: newQty(copyStartSeq) was supposed to be ").append(this.get(oldQty, copyStartSeq) + offset).append(" but instead was ").append(newQty[copyStartSeq]).toString());
            }
            package$.MODULE$.Range().apply(copyStartSeq + 1, insertionSeq + 1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                newQty$3[idx] = this.get(oldQty, idx) + offset;
            });
            insertion2.foreach((Function1)(JProcedure1 & Serializable)insertion -> {
                System.arraycopy(setPropertyValues, insertion.start(), newProperty, outIndex$1.elem, insertion.length());
                outIndex$1.elem += insertion.length();
                newQty$4[insertionSeq$1 + 1] = outIndex$1.elem;
            });
            copyStartSeq = insertionSeq + 1;
        }
        newQty[nodeCount] = outIndex.elem;
        if (viaNewNode$1 > 0) {
            NewNodePropertyInsertionHelper inserter = schema$1.getNewNodePropertyInserter(nodeKind$16, propertyKind$2);
            inserter.insertNewNodeProperties(this.newNodes()[nodeKind$16], newProperty, newQty);
        }
        this.flatgraph$DiffGraphApplier$$graph.properties()[pos$4] = newQty;
        this.flatgraph$DiffGraphApplier$$graph.properties()[pos$4 + 1] = newProperty;
        this.setNodeProperties()[pos$4] = null;
        this.setNodeProperties()[pos$4 + 1] = null;
        if (this.newNodeUsers().decrementAndGet(nodeKind$16) == -1) {
            this.newNodes()[nodeKind$16] = null;
            return;
        }
    }

    private static final String $anonfun$18() {
        return "";
    }
}

