/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.traversal;

import flatgraph.traversal.RepeatBehaviour;
import flatgraph.traversal.RepeatBehaviour$SearchAlgorithm$;
import flatgraph.traversal.RepeatStep;
import flatgraph.traversal.RepeatStep$WorklistItem$;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxesRunTime;

public class RepeatStepIterator<A>
implements Iterator<A> {
    private final Function1<A, Iterator<A>> repeatTraversal;
    private final RepeatBehaviour<A> behaviour;
    private final Set<A> visited;
    private final Queue<A> emitSack;
    private final RepeatStep.Worklist<RepeatStep.WorklistItem<A>> worklist;

    public RepeatStepIterator(A element, Function1<A, Iterator<A>> repeatTraversal, RepeatBehaviour<A> behaviour) {
        RepeatStep.Worklist<RepeatStep.WorklistItem<A>> worklist;
        this.repeatTraversal = repeatTraversal;
        this.behaviour = behaviour;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        this.visited = (Set)Set$.MODULE$.empty();
        this.emitSack = Queue$.MODULE$.empty();
        Enumeration.Value value = behaviour.searchAlgorithm();
        Enumeration.Value value2 = RepeatBehaviour$SearchAlgorithm$.MODULE$.DepthFirst();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            worklist = new RepeatStep.LifoWorklist<RepeatStep.WorklistItem<A>>();
        } else {
            Enumeration.Value value4 = RepeatBehaviour$SearchAlgorithm$.MODULE$.BreadthFirst();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                worklist = new RepeatStep.FifoWorklist();
            } else {
                throw new MatchError((Object)value);
            }
        }
        this.worklist = worklist;
        this.worklist().addItem(RepeatStep$WorklistItem$.MODULE$.apply(Iterator$.MODULE$.single(element), 0));
    }

    public Set<A> visited() {
        return this.visited;
    }

    public Queue<A> emitSack() {
        return this.emitSack;
    }

    public RepeatStep.Worklist<RepeatStep.WorklistItem<A>> worklist() {
        return this.worklist;
    }

    public boolean hasNext() {
        if (this.emitSack().isEmpty()) {
            this.traverseOnWorklist();
        }
        return this.emitSack().nonEmpty() || this.worklistTopHasNext();
    }

    private void traverseOnWorklist() {
        boolean stop = false;
        while (this.worklist().nonEmpty() && !stop) {
            RepeatStep.WorklistItem<A> worklistItem = this.worklist().head();
            if (worklistItem == null) {
                throw new MatchError(worklistItem);
            }
            RepeatStep.WorklistItem<A> worklistItem2 = RepeatStep$WorklistItem$.MODULE$.unapply(worklistItem);
            Iterator<A> iterator = worklistItem2._1();
            int n = worklistItem2._2();
            Iterator<A> trav = iterator;
            int depth = n;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(trav, (Object)BoxesRunTime.boxToInteger((int)depth));
            Iterator trav2 = (Iterator)tuple2._1();
            int depth2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
            if (trav2.isEmpty()) {
                this.worklist().removeHead();
                continue;
            }
            if (this.behaviour.maxDepthReached(depth2)) {
                stop = true;
                continue;
            }
            Object element = trav2.next();
            if (this.behaviour.dedupEnabled()) {
                this.visited().addOne(element);
            }
            if (this.behaviour.whileConditionIsDefinedAndEmpty(element) || depth2 > 0 && this.behaviour.untilConditionReached(element)) {
                this.emitSack().enqueue(element);
                stop = true;
                continue;
            }
            Iterator repeat = (Iterator)this.repeatTraversal.apply(element);
            Iterator nextLevelTraversal = this.behaviour.dedupEnabled() ? repeat.filterNot((Function1 & Serializable)elem -> this.visited().contains(elem)) : repeat;
            this.worklist().addItem(RepeatStep$WorklistItem$.MODULE$.apply(nextLevelTraversal, depth2 + 1));
            if (this.behaviour.shouldEmit(element, depth2)) {
                this.emitSack().enqueue(element);
            }
            if (!this.emitSack().nonEmpty()) continue;
            stop = true;
        }
    }

    private boolean worklistTopHasNext() {
        return this.worklist().nonEmpty() && this.worklist().head().traversal().hasNext();
    }

    public A next() {
        Object object;
        if (this.emitSack().nonEmpty()) {
            object = this.emitSack().dequeue();
        } else if (this.worklistTopHasNext()) {
            object = this.worklist().head().traversal().next();
        } else {
            throw new NoSuchElementException("next on empty iterator");
        }
        Object result = object;
        if (this.behaviour.dedupEnabled()) {
            this.visited().addOne(result);
        }
        return (A)result;
    }
}

