/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.storage;

import com.github.luben.zstd.Zstd;
import flatgraph.AccessHelpers;
import flatgraph.DefaultValue;
import flatgraph.Edge;
import flatgraph.Edge$Direction$;
import flatgraph.GNode;
import flatgraph.Graph;
import flatgraph.storage.Manifest;
import flatgraph.storage.Manifest$GraphItem$;
import flatgraph.storage.package$Keys$;
import flatgraph.storage.package$StorageType$;
import java.io.ByteArrayOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import ujson.Value;

public final class Serialization$
implements Serializable {
    public static final Serialization$ MODULE$ = new Serialization$();

    private Serialization$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Serialization$.class);
    }

    public void writeGraph(Graph g, Path storagePath) {
        AtomicLong fileOffset = new AtomicLong(16L);
        LinkedHashMap stringPool = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        FileChannel fileChannel = new RandomAccessFile(storagePath.toAbsolutePath().toFile(), "rw").getChannel();
        try {
            this.innerWriteGraph(g, (LinkedHashMap<String, Object>)stringPool, fileOffset, fileChannel);
        }
        finally {
            stringPool.clear();
            fileChannel.close();
        }
    }

    private void innerWriteGraph(Graph g, LinkedHashMap<String, Object> stringPool, AtomicLong filePtr, FileChannel fileChannel) {
        ArrayBuffer nodes = ArrayBuffer$.MODULE$.empty();
        ArrayBuffer edges = ArrayBuffer$.MODULE$.empty();
        ArrayBuffer properties = ArrayBuffer$.MODULE$.empty();
        g.schema().nodeKinds().foreach((Function1 & Serializable)nodeKind -> this.innerWriteGraph$$anonfun$1(g, nodes, BoxesRunTime.unboxToInt((Object)nodeKind)));
        g.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> g.schema().edgeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)edgeKind -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])Edge$Direction$.MODULE$.values());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)direction -> {
                int pos = g.schema().neighborOffsetArrayIndex(nodeKind, (Edge.Direction)direction, edgeKind);
                if (g.neighbors()[pos] != null) {
                    String nodeLabel = g.schema().getNodeLabel(nodeKind);
                    String edgeLabel = g.schema().getEdgeLabel(nodeKind, edgeKind);
                    Manifest.EdgeItem edgeItem = new Manifest.EdgeItem(nodeLabel, edgeLabel, direction.encoding(), null, null, null);
                    edges.addOne((Object)edgeItem);
                    edgeItem.qty_$eq(MODULE$.encodeAny(MODULE$.deltaEncode(g.nodeCountByKind(nodeKind), (int[])g.neighbors()[pos]), filePtr, stringPool, fileChannel));
                    edgeItem.neighbors_$eq(MODULE$.encodeAny(g.neighbors()[pos + 1], filePtr, stringPool, fileChannel));
                    edgeItem.property_$eq(MODULE$.encodeAny(g.neighbors()[pos + 2], filePtr, stringPool, fileChannel));
                    return;
                }
            });
        }));
        g.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> g.schema().propertyKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)propertyKind -> {
            int pos = g.schema().propertyOffsetArrayIndex(nodeKind, propertyKind);
            if (g.properties()[pos] != null) {
                String nodeLabel = g.schema().getNodeLabel(nodeKind);
                String propertyLabel = g.schema().getPropertyLabel(nodeKind, propertyKind);
                Manifest.PropertyItem propertyItem = new Manifest.PropertyItem(nodeLabel, propertyLabel, null, null);
                properties.addOne((Object)propertyItem);
                propertyItem.qty_$eq(MODULE$.encodeAny(MODULE$.deltaEncode(g.nodeCountByKind(nodeKind), (int[])g.properties()[pos]), filePtr, stringPool, fileChannel));
                propertyItem.property_$eq(MODULE$.encodeAny(g.properties()[pos + 1], filePtr, stringPool, fileChannel));
                return;
            }
        }));
        byte[] poolLenBytes = new byte[4 * stringPool.size()];
        IntBuffer poolLenBuffer = ByteBuffer.wrap(poolLenBytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        ByteArrayOutputStream poolBytes = new ByteArrayOutputStream();
        stringPool.keysIterator().foreach((Function1 & Serializable)s -> {
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            poolBytes.write(bytes);
            return poolLenBuffer.put(bytes.length);
        });
        Manifest.OutlineStorage poolLensStored = new Manifest.OutlineStorage(package$StorageType$.MODULE$.Int());
        Manifest.OutlineStorage poolBytesStored = new Manifest.OutlineStorage(package$StorageType$.MODULE$.Byte());
        this.write(poolLenBytes, poolLensStored, filePtr, fileChannel);
        this.write(poolBytes.toByteArray(), poolBytesStored, filePtr, fileChannel);
        long pos = filePtr.get();
        byte[] header = new byte[16];
        ByteBuffer headerBuf = ByteBuffer.wrap(header);
        headerBuf.order(ByteOrder.LITTLE_ENDIAN).put(package$Keys$.MODULE$.Header()).asLongBuffer().put(pos);
        headerBuf.position(0);
        long headPos = 0L;
        while (headerBuf.hasRemaining()) {
            headPos += (long)fileChannel.write(headerBuf, headPos);
        }
        Manifest.GraphItem manifest = new Manifest.GraphItem((Manifest.NodeItem[])nodes.toArray(ClassTag$.MODULE$.apply(Manifest.NodeItem.class)), (Manifest.EdgeItem[])edges.toArray(ClassTag$.MODULE$.apply(Manifest.EdgeItem.class)), (Manifest.PropertyItem[])properties.toArray(ClassTag$.MODULE$.apply(Manifest.PropertyItem.class)), poolLensStored, poolBytesStored);
        Value manifestObj = Manifest$GraphItem$.MODULE$.write(manifest);
        ByteBuffer buf = ByteBuffer.wrap(manifestObj.render(manifestObj.render$default$1(), manifestObj.render$default$2()).getBytes(StandardCharsets.UTF_8));
        while (buf.hasRemaining()) {
            pos += (long)fileChannel.write(buf, pos);
        }
        fileChannel.truncate(pos);
    }

    private int[] deltaEncode(int padTo, int[] offsets) {
        if (offsets == null) {
            return null;
        }
        int[] res = new int[padTo + 1];
        if (offsets.length != 0 && offsets[0] != 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        int until = package$.MODULE$.min(offsets.length - 1, padTo);
        for (int idx = 0; idx < until; ++idx) {
            res[idx] = offsets[idx + 1] - offsets[idx];
        }
        return res;
    }

    public Manifest.OutlineStorage encodeAny(Object item, AtomicLong filePtr, LinkedHashMap<String, Object> stringPool, FileChannel fileChannel) {
        Object object = item;
        if (object instanceof DefaultValue) {
            return null;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof boolean[]) {
            boolean[] bools = (boolean[])object;
            Object object2 = Predef$.MODULE$.booleanArrayOps(bools);
            return this.write((byte[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)b -> Serialization$.encodeAny$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)b)), ClassTag$.MODULE$.apply(Byte.TYPE)), new Manifest.OutlineStorage(package$StorageType$.MODULE$.Bool()), filePtr, fileChannel);
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return this.write(bytes, new Manifest.OutlineStorage(package$StorageType$.MODULE$.Byte()), filePtr, fileChannel);
        }
        if (object instanceof short[]) {
            short[] shorts = (short[])object;
            byte[] bytes = new byte[2 * shorts.length];
            ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().put(shorts);
            return this.write(bytes, new Manifest.OutlineStorage(package$StorageType$.MODULE$.Short()), filePtr, fileChannel);
        }
        if (object instanceof int[]) {
            int[] ints = (int[])object;
            byte[] bytes = new byte[4 * ints.length];
            ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().put(ints);
            return this.write(bytes, new Manifest.OutlineStorage(package$StorageType$.MODULE$.Int()), filePtr, fileChannel);
        }
        if (object instanceof long[]) {
            long[] longs = (long[])object;
            byte[] bytes = new byte[8 * longs.length];
            ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().put(longs);
            return this.write(bytes, new Manifest.OutlineStorage(package$StorageType$.MODULE$.Long()), filePtr, fileChannel);
        }
        if (object instanceof float[]) {
            float[] floats = (float[])object;
            byte[] bytes = new byte[4 * floats.length];
            ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().put(floats);
            return this.write(bytes, new Manifest.OutlineStorage(package$StorageType$.MODULE$.Float()), filePtr, fileChannel);
        }
        if (object instanceof double[]) {
            double[] doubles = (double[])object;
            byte[] bytes = new byte[8 * doubles.length];
            ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer().put(doubles);
            return this.write(bytes, new Manifest.OutlineStorage(package$StorageType$.MODULE$.Double()), filePtr, fileChannel);
        }
        if (object instanceof GNode[]) {
            Object[] refs = (GNode[])object;
            byte[] bytes = new byte[8 * refs.length];
            ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            Object object3 = Predef$.MODULE$.refArrayOps(refs);
            ArrayOps$.MODULE$.foreach$extension(object3, (Function1 & Serializable)ref -> {
                if (ref == null) {
                    return buf.putLong(0xFFFFFFFFFFFFL);
                }
                return buf.putLong((long)ref.seq() + ((long)ref.nodeKind << 32));
            });
            return this.write(bytes, new Manifest.OutlineStorage(package$StorageType$.MODULE$.Ref()), filePtr, fileChannel);
        }
        if (object instanceof String[]) {
            Object[] strings = (String[])object;
            Object object4 = Predef$.MODULE$.refArrayOps(strings);
            int[] indices = (int[])ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)s -> MODULE$.insertString(stringPool, (String)s), ClassTag$.MODULE$.apply(Integer.TYPE));
            byte[] bytes = new byte[4 * strings.length];
            ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().put(indices);
            return this.write(bytes, new Manifest.OutlineStorage(package$StorageType$.MODULE$.String()), filePtr, fileChannel);
        }
        throw new MatchError(object);
    }

    public Manifest.OutlineStorage write(byte[] bytes, Manifest.OutlineStorage res, AtomicLong filePtr, FileChannel fileChannel) {
        res.decompressedLength_$eq(bytes.length);
        byte[] compressed = Zstd.compress((byte[])bytes);
        long outPos = filePtr.getAndAdd(Int$.MODULE$.int2long(compressed.length));
        res.startOffset_$eq(outPos);
        res.compressedLength_$eq(compressed.length);
        ByteBuffer buf = ByteBuffer.wrap(compressed);
        while (buf.hasRemaining()) {
            outPos += (long)fileChannel.write(buf, outPos);
        }
        return res;
    }

    private int insertString(LinkedHashMap<String, Object> stringPool, String s) {
        if (s == null) {
            return -1;
        }
        return BoxesRunTime.unboxToInt((Object)stringPool.getOrElseUpdate((Object)s, () -> Serialization$.insertString$$anonfun$1(stringPool)));
    }

    private final /* synthetic */ ArrayBuffer innerWriteGraph$$anonfun$1(Graph g$1, ArrayBuffer nodes$1, int nodeKind) {
        String nodeLabel = g$1.schema().getNodeLabel(nodeKind);
        Object object = Predef$.MODULE$.refArrayOps(g$1.nodesArray()[nodeKind]);
        int[] deletions = (int[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(GNode x) {
                GNode deleted;
                GNode gNode = x;
                return gNode != null && AccessHelpers.isDeleted(deleted = gNode);
            }

            public final Object applyOrElse(GNode x, Function1 function1) {
                GNode deleted;
                GNode gNode = x;
                if (gNode != null && AccessHelpers.isDeleted(deleted = gNode)) {
                    return BoxesRunTime.boxToInteger((int)deleted.seq());
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(Integer.TYPE));
        int size = g$1.nodeCountByKind(nodeKind);
        return nodes$1.addOne((Object)new Manifest.NodeItem(nodeLabel, size, deletions));
    }

    private static final /* synthetic */ byte encodeAny$$anonfun$1(boolean b) {
        if (b) {
            return (byte)1;
        }
        return (byte)0;
    }

    private static final int insertString$$anonfun$1(LinkedHashMap stringPool$7) {
        return stringPool$7.size();
    }
}

