/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.util;

import flatgraph.Accessors;
import flatgraph.Edge;
import flatgraph.GNode;
import flatgraph.Graph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.jdk.javaapi.CollectionConverters;

public class DiffTool {
    public static List<String> compare(Graph graph1, Graph graph2) {
        ArrayList<String> diff = new ArrayList<String>();
        if (graph1.nodeCount() != graph2.nodeCount()) {
            diff.add(String.format("node count differs: graph1=%d, graph2=%d", graph1.nodeCount(), graph2.nodeCount()));
        }
        TreeSet nodeIds = new TreeSet();
        graph1.allNodes().foreach(node -> nodeIds.add(node.id()));
        graph2.allNodes().foreach(node -> nodeIds.add(node.id()));
        nodeIds.forEach(nodeId -> {
            GNode node1 = graph1.node((long)nodeId);
            GNode node2 = graph2.node((long)nodeId);
            if (node1 == null) {
                diff.add(String.format("node %s only exists in graph2", node2));
            } else if (node2 == null) {
                diff.add(String.format("node %s only exists in graph1", node1));
            } else {
                if (!node1.label().equals(node2.label())) {
                    diff.add(String.format("different label for nodeId=%d; graph1=%s, graph2=%s ", nodeId, node1.label(), node2.label()));
                }
                String context = "nodeId=" + nodeId;
                DiffTool.compareProperties(DiffTool.properties(node1), DiffTool.properties(node2), diff, context);
                DiffTool.compareEdges(DiffTool.outEdges(node1), DiffTool.outEdges(node2), diff, context + ".outE");
            }
        });
        return diff;
    }

    private static java.util.Iterator<Edge> outEdges(GNode node) {
        return CollectionConverters.asJava((Iterator)Accessors.getEdgesOut(node).iterator());
    }

    private static Map<String, Object> properties(GNode node) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        CollectionConverters.asJava((Iterator)Accessors.getNodeProperties(node).iterator()).forEachRemaining(keyValue -> properties.put((String)keyValue._1, keyValue._2));
        return properties;
    }

    private static void compareProperties(Map<String, Object> properties1, Map<String, Object> properties2, List<String> diff, String context) {
        TreeSet<String> propertyKeys = new TreeSet<String>();
        propertyKeys.addAll(properties1.keySet());
        propertyKeys.addAll(properties2.keySet());
        propertyKeys.forEach(key -> DiffTool.compareProperty(key, properties1.get(key), properties2.get(key), diff, context));
    }

    private static void compareProperty(String key, Object value1, Object value2, List<String> diff, String context) {
        if (value1 != null && value2 != null) {
            if (value1 instanceof IterableOnce && value2 instanceof IterableOnce) {
                if (!DiffTool.iterablesEqual((IterableOnce)value1, (IterableOnce)value2)) {
                    diff.add(String.format("%s; property '%s' has different values: graph1='%s', graph2='%s'", context, key, value1, value2));
                }
            } else if (value1.getClass().isArray() && value2.getClass().isArray()) {
                if (!DiffTool.arraysEqual(value1, value2)) {
                    diff.add(String.format("%s; property '%s' has different values: graph1='%s', graph2='%s'", context, key, value1, value2));
                }
            } else if (!value1.equals(value2)) {
                diff.add(String.format("%s; property '%s' has different values: graph1='%s', graph2='%s'", context, key, value1, value2));
            }
        } else if (value1 == null && value2 != null) {
            diff.add(String.format("%s; property '%s' -> '%s' only exists in graph2", context, key, value2));
        } else if (value1 != null && value2 == null) {
            diff.add(String.format("%s; property '%s' -> '%s' only exists in graph1", context, key, value1));
        }
    }

    private static boolean iterablesEqual(IterableOnce<?> values1, IterableOnce<?> values2) {
        Iterator iterator1 = values1.iterator();
        Iterator iterator2 = values2.iterator();
        while (iterator1.hasNext() || iterator2.hasNext()) {
            if (iterator1.hasNext() && !iterator2.hasNext() || !iterator1.hasNext() && iterator2.hasNext()) {
                return false;
            }
            Object value1 = iterator1.next();
            Object value2 = iterator2.next();
            if (value1 instanceof GNode && value2 instanceof GNode) {
                GNode node1 = (GNode)value1;
                GNode node2 = (GNode)value2;
                if (node1.nodeKind == node2.nodeKind && node1.seq() == node2.seq()) continue;
                return false;
            }
            if (value1.equals(value2)) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEqual(Object value1, Object value2) {
        if (value1 instanceof Object[] && value2 instanceof Object[]) {
            return Arrays.deepEquals((Object[])value1, (Object[])value2);
        }
        if (value1 instanceof boolean[] && value2 instanceof int[]) {
            return Arrays.equals((boolean[])value1, (boolean[])value2);
        }
        if (value1 instanceof byte[] && value2 instanceof byte[]) {
            return Arrays.equals((byte[])value1, (byte[])value2);
        }
        if (value1 instanceof char[] && value2 instanceof char[]) {
            return Arrays.equals((char[])value1, (char[])value2);
        }
        if (value1 instanceof short[] && value2 instanceof short[]) {
            return Arrays.equals((short[])value1, (short[])value2);
        }
        if (value1 instanceof int[] && value2 instanceof int[]) {
            return Arrays.equals((int[])value1, (int[])value2);
        }
        if (value1 instanceof long[] && value2 instanceof long[]) {
            return Arrays.equals((long[])value1, (long[])value2);
        }
        if (value1 instanceof float[] && value2 instanceof float[]) {
            return Arrays.equals((float[])value1, (float[])value2);
        }
        if (value1 instanceof double[] && value2 instanceof double[]) {
            return Arrays.equals((double[])value1, (double[])value2);
        }
        throw new AssertionError((Object)String.format("unable to compare given objects (%s of type %s; %s of type %s)", value1, value1.getClass(), value2, value2.getClass()));
    }

    private static void compareEdges(java.util.Iterator<Edge> edges1, java.util.Iterator<Edge> edges2, List<String> diff, String context) {
        List<Edge> edges1Sorted = DiffTool.sort(edges1);
        List<Edge> edges2Sorted = DiffTool.sort(edges2);
        if (edges1Sorted.size() != edges2Sorted.size()) {
            diff.add(String.format("%s; different number of edges: graph1=%d, graph2=%d", context, edges1Sorted.size(), edges2Sorted.size()));
        } else {
            java.util.Iterator<Edge> edges1SortedIter = edges1Sorted.iterator();
            java.util.Iterator<Edge> edges2SortedIter = edges2Sorted.iterator();
            while (edges1SortedIter.hasNext()) {
                Edge edge1 = edges1SortedIter.next();
                Edge edge2 = edges2SortedIter.next();
                if (!edge1.label().equals(edge2.label())) {
                    diff.add(String.format("%s; different label for sorted edges; graph1=%s, graph2=%s ", context, edge1.label(), edge2.label()));
                    continue;
                }
                DiffTool.compareProperty("EDGE_PROPERTY", edge1.property(), edge2.property(), diff, String.format("%s; edge label = %s", context, edge1.label()));
            }
        }
    }

    private static List<Edge> sort(java.util.Iterator<Edge> edges) {
        LinkedList<Edge> edgesSorted = new LinkedList<Edge>();
        edges.forEachRemaining(edgesSorted::add);
        edgesSorted.sort(Comparator.comparing(edge -> String.format("%s %s", edge.label(), edge.property())));
        return edgesSorted;
    }
}

