/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.storage;

import com.github.luben.zstd.Zstd;
import flatgraph.AccessHelpers;
import flatgraph.Edge;
import flatgraph.Edge$Direction$;
import flatgraph.FreeSchema;
import flatgraph.FreeSchema$;
import flatgraph.GNode;
import flatgraph.Graph;
import flatgraph.Schema;
import flatgraph.storage.Deserialization;
import flatgraph.storage.Deserialization$DeserializationException$;
import flatgraph.storage.Manifest;
import flatgraph.storage.Manifest$GraphItem$;
import flatgraph.storage.package$;
import flatgraph.storage.package$Keys$;
import flatgraph.storage.package$StorageType$;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Byte$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Short$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;

public final class Deserialization$
implements Serializable {
    public static final Deserialization$DeserializationException$ DeserializationException;
    public static final Deserialization$ MODULE$;

    private Deserialization$() {
    }

    static {
        MODULE$ = new Deserialization$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Deserialization$.class);
    }

    public Graph readGraph(Path storagePath, Option<Schema> schemaMaybe, boolean persistOnClose) {
        Graph graph;
        try (FileChannel fileChannel = new RandomAccessFile(storagePath.toAbsolutePath().toFile(), "r").getChannel();){
            Manifest.GraphItem manifest = this.readManifest(fileChannel);
            String[] pool = this.readPool(manifest, fileChannel);
            Schema schema = (Schema)schemaMaybe.getOrElse(() -> Deserialization$.$anonfun$1(manifest));
            None$ storagePathMaybe = persistOnClose ? Option$.MODULE$.apply((Object)storagePath) : None$.MODULE$;
            Graph g = new Graph(schema, (Option<Path>)storagePathMaybe);
            HashMap nodekinds = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            g.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> nodekinds.update((Object)g.schema().getNodeLabel(nodeKind), (Object)BoxesRunTime.boxToShort((short)((short)nodeKind))));
            Object object = Predef$.MODULE$.refArrayOps((Object[])manifest.nodes());
            short[] kindRemapper = (short[])Array$.MODULE$.fill(ArrayOps$.MODULE$.size$extension(object), Deserialization$::$anonfun$2, ClassTag$.MODULE$.apply(Short.TYPE));
            GNode[][] nodeRemapper = new GNode[manifest.nodes().length][];
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])manifest.nodes());
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object2));
            ArrayOps$.MODULE$.foreach$extension(object3, (Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Manifest.NodeItem nodeItem = (Manifest.NodeItem)tuple2._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    nodekinds.get((Object)nodeItem.nodeLabel()).foreach((Function1 & Serializable)v1 -> {
                        Deserialization$.readGraph$$anonfun$2$$anonfun$1(kindRemapper, idx, nodeItem, g, nodeRemapper, BoxesRunTime.unboxToShort((Object)v1));
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            HashMap edgeKinds = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            g.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> g.schema().edgeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)edgeKind -> {
                String nodeLabel = g.schema().getNodeLabel(nodeKind);
                String edgeLabel = g.schema().getEdgeLabel(nodeKind, edgeKind);
                if (edgeLabel != null) {
                    edgeKinds.update((Object)Tuple2$.MODULE$.apply((Object)nodeLabel, (Object)edgeLabel), (Object)BoxesRunTime.boxToShort((short)((short)edgeKind)));
                    return;
                }
            }));
            Object object4 = Predef$.MODULE$.refArrayOps((Object[])manifest.edges());
            ArrayOps$.MODULE$.foreach$extension(object4, (Function1)(JProcedure1 & Serializable)edgeItem -> {
                Option nodeKind = nodekinds.get((Object)edgeItem.nodeLabel());
                Option edgeKind = edgeKinds.get((Object)Tuple2$.MODULE$.apply((Object)edgeItem.nodeLabel(), (Object)edgeItem.edgeLabel()));
                Edge.Direction direction = Edge$Direction$.MODULE$.fromOrdinal(Byte$.MODULE$.byte2int(edgeItem.inout()));
                if (nodeKind.isDefined() && edgeKind.isDefined()) {
                    int pos = g.schema().neighborOffsetArrayIndex(Short$.MODULE$.short2int(BoxesRunTime.unboxToShort((Object)nodeKind.get())), direction, Short$.MODULE$.short2int(BoxesRunTime.unboxToShort((Object)edgeKind.get())));
                    g$7.neighbors()[pos] = MODULE$.deltaDecode((int[])MODULE$.readArray(fileChannel, edgeItem.qty(), nodeRemapper, pool));
                    g$7.neighbors()[pos + 1] = MODULE$.readArray(fileChannel, edgeItem.neighbors(), nodeRemapper, pool);
                    Object property = MODULE$.readArray(fileChannel, edgeItem.property(), nodeRemapper, pool);
                    if (property != null) {
                        g$7.neighbors()[pos + 2] = property;
                        return;
                    }
                    return;
                }
            });
            HashMap propertykinds = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            g.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> g.schema().propertyKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)propertyKind -> {
                String nodeLabel = g.schema().getNodeLabel(nodeKind);
                String propertyLabel = g.schema().getPropertyLabel(nodeKind, propertyKind);
                if (propertyLabel != null) {
                    propertykinds.update((Object)Tuple2$.MODULE$.apply((Object)nodeLabel, (Object)propertyLabel), (Object)BoxesRunTime.boxToInteger((int)propertyKind));
                    return;
                }
            }));
            Object object5 = Predef$.MODULE$.refArrayOps((Object[])manifest.properties());
            ArrayOps$.MODULE$.foreach$extension(object5, (Function1)(JProcedure1 & Serializable)property -> {
                Option nodeKind = nodekinds.get((Object)property.nodeLabel());
                Option propertyKind = propertykinds.get((Object)Tuple2$.MODULE$.apply((Object)property.nodeLabel(), (Object)property.propertyLabel()));
                if (nodeKind.isDefined() && propertyKind.isDefined()) {
                    int pos = g.schema().propertyOffsetArrayIndex(Short$.MODULE$.short2int(BoxesRunTime.unboxToShort((Object)nodeKind.get())), BoxesRunTime.unboxToInt((Object)propertyKind.get()));
                    g$10.properties()[pos] = MODULE$.deltaDecode((int[])MODULE$.readArray(fileChannel, property.qty(), nodeRemapper, pool));
                    g$10.properties()[pos + 1] = MODULE$.readArray(fileChannel, property.property(), nodeRemapper, pool);
                    return;
                }
            });
            graph = g;
        }
        return graph;
    }

    public boolean readGraph$default$3() {
        return true;
    }

    private FreeSchema freeSchemaFromManifest(Manifest.GraphItem manifest) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])manifest.nodes());
        String[] nodeLabels = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)n -> n.nodeLabel(), ClassTag$.MODULE$.apply(String.class));
        LinkedHashMap nodePropNames = LinkedHashMap$.MODULE$.empty();
        LinkedHashMap propertyNamesByNodeLabel = LinkedHashMap$.MODULE$.empty();
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])manifest.properties());
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)prop -> {
            propertyNamesByNodeLabel.updateWith((Object)prop.nodeLabel(), (Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (None$.MODULE$.equals(option)) {
                    return Some$.MODULE$.apply(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{prop.propertyLabel()})));
                }
                if (option instanceof Some) {
                    Set oldEntries = (Set)((Some)option).value();
                    return Some$.MODULE$.apply((Object)oldEntries.$plus((Object)prop.propertyLabel()));
                }
                throw new MatchError((Object)option);
            });
            nodePropNames.update((Object)prop.propertyLabel(), MODULE$.protoFromOutline(prop.property()));
        });
        String[] propertyLabels = (String[])nodePropNames.keysIterator().toArray(ClassTag$.MODULE$.apply(String.class));
        Object[] nodePropertyPrototypes = (Object[])nodePropNames.valuesIterator().toArray(ClassTag$.MODULE$.apply(Object.class));
        LinkedHashMap edgePropNames = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])manifest.edges());
        ArrayOps$.MODULE$.foreach$extension(object3, (Function1)(JProcedure1 & Serializable)edge -> {
            Option option = edgePropNames.get((Object)edge.edgeLabel());
            if (None$.MODULE$.equals(option) || option instanceof Some && ((Some)option).value() == null) {
                edgePropNames.update((Object)edge.edgeLabel(), MODULE$.protoFromOutline(edge.property()));
                return;
            }
        });
        String[] edgeLabels = (String[])edgePropNames.keysIterator().toArray(ClassTag$.MODULE$.apply(String.class));
        Object[] edgePropertyPrototypes = (Object[])edgePropNames.valuesIterator().toArray(ClassTag$.MODULE$.apply(Object.class));
        return new FreeSchema(nodeLabels, propertyLabels, nodePropertyPrototypes, (Map<String, Set<String>>)propertyNamesByNodeLabel.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), edgeLabels, edgePropertyPrototypes, FreeSchema$.MODULE$.$lessinit$greater$default$7());
    }

    private Object protoFromOutline(Manifest.OutlineStorage outline) {
        if (outline == null) {
            return null;
        }
        String string = outline.typ();
        String string2 = package$StorageType$.MODULE$.Bool();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new boolean[0];
        }
        String string4 = package$StorageType$.MODULE$.Byte();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new byte[0];
        }
        String string6 = package$StorageType$.MODULE$.Short();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return new short[0];
        }
        String string8 = package$StorageType$.MODULE$.Int();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return new int[0];
        }
        String string10 = package$StorageType$.MODULE$.Long();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return new long[0];
        }
        String string12 = package$StorageType$.MODULE$.Float();
        String string13 = string;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            return new float[0];
        }
        String string14 = package$StorageType$.MODULE$.Double();
        String string15 = string;
        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
            return new double[0];
        }
        String string16 = package$StorageType$.MODULE$.Ref();
        String string17 = string;
        if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
            return new GNode[0];
        }
        String string18 = package$StorageType$.MODULE$.String();
        String string19 = string;
        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
            return new String[0];
        }
        throw new MatchError((Object)string);
    }

    private Manifest.GraphItem readManifest(FileChannel channel) {
        int readBytes;
        if (channel.size() < (long)package$.MODULE$.HeaderSize()) {
            throw new Deserialization.DeserializationException(new StringBuilder(55).append("corrupt file, expected at least ").append(package$.MODULE$.HeaderSize()).append(" bytes, but only found ").append(channel.size()).toString(), Deserialization$DeserializationException$.MODULE$.$lessinit$greater$default$2());
        }
        ByteBuffer header = ByteBuffer.allocate(package$.MODULE$.HeaderSize()).order(ByteOrder.LITTLE_ENDIAN);
        for (readBytes = 0; readBytes < package$.MODULE$.HeaderSize(); readBytes += channel.read(header, Int$.MODULE$.int2long(readBytes))) {
        }
        header.flip();
        if (header.getLong() != package$Keys$.MODULE$.Header()) {
            throw new Deserialization.DeserializationException(new StringBuilder(32).append("expected header (`").append(package$Keys$.MODULE$.Header()).append("`), but found ").append(header.getLong()).toString(), Deserialization$DeserializationException$.MODULE$.$lessinit$greater$default$2());
        }
        long manifestOffset = header.getLong();
        long manifestSize = channel.size() - manifestOffset;
        ByteBuffer manifestBytes = ByteBuffer.allocate((int)manifestSize);
        readBytes = 0;
        while ((long)readBytes < manifestSize) {
            readBytes += channel.read(manifestBytes, (long)readBytes + manifestOffset);
        }
        manifestBytes.flip();
        Value jsonObj = ujson.package$.MODULE$.read((Readable)Readable$.MODULE$.fromByteBuffer(manifestBytes), ujson.package$.MODULE$.read$default$2());
        return Manifest$GraphItem$.MODULE$.read(jsonObj);
    }

    private String[] readPool(Manifest.GraphItem manifest, FileChannel fileChannel) {
        ByteBuffer stringPoolLength = Zstd.decompress((ByteBuffer)fileChannel.map(FileChannel.MapMode.READ_ONLY, manifest.stringPoolLength().startOffset(), Int$.MODULE$.int2long(manifest.stringPoolLength().compressedLength())), (int)manifest.stringPoolLength().decompressedLength()).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer stringPoolBytes = Zstd.decompress((ByteBuffer)fileChannel.map(FileChannel.MapMode.READ_ONLY, manifest.stringPoolBytes().startOffset(), Int$.MODULE$.int2long(manifest.stringPoolBytes().compressedLength())), (int)manifest.stringPoolBytes().decompressedLength()).order(ByteOrder.LITTLE_ENDIAN);
        byte[] poolBytes = new byte[manifest.stringPoolBytes().decompressedLength()];
        stringPoolBytes.get(poolBytes);
        String[] pool = new String[manifest.stringPoolLength().decompressedLength() >> 2];
        int idx = 0;
        int poolPtr = 0;
        while (idx < pool.length) {
            int len = stringPoolLength.getInt();
            pool[idx] = new String(poolBytes, poolPtr, len, StandardCharsets.UTF_8);
            ++idx;
            poolPtr += len;
        }
        return pool;
    }

    private int[] deltaDecode(int[] a) {
        if (a == null) {
            return null;
        }
        int cumsum = 0;
        for (int idx = 0; idx < a.length; ++idx) {
            int tmp = a[idx];
            a[idx] = cumsum;
            cumsum += tmp;
        }
        return a;
    }

    private Object readArray(FileChannel channel, Manifest.OutlineStorage ptr, GNode[][] nodes, String[] stringPool) {
        if (ptr == null) {
            return null;
        }
        ByteBuffer dec = Zstd.decompress((ByteBuffer)channel.map(FileChannel.MapMode.READ_ONLY, ptr.startOffset(), Int$.MODULE$.int2long(ptr.compressedLength())), (int)ptr.decompressedLength()).order(ByteOrder.LITTLE_ENDIAN);
        String string = ptr.typ();
        String string2 = package$StorageType$.MODULE$.Bool();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            byte[] bytes = new byte[dec.limit()];
            dec.get(bytes);
            Object object = Predef$.MODULE$.byteArrayOps(bytes);
            return ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> Deserialization$.readArray$$anonfun$1(BoxesRunTime.unboxToByte((Object)x$1)), ClassTag$.MODULE$.apply(Boolean.TYPE));
        }
        String string4 = package$StorageType$.MODULE$.Byte();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            byte[] bytes = new byte[dec.limit()];
            dec.get(bytes);
            return bytes;
        }
        String string6 = package$StorageType$.MODULE$.Short();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            short[] res = new short[dec.limit() >> 1];
            dec.asShortBuffer().get(res);
            return res;
        }
        String string8 = package$StorageType$.MODULE$.Int();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            int[] res = new int[dec.limit() >> 2];
            dec.asIntBuffer().get(res);
            return res;
        }
        String string10 = package$StorageType$.MODULE$.Long();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            long[] res = new long[dec.limit() >> 3];
            dec.asLongBuffer().get(res);
            return res;
        }
        String string12 = package$StorageType$.MODULE$.Float();
        String string13 = string;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            float[] res = new float[dec.limit() >> 2];
            dec.asFloatBuffer().get(res);
            return res;
        }
        String string14 = package$StorageType$.MODULE$.Double();
        String string15 = string;
        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
            double[] res = new double[dec.limit() >> 3];
            dec.asDoubleBuffer().get(res);
            return res;
        }
        String string16 = package$StorageType$.MODULE$.String();
        String string17 = string;
        if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
            String[] res = new String[dec.limit() >> 2];
            IntBuffer intbuf = dec.asIntBuffer();
            for (int idx = 0; idx < res.length; ++idx) {
                int offset = intbuf.get(idx);
                if (offset < 0) continue;
                res[idx] = stringPool[offset];
            }
            return res;
        }
        String string18 = package$StorageType$.MODULE$.Ref();
        String string19 = string;
        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
            GNode[] res = new GNode[dec.limit() >> 3];
            LongBuffer longbuf = dec.asLongBuffer();
            for (int idx = 0; idx < res.length; ++idx) {
                long encodedRef = longbuf.get();
                int kind = (int)(encodedRef >>> 32);
                int seqid = (int)encodedRef;
                if (kind < 0 || kind >= nodes.length) continue;
                res[idx] = nodes[kind][seqid];
            }
            return res;
        }
        throw new MatchError((Object)string);
    }

    private static final Schema $anonfun$1(Manifest.GraphItem manifest$1) {
        return MODULE$.freeSchemaFromManifest(manifest$1);
    }

    private static final short $anonfun$2() {
        return (short)-1;
    }

    private static final /* synthetic */ void readGraph$$anonfun$2$$anonfun$1(short[] kindRemapper$2, int idx$1, Manifest.NodeItem nodeItem$1, Graph g$3, GNode[][] nodeRemapper$2, short nodeKind) {
        kindRemapper$2[idx$1] = nodeKind;
        GNode[] nodes = new GNode[nodeItem$1.nnodes()];
        scala.package$.MODULE$.Range().apply(0, nodes.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)seq -> {
            nodes$1[seq] = g$3.schema().makeNode(g$3, nodeKind, seq);
        });
        g$3.nodesArray()[Short$.MODULE$.short2int((short)nodeKind)] = nodes;
        nodeRemapper$2[idx$1] = nodes;
        if (nodeItem$1.deletions() != null) {
            Object object = Predef$.MODULE$.intArrayOps(nodeItem$1.deletions());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JFunction1.mcVI.sp & Serializable)del -> {
                GNode node = nodes[del];
                if (!AccessHelpers.isDeleted(node)) {
                    AccessHelpers.markDeleted(nodes[del]);
                    return;
                }
                throw new RuntimeException();
            });
            g$3.livingNodeCountByKind()[Short$.MODULE$.short2int((short)nodeKind)] = nodes.length - nodeItem$1.deletions().length;
            return;
        }
        g$3.livingNodeCountByKind()[Short$.MODULE$.short2int((short)nodeKind)] = nodes.length;
    }

    private static final /* synthetic */ boolean readArray$$anonfun$1(byte x$1) {
        byte by = x$1;
        if (0 == by) {
            return false;
        }
        if (1 == by) {
            return true;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }
}

