/*
 * Decompiled with CFR 0.152.
 */
package flatgraph;

import flatgraph.DNode;
import flatgraph.DNodeOrNode;
import flatgraph.DefaultValue$;
import flatgraph.DiffGraphBuilder$;
import flatgraph.Edge;
import flatgraph.GNode;
import flatgraph.Schema;
import flatgraph.Schema$;
import flatgraph.SchemaViolationException;
import flatgraph.misc.Conversions$;
import flatgraph.misc.SchemaViolationReporter;
import scala.Short$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.ArrayDeque$;
import scala.runtime.ScalaRunTime$;

public class DiffGraphBuilder {
    private final Schema schema;
    private final SchemaViolationReporter schemaViolationReporter;
    private ArrayDeque<RawUpdate> buffer;

    public static SchemaViolationReporter $lessinit$greater$default$2() {
        return DiffGraphBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    public DiffGraphBuilder(Schema schema, SchemaViolationReporter schemaViolationReporter) {
        this.schema = schema;
        this.schemaViolationReporter = schemaViolationReporter;
        this.buffer = (ArrayDeque)ArrayDeque$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RawUpdate[0]));
    }

    public ArrayDeque<RawUpdate> buffer() {
        return this.buffer;
    }

    public void buffer_$eq(ArrayDeque<RawUpdate> x$1) {
        this.buffer = x$1;
    }

    public DiffGraphBuilder addNode(DNode newNode) {
        this.buffer().append((Object)newNode);
        return this;
    }

    public DiffGraphBuilder addEdge(DNodeOrNode src, DNodeOrNode dst, String edgeLabel, Object property) {
        int edgeKind = this.schema.getEdgeKindByLabel(edgeLabel);
        if (edgeKind == Schema$.MODULE$.UndefinedKind()) {
            throw new SchemaViolationException(new StringBuilder(22).append("unknown edge label: `").append(edgeLabel).append("`").toString());
        }
        return this._addEdge(src, dst, Conversions$.MODULE$.toShortSafely(edgeKind), property);
    }

    public Object addEdge$default$4() {
        return DefaultValue$.MODULE$;
    }

    public DiffGraphBuilder _addEdge(DNodeOrNode src, DNodeOrNode dst, short edgeKind, Object property) {
        this.buffer().append((Object)new AddEdgeUnprocessed(src, dst, edgeKind, property));
        return this;
    }

    public Object _addEdge$default$4() {
        return DefaultValue$.MODULE$;
    }

    public DiffGraphBuilder setEdgeProperty(Edge edge, Object property) {
        this.buffer().append((Object)new SetEdgeProperty(edge, property));
        return this;
    }

    public DiffGraphBuilder setNodeProperty(GNode node, String propertyName, Object property) {
        int n = this.schema.getPropertyKindByName(propertyName);
        if (Schema$.MODULE$.UndefinedKind() == n) {
            this.schemaViolationReporter.illegalNodeProperty(Short$.MODULE$.short2int(node.nodeKind), propertyName, this.schema);
            return this;
        }
        int propertyKind = n;
        return this._setNodeProperty(node, propertyKind, property);
    }

    public DiffGraphBuilder _setNodeProperty(GNode node, int propertyKind, Object property) {
        this.buffer().append((Object)new SetNodeProperty(node, propertyKind, property));
        return this;
    }

    public DiffGraphBuilder removeEdge(Edge edge) {
        this.buffer().append((Object)new RemoveEdge(edge));
        return this;
    }

    public DiffGraphBuilder removeNode(GNode node) {
        this.buffer().append((Object)new DelNode(node));
        return this;
    }

    public DiffGraphBuilder unsafeAddHalfEdgeForward(DNodeOrNode src, DNodeOrNode dst, int edgeKind, Object property) {
        this.buffer().append((Object)new AddUnsafeHalfEdge(src, dst, Conversions$.MODULE$.toShortSafely(edgeKind), 1, property));
        return this;
    }

    public Object unsafeAddHalfEdgeForward$default$4() {
        return DefaultValue$.MODULE$;
    }

    public DiffGraphBuilder unsafeAddHalfEdgeBackward(DNodeOrNode src, DNodeOrNode dst, int edgeKind, Object property) {
        this.buffer().append((Object)new AddUnsafeHalfEdge(src, dst, Conversions$.MODULE$.toShortSafely(edgeKind), 0, property));
        return this;
    }

    public Object unsafeAddHalfEdgeBackward$default$4() {
        return DefaultValue$.MODULE$;
    }

    public int size() {
        return this.buffer().size();
    }

    public void absorb(DiffGraphBuilder right) {
        if (this.buffer().size() >= right.buffer().size()) {
            this.buffer().appendAll(right.buffer());
            right.buffer_$eq(null);
            return;
        }
        ArrayDeque<RawUpdate> tmp = right.buffer();
        tmp.prependAll(this.buffer());
        this.buffer_$eq(tmp);
        right.buffer_$eq(null);
    }

    public static class AddEdgeUnprocessed
    implements RawUpdate {
        private final DNodeOrNode src;
        private final DNodeOrNode dst;
        private final short edgeKind;
        private final Object property;

        public AddEdgeUnprocessed(DNodeOrNode src, DNodeOrNode dst, short edgeKind, Object property) {
            this.src = src;
            this.dst = dst;
            this.edgeKind = edgeKind;
            this.property = property;
        }

        public DNodeOrNode src() {
            return this.src;
        }

        public DNodeOrNode dst() {
            return this.dst;
        }

        public short edgeKind() {
            return this.edgeKind;
        }

        public Object property() {
            return this.property;
        }
    }

    public static class AddUnsafeHalfEdge
    implements RawUpdate {
        private final DNodeOrNode src;
        private final DNodeOrNode dst;
        private final short edgeKind;
        private final byte inout;
        private final Object property;

        public AddUnsafeHalfEdge(DNodeOrNode src, DNodeOrNode dst, short edgeKind, byte inout, Object property) {
            this.src = src;
            this.dst = dst;
            this.edgeKind = edgeKind;
            this.inout = inout;
            this.property = property;
        }

        public DNodeOrNode src() {
            return this.src;
        }

        public DNodeOrNode dst() {
            return this.dst;
        }

        public short edgeKind() {
            return this.edgeKind;
        }

        public byte inout() {
            return this.inout;
        }

        public Object property() {
            return this.property;
        }
    }

    public static class DelNode
    implements RawUpdate {
        private final GNode node;

        public DelNode(GNode node) {
            this.node = node;
        }

        public GNode node() {
            return this.node;
        }
    }

    public static interface RawUpdate {
    }

    public static class RemoveEdge
    implements RawUpdate {
        private final Edge edge;

        public RemoveEdge(Edge edge) {
            this.edge = edge;
        }

        public Edge edge() {
            return this.edge;
        }
    }

    public static class SetEdgeProperty
    implements RawUpdate {
        private final Edge edge;
        private final Object property;

        public SetEdgeProperty(Edge edge, Object property) {
            this.edge = edge;
            this.property = property;
        }

        public Edge edge() {
            return this.edge;
        }

        public Object property() {
            return this.property;
        }
    }

    public static class SetNodeProperty
    implements RawUpdate {
        private final GNode node;
        private final int propertyKind;
        private final Object property;

        public SetNodeProperty(GNode node, int propertyKind, Object property) {
            this.node = node;
            this.propertyKind = propertyKind;
            this.property = property;
        }

        public GNode node() {
            return this.node;
        }

        public int propertyKind() {
            return this.propertyKind;
        }

        public Object property() {
            return this.property;
        }
    }
}

