/*
 * Decompiled with CFR 0.152.
 */
package flatgraph;

import flatgraph.Accessors$;
import flatgraph.DefaultValue;
import flatgraph.Edge;
import flatgraph.Edge$Direction$;
import flatgraph.GNode;
import flatgraph.Graph$;
import flatgraph.Schema;
import flatgraph.Schema$;
import flatgraph.misc.InitNodeIterator;
import flatgraph.misc.InitNodeIteratorArray;
import flatgraph.misc.InitNodeIteratorArrayFiltered;
import flatgraph.storage.Serialization$;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class Graph
implements AutoCloseable {
    private final Schema schema;
    private final Option<Path> storagePathMaybe;
    private final int nodeKindCount;
    private final int edgeKindCount;
    private boolean closed;
    private final int[] livingNodeCountByKind;
    private final Object[] properties;
    private final AtomicReferenceArray<Object> inverseIndices;
    private final GNode[][] nodesArray;
    private final Object[] neighbors;

    public static int NeighborsSlotSize() {
        return Graph$.MODULE$.NeighborsSlotSize();
    }

    public static int NumberOfDirections() {
        return Graph$.MODULE$.NumberOfDirections();
    }

    public static int PropertySlotSize() {
        return Graph$.MODULE$.PropertySlotSize();
    }

    public static Logger logger() {
        return Graph$.MODULE$.logger();
    }

    public static Graph withStorage(Schema schema, Path path, boolean bl) {
        return Graph$.MODULE$.withStorage(schema, path, bl);
    }

    public static Option<Path> $lessinit$greater$default$2() {
        return Graph$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean withStorage$default$3() {
        return Graph$.MODULE$.withStorage$default$3();
    }

    public Graph(Schema schema, Option<Path> storagePathMaybe) {
        this.schema = schema;
        this.storagePathMaybe = storagePathMaybe;
        this.nodeKindCount = schema.getNumberOfNodeKinds();
        this.edgeKindCount = schema.getNumberOfEdgeKinds();
        int propertiesCount = schema.getNumberOfPropertyKinds();
        this.closed = false;
        this.livingNodeCountByKind = new int[this.nodeKindCount];
        this.properties = new Object[this.nodeKindCount * propertiesCount * Graph$.MODULE$.PropertySlotSize()];
        this.inverseIndices = new AtomicReferenceArray(this.nodeKindCount * propertiesCount * Graph$.MODULE$.PropertySlotSize());
        this.nodesArray = this.makeNodesArray();
        this.neighbors = this.makeNeighbors();
    }

    public Schema schema() {
        return this.schema;
    }

    public Option<Path> storagePathMaybe() {
        return this.storagePathMaybe;
    }

    public int[] livingNodeCountByKind() {
        return this.livingNodeCountByKind;
    }

    public Object[] properties() {
        return this.properties;
    }

    public AtomicReferenceArray<Object> inverseIndices() {
        return this.inverseIndices;
    }

    public GNode[][] nodesArray() {
        return this.nodesArray;
    }

    public Object[] neighbors() {
        return this.neighbors;
    }

    public int nodeCountByKind(int kind) {
        this.schema().verifyNodeKindIsValid(kind);
        return this.nodesArray()[kind].length;
    }

    public InitNodeIterator<GNode> _nodes(int nodeKind) {
        if (nodeKind < 0 || this.schema().getNumberOfNodeKinds() <= nodeKind) {
            return new InitNodeIteratorArray<GNode>((GNode[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(GNode.class)));
        }
        if (this.nodeCountByKind(nodeKind) == this.livingNodeCountByKind()[nodeKind]) {
            return new InitNodeIteratorArray<GNode>(this.nodesArray()[nodeKind]);
        }
        return new InitNodeIteratorArrayFiltered<GNode>(this.nodesArray()[nodeKind]);
    }

    public InitNodeIterator<GNode> nodes(String label) {
        return this._nodes(this.schema().getNodeKindByLabel(label));
    }

    public Iterator<GNode> nodes(Seq<String> labels) {
        if (labels.isEmpty()) {
            return this.allNodes();
        }
        return labels.iterator().flatMap((Function1 & Serializable)label -> this.nodes((String)label));
    }

    public GNode node(long id) {
        return this.node(GNode.extractKind(id), GNode.extractSeq(id));
    }

    public GNode node(int kind, int seq) {
        GNode node = this.nodesArray()[kind][seq];
        if (node._isDeleted) {
            return null;
        }
        return node;
    }

    public GNode node(GNode.KindAndSeq kindAndSeq) {
        return this.node(kindAndSeq.kind, kindAndSeq.seq);
    }

    public Iterator<GNode> allNodes() {
        return this.schema().nodeKinds().iterator().flatMap((Function1 & Serializable)nodeKind -> this.allNodes$$anonfun$1(BoxesRunTime.unboxToInt((Object)nodeKind)));
    }

    public int nodeCount(String label) {
        return this.livingNodeCountByKind()[this.schema().getNodeKindByLabel(label)];
    }

    public int nodeCount() {
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(this.livingNodeCountByKind()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Iterator<Edge> allEdges() {
        return this.allNodes().flatMap((Function1 & Serializable)node -> Accessors$.MODULE$.getEdgesOut((GNode)node));
    }

    public int edgeCount() {
        return this.allEdges().size();
    }

    public Iterator<GNode> nodesWithProperty(String label, String propertyName, String value) {
        int nodeKind = this.schema().getNodeKindByLabel(label);
        int propertyKind = this.schema().getPropertyKindByName(propertyName);
        if (nodeKind == Schema$.MODULE$.UndefinedKind() || propertyKind == Schema$.MODULE$.UndefinedKind()) {
            return package$.MODULE$.Iterator().empty();
        }
        return Accessors$.MODULE$.getWithInverseIndex(this, nodeKind, propertyKind, value);
    }

    public Iterator<GNode> nodesWithProperty(String propertyName, String value) {
        int n = this.schema().getPropertyKindByName(propertyName);
        if (Schema$.MODULE$.UndefinedKind() == n) {
            return package$.MODULE$.Iterator().empty();
        }
        int propertyKind = n;
        return this.schema().nodeKinds().iterator().flatMap((Function1 & Serializable)nodeKind -> this.nodesWithProperty$$anonfun$1(propertyKind, value, BoxesRunTime.unboxToInt((Object)nodeKind)));
    }

    private GNode[][] makeNodesArray() {
        GNode[][] nodes = new GNode[this.nodeKindCount][];
        package$.MODULE$.Range().apply(0, nodes.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> {
            nodes$1[nodeKind] = new GNode[0];
        });
        return nodes;
    }

    private Object[] makeNeighbors() {
        Object[] neighbors = new Object[this.nodeKindCount * this.edgeKindCount * Graph$.MODULE$.NeighborsSlotSize() * Graph$.MODULE$.NumberOfDirections()];
        this.schema().nodeKinds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)nodeKind -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])Edge$Direction$.MODULE$.values());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)direction -> this.schema().edgeKinds().map((Function1 & Serializable)edgeKind -> this.makeNeighbors$$anonfun$1$$anonfun$1$$anonfun$1(nodeKind, (Edge.Direction)direction, BoxesRunTime.unboxToInt((Object)edgeKind))).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple4 tuple4 = x$1;
                if (tuple4 != null) {
                    int edgeKind = BoxesRunTime.unboxToInt((Object)tuple4._1());
                    int pos = BoxesRunTime.unboxToInt((Object)tuple4._2());
                    Object propertyDefault = tuple4._3();
                    DefaultValue value = (DefaultValue)tuple4._4();
                    neighbors$3[pos + 2] = value;
                    return;
                }
                throw new MatchError((Object)tuple4);
            }));
        });
        return neighbors;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        this.storagePathMaybe().foreach((Function1)(JProcedure1 & Serializable)storagePath -> {
            Graph$.MODULE$.logger().info(new StringBuilder(39).append("closing graph: writing to storage at `").append(storagePath).append("`").toString());
            Serialization$.MODULE$.writeGraph(this, (Path)storagePath);
        });
    }

    public String toString() {
        return new StringBuilder(13).append("Graph[").append(this.nodeCount()).append(" nodes]").toString();
    }

    public Map<String, Object> nodeCountByLabel() {
        return ((IterableOnceOps)((IterableOps)this.schema().nodeKinds().map((Function1 & Serializable)nodeKind -> this.nodeCountByLabel$$anonfun$1(BoxesRunTime.unboxToInt((Object)nodeKind))).map((Function1 & Serializable)label -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(label);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)this.nodeCount((String)label)));
        })).filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return count > 0;
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final /* synthetic */ IterableOnce allNodes$$anonfun$1(int nodeKind) {
        return this._nodes(nodeKind);
    }

    private final /* synthetic */ IterableOnce nodesWithProperty$$anonfun$1(int propertyKind$1, String value$1, int nodeKind) {
        return Accessors$.MODULE$.getWithInverseIndex(this, nodeKind, propertyKind$1, value$1);
    }

    private final /* synthetic */ Tuple4 makeNeighbors$$anonfun$1$$anonfun$1$$anonfun$1(int nodeKind$2, Edge.Direction direction$1, int edgeKind) {
        int pos = this.schema().neighborOffsetArrayIndex(nodeKind$2, direction$1, edgeKind);
        Object propertyDefault = this.schema().allocateEdgeProperty(nodeKind$2, direction$1, edgeKind, 1);
        DefaultValue value = propertyDefault == null ? null : new DefaultValue(ScalaRunTime$.MODULE$.array_apply(propertyDefault, 0));
        return Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)edgeKind), (Object)BoxesRunTime.boxToInteger((int)pos), propertyDefault, (Object)value);
    }

    private final /* synthetic */ String nodeCountByLabel$$anonfun$1(int nodeKind) {
        return this.schema().getNodeLabel(nodeKind);
    }
}

