/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample.probes;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.javaoperatorsdk.operator.Operator;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class StartupHandler
implements HttpHandler {
    private final Operator operator;

    public StartupHandler(Operator operator) {
        this.operator = operator;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        if (this.operator.getRuntimeInfo().isStarted()) {
            StartupHandler.sendMessage(httpExchange, 200, "started");
        } else {
            StartupHandler.sendMessage(httpExchange, 400, "not started yet");
        }
    }

    public static void sendMessage(HttpExchange httpExchange, int code, String message) throws IOException {
        try (OutputStream outputStream = httpExchange.getResponseBody();){
            byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
            httpExchange.sendResponseHeaders(code, bytes.length);
            outputStream.write(bytes);
            outputStream.flush();
        }
    }
}

