/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample.dependentresource;

import io.fabric8.kubernetes.api.model.Service;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.informer.Informer;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.sample.Utils;
import io.javaoperatorsdk.operator.sample.customresource.WebPage;
import java.util.HashMap;

@KubernetesDependent(informer=@Informer(labelSelector="managed"))
public class ServiceDependentResource
extends CRUDKubernetesDependentResource<Service, WebPage> {
    public ServiceDependentResource() {
        super(Service.class);
    }

    protected Service desired(WebPage webPage, Context<WebPage> context) {
        HashMap<String, String> serviceLabels = new HashMap<String, String>();
        serviceLabels.put("managed", "true");
        Service service = (Service)ReconcilerUtils.loadYaml(Service.class, Utils.class, (String)"service.yaml");
        service.getMetadata().setName(Utils.serviceName(webPage));
        service.getMetadata().setNamespace(webPage.getMetadata().getNamespace());
        service.getMetadata().setLabels(serviceLabels);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("app", Utils.deploymentName(webPage));
        service.getSpec().setSelector(labels);
        return service;
    }
}

