/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample.dependentresource;

import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.informer.Informer;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.sample.Utils;
import io.javaoperatorsdk.operator.sample.customresource.WebPage;
import java.util.HashMap;

@KubernetesDependent(informer=@Informer(labelSelector="managed"))
public class DeploymentDependentResource
extends CRUDKubernetesDependentResource<Deployment, WebPage> {
    public DeploymentDependentResource() {
        super(Deployment.class);
    }

    protected Deployment desired(WebPage webPage, Context<WebPage> context) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("managed", "true");
        String deploymentName = Utils.deploymentName(webPage);
        Deployment deployment = (Deployment)ReconcilerUtils.loadYaml(Deployment.class, Utils.class, (String)"deployment.yaml");
        deployment.getMetadata().setName(deploymentName);
        deployment.getMetadata().setNamespace(webPage.getMetadata().getNamespace());
        deployment.getMetadata().setLabels(labels);
        deployment.getSpec().getSelector().getMatchLabels().put("app", deploymentName);
        deployment.getSpec().getTemplate().getMetadata().getLabels().put("app", deploymentName);
        ((Volume)deployment.getSpec().getTemplate().getSpec().getVolumes().get(0)).setConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(Utils.configMapName(webPage))).build());
        return deployment;
    }
}

