/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceUtils;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfigBuilder;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Workflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.WorkflowBuilder;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import io.javaoperatorsdk.operator.sample.Utils;
import io.javaoperatorsdk.operator.sample.customresource.WebPage;
import io.javaoperatorsdk.operator.sample.dependentresource.ConfigMapDependentResource;
import io.javaoperatorsdk.operator.sample.dependentresource.DeploymentDependentResource;
import io.javaoperatorsdk.operator.sample.dependentresource.ExposedIngressCondition;
import io.javaoperatorsdk.operator.sample.dependentresource.IngressDependentResource;
import io.javaoperatorsdk.operator.sample.dependentresource.ServiceDependentResource;
import java.util.Arrays;
import java.util.List;

@ControllerConfiguration
public class WebPageStandaloneDependentsReconciler
implements Reconciler<WebPage> {
    private final Workflow<WebPage> workflow = this.createDependentResourcesAndWorkflow();

    public List<EventSource<?, WebPage>> prepareEventSources(EventSourceContext<WebPage> context) {
        return EventSourceUtils.eventSourcesFromWorkflow(context, this.workflow);
    }

    public UpdateControl<WebPage> reconcile(WebPage webPage, Context<WebPage> context) throws Exception {
        Utils.simulateErrorIfRequested(webPage);
        if (!Utils.isValidHtml(webPage)) {
            return UpdateControl.patchStatus((HasMetadata)Utils.setInvalidHtmlErrorMessage(webPage));
        }
        this.workflow.reconcile((HasMetadata)webPage, context);
        webPage.setStatus(Utils.createStatus(((ConfigMap)context.getSecondaryResource(ConfigMap.class).orElseThrow()).getMetadata().getName()));
        return UpdateControl.patchStatus((HasMetadata)webPage);
    }

    public ErrorStatusUpdateControl<WebPage> updateErrorStatus(WebPage resource, Context<WebPage> retryInfo, Exception e) {
        return Utils.handleError(resource, e);
    }

    private Workflow<WebPage> createDependentResourcesAndWorkflow() {
        ConfigMapDependentResource configMapDR = new ConfigMapDependentResource();
        DeploymentDependentResource deploymentDR = new DeploymentDependentResource();
        ServiceDependentResource serviceDR = new ServiceDependentResource();
        IngressDependentResource ingressDR = new IngressDependentResource();
        Arrays.asList(new CRUDKubernetesDependentResource[]{configMapDR, deploymentDR, serviceDR, ingressDR}).forEach(dr -> dr.configureWith(new KubernetesDependentResourceConfigBuilder().withKubernetesDependentInformerConfig(InformerConfiguration.builder((Class)dr.resourceType()).withLabelSelector("managed=true").build()).build()));
        return new WorkflowBuilder().addDependentResource((DependentResource)configMapDR).addDependentResource((DependentResource)deploymentDR).addDependentResource((DependentResource)serviceDR).addDependentResourceAndConfigure((DependentResource)ingressDR).withReconcilePrecondition((Condition)new ExposedIngressCondition()).build();
    }
}

