/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRule;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.informer.InformerEventSourceConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimited;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import io.javaoperatorsdk.operator.processing.event.source.informer.InformerEventSource;
import io.javaoperatorsdk.operator.sample.Utils;
import io.javaoperatorsdk.operator.sample.customresource.WebPage;
import io.javaoperatorsdk.operator.sample.customresource.WebPageSpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RateLimited(maxReconciliations=2, within=3)
@ControllerConfiguration
public class WebPageReconciler
implements Reconciler<WebPage> {
    public static final String INDEX_HTML = "index.html";
    private static final Logger log = LoggerFactory.getLogger(WebPageReconciler.class);

    public List<EventSource<?, WebPage>> prepareEventSources(EventSourceContext<WebPage> context) {
        InformerEventSource configMapEventSource = new InformerEventSource(InformerEventSourceConfiguration.from(ConfigMap.class, WebPage.class).withLabelSelector("managed").build(), context);
        InformerEventSource deploymentEventSource = new InformerEventSource(InformerEventSourceConfiguration.from(Deployment.class, WebPage.class).withLabelSelector("managed").build(), context);
        InformerEventSource serviceEventSource = new InformerEventSource(InformerEventSourceConfiguration.from(Service.class, WebPage.class).withLabelSelector("managed").build(), context);
        InformerEventSource ingressEventSource = new InformerEventSource(InformerEventSourceConfiguration.from(Ingress.class, WebPage.class).withLabelSelector("managed").build(), context);
        return List.of(configMapEventSource, deploymentEventSource, serviceEventSource, ingressEventSource);
    }

    public UpdateControl<WebPage> reconcile(WebPage webPage, Context<WebPage> context) throws Exception {
        Service existingService;
        Deployment existingDeployment;
        log.info("Reconciling web page: {}", (Object)webPage);
        Utils.simulateErrorIfRequested(webPage);
        if (!Utils.isValidHtml(webPage)) {
            return UpdateControl.patchStatus((HasMetadata)Utils.setInvalidHtmlErrorMessage(webPage));
        }
        String ns = webPage.getMetadata().getNamespace();
        String configMapName = Utils.configMapName(webPage);
        String deploymentName = Utils.deploymentName(webPage);
        ConfigMap desiredHtmlConfigMap = this.makeDesiredHtmlConfigMap(ns, configMapName, webPage);
        Deployment desiredDeployment = this.makeDesiredDeployment(webPage, deploymentName, ns, configMapName);
        Service desiredService = this.makeDesiredService(webPage, ns, desiredDeployment);
        ConfigMap previousConfigMap = context.getSecondaryResource(ConfigMap.class).orElse(null);
        if (!this.match(desiredHtmlConfigMap, previousConfigMap)) {
            log.info("Creating or updating ConfigMap {} in {}", (Object)desiredHtmlConfigMap.getMetadata().getName(), (Object)ns);
            ((Resource)((NonNamespaceOperation)context.getClient().configMaps().inNamespace(ns)).resource((Object)desiredHtmlConfigMap)).serverSideApply();
        }
        if (!this.match(desiredDeployment, existingDeployment = (Deployment)context.getSecondaryResource(Deployment.class).orElse(null))) {
            log.info("Creating or updating Deployment {} in {}", (Object)desiredDeployment.getMetadata().getName(), (Object)ns);
            ((RollableScalableResource)((NonNamespaceOperation)context.getClient().apps().deployments().inNamespace(ns)).resource((Object)desiredDeployment)).serverSideApply();
        }
        if (!this.match(desiredService, existingService = (Service)context.getSecondaryResource(Service.class).orElse(null))) {
            log.info("Creating or updating Deployment {} in {}", (Object)desiredDeployment.getMetadata().getName(), (Object)ns);
            ((ServiceResource)((NonNamespaceOperation)context.getClient().services().inNamespace(ns)).resource((Object)desiredService)).serverSideApply();
        }
        Optional existingIngress = context.getSecondaryResource(Ingress.class);
        if (Boolean.TRUE.equals(((WebPageSpec)webPage.getSpec()).getExposed())) {
            Ingress desiredIngress = Utils.makeDesiredIngress(webPage);
            if (existingIngress.isEmpty() || !this.match(desiredIngress, (Ingress)existingIngress.get())) {
                context.getClient().resource((HasMetadata)desiredIngress).inNamespace(ns).serverSideApply();
            }
        } else {
            existingIngress.ifPresent(ingress -> context.getClient().resource((HasMetadata)ingress).delete());
        }
        if (previousConfigMap != null && !StringUtils.equals((CharSequence)((CharSequence)previousConfigMap.getData().get(INDEX_HTML)), (CharSequence)((CharSequence)desiredHtmlConfigMap.getData().get(INDEX_HTML)))) {
            log.info("Restarting pods because HTML has changed in {}", (Object)ns);
            ((FilterWatchListDeletable)((NonNamespaceOperation)context.getClient().pods().inNamespace(ns)).withLabel("app", Utils.deploymentName(webPage))).delete();
        }
        return UpdateControl.patchStatus((HasMetadata)Utils.createWebPageForStatusUpdate(webPage, desiredHtmlConfigMap.getMetadata().getName()));
    }

    private boolean match(Ingress desiredIngress, Ingress existingIngress) {
        String desiredServiceName = ((HTTPIngressPath)((IngressRule)desiredIngress.getSpec().getRules().get(0)).getHttp().getPaths().get(0)).getBackend().getService().getName();
        String existingServiceName = ((HTTPIngressPath)((IngressRule)existingIngress.getSpec().getRules().get(0)).getHttp().getPaths().get(0)).getBackend().getService().getName();
        return Objects.equals(desiredServiceName, existingServiceName);
    }

    private boolean match(Deployment desiredDeployment, Deployment deployment) {
        if (deployment == null) {
            return false;
        }
        return desiredDeployment.getSpec().getReplicas().equals(deployment.getSpec().getReplicas()) && ((Container)desiredDeployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage().equals(((Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage());
    }

    private boolean match(Service desiredService, Service service) {
        if (service == null) {
            return false;
        }
        return desiredService.getSpec().getSelector().equals(service.getSpec().getSelector());
    }

    private boolean match(ConfigMap desiredHtmlConfigMap, ConfigMap existingConfigMap) {
        if (existingConfigMap == null) {
            return false;
        }
        return desiredHtmlConfigMap.getData().equals(existingConfigMap.getData());
    }

    private Service makeDesiredService(WebPage webPage, String ns, Deployment desiredDeployment) {
        Service desiredService = (Service)ReconcilerUtils.loadYaml(Service.class, this.getClass(), (String)"service.yaml");
        desiredService.getMetadata().setName(Utils.serviceName(webPage));
        desiredService.getMetadata().setNamespace(ns);
        desiredService.getMetadata().setLabels(WebPageReconciler.lowLevelLabel());
        desiredService.getSpec().setSelector(desiredDeployment.getSpec().getTemplate().getMetadata().getLabels());
        desiredService.addOwnerReference((HasMetadata)webPage);
        return desiredService;
    }

    private Deployment makeDesiredDeployment(WebPage webPage, String deploymentName, String ns, String configMapName) {
        Deployment desiredDeployment = (Deployment)ReconcilerUtils.loadYaml(Deployment.class, this.getClass(), (String)"deployment.yaml");
        desiredDeployment.getMetadata().setName(deploymentName);
        desiredDeployment.getMetadata().setNamespace(ns);
        desiredDeployment.getMetadata().setLabels(WebPageReconciler.lowLevelLabel());
        desiredDeployment.getSpec().getSelector().getMatchLabels().put("app", deploymentName);
        desiredDeployment.getSpec().getTemplate().getMetadata().getLabels().put("app", deploymentName);
        ((Volume)desiredDeployment.getSpec().getTemplate().getSpec().getVolumes().get(0)).setConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(configMapName)).build());
        desiredDeployment.addOwnerReference((HasMetadata)webPage);
        return desiredDeployment;
    }

    private ConfigMap makeDesiredHtmlConfigMap(String ns, String configMapName, WebPage webPage) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(INDEX_HTML, ((WebPageSpec)webPage.getSpec()).getHtml());
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)new ConfigMapBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(configMapName)).withNamespace(ns)).withLabels(WebPageReconciler.lowLevelLabel())).build())).withData(data)).build();
        configMap.addOwnerReference((HasMetadata)webPage);
        return configMap;
    }

    public static Map<String, String> lowLevelLabel() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("managed", "true");
        return labels;
    }

    public ErrorStatusUpdateControl<WebPage> updateErrorStatus(WebPage resource, Context<WebPage> context, Exception e) {
        return Utils.handleError(resource, e);
    }
}

