/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusHandler;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceInitializer;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfig;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import io.javaoperatorsdk.operator.sample.ConfigMapDependentResource;
import io.javaoperatorsdk.operator.sample.DeploymentDependentResource;
import io.javaoperatorsdk.operator.sample.IngressDependentResource;
import io.javaoperatorsdk.operator.sample.ServiceDependentResource;
import io.javaoperatorsdk.operator.sample.Utils;
import io.javaoperatorsdk.operator.sample.WebPage;
import io.javaoperatorsdk.operator.sample.WebPageSpec;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ControllerConfiguration
public class WebPageStandaloneDependentsReconciler
implements Reconciler<WebPage>,
ErrorStatusHandler<WebPage>,
EventSourceInitializer<WebPage> {
    private static final Logger log = LoggerFactory.getLogger(WebPageStandaloneDependentsReconciler.class);
    private KubernetesDependentResource<ConfigMap, WebPage> configMapDR;
    private KubernetesDependentResource<Deployment, WebPage> deploymentDR;
    private KubernetesDependentResource<Service, WebPage> serviceDR;
    private KubernetesDependentResource<Ingress, WebPage> ingressDR;

    public WebPageStandaloneDependentsReconciler(KubernetesClient kubernetesClient) {
        this.createDependentResources(kubernetesClient);
    }

    public Map<String, EventSource> prepareEventSources(EventSourceContext<WebPage> context) {
        return EventSourceInitializer.nameEventSources((EventSource[])new EventSource[]{this.configMapDR.initEventSource(context), this.deploymentDR.initEventSource(context), this.serviceDR.initEventSource(context), this.ingressDR.initEventSource(context)});
    }

    public UpdateControl<WebPage> reconcile(WebPage webPage, Context<WebPage> context) throws Exception {
        Utils.simulateErrorIfRequested(webPage);
        if (!Utils.isValidHtml(webPage)) {
            return UpdateControl.patchStatus((HasMetadata)Utils.setInvalidHtmlErrorMessage(webPage));
        }
        Arrays.asList(this.configMapDR, this.deploymentDR, this.serviceDR).forEach(dr -> dr.reconcile((HasMetadata)webPage, context));
        if (Boolean.TRUE.equals(((WebPageSpec)webPage.getSpec()).getExposed())) {
            this.ingressDR.reconcile((HasMetadata)webPage, context);
        } else {
            this.ingressDR.delete((HasMetadata)webPage, context);
        }
        webPage.setStatus((Object)Utils.createStatus(((ConfigMap)this.configMapDR.getSecondaryResource((HasMetadata)webPage).orElseThrow()).getMetadata().getName()));
        return UpdateControl.patchStatus((HasMetadata)webPage);
    }

    public ErrorStatusUpdateControl<WebPage> updateErrorStatus(WebPage resource, Context<WebPage> retryInfo, Exception e) {
        return Utils.handleError(resource, e);
    }

    private void createDependentResources(KubernetesClient client) {
        this.configMapDR = new ConfigMapDependentResource();
        this.deploymentDR = new DeploymentDependentResource();
        this.serviceDR = new ServiceDependentResource();
        this.ingressDR = new IngressDependentResource();
        Arrays.asList(this.configMapDR, this.deploymentDR, this.serviceDR, this.ingressDR).forEach(dr -> {
            dr.setKubernetesClient(client);
            dr.configureWith(new KubernetesDependentResourceConfig().setLabelSelector("managed=true"));
        });
    }
}

