/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.javaoperatorsdk.operator.api.Context;
import io.javaoperatorsdk.operator.api.Controller;
import io.javaoperatorsdk.operator.api.DeleteControl;
import io.javaoperatorsdk.operator.api.ResourceController;
import io.javaoperatorsdk.operator.api.UpdateControl;
import io.javaoperatorsdk.operator.sample.CustomService;
import io.javaoperatorsdk.operator.sample.ServiceSpec;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
public class CustomServiceController
implements ResourceController<CustomService> {
    public static final String KIND = "CustomService";
    private static final Logger log = LoggerFactory.getLogger(CustomServiceController.class);
    private final KubernetesClient kubernetesClient;

    public CustomServiceController(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public DeleteControl deleteResource(CustomService resource, Context<CustomService> context) {
        log.info("Execution deleteResource for: {}", (Object)resource.getMetadata().getName());
        return DeleteControl.DEFAULT_DELETE;
    }

    public UpdateControl<CustomService> createOrUpdateResource(CustomService resource, Context<CustomService> context) {
        log.info("Execution createOrUpdateResource for: {}", (Object)resource.getMetadata().getName());
        ServicePort servicePort = new ServicePort();
        servicePort.setPort(Integer.valueOf(8080));
        io.fabric8.kubernetes.api.model.ServiceSpec serviceSpec = new io.fabric8.kubernetes.api.model.ServiceSpec();
        serviceSpec.setPorts(Collections.singletonList(servicePort));
        ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(resource.getMetadata().getNamespace())).createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(((ServiceSpec)resource.getSpec()).getName())).addToLabels("testLabel", ((ServiceSpec)resource.getSpec()).getLabel())).endMetadata()).withSpec(serviceSpec)).build()});
        return UpdateControl.updateCustomResource((CustomResource)resource);
    }
}

