/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.process;

import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.KubeAPIServerConfig;
import io.javaoperatorsdk.jenvtest.Utils;
import io.javaoperatorsdk.jenvtest.binary.BinaryManager;
import io.javaoperatorsdk.jenvtest.cert.CertManager;
import io.javaoperatorsdk.jenvtest.process.UnexpectedProcessStopHandler;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeAPIServerProcess {
    private static final Logger log = LoggerFactory.getLogger(KubeAPIServerProcess.class);
    private static final Logger apiLog = LoggerFactory.getLogger((String)(KubeAPIServerProcess.class.getName() + ".APIServerProcessLogs"));
    public static final int POLLING_INTERVAL = 150;
    private final CertManager certManager;
    private final BinaryManager binaryManager;
    private final KubeAPIServerConfig config;
    private volatile Process apiServerProcess;
    private volatile boolean stopped = false;
    private final UnexpectedProcessStopHandler processStopHandler;
    private int apiServerPort;

    public KubeAPIServerProcess(CertManager certManager, BinaryManager binaryManager, UnexpectedProcessStopHandler processStopHandler, KubeAPIServerConfig config) {
        this.certManager = certManager;
        this.binaryManager = binaryManager;
        this.config = config;
        this.processStopHandler = processStopHandler;
    }

    public int startApiServer(int etcdPort) {
        File apiServerBinary = this.binaryManager.binaries().getApiServer();
        try {
            if (!apiServerBinary.exists()) {
                throw new JenvtestException("Missing binary for API Server on path: " + apiServerBinary.getAbsolutePath());
            }
            this.apiServerPort = Utils.findFreePort();
            List<String> command = this.createCommand(apiServerBinary, this.apiServerPort, etcdPort);
            this.apiServerProcess = new ProcessBuilder(command).start();
            Utils.redirectProcessOutputToLogger(this.apiServerProcess.getInputStream(), apiLog);
            Utils.redirectProcessOutputToLogger(this.apiServerProcess.getErrorStream(), apiLog);
            this.apiServerProcess.onExit().thenApply(p -> {
                if (!this.stopped) {
                    this.stopped = true;
                    log.error("API Server process stopped unexpectedly");
                    this.processStopHandler.processStopped((Process)p);
                }
                return null;
            });
            log.debug("Kube API Server started on port: {} using binaries: {}", (Object)this.apiServerPort, (Object)apiServerBinary);
            return this.apiServerPort;
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
    }

    private List<String> createCommand(File apiServerBinary, int apiServerPort, int etcdPort) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(apiServerBinary.getAbsolutePath());
        command.addAll(this.config.getApiServerFlags());
        command.addAll(List.of("--cert-dir", this.config.getJenvtestDir(), "--secure-port", "" + apiServerPort, "--etcd-servers", "http://0.0.0.0:" + etcdPort, "--authorization-mode", "RBAC", "--service-account-issuer", "https://localhost", "--service-account-signing-key-file", this.certManager.getAPIServerKeyPath(), "--service-account-signing-key-file", this.certManager.getAPIServerKeyPath(), "--service-account-key-file", this.certManager.getAPIServerKeyPath(), "--service-account-issuer", this.certManager.getAPIServerCertPath(), "--disable-admission-plugins", "ServiceAccount", "--client-ca-file", this.certManager.getClientCertPath(), "--service-cluster-ip-range", "10.0.0.0/24", "--allow-privileged"));
        return command;
    }

    public void waitUntilDefaultNamespaceCreated() {
        try {
            HttpClient client = KubeAPIServerProcess.getHttpClient();
            HttpRequest request = this.getHttpRequest();
            LocalTime startedAt = LocalTime.now();
            while (true) {
                if (this.ready(client, request)) {
                    return;
                }
                if (LocalTime.now().isAfter(startedAt.plus(10000L, ChronoUnit.MILLIS))) {
                    throw new JenvtestException("API Server did not start properly");
                }
                Thread.sleep(150L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JenvtestException(e);
        }
    }

    private boolean ready(HttpClient client, HttpRequest request) {
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            log.trace("Ready Response message:{} code: {}", (Object)response.body(), (Object)response.statusCode());
            return response.statusCode() == 200;
        }
        catch (ConnectException e) {
            log.warn("Cannot connect to the server", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JenvtestException(e);
        }
    }

    private HttpRequest getHttpRequest() {
        try {
            return HttpRequest.newBuilder().uri(new URI("https://127.0.0.1:" + this.apiServerPort + "/readyz")).GET().build();
        }
        catch (URISyntaxException e) {
            throw new JenvtestException(e);
        }
    }

    private static HttpClient getHttpClient() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new X509ExtendedTrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] a_certificates, String a_auth_type) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] a_certificates, String a_auth_type) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] a_certificates, String a_auth_type, Socket a_socket) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] a_certificates, String a_auth_type, SSLEngine a_engine) {
                }
            }}, null);
            return HttpClient.newBuilder().sslContext(sslContext).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new JenvtestException(e);
        }
    }

    public void stopApiServer() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.apiServerProcess != null) {
            this.apiServerProcess.destroyForcibly();
        }
        log.debug("API Server stopped");
    }

    public int getApiServerPort() {
        return this.apiServerPort;
    }
}

