/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.binary.repo;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.binary.OSInfo;
import io.javaoperatorsdk.jenvtest.binary.repo.ObjectList;
import io.javaoperatorsdk.jenvtest.binary.repo.ObjectListItem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryRepo {
    private static final Logger log = LoggerFactory.getLogger(BinaryRepo.class);
    private static final String BUCKET_NAME = "kubebuilder-tools";
    private final OSInfo osInfo;

    public BinaryRepo(OSInfo osInfo) {
        this.osInfo = osInfo;
    }

    public File downloadVersionToTempFile(String version) {
        try {
            String url = "https://storage.googleapis.com/kubebuilder-tools/kubebuilder-tools-" + version + "-" + this.osInfo.getOSName() + "-" + this.osInfo.getOSArch() + ".tar.gz";
            File tempFile = File.createTempFile("kubebuilder-tools-" + version, ".tar.gz");
            log.debug("Downloading binary from url: {} to Temp file: {}", (Object)url, (Object)tempFile.getPath());
            FileUtils.copyURLToFile((URL)new URL(url), (File)tempFile);
            return tempFile;
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
    }

    public Stream<String> listObjectNames() {
        try {
            HttpClient httpClient = HttpClient.newBuilder().build();
            HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create("https://storage.googleapis.com/storage/v1/b/kubebuilder-tools/o")).build();
            String response = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ObjectList objectList = (ObjectList)mapper.readValue(response, ObjectList.class);
            return objectList.getItems().stream().map(ObjectListItem::getName);
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JenvtestException(e);
        }
    }
}

