/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.junit;

import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.KubeAPIServer;
import io.javaoperatorsdk.jenvtest.KubeAPIServerConfig;
import io.javaoperatorsdk.jenvtest.KubeAPIServerConfigBuilder;
import io.javaoperatorsdk.jenvtest.junit.EnableKubeAPIServer;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeAPIServerExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final Logger log = LoggerFactory.getLogger(KubeAPIServerExtension.class);
    private KubeAPIServer kubeApiServer;

    public void beforeAll(ExtensionContext extensionContext) {
        this.startIfAnnotationPresent(extensionContext);
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.stopIfAnnotationPresent(extensionContext);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.startIfAnnotationPresent(extensionContext);
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.stopIfAnnotationPresent(extensionContext);
    }

    private void startIfAnnotationPresent(ExtensionContext extensionContext) {
        extensionContext.getElement().ifPresent(ae -> {
            Optional<EnableKubeAPIServer> annotation = this.getExtensionAnnotationInstance((AnnotatedElement)ae);
            annotation.ifPresent(this::startApiServer);
        });
    }

    private void startApiServer(EnableKubeAPIServer annotation) {
        this.kubeApiServer = new KubeAPIServer(this.annotationToConfig(annotation));
        this.kubeApiServer.start();
    }

    private void stopIfAnnotationPresent(ExtensionContext extensionContext) {
        extensionContext.getElement().ifPresent(ae -> {
            Optional<EnableKubeAPIServer> annotation = this.getExtensionAnnotationInstance((AnnotatedElement)ae);
            annotation.ifPresent(a -> this.kubeApiServer.stop());
        });
    }

    private KubeAPIServerConfig annotationToConfig(EnableKubeAPIServer annotation) {
        KubeAPIServerConfigBuilder builder = KubeAPIServerConfigBuilder.anAPIServerConfig();
        String version = annotation.kubeAPIVersion();
        if (!"NOT_SET".equals(version)) {
            builder.withApiServerVersion(version);
        }
        if (annotation.apiServerFlags().length > 0) {
            builder.withApiServerFlags(List.of(annotation.apiServerFlags()));
        }
        return builder.build();
    }

    private Optional<EnableKubeAPIServer> getExtensionAnnotationInstance(AnnotatedElement ae) {
        List annotations = Arrays.stream(ae.getAnnotations()).filter(a -> a.annotationType().isAssignableFrom(EnableKubeAPIServer.class)).collect(Collectors.toList());
        if (annotations.size() > 1) {
            throw new JenvtestException("Only one instance of @EnableKubeAPIServer annotation is allowed");
        }
        if (annotations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((EnableKubeAPIServer)annotations.get(0));
    }
}

