/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.binary;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.binary.OSInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryRepo {
    private static final Logger log = LoggerFactory.getLogger(BinaryRepo.class);
    private static final String BUCKET_NAME = "kubebuilder-tools";
    private final OSInfo osInfo;

    public BinaryRepo(OSInfo osInfo) {
        this.osInfo = osInfo;
    }

    public File downloadVersionToTempFile(String version) {
        try {
            String url = "https://storage.googleapis.com/kubebuilder-tools/kubebuilder-tools-" + version + "-" + this.osInfo.getOSName() + "-" + this.osInfo.getOSArch() + ".tar.gz";
            File tempFile = File.createTempFile("kubebuilder-tools-" + version, ".tar.gz");
            log.debug("Downloading binary from url: {} to Temp file: {}", (Object)url, (Object)tempFile.getPath());
            FileUtils.copyURLToFile((URL)new URL(url), (File)tempFile);
            return tempFile;
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
    }

    public Stream<String> listObjectNames() {
        Storage storage = (Storage)StorageOptions.getDefaultInstance().getService();
        Page blobs = storage.get(BUCKET_NAME, new Storage.BucketGetOption[0]).list(new Storage.BlobListOption[0]);
        return StreamSupport.stream(blobs.iterateAll().spliterator(), false).map(b -> b.asBlobInfo().getName());
    }
}

