/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.binary;

import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.KubeAPIServerConfig;
import io.javaoperatorsdk.jenvtest.Utils;
import io.javaoperatorsdk.jenvtest.binary.Binaries;
import io.javaoperatorsdk.jenvtest.binary.BinaryDownloader;
import io.javaoperatorsdk.jenvtest.binary.OSInfo;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class BinaryManager {
    public static final String BINARY_LIST_DIR = "k8s";
    private Binaries binaries;
    private final KubeAPIServerConfig config;
    private final BinaryDownloader downloader;
    private final OSInfo osInfo;

    public BinaryManager(KubeAPIServerConfig config) {
        this.config = config;
        this.osInfo = new OSInfo();
        this.downloader = new BinaryDownloader(config.getJenvtestDir(), this.osInfo);
    }

    public void initAndDownloadIfRequired() {
        Optional<File> maybeBinaryDir = this.findTargetBinariesIfAvailable();
        File binaryDir = maybeBinaryDir.orElse(null);
        if (maybeBinaryDir.isEmpty()) {
            if (this.config.isOfflineMode()) {
                throw new JenvtestException("Binaries cannot be found, and download is turned off");
            }
            binaryDir = this.config.getApiServerVersion().isEmpty() ? this.downloader.downloadLatest() : this.downloader.download(this.config.getApiServerVersion().get());
        }
        this.initBinariesPojo(binaryDir);
    }

    private void initBinariesPojo(File binaryDir) {
        this.binaries = new Binaries(new File(binaryDir, "etcd"), new File(binaryDir, "kube-apiserver"), new File(binaryDir, "kubectl"));
        if (!this.binaries.getApiServer().exists()) {
            throw new JenvtestException("API Server binary not found at path:" + this.binaries.getApiServer().getPath());
        }
        if (!this.binaries.getKubectl().exists()) {
            throw new JenvtestException("Kubectl binary not found at path:" + this.binaries.getKubectl().getPath());
        }
        if (!this.binaries.getEtcd().exists()) {
            throw new JenvtestException("Etcd binary not found at path:" + this.binaries.getEtcd().getPath());
        }
    }

    public Binaries binaries() {
        if (this.binaries == null) {
            throw new JenvtestException("Binaries not found.");
        }
        return this.binaries;
    }

    private Optional<File> findTargetBinariesIfAvailable() {
        String platformSuffix = Utils.platformSuffix(this.osInfo);
        if (this.config.getApiServerVersion().isPresent()) {
            File targetVersionDir = new File(this.config.getJenvtestDir(), BINARY_LIST_DIR + File.separator + this.config.getApiServerVersion().get() + platformSuffix);
            if (targetVersionDir.exists()) {
                return Optional.of(targetVersionDir);
            }
            return Optional.empty();
        }
        File binariesListDir = new File(this.config.getJenvtestDir(), BINARY_LIST_DIR);
        if (!binariesListDir.exists()) {
            return Optional.empty();
        }
        List<String> dirVersionList = List.of(binariesListDir.list((dir, name) -> name != null && name.endsWith(platformSuffix))).stream().map(s -> s.substring(0, s.indexOf(platformSuffix))).collect(Collectors.toList());
        if (dirVersionList.isEmpty()) {
            return Optional.empty();
        }
        String latest = Utils.getLatestVersion(dirVersionList) + platformSuffix;
        return Optional.of(new File(binariesListDir, latest));
    }
}

